/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.custom;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.custom.OpenCloseDelta$Values;

@StudyHeader(namespace="com.motivewave", id="OCD", rb="com.motivewave.platform.study.nls.strings", name="TITLE_OPEN_CLOSE_DELTA", desc="DESC_OPEN_CLOSE_DELTA", tabName="LBL_OPEN_CLOSE_DELTA", menu="MENU_CUSTOM", overlay=false, helpLink="http://www.motivewave.com/studies/open_close_delta.htm")
public class OpenCloseDelta
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"upColor", "downColor"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)OpenCloseDelta$Values.DELTA, this.get("LBL_OPEN_CLOSE_DELTA", new Object[0]), new String[0]));
        runtimeDescriptor.declareBars((Object)OpenCloseDelta$Values.DELTA);
        runtimeDescriptor.declareIndicator((Object)OpenCloseDelta$Values.DELTA, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{OpenCloseDelta$Values.DELTA});
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.setBottomInsetPixels(0);
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)Enums.BarInput.OPEN);
        Double d3 = dataSeries.getDouble(n2, (Object)Enums.BarInput.CLOSE);
        if (d2 == null || d3 == null) {
            return;
        }
        double d4 = Math.abs(d3 - d2);
        dataSeries.setDouble(n2, (Object)OpenCloseDelta$Values.DELTA, Double.valueOf(d4));
        if (d3 > d2) {
            dataSeries.setBarColor(n2, (Object)OpenCloseDelta$Values.DELTA, this.getSettings().getColor("upColor"));
        } else {
            dataSeries.setBarColor(n2, (Object)OpenCloseDelta$Values.DELTA, this.getSettings().getColor("downColor"));
        }
        dataSeries.setComplete(n2);
    }
}

