/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.custom;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.custom.MAHighLow$Signals;
import com.motivewave.platform.study.custom.MAHighLow$Values;

@StudyHeader(namespace="com.motivewave", id="MA_HIGH_LOW", rb="com.motivewave.platform.study.nls.strings", name="TITLE_MA_HIGH_LOW", desc="DESC_MA_HIGH_LOW", menu="MENU_OVERLAY", menu2="MENU_CUSTOM", overlay=true, signals=true, helpLink="http://www.motivewave.com/studies/ma_high_low.htm")
public class MAHighLow
extends Study {
    static final String a = "highPeriod";
    static final String b = "highMAPeriod";
    static final String c = "highShift";
    static final String d = "lowPeriod";
    static final String e = "lowMAPeriod";
    static final String f = "lowShift";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.WMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_HIGH_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("LBL_HIGH_MA_PERIOD", new Object[0]), 14, 1, 9999, 1), new IntegerDescriptor(c, this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(d, this.get("LBL_LOW_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(e, this.get("LBL_LOW_MA_PERIOD", new Object[0]), 14, 1, 9999, 1), new IntegerDescriptor(f, this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("topLine", this.get("LBL_TOP_LINE", new Object[0]), defaults.getBlue(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("middleLine", this.get("LBL_MIDDLE_LINE", new Object[0]), defaults.getGrey(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("bottomLine", this.get("LBL_BOTTOM_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_CROSS_TOP_BAND", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_CROSS_BOTTOM_BAND", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("topInd", this.get("LBL_TOP_IND", new Object[0]), defaults.getBlue(), X11Colors.WHITE, false, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("middleInd", this.get("LBL_MIDDLE_IND", new Object[0]), defaults.getGrey(), X11Colors.BLACK, false, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("bottomInd", this.get("LBL_BOTTOM_IND", new Object[0]), defaults.getRed(), X11Colors.WHITE, false, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(a, this.get("LBL_HIGH_PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(b, this.get("LBL_HIGH_MA_PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(c, this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, true, () -> Enums.Icon.SHIFT.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(d, this.get("LBL_LOW_PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(e, this.get("LBL_LOW_MA_PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(f, this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, true, () -> Enums.Icon.SHIFT.get())});
        settingsDescriptor.addQuickSettings(new String[]{"topLine", "middleLine", "bottomLine"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"method", a, b, c, d, e, f});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MAHighLow$Values.TOP, this.get("LBL_MA_HL_TOP", new Object[0]), new String[]{"method", a, b, c}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MAHighLow$Values.MIDDLE, this.get("LBL_MA_HL_MIDDLE", new Object[0]), new String[]{"method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MAHighLow$Values.BOTTOM, this.get("LBL_MA_HL_BOTTOM", new Object[0]), new String[]{"method", d, e, f}));
        runtimeDescriptor.declarePath((Object)MAHighLow$Values.TOP, "topLine");
        runtimeDescriptor.declarePath((Object)MAHighLow$Values.MIDDLE, "middleLine");
        runtimeDescriptor.declarePath((Object)MAHighLow$Values.BOTTOM, "bottomLine");
        runtimeDescriptor.declareIndicator((Object)MAHighLow$Values.TOP, "topInd");
        runtimeDescriptor.declareIndicator((Object)MAHighLow$Values.MIDDLE, "middleInd");
        runtimeDescriptor.declareIndicator((Object)MAHighLow$Values.BOTTOM, "bottomInd");
        runtimeDescriptor.declareSignal((Object)MAHighLow$Signals.CROSS_ABOVE_TOP_BAND, this.get("LBL_CROSS_TOP_BAND", new Object[0]));
        runtimeDescriptor.declareSignal((Object)MAHighLow$Signals.CROSS_BELOW_BOTTOM_BAND, this.get("LBL_CROSS_BOTTOM_BAND", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{MAHighLow$Values.TOP, MAHighLow$Values.BOTTOM});
    }

    protected synchronized void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger(a);
        int n4 = this.getSettings().getInteger(b);
        int n5 = this.getSettings().getInteger(c);
        DataSeries dataSeries = dataContext.getDataSeries();
        boolean bl2 = false;
        if (n2 >= n3) {
            double d2 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
            dataSeries.setDouble(n2, (Object)MAHighLow$Values.HIGHEST, Double.valueOf(d2));
            if (n2 >= n3 + n4) {
                Util.calcMAAt((int)n2, (DataContext)dataContext, (Enums.MAMethod)this.getSettings().getMAMethod("method"), (Object)((Object)MAHighLow$Values.HIGHEST), (int)n4, (int)n5, (Object)((Object)MAHighLow$Values.TOP));
                bl2 = true;
            }
        }
        int n6 = this.getSettings().getInteger(d);
        int n7 = this.getSettings().getInteger(e);
        int n8 = this.getSettings().getInteger(f);
        if (n2 >= n6) {
            dataSeries.setDouble(n2, (Object)MAHighLow$Values.LOWEST, dataSeries.lowest(n2, n6, Enums.BarInput.LOW));
            if (n2 >= n6 + n7) {
                Util.calcMAAt((int)n2, (DataContext)dataContext, (Enums.MAMethod)this.getSettings().getMAMethod("method"), (Object)((Object)MAHighLow$Values.LOWEST), (int)n7, (int)n8, (Object)((Object)MAHighLow$Values.BOTTOM));
            } else {
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        Double d3 = dataSeries.getDouble(n2, (Object)MAHighLow$Values.TOP);
        Double d4 = dataSeries.getDouble(n2, (Object)MAHighLow$Values.BOTTOM);
        if (d3 != null && d4 != null) {
            dataSeries.setDouble(n2, (Object)MAHighLow$Values.MIDDLE, Double.valueOf((d3 + d4) / 2.0));
        } else {
            bl2 = false;
        }
        this.a(dataContext, n2);
        this.b(dataContext, n2);
        dataSeries.setComplete(n2, bl2);
    }

    private void a(DataContext dataContext, int n2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)MAHighLow$Values.TOP);
        if (d2 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedAbove(dataSeries, n2, Enums.BarInput.CLOSE, (Object)MAHighLow$Values.TOP) && !dataSeries.getBoolean(n2, (Object)MAHighLow$Signals.CROSS_ABOVE_TOP_BAND, false)) {
            boolean bl2 = n2 == dataSeries.size() - 1 && dataSeries.getBoolean(n2, (Object)MAHighLow$Signals.CROSS_ABOVE_TOP_BAND, false);
            dataSeries.setBoolean(n2, (Object)MAHighLow$Signals.CROSS_ABOVE_TOP_BAND, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("CROSS_ABOVE_TOP_BAND", new Object[]{this.format(dataSeries.getClose(n2)), this.format(d2)});
            if (!bl2 && markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MAHighLow$Signals.CROSS_ABOVE_TOP_BAND, string, (Object)this.round(dataSeries.getClose(n2)));
        }
    }

    private void b(DataContext dataContext, int n2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)MAHighLow$Values.BOTTOM);
        if (d2 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedBelow(dataSeries, n2, Enums.BarInput.CLOSE, (Object)MAHighLow$Values.BOTTOM) && !dataSeries.getBoolean(n2, (Object)MAHighLow$Signals.CROSS_BELOW_BOTTOM_BAND, false)) {
            boolean bl2 = n2 == dataSeries.size() - 1 && dataSeries.getBoolean(n2, (Object)MAHighLow$Signals.CROSS_BELOW_BOTTOM_BAND, false);
            dataSeries.setBoolean(n2, (Object)MAHighLow$Signals.CROSS_BELOW_BOTTOM_BAND, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("CROSS_BELOW_BOTTOM_BAND", new Object[]{this.format(dataSeries.getClose(n2)), this.format(d2)});
            if (!bl2 && markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MAHighLow$Signals.CROSS_BELOW_BOTTOM_BAND, string, (Object)this.round(dataSeries.getClose(n2)));
        }
    }
}

