/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.chande;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.chande.ChandeMomentum$Signals;
import com.motivewave.platform.study.chande.ChandeMomentum$Values;

@StudyHeader(namespace="com.motivewave", id="CHANDE_MOMENTUM", rb="com.motivewave.platform.study.nls.strings", name="TITLE_CHANDE_MOMENTUM", label="LBL_CHANDE_MOMENTUM", tabName="TAB_CHANDE_MOMENTUM", desc="DESC_CHANDE_MOMENTUM", menu="MENU_TUSCHARD_CHANDE", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/chande_momentum_oscillator.htm")
public class ChandeMomentum
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_LINES", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 50.0, -100.0, 100.0, 1.0, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), -50.0, -100.0, 100.0, 1.0, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ChandeMomentum$Values.CMO, this.get("TAB_CHANDE_MOMENTUM", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)ChandeMomentum$Values.CMO, "line");
        runtimeDescriptor.declareIndicator((Object)ChandeMomentum$Values.CMO, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ChandeMomentum$Values.CMO});
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(-90));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(90));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        runtimeDescriptor.declareSignal((Object)ChandeMomentum$Signals.CMO_TOP, this.get("LBL_CMO_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)ChandeMomentum$Signals.CMO_BOTTOM, this.get("LBL_CMO_BOTTOM", new Object[0]));
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = this.getSettings().getInput("input");
        Double d2 = dataSeries.getDouble(n2, object);
        Double d3 = dataSeries.getDouble(n2 - 1, object);
        if (d2 == null || d3 == null) {
            return;
        }
        double d4 = d2 - d3;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d4 > 0.0) {
            d5 = d4;
        }
        if (d4 < 0.0) {
            d6 = -d4;
        }
        dataSeries.setDouble(n2, (Object)ChandeMomentum$Values.CMO1, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)ChandeMomentum$Values.CMO2, Double.valueOf(d6));
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3 - 1) {
            return;
        }
        double d7 = dataSeries.sum(n2, n3, (Object)ChandeMomentum$Values.CMO1);
        double d8 = dataSeries.sum(n2, n3, (Object)ChandeMomentum$Values.CMO2);
        double d9 = (d7 - d8) / (d7 + d8) * 100.0;
        dataSeries.setDouble(n2, (Object)ChandeMomentum$Values.CMO, Double.valueOf(d9));
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        d9 = this.round(d9);
        if (this.crossedAbove(dataSeries, n2, (Object)ChandeMomentum$Values.CMO, guideInfo.getValue())) {
            dataContext.signal(n2, (Object)ChandeMomentum$Signals.CMO_TOP, this.get("SIGNAL_CMO_TOP", new Object[]{d9, guideInfo.getValue()}), (Object)d9);
        } else if (this.crossedBelow(dataSeries, n2, (Object)ChandeMomentum$Values.CMO, guideInfo2.getValue())) {
            dataContext.signal(n2, (Object)ChandeMomentum$Signals.CMO_BOTTOM, this.get("SIGNAL_CMO_BOTTOM", new Object[]{d9, guideInfo2.getValue()}), (Object)d9);
        }
        dataSeries.setComplete(n2);
    }
}

