/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.chande;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.chande.Aroon$Values;

@StudyHeader(namespace="com.motivewave", id="AROON", rb="com.motivewave.platform.study.nls.strings", name="TITLE_AROON", desc="DESC_AROON", menu="MENU_TUSCHARD_CHANDE", overlay=false, studyOverlay=true, helpLink="http://www.motivewave.com/studies/aroon.htm")
public class Aroon
extends Study {
    static final String a = "upLine";
    static final String b = "downLine";
    static final String c = "upInd";
    static final String d = "downInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 25, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(a, this.get("LBL_UP_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b, this.get("LBL_DOWN_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(c, this.get("LBL_UP_IND", new Object[0]), null, null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(d, this.get("LBL_DOWN_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 70.0, 1.0, 100.0, 1.0, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 30.0, 1.0, 100.0, 1.0, true)});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 25, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, b});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Aroon$Values.UP, this.get("LBL_AROON_UP", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Aroon$Values.DOWN, this.get("LBL_ARRON_DOWN", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)Aroon$Values.UP, a);
        runtimeDescriptor.declarePath((Object)Aroon$Values.DOWN, b);
        runtimeDescriptor.declareIndicator((Object)Aroon$Values.UP, c);
        runtimeDescriptor.declareIndicator((Object)Aroon$Values.DOWN, d);
        runtimeDescriptor.setRangeKeys(new Object[]{Aroon$Values.UP, Aroon$Values.DOWN});
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(10));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(90));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3 - 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        int n4 = 0;
        int n5 = 0;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        int n6 = n3;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            double d4 = dataSeries.getHigh(i2);
            double d5 = dataSeries.getLow(i2);
            if (d4 >= d2) {
                d2 = d4;
                n4 = n6;
            }
            if (d5 <= d3) {
                d3 = d5;
                n5 = n6;
            }
            --n6;
        }
        double d6 = ((double)n3 - (double)(--n4)) / (double)n3 * 100.0;
        double d7 = ((double)n3 - (double)(--n5)) / (double)n3 * 100.0;
        dataSeries.setDouble(n2, (Object)Aroon$Values.UP, Double.valueOf(d6));
        dataSeries.setDouble(n2, (Object)Aroon$Values.DOWN, Double.valueOf(d7));
        dataSeries.setComplete(n2);
    }
}

