/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.chaikin;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.chaikin.ChaikinVolatility$Values;

@StudyHeader(namespace="com.motivewave", id="ID_CVI", rb="com.motivewave.platform.study.nls.strings2", name="NAME_CHAIKIN_VOLATILITY_INDICATOR", desc="DESC_CVI", menu="MENU_MARC_CHAIKIN", helpLink="http://www.motivewave.com/studies/chaikin_volatility_indicator.htm", label="LBL_CVI", signals=false, overlay=false, studyOverlay=true)
public class ChaikinVolatility
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("MA_PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("ROC_PERIOD", new Object[0]), 12, 1, 999, 1)});
        settingGroup = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.01, 999.01, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("MA_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("ROC_PERIOD", new Object[0]), 12, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ChaikinVolatility$Values.CVI, this.get("LBL_CVI", new Object[0]), new String[]{"method", "period", "period2"}));
        runtimeDescriptor.declarePath((Object)ChaikinVolatility$Values.CVI, "line");
        runtimeDescriptor.declareIndicator((Object)ChaikinVolatility$Values.CVI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ChaikinVolatility$Values.CVI});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getHigh(n2);
        double d3 = dataSeries.getLow(n2);
        dataSeries.setDouble(n2, (Object)ChaikinVolatility$Values.H_L, Double.valueOf(d2 - d3));
        if (n2 < n3) {
            return;
        }
        Double d4 = dataSeries.ma(mAMethod, n2, n3, (Object)ChaikinVolatility$Values.H_L);
        if (d4 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)ChaikinVolatility$Values.MA, d4);
        if (n2 < n3 + n4) {
            return;
        }
        Double d5 = dataSeries.roc(n2, n4, (Object)ChaikinVolatility$Values.MA);
        if (d5 == null) {
            return;
        }
        d5 = d5 * 100.0;
        dataSeries.setDouble(n2, (Object)ChaikinVolatility$Values.CVI, d5);
        dataSeries.setComplete(n2);
    }
}

