/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.bar_pattern;

import com.motivewave.platform.sdk.common.ColorInfo;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.bar_pattern.RSIBarPattern$Signals;
import com.motivewave.platform.study.bar_pattern.RSIBarPattern$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="RSI_BARS", rb="com.motivewave.platform.study.nls.strings", name="TITLE_RSI_BARS", desc="DESC_RSI_BARS", menu="MENU_WELLES_WILDER", menu2="MENU_BAR_PATTERNS", overlay=true, signals=true, helpLink="http://www.motivewave.com/studies/rsi_bars.htm")
public class RSIBarPattern
extends Study {
    static final String a = "RSITop";
    static final String b = "RSIBottom";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("LBL_RSI_TOP", new Object[0]), 70.0, 1.0, 99.0, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("LBL_RSI_BOTTOM", new Object[0]), 30.0, 1.0, 99.0, 0.1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("topColor", this.get("LBL_TOP_COLOR", new Object[0]), defaults.getGreen(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("neutralColor", this.get("LBL_NEUTRAL_COLOR", new Object[0]), defaults.getBlue(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("bottomColor", this.get("LBL_BOTTOM_COLOR", new Object[0]), defaults.getRed(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, b, "topColor", "neutralColor", "bottomColor"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RSIBarPattern$Values.RSI, this.get("LBL_RSI", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declareSignal((Object)RSIBarPattern$Signals.TOP_BAR, this.get("LBL_RSI_TOP_BAR", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RSIBarPattern$Signals.BOTTOM_BAR, this.get("LBL_RSI_BOTTOM_BAR", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RSIBarPattern$Signals.NEUTRAL_BAR, this.get("LBL_RSI_NEUTRAL_BAR", new Object[0]));
    }

    protected void calculate(int n2, DataContext dataContext) {
        Settings settings = this.getSettings();
        int n3 = settings.getInteger("period");
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = settings.getInput("input");
        double d2 = dataSeries.getDouble(n2, object) - dataSeries.getDouble(n2 - 1, object);
        double d3 = 0.0;
        double d4 = 0.0;
        if (d2 > 0.0) {
            d3 = d2;
        } else {
            d4 = d2;
        }
        dataSeries.setDouble(n2, (Object)RSIBarPattern$Values.UP, Double.valueOf(d3));
        dataSeries.setDouble(n2, (Object)RSIBarPattern$Values.DOWN, Double.valueOf(Math.abs(d4)));
        if (n2 <= n3 + 1) {
            return;
        }
        Enums.MAMethod mAMethod = settings.getMAMethod("method");
        Double d5 = dataSeries.ma(mAMethod, n2, n3, (Object)RSIBarPattern$Values.UP);
        Double d6 = dataSeries.ma(mAMethod, n2, n3, (Object)RSIBarPattern$Values.DOWN);
        if (d5 == null || d6 == null) {
            return;
        }
        double d7 = d5 / d6;
        double d8 = 100.0 - 100.0 / (1.0 + d7);
        boolean bl2 = dataSeries.isBarComplete(n2);
        Instrument instrument = dataContext.getInstrument();
        dataSeries.setDouble(n2, (Object)RSIBarPattern$Values.RSI, Double.valueOf(d8));
        double d9 = settings.getDouble(a);
        double d10 = settings.getDouble(b);
        ColorInfo colorInfo = settings.getColorInfo("topColor");
        ColorInfo colorInfo2 = settings.getColorInfo("bottomColor");
        ColorInfo colorInfo3 = settings.getColorInfo("neutralColor");
        Color color = dataSeries.getPriceBarColor(n2 - 1);
        String string = Util.formatDouble((double)d8, (int)2);
        String string2 = instrument.format(dataSeries.getClose(n2));
        if (d8 >= d9) {
            dataSeries.setPriceBarColor(n2, colorInfo.isEnabled() ? colorInfo.getColor() : null);
            if (bl2 && !Util.compare((Object)color, (Object)colorInfo.getColor())) {
                dataContext.signal(n2, (Object)RSIBarPattern$Signals.TOP_BAR, this.get("SIGNAL_RSI_TOP_BAR", new Object[]{string, string2}), (Object)string);
            }
        } else if (d8 <= d10) {
            dataSeries.setPriceBarColor(n2, colorInfo2.isEnabled() ? colorInfo2.getColor() : null);
            if (bl2 && !Util.compare((Object)color, (Object)colorInfo2.getColor())) {
                dataContext.signal(n2, (Object)RSIBarPattern$Signals.BOTTOM_BAR, this.get("SIGNAL_RSI_BOTTOM_BAR", new Object[]{string, string2}), (Object)string);
            }
        } else {
            dataSeries.setPriceBarColor(n2, colorInfo3.isEnabled() ? colorInfo3.getColor() : null);
            if (bl2 && !Util.compare((Object)color, (Object)colorInfo3.getColor())) {
                dataContext.signal(n2, (Object)RSIBarPattern$Signals.NEUTRAL_BAR, this.get("SIGNAL_RSI_NEUTRAL_BAR", new Object[]{string, string2}), (Object)string);
            }
        }
        dataSeries.setComplete(n2, bl2);
    }
}

