/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.premium_study.order_flow;

import com.motivewave.platform.premium_study.order_flow.BidAskVolume$Signals;
import com.motivewave.platform.premium_study.order_flow.BidAskVolume$Values;
import com.motivewave.platform.premium_study.order_flow.a;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.TickOperation;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="BIDASKVOL", rb="com.motivewave.platform.study.nls.strings", name="TITLE_BIDASK_VOLUME", label="LBL_BIDASK_VOL", desc="DESC_BIDASK_VOL", menu="MENU_VOLUME", overlay=false, studyOverlay=true, signals=true, requiresBarUpdates=true, allowTickAggregate=true, allowTickFilter=true, helpLink="https://www.motivewave.com/studies/bid_ask_volume.htm")
public class BidAskVolume
extends Study {
    static final String a = "count";
    static final String b = "showAll";
    static final String c = "rthData";
    static final String d = "askPath";
    static final String e = "bidPath";
    static final String f = "askInd";
    static final String g = "bidInd";
    private boolean a = false;
    private boolean b = false;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("TAB_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_BAR_COUNT", new Object[0]), 20, 1, 9999, 1), new BooleanDescriptor(b, this.get("LBL_SHOW_ALL", new Object[0]), Boolean.valueOf(false), false)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(c, this.get("LBL_RTH_DATA", new Object[0]), Boolean.valueOf(false), false)});
        settingGroup = settingTab.addGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor(d, this.get("LBL_ASK_VOLUME", new Object[0]), defaults.getGreenLine(), 1.0f, null, true, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor(e, this.get("LBL_BID_VOLUME", new Object[0]), defaults.getRedLine(), 1.0f, null, true, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("LBL_ASK_INDICATOR", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("LBL_BID_INDICATOR", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(false, b, new String[]{a}));
        settingsDescriptor.addQuickSettings(new String[]{a, b, c, d, e, "upMarker", "downMarker"});
        settingsDescriptor.rowAlign(new String[]{a, b});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.declarePath((Object)BidAskVolume$Values.ASK_VOL, d);
        runtimeDescriptor.declarePath((Object)BidAskVolume$Values.BID_VOL, e);
        runtimeDescriptor.declareIndicator((Object)BidAskVolume$Values.ASK_VOL, f);
        runtimeDescriptor.declareIndicator((Object)BidAskVolume$Values.BID_VOL, g);
        runtimeDescriptor.setRangeKeys(new Object[]{BidAskVolume$Values.ASK_VOL, BidAskVolume$Values.BID_VOL});
        runtimeDescriptor.setMinTick(Double.valueOf(1.0));
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.declareSignal((Object)BidAskVolume$Signals.CROSS_ABOVE, this.get("LBL_ASK_CROSS_ABOVE_BID", new Object[0]));
        runtimeDescriptor.declareSignal((Object)BidAskVolume$Signals.CROSS_BELOW, this.get("LBL_ASK_CROSS_BELOW_BID", new Object[0]));
    }

    public void clearState() {
        this.a = false;
        this.b = false;
        super.clearState();
    }

    public void onBarClose(DataContext dataContext) {
        if (this.a) {
            return;
        }
        this.a(dataContext, dataContext.getDataSeries(), dataContext.getDataSeries().size() - 1);
    }

    protected void calculateValues(DataContext dataContext) {
        if (this.b || this.a || !dataContext.getDataSeries().hasData()) {
            return;
        }
        this.b = true;
        Util.schedule(() -> this.a(dataContext));
    }

    private void a(DataContext dataContext) {
        int n2;
        int n3;
        this.a = true;
        boolean bl2 = this.getSettings().is(b);
        int n4 = this.getSettings().getInteger(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        int n5 = n3 = bl2 ? 0 : dataSeries.size() - n4;
        for (n2 = dataSeries.size() - 1; n2 >= n3; --n2) {
            if (!dataSeries.isComplete(n2)) continue;
            n5 = n2 + 1;
            break;
        }
        if (!bl2) {
            for (n2 = dataSeries.size() - n4 - 1; n2 >= 0 && dataSeries.isComplete(n2); --n2) {
                dataSeries.setFloat(n2, (Object)BidAskVolume$Values.ASK_VOL, Float.valueOf(0.0f));
                dataSeries.setFloat(n2, (Object)BidAskVolume$Values.BID_VOL, Float.valueOf(0.0f));
            }
        }
        Instrument instrument = dataSeries.getInstrument();
        boolean bl3 = this.getSettings().is(c);
        long l2 = Util.getStartOfBar((long)dataSeries.getStartTime(n5), (long)dataSeries.getEndTime(n5), (Instrument)instrument, (BarSize)dataSeries.getBarSize(), (boolean)bl3);
        a a2 = new a(this, n5, dataContext, bl3);
        instrument.forEachTick(l2, dataContext.getCurrentTime() + 300000L, bl3, (TickOperation)a2);
        a2.a();
        this.a = false;
        this.notifyRangeUpdated();
        this.notifyValuesUpdated();
        this.notifyRedraw();
    }

    public void onBarUpdate(DataContext dataContext) {
    }

    public void onTick(DataContext dataContext, Tick tick) {
        float f2;
        Settings settings = this.getSettings();
        Instrument instrument = dataContext.getInstrument();
        boolean bl2 = settings.is(c);
        if (this.a || !instrument.isInsideTradingHours(tick.getTime(), bl2)) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        float f3 = dataSeries.getFloat(dataSeries.size() - 1, (Object)BidAskVolume$Values.ASK_VOL, 0.0f);
        float f4 = dataSeries.getFloat(dataSeries.size() - 1, (Object)BidAskVolume$Values.BID_VOL, 0.0f);
        float f5 = f2 = tick.getVolumeAsFloat() <= 0.0f ? 1.0f : tick.getVolumeAsFloat();
        if (tick.isAskTick()) {
            f3 += f2;
        } else {
            f4 += f2;
        }
        float f6 = Math.max(f3, f4);
        Double d2 = dataSeries.highestVisible((Object)BidAskVolume$Values.ASK_VOL);
        Double d3 = dataSeries.highestVisible((Object)BidAskVolume$Values.BID_VOL);
        if (d2 == null || d3 == null) {
            return;
        }
        boolean bl3 = (double)f6 > d2 || (double)f6 > d3;
        dataSeries.setFloat((Object)BidAskVolume$Values.ASK_VOL, Float.valueOf(f3));
        dataSeries.setFloat((Object)BidAskVolume$Values.BID_VOL, Float.valueOf(f4));
        if (bl3) {
            this.notifyRangeUpdated();
        }
    }

    private void a(DataContext dataContext, DataSeries dataSeries, int n2) {
        float f2 = dataSeries.getFloat(n2, (Object)BidAskVolume$Values.BID_VOL, 0.0f);
        float f3 = dataSeries.getFloat(n2, (Object)BidAskVolume$Values.ASK_VOL, 0.0f);
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), (double)f3);
        if (this.crossedAbove(dataSeries, n2, (Object)BidAskVolume$Values.ASK_VOL, (Object)BidAskVolume$Values.BID_VOL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_ASK_VOL_CROSS_ABOVE", new Object[]{Float.valueOf(f3), Float.valueOf(f2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            if (!this.a) {
                dataContext.signal(n2, (Object)BidAskVolume$Signals.CROSS_ABOVE, string, (Object)Float.valueOf(f2));
            }
        } else if (this.crossedBelow(dataSeries, n2, (Object)BidAskVolume$Values.ASK_VOL, (Object)BidAskVolume$Values.BID_VOL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_ASK_VOL_CROSS_BELOW", new Object[]{Float.valueOf(f3), Float.valueOf(f2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            if (!this.a) {
                dataContext.signal(n2, (Object)BidAskVolume$Signals.CROSS_BELOW, string, (Object)Float.valueOf(f2));
            }
        }
    }
}

