/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.databean.cell.BaseTreeCell;
import com.motivewave.platform.databean.cell.TextRenderer;
import com.motivewave.platform.databean.cell.UpDownCellRenderer;
import javafx.geometry.Pos;

public class UpDownTreeDoubleCell
extends BaseTreeCell {
    double neutralValue = 0.0;

    public UpDownTreeDoubleCell(TableColumnInfo tableColumnInfo, double d2, RowFormatSource rowFormatSource) {
        super(tableColumnInfo, rowFormatSource);
        this.neutralValue = d2;
        this.renderer.setAlignment(Pos.CENTER_RIGHT);
    }

    @Override
    protected void formatLeaf(Object object, Object object2) {
        UpDownCellRenderer upDownCellRenderer = (UpDownCellRenderer)this.renderer;
        double d2 = (Double)object2;
        if (d2 >= this.neutralValue) {
            upDownCellRenderer.setDirection(Boolean.TRUE);
        } else if (d2 <= -this.neutralValue) {
            upDownCellRenderer.setDirection(Boolean.FALSE);
        } else {
            upDownCellRenderer.setDirection(null);
        }
        upDownCellRenderer.setText(((ObservableBean)object).format(this.getProperty()));
        upDownCellRenderer.postUpdate();
    }

    @Override
    protected TextRenderer createRenderer() {
        return new UpDownCellRenderer();
    }
}

