/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.RowFormat;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.databean.cell.BaseTreeCell;
import com.motivewave.platform.databean.cell.TextRenderer;
import com.motivewave.platform.databean.cell.UpDownCellRenderer;
import javafx.geometry.Pos;

public class UpDownTreeCell
extends BaseTreeCell {
    float neutralValue = 0.0f;

    public UpDownTreeCell(TableColumnInfo tableColumnInfo, float f2, RowFormatSource rowFormatSource) {
        super(tableColumnInfo, rowFormatSource);
        this.neutralValue = f2;
        this.renderer.setAlignment(Pos.CENTER_RIGHT);
    }

    @Override
    protected void formatLeaf(Object object, Object object2) {
        Object object3;
        UpDownCellRenderer upDownCellRenderer = (UpDownCellRenderer)this.renderer;
        float f2 = ((Float)object2).floatValue();
        if (f2 >= this.neutralValue) {
            upDownCellRenderer.setDirection(Boolean.TRUE);
        } else if (f2 <= -this.neutralValue) {
            upDownCellRenderer.setDirection(Boolean.FALSE);
        } else {
            upDownCellRenderer.setDirection(null);
            if (this.isDark()) {
                upDownCellRenderer.setTextWhite();
            } else {
                upDownCellRenderer.setTextBlack();
            }
            if (this.formatSrc != null && (object3 = this.formatSrc.getFormat(this.getTableRow())) != null && ((RowFormat)object3).getForeground() != null) {
                this.renderer.setTextColor(((RowFormat)object3).getForeground());
            }
        }
        object3 = ((ObservableBean)object).format(this.getProperty());
        upDownCellRenderer.setText((String)object3);
        upDownCellRenderer.postUpdate();
    }

    @Override
    protected TextRenderer createRenderer() {
        return new UpDownCellRenderer();
    }
}

