/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.platform.databean.PropertyBean;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.databean.cell.BaseCell;
import com.motivewave.platform.databean.cell.TextRenderer;
import com.motivewave.platform.databean.cell.UpDownCellRenderer;
import javafx.geometry.Pos;

public class UpDownDoubleCell
extends BaseCell {
    double neutralValue = 0.0;

    public UpDownDoubleCell(TableColumnInfo tableColumnInfo, double d2, RowFormatSource rowFormatSource) {
        super(tableColumnInfo, rowFormatSource);
        this.neutralValue = d2;
        this.renderer.setAlignment(Pos.CENTER_RIGHT);
    }

    @Override
    protected void format(PropertyBean propertyBean, Object object) {
        UpDownCellRenderer upDownCellRenderer = (UpDownCellRenderer)this.renderer;
        double d2 = (Double)object;
        if (d2 > this.neutralValue) {
            upDownCellRenderer.setDirection(Boolean.TRUE);
        } else if (d2 < -this.neutralValue) {
            upDownCellRenderer.setDirection(Boolean.FALSE);
        } else {
            upDownCellRenderer.setDirection(null);
        }
        upDownCellRenderer.setText(propertyBean.format(this.getProperty()));
        upDownCellRenderer.postUpdate();
    }

    @Override
    protected TextRenderer createRenderer() {
        return new UpDownCellRenderer();
    }
}

