/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.platform.databean.PropertyBean;
import com.motivewave.platform.databean.RowFormat;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.databean.cell.BaseCell;
import com.motivewave.platform.databean.cell.TextRenderer;
import com.motivewave.platform.databean.cell.UpDownCellRenderer;
import javafx.geometry.Pos;

public class UpDownCell
extends BaseCell {
    float neutralValue = 0.0f;

    public UpDownCell(TableColumnInfo tableColumnInfo, float f2, RowFormatSource rowFormatSource) {
        super(tableColumnInfo, rowFormatSource);
        this.neutralValue = f2;
        this.renderer.setAlignment(Pos.CENTER_RIGHT);
    }

    @Override
    protected void format(PropertyBean propertyBean, Object object) {
        UpDownCellRenderer upDownCellRenderer = (UpDownCellRenderer)this.renderer;
        float f2 = ((Float)object).floatValue();
        if (f2 > this.neutralValue) {
            upDownCellRenderer.setDirection(Boolean.TRUE);
        } else if (f2 < -this.neutralValue) {
            upDownCellRenderer.setDirection(Boolean.FALSE);
        } else {
            RowFormat rowFormat;
            upDownCellRenderer.setDirection(null);
            if (this.isDark()) {
                upDownCellRenderer.setTextWhite();
            } else {
                upDownCellRenderer.setTextBlack();
            }
            if (this.formatSrc != null && (rowFormat = this.formatSrc.getFormat(this.getTableRow())) != null && rowFormat.getForeground() != null) {
                this.renderer.setTextColor(rowFormat.getForeground());
            }
        }
        upDownCellRenderer.setText(propertyBean.format(this.getProperty()));
        upDownCellRenderer.postUpdate();
    }

    @Override
    protected TextRenderer createRenderer() {
        return new UpDownCellRenderer();
    }
}

