/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.common.h;
import com.motivewave.platform.databean.PropertyBean;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.cell.BaseCell;
import com.motivewave.platform.databean.cell.BaseCellFactory;
import com.motivewave.platform.databean.cell.BaseProperty;
import com.motivewave.platform.databean.cell.BaseTreeCell;
import com.motivewave.platform.databean.cell.DelayedProperty;
import com.motivewave.platform.databean.cell.PriceCell;
import com.motivewave.platform.databean.cell.PriceTreeCell;
import com.motivewave.platform.databean.cell.UpDownCell;
import com.motivewave.platform.databean.cell.UpDownDoubleCell;
import com.motivewave.platform.databean.cell.UpDownTreeCell;
import com.motivewave.platform.databean.cell.UpDownTreeDoubleCell;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;

public class TickerCellFactory
extends BaseCellFactory {
    @Override
    protected Callback createValueFactory() {
        return cellDataFeatures -> {
            PropertyBean propertyBean = (PropertyBean)cellDataFeatures.getValue();
            if (propertyBean == null) {
                return null;
            }
            BaseProperty baseProperty = (BaseProperty)this.valueMap.get(propertyBean);
            if (baseProperty != null) {
                return baseProperty;
            }
            baseProperty = this.getProperty(propertyBean, this.info.getProperty());
            this.valueMap.put(propertyBean, baseProperty);
            return baseProperty;
        };
    }

    private BaseProperty getProperty(PropertyBean propertyBean, String string) {
        if (h.a(string, "bidPrice", "askPrice", "lastPrice", "buyPrice", "sellPrice", "closeSellPrice", "closeBuyPrice", "midpoint")) {
            return new DelayedProperty(propertyBean, string);
        }
        return new BaseProperty(propertyBean, string);
    }

    @Override
    protected Callback createTreeValueFactory() {
        return cellDataFeatures -> {
            TreeItem treeItem = cellDataFeatures.getValue();
            if (treeItem == null || !treeItem.isLeaf()) {
                return null;
            }
            Object object = treeItem.getValue();
            if (object == null) {
                return null;
            }
            BaseProperty baseProperty = (BaseProperty)this.valueMap.get(object);
            if (baseProperty != null) {
                return baseProperty;
            }
            try {
                PropertyBean propertyBean = (PropertyBean)treeItem.getValue();
                baseProperty = this.getProperty(propertyBean, this.info.getProperty());
                this.valueMap.put(propertyBean, baseProperty);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return baseProperty;
        };
    }

    @Override
    protected Callback createCellFactory(RowFormatSource rowFormatSource) {
        return tableColumn -> {
            switch (this.info.getProperty()) {
                case "bidPrice": 
                case "askPrice": 
                case "midpoint": 
                case "lastPrice": {
                    return new PriceCell(this.info, rowFormatSource);
                }
                case "change": 
                case "invChange": {
                    return new UpDownCell(this.info, 0.0f, rowFormatSource);
                }
                case "changePer": 
                case "invChangePer": 
                case "percentOffOpen": 
                case "percentOffAvgVolume": {
                    return new UpDownCell(this.info, 1.0E-5f, rowFormatSource);
                }
                case "unrealizedPnL": 
                case "realizedPnL": 
                case "pnl": {
                    return new UpDownDoubleCell(this.info, 0.01, rowFormatSource);
                }
            }
            return new BaseCell(this.info, rowFormatSource);
        };
    }

    @Override
    protected Callback createTreeCellFactory(RowFormatSource rowFormatSource) {
        return treeTableColumn -> {
            switch (this.info.getProperty()) {
                case "bidPrice": 
                case "askPrice": 
                case "midpoint": 
                case "lastPrice": {
                    return new PriceTreeCell(this.info, rowFormatSource);
                }
                case "change": 
                case "invChange": {
                    return new UpDownTreeCell(this.info, 0.0f, rowFormatSource);
                }
                case "changePer": 
                case "invChangePer": 
                case "percentOffOpen": 
                case "percentOffAvgVolume": {
                    return new UpDownTreeCell(this.info, 1.0E-5f, rowFormatSource);
                }
                case "unrealizedPnL": 
                case "realizedPnL": 
                case "pnl": {
                    return new UpDownTreeDoubleCell(this.info, 0.01, rowFormatSource);
                }
            }
            return new BaseTreeCell(this.info, rowFormatSource);
        };
    }
}

