/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.databean.cell.TextRenderer$1;
import com.motivewave.platform.databean.cell.TextRenderer$TextInfo;
import com.motivewave.platform.sdk.common.FontInfo;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class TextRenderer
extends Pane {
    protected TextRenderer$TextInfo text = new TextRenderer$TextInfo();
    protected Color bgColor = null;
    protected Color highlightColor = null;
    protected boolean updated = false;
    protected boolean highlighted = false;
    private Canvas canvas = new TextRenderer$1(this);

    public TextRenderer() {
        this.getChildren().addAll((Object[])new Node[]{this.canvas});
    }

    public boolean isResizable() {
        return true;
    }

    public void resize(double d2, double d3) {
        super.resize(d2, d3);
        this.setWidth(d2);
        this.setHeight(d3);
        if (this.getWidth() <= 10.0 || this.getHeight() <= 10.0) {
            return;
        }
        try {
            this.draw();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected GraphicsContext getGC() {
        return this.canvas.getGraphicsContext2D();
    }

    protected void draw() {
        if (this.bgColor == null || !this.bgColor.isOpaque()) {
            this.getGC().clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        this.drawBG();
        this.drawHighlightColor();
        this.drawText();
        if (this.isHighlighted()) {
            this.drawHighlight();
        }
    }

    protected void drawBG() {
        if (this.bgColor == null) {
            return;
        }
        GraphicsContext graphicsContext = this.getGC();
        graphicsContext.setFill((Paint)this.bgColor);
        graphicsContext.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    protected void drawHighlightColor() {
        if (this.highlightColor == null) {
            return;
        }
        GraphicsContext graphicsContext = this.getGC();
        graphicsContext.setFill((Paint)this.highlightColor);
        graphicsContext.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    protected void drawText() {
        this.text.drawText(this.getGC(), this.bgColor, this.canvas);
    }

    public void clearExceptBg() {
        this.setText("");
        this.setHighlightColor(null);
        this.highlighted = false;
        this.updated = true;
        this.postUpdate();
    }

    public void clear() {
        this.setText("");
        this.setBGColor(null);
        this.setHighlightColor(null);
        this.highlighted = false;
        this.updated = true;
        this.postUpdate();
    }

    public void setText(String string) {
        if (h.a((Object)string, (Object)this.text.getText())) {
            return;
        }
        this.text.setText(string);
        this.updated = true;
    }

    public String getText() {
        return this.text.getText();
    }

    public void setFont(Font font) {
        if (this.text.getFont() == font) {
            return;
        }
        if (this.text.getFont() != null && this.text.getFont().equals((Object)font)) {
            return;
        }
        this.text.setFont(font);
        this.updated = true;
    }

    public void setFrom(FontInfo fontInfo) {
        if (fontInfo == null || !fontInfo.isEnabled()) {
            return;
        }
        if (fontInfo.getFont() != null) {
            this.setFont(UIUtil.a(fontInfo.getFont()));
        }
        if (fontInfo.getColor() != null) {
            this.setTextColor(UIUtil.a(fontInfo.getColor()));
        }
        if (fontInfo.getBgColor() != null) {
            this.setBGColor(UIUtil.a(fontInfo.getBgColor()));
        }
    }

    public void setAlignment(Pos pos) {
        if (this.text.getAlignment() == pos) {
            return;
        }
        this.text.setAlignment(pos);
        this.updated = true;
    }

    public Pos getAlignment() {
        return this.text.getAlignment();
    }

    public void setTextColor(Color color) {
        if (h.a((Object)color, (Object)this.text.getTextColor())) {
            return;
        }
        this.text.setTextColor(color);
        this.updated = true;
    }

    public Color getTextColor() {
        return this.text.getTextColor();
    }

    public void setBGColor(Color color) {
        if (h.a((Object)color, (Object)this.bgColor)) {
            return;
        }
        this.bgColor = color;
        this.updated = true;
    }

    public Color getBGColor() {
        return this.bgColor;
    }

    public void setHighlightColor(Color color) {
        if (h.a((Object)color, (Object)this.highlightColor)) {
            return;
        }
        this.highlightColor = color;
        this.updated = true;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setTextWhite() {
        this.setTextColor(Color.WHITE);
    }

    public void setTextBlack() {
        this.setTextColor(Color.BLACK);
    }

    public void postUpdate() {
        if (!this.updated) {
            return;
        }
        this.updated = false;
        this.draw();
    }

    public void setHighlighted(boolean bl2) {
        if (this.highlighted == bl2) {
            return;
        }
        this.highlighted = bl2;
        this.updated = true;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    protected void drawHighlight() {
        if (!this.highlighted) {
            return;
        }
        GraphicsContext graphicsContext = this.getGC();
        graphicsContext.setStroke((Paint)Color.GRAY);
        graphicsContext.setLineWidth(1.5);
        graphicsContext.setLineDashes(new double[]{5.0, 5.0});
        graphicsContext.strokeRect(1.0, 1.0, this.getWidth() - 2.0, this.getHeight() - 2.0);
    }
}

