/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.platform.databean.PropertyBean;
import com.motivewave.platform.databean.RowFormat;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.databean.cell.BaseCell;
import com.motivewave.platform.databean.cell.BaseTreeCell;
import com.motivewave.platform.databean.cell.MeterArrowRenderer;
import com.motivewave.platform.databean.cell.TextRenderer;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Pos;

public class PriceTreeCell
extends BaseTreeCell {
    Map lastValueMap = new HashMap();

    public PriceTreeCell(TableColumnInfo tableColumnInfo, RowFormatSource rowFormatSource) {
        super(tableColumnInfo, rowFormatSource);
        this.renderer.setAlignment(Pos.CENTER_RIGHT);
    }

    protected boolean isItemChanged(Object object, Object object2) {
        return true;
    }

    @Override
    protected void formatLeaf(Object object, Object object2) {
        MeterArrowRenderer meterArrowRenderer = (MeterArrowRenderer)this.renderer;
        PropertyBean propertyBean = (PropertyBean)object;
        float f2 = ((Float)object2).floatValue();
        Float f3 = (Float)this.lastValueMap.get(propertyBean);
        if (f3 == null) {
            f3 = Float.valueOf(0.0f);
        }
        this.lastValueMap.put(propertyBean, Float.valueOf(f2));
        meterArrowRenderer.setText(propertyBean.formatPrice(f2));
        if (f3.floatValue() == 0.0f || f3.floatValue() == f2) {
            RowFormat rowFormat;
            meterArrowRenderer.setDirection(null);
            if (this.isDark()) {
                meterArrowRenderer.setTextWhite();
            } else {
                meterArrowRenderer.setTextBlack();
            }
            if (this.formatSrc != null && (rowFormat = this.formatSrc.getFormat(this.getTableRow())) != null && rowFormat.getForeground() != null) {
                this.renderer.setTextColor(rowFormat.getForeground());
            }
        } else if (f2 > f3.floatValue()) {
            meterArrowRenderer.setDirection(Boolean.TRUE);
            meterArrowRenderer.setTextColor(BaseCell.getPriceUpColor(this.isDark()));
        } else {
            meterArrowRenderer.setDirection(Boolean.FALSE);
            meterArrowRenderer.setTextColor(BaseCell.getPriceDownColor(this.isDark()));
        }
        meterArrowRenderer.postUpdate();
    }

    @Override
    protected TextRenderer createRenderer() {
        return new MeterArrowRenderer(false);
    }
}

