/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.platform.databean.PropertyBean;
import com.motivewave.platform.databean.RowFormat;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.databean.cell.BaseCell;
import com.motivewave.platform.databean.cell.MeterArrowRenderer;
import com.motivewave.platform.databean.cell.TextRenderer;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Pos;
import javafx.scene.paint.Color;

public class PriceCell
extends BaseCell {
    private Map lastValueMap = new HashMap();

    public PriceCell(TableColumnInfo tableColumnInfo, RowFormatSource rowFormatSource) {
        this(tableColumnInfo, null, null, null, rowFormatSource);
    }

    public PriceCell(TableColumnInfo tableColumnInfo, Color color, Color color2, Color color3, RowFormatSource rowFormatSource) {
        super(tableColumnInfo, color, color2, color3, rowFormatSource);
        this.renderer.setAlignment(Pos.CENTER_RIGHT);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.lastValueMap.clear();
    }

    protected boolean isItemChanged(Object object, Object object2) {
        return true;
    }

    @Override
    protected void format(PropertyBean propertyBean, Object object) {
        float f2 = ((Float)object).floatValue();
        Float f3 = (Float)this.lastValueMap.get(propertyBean);
        if (f3 == null) {
            f3 = Float.valueOf(0.0f);
        }
        this.lastValueMap.put(propertyBean, Float.valueOf(f2));
        MeterArrowRenderer meterArrowRenderer = (MeterArrowRenderer)this.renderer;
        meterArrowRenderer.setText(propertyBean.formatPrice(f2));
        if (f3.floatValue() == 0.0f || f3.floatValue() == f2) {
            RowFormat rowFormat;
            meterArrowRenderer.setDirection(null);
            if (this.textColor == null) {
                if (this.isDark()) {
                    meterArrowRenderer.setTextWhite();
                } else {
                    meterArrowRenderer.setTextBlack();
                }
            }
            if (this.formatSrc != null && (rowFormat = this.formatSrc.getFormat(this.getTableRow())) != null && rowFormat.getForeground() != null) {
                this.renderer.setTextColor(rowFormat.getForeground());
            }
        } else if (f2 > f3.floatValue()) {
            meterArrowRenderer.setDirection(Boolean.TRUE);
            if (this.textColor == null) {
                meterArrowRenderer.setTextColor(PriceCell.getPriceUpColor(this.isDark()));
            }
        } else {
            meterArrowRenderer.setDirection(Boolean.FALSE);
            if (this.textColor == null) {
                meterArrowRenderer.setTextColor(PriceCell.getPriceDownColor(this.isDark()));
            }
        }
        meterArrowRenderer.postUpdate();
    }

    @Override
    protected TextRenderer createRenderer() {
        return new MeterArrowRenderer(false);
    }
}

