/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.themes.ChartTheme;
import com.motivewave.platform.common.themes.Colors;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.cell.TextRenderer;
import com.motivewave.platform.databean.cell.TextRenderer$TextInfo;
import javafx.geometry.Pos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class OrderRenderer
extends TextRenderer {
    private MWOrder order;
    private TextRenderer$TextInfo cancel = new TextRenderer$TextInfo("C");
    private boolean showCancel = false;
    static Color BUY_BLUE = UIUtil.a(Colors.getBuyBlue());
    static Color BUY_GREEN = UIUtil.a(Colors.getBuyGreen());
    static Color SELL = UIUtil.a(Colors.getSell());
    static Color HIGHLIGHT_BUY_BLUE = UIUtil.a(UIUtil.a(Colors.getBuyBlue().brighter()), 120);
    static Color HIGHLIGHT_BUY_GREEN = UIUtil.a(UIUtil.a(Colors.getBuyGreen().brighter()), 120);
    static Color HIGHLIGHT_SELL = UIUtil.a(UIUtil.a(Colors.getSell().brighter()), 120);
    static Color CANCEL;

    public OrderRenderer() {
        this.cancel.setTextColor(Color.BLACK);
        this.setTextColor(Color.WHITE);
        this.setAlignment(Pos.CENTER_LEFT);
    }

    @Override
    public void setTextBlack() {
    }

    @Override
    protected void draw() {
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        if (d2 <= 0.0 || d3 <= 0.0) {
            return;
        }
        if (this.order == null || this.order.isCancelled()) {
            super.draw();
            return;
        }
        GraphicsContext graphicsContext = this.getGC();
        if (this.order.isFilled()) {
            graphicsContext.setFill((Paint)Color.GRAY);
            graphicsContext.fillRect(0.0, 0.0, d2, d3);
            this.drawText();
            return;
        }
        Color color = SELL;
        if (this.order.isBuy()) {
            Color color2 = color = b.o() ? BUY_GREEN : BUY_BLUE;
        }
        if (this.order.isExitStep()) {
            graphicsContext.clearRect(0.0, 0.0, d2, d3);
            color = UIUtil.a(color, 100);
        }
        graphicsContext.setFill((Paint)color);
        graphicsContext.fillRect(0.0, 0.0, d2, d3);
        this.drawText();
        if (this.showCancel) {
            graphicsContext.setFill((Paint)UIUtil.a(ChartTheme.getTheme().CANCEL_BG));
            graphicsContext.fillRect(d2 - 20.0, 0.0, 20.0, d3);
            this.cancel.drawText(graphicsContext, this.bgColor, d2 - this.cancel.getWidth() - 5.0, d3 - (Math.floor((d3 - this.cancel.getHeight()) / 2.0) + 2.0), d2);
        }
        this.drawHighlight();
    }

    public void setOrder(MWOrder mWOrder) {
        if (this.order == mWOrder) {
            return;
        }
        this.order = mWOrder;
        this.updated = true;
    }

    public MWOrder getOrder() {
        return this.order;
    }

    @Override
    public void setFont(Font font) {
        Font font2 = UIUtil.a(font);
        Font font3 = UIUtil.b(font);
        if (this.text.getFont() != null && this.text.getFont().equals((Object)font2)) {
            return;
        }
        this.text.setFont(font2);
        this.cancel.setFont(font3);
        this.updated = true;
    }

    @Override
    public void clear() {
        this.order = null;
        super.clear();
    }

    public void setShowCancel(boolean bl2) {
        if (bl2 == this.showCancel) {
            return;
        }
        this.showCancel = bl2;
        this.draw();
    }
}

