/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import cb.b;
import cb.g;
import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$OrderType;
import com.motivewave.platform.common.af;
import com.motivewave.platform.databean.CallPutOption;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.cell.OrderRenderer;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class OptionOrderCell
extends TableCell {
    private HBox buttons;
    private OrderRenderer renderer;
    private BorderPane pane = new BorderPane();
    private boolean call = true;

    public OptionOrderCell(boolean bl2) {
        this.renderer = new OrderRenderer();
        this.renderer.setFont(this.getFont());
        this.fontProperty().addListener((observableValue, font, font2) -> this.renderer.setFont(this.getFont()));
        this.call = bl2;
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        String string = "-fx-padding: 0.083333em;";
        Button button = new Button(af.a("LBL_BUY", new Object[0]));
        button.setStyle(string);
        button.getStyleClass().add((Object)(com.motivewave.platform.common.b.o() ? "button-green" : "button-blue"));
        button.setOnAction(actionEvent -> this.orderDialog(true));
        button.setMaxWidth(Double.MAX_VALUE);
        button.setMaxHeight(Double.MAX_VALUE);
        button.setFocusTraversable(false);
        button.setTextFill((Paint)Color.WHITE);
        Button button2 = new Button(af.a("LBL_SELL", new Object[0]));
        button2.setStyle(string);
        button2.getStyleClass().add((Object)"button-red");
        button2.setOnAction(actionEvent -> this.orderDialog(false));
        button2.setMaxWidth(Double.MAX_VALUE);
        button2.setMaxHeight(Double.MAX_VALUE);
        button2.setFocusTraversable(false);
        button2.setTextFill((Paint)Color.WHITE);
        HBox.setHgrow((Node)button, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)button2, (Priority)Priority.ALWAYS);
        this.buttons = new HBox(new Node[]{button, button2});
        this.pane.setCenter((Node)this.buttons);
    }

    private void orderDialog(boolean bl2) {
        CallPutOption callPutOption = (CallPutOption)this.getTableRow().getItem();
        if (callPutOption == null) {
            return;
        }
        b b2 = (b)UIUtil.b((Object)this, b.class);
        LiveTicker liveTicker = this.call ? callPutOption.getCallTicker() : callPutOption.getPutTicker();
        MWOrder mWOrder = new MWOrder(b2.b(), liveTicker, bl2 ? Enums$OrderAction.BUY : Enums$OrderAction.SELL, Enums$OrderType.LMT);
        mWOrder.setFromDefaults();
        mWOrder.setLimitPrice(liveTicker.getMidpoint());
        mWOrder.setTif(b2.a());
        mWOrder.setQuantity(b2.a());
        g g2 = new g(b2, mWOrder);
        g2.show();
    }

    protected void updateItem(Object object, boolean bl2) {
        super.updateItem(object, bl2);
        if (bl2) {
            this.setGraphic(null);
            return;
        }
        this.setGraphic((Node)this.pane);
        List list = (List)object;
        if (h.a((Collection)list)) {
            this.pane.setCenter((Node)this.buttons);
        } else {
            MWOrder mWOrder = (MWOrder)list.get(0);
            MWOrder mWOrder2 = mWOrder.getParentOrder();
            if (mWOrder2 != null && mWOrder2.isActive() && mWOrder2.getAcctInstrument() == mWOrder.getAcctInstrument()) {
                mWOrder = mWOrder2;
            }
            Object object2 = "";
            object2 = mWOrder.isEntryOrder() ? "+" : "-";
            if (!mWOrder.isLimit()) {
                object2 = (String)object2 + String.valueOf((Object)mWOrder.getType()) + " ";
            }
            object2 = (String)object2 + mWOrder.format("quantity");
            if (mWOrder.isLimit()) {
                object2 = (String)object2 + "@" + mWOrder.format("limitPrice");
            } else if (mWOrder.isStop()) {
                object2 = (String)object2 + "@" + mWOrder.format("stopPrice");
            }
            this.renderer.setText((String)object2);
            this.renderer.setOrder(mWOrder);
            this.pane.setCenter((Node)this.renderer);
            this.renderer.postUpdate();
        }
    }

    public boolean isCancel(MouseEvent mouseEvent) {
        if (mouseEvent.getTarget() == this) {
            return this.isCancel(mouseEvent.getX());
        }
        return this.isCancel(this.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()).getX());
    }

    public boolean isCancel(double d2) {
        if (this.pane.getCenter() != this.renderer) {
            return false;
        }
        if (this.renderer.getOrder() == null) {
            return false;
        }
        return d2 >= this.getWidth() - 20.0 && d2 <= this.getWidth();
    }

    public MWOrder getOrder() {
        return this.renderer.getOrder();
    }
}

