/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.cell.BaseCell;
import com.motivewave.platform.databean.cell.BaseCellFactory;
import com.motivewave.platform.databean.cell.BaseProperty;
import com.motivewave.platform.databean.cell.DelayedProperty;
import com.motivewave.platform.databean.cell.OptionOrderCell;
import com.motivewave.platform.databean.cell.PriceCell;
import com.motivewave.platform.databean.cell.UpDownCell;
import com.motivewave.platform.databean.cell.UpDownDoubleCell;
import javafx.scene.paint.Color;
import javafx.util.Callback;

public class OptionCellFactory
extends BaseCellFactory {
    private static Color RED1 = UIUtil.a(255, 215, 225);
    private static Color RED2 = UIUtil.a(255, 170, 180);
    private static Color BLUE1 = UIUtil.a(200, 230, 255);
    private static Color BLUE2 = UIUtil.a(150, 200, 255);

    @Override
    protected Callback createCellFactory(RowFormatSource rowFormatSource) {
        return tableColumn -> {
            switch (this.info.getProperty()) {
                case "callBidPrice": 
                case "callAskPrice": 
                case "callLastPrice": {
                    return new PriceCell(this.info, RED1, RED2, null, rowFormatSource);
                }
                case "callBidSize": 
                case "callAskSize": 
                case "callLastSize": {
                    return new BaseCell(this.info, RED1, RED2, null, rowFormatSource);
                }
                case "putBidPrice": 
                case "putAskPrice": 
                case "putLastPrice": {
                    return new PriceCell(this.info, BLUE1, BLUE2, null, rowFormatSource);
                }
                case "putBidSize": 
                case "putAskSize": 
                case "putLastSize": {
                    return new BaseCell(this.info, BLUE1, BLUE2, null, rowFormatSource);
                }
                case "callChange": 
                case "callChangePer": 
                case "putChange": 
                case "putChangePer": {
                    return new UpDownCell(this.info, 0.0f, rowFormatSource);
                }
                case "callOrder": {
                    return new OptionOrderCell(true);
                }
                case "putOrder": {
                    return new OptionOrderCell(false);
                }
                case "callPnl": 
                case "putPnl": {
                    return new UpDownDoubleCell(this.info, 0.01, rowFormatSource);
                }
            }
            return new BaseCell(this.info, rowFormatSource);
        };
    }

    @Override
    protected Callback createValueFactory() {
        return cellDataFeatures -> {
            ObservableBean observableBean = (ObservableBean)cellDataFeatures.getValue();
            if (observableBean == null) {
                return null;
            }
            BaseProperty baseProperty = (BaseProperty)this.valueMap.get(observableBean);
            if (baseProperty != null) {
                return baseProperty;
            }
            baseProperty = this.getProperty(observableBean, this.info.getProperty());
            this.valueMap.put(observableBean, baseProperty);
            return baseProperty;
        };
    }

    protected BaseProperty getProperty(ObservableBean observableBean, String string) {
        if (h.a(string, "callBidPrice", "callAskPrice", "callLastPrice", "putBidPrice", "putAskPrice", "putLastPrice")) {
            return new DelayedProperty(observableBean, string);
        }
        return new BaseProperty(observableBean, string);
    }
}

