/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.cell.TextRenderer;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MeterArrowRenderer
extends TextRenderer {
    public static final Color LIGHTBLUE = new Color(0.6784313917160034, 0.8470588326454163, 0.9019607901573181, 1.0);
    public static final Color LIGHTGREEN = Color.LIGHTGREEN;
    public static final Color PINK = new Color(1.0, 0.7529411911964417, 0.7960784435272217, 1.0);
    private static final Color UP = UIUtil.a(0, 122, 204);
    private static final Color UP_GREEN = UIUtil.a(20, 140, 40);
    private static final Color DOWN = UIUtil.a(220, 35, 0);
    private double per;
    private Color fill = UIUtil.a(0, 122, 204);
    private Boolean up;
    private boolean showArrow = true;
    private boolean showMeter = true;

    public MeterArrowRenderer(boolean bl2) {
        this.showMeter = bl2;
    }

    public MeterArrowRenderer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void draw() {
        int n2;
        GraphicsContext graphicsContext = this.getGC();
        if (this.bgColor == null || !this.bgColor.isOpaque()) {
            graphicsContext.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        this.drawBG();
        if (this.fill != null && this.showMeter && (n2 = (int)Math.round(this.getWidth() * this.per)) > 0) {
            graphicsContext.setFill((Paint)this.fill);
            switch (this.getAlignment()) {
                case CENTER_LEFT: 
                case BASELINE_LEFT: 
                case BOTTOM_LEFT: 
                case TOP_LEFT: {
                    graphicsContext.fillRect(0.0, 1.0, (double)n2, this.getHeight() - 2.0);
                    break;
                }
                case CENTER_RIGHT: 
                case BASELINE_RIGHT: 
                case BOTTOM_RIGHT: 
                case TOP_RIGHT: {
                    graphicsContext.fillRect(this.getWidth() - (double)n2, 1.0, (double)n2, this.getHeight() - 2.0);
                    break;
                }
                default: {
                    graphicsContext.fillRect(this.getWidth() / 2.0 - (double)(n2 / 2), 1.0, (double)n2, this.getHeight() - 2.0);
                }
            }
        }
        this.drawHighlightColor();
        this.drawText();
        if (!this.showArrow) {
            return;
        }
        Boolean bl2 = this.up;
        if (bl2 == null) {
            return;
        }
        double d2 = this.getWidth();
        double d3 = Math.floor(d2 - this.text.getWidth() - 12.0);
        switch (this.getAlignment()) {
            case CENTER_LEFT: 
            case BASELINE_LEFT: 
            case BOTTOM_LEFT: 
            case TOP_LEFT: {
                d3 = this.text.getWidth() + 12.0;
                break;
            }
            case BASELINE_CENTER: 
            case CENTER: 
            case TOP_CENTER: 
            case BOTTOM_CENTER: {
                d3 = d2 / 2.0 - this.text.getWidth() / 2.0 - 12.0;
                break;
            }
        }
        double d4 = this.getHeight() / 2.0;
        graphicsContext.translate(d3, d4);
        try {
            int n3 = 0;
            int n4 = 0;
            int n5 = 7;
            int n6 = 3;
            int n7 = 6;
            if (bl2.booleanValue()) {
                graphicsContext.setFill((Paint)(b.o() ? UP_GREEN : UP));
                graphicsContext.beginPath();
                graphicsContext.moveTo((double)(n3 - n6), (double)(n4 + n7));
                graphicsContext.lineTo((double)(n3 + n6), (double)(n4 + n7));
                graphicsContext.lineTo((double)(n3 + n6), (double)(n4 - n7 + n5));
                graphicsContext.lineTo((double)(n3 + n5), (double)(n4 - n7 + n5));
                graphicsContext.lineTo((double)n3, (double)(n4 - n7));
                graphicsContext.lineTo((double)(n3 - n5), (double)(n4 - n7 + n5));
                graphicsContext.lineTo((double)(n3 - n6), (double)(n4 - n7 + n5));
                graphicsContext.closePath();
                graphicsContext.fill();
            } else {
                graphicsContext.setFill((Paint)DOWN);
                graphicsContext.beginPath();
                graphicsContext.moveTo((double)(n3 - n6), (double)(n4 - n7));
                graphicsContext.lineTo((double)(n3 + n6), (double)(n4 - n7));
                graphicsContext.lineTo((double)(n3 + n6), (double)(n4 + n7 - n5));
                graphicsContext.lineTo((double)(n3 + n5), (double)(n4 + n7 - n5));
                graphicsContext.lineTo((double)n3, (double)(n4 + n7));
                graphicsContext.lineTo((double)(n3 - n5), (double)(n4 + n7 - n5));
                graphicsContext.lineTo((double)(n3 - n6), (double)(n4 + n7 - n5));
                graphicsContext.closePath();
                graphicsContext.fill();
            }
        }
        finally {
            graphicsContext.translate(-d3, -d4);
        }
    }

    @Override
    public void clear() {
        this.setDirection(null);
        this.setPercent(0.0);
        super.clear();
    }

    public void setDirection(Boolean bl2) {
        if (this.up == bl2) {
            return;
        }
        this.up = bl2;
        this.updated = true;
    }

    public void setPercent(double d2) {
        if (this.per == d2) {
            return;
        }
        this.per = d2;
        this.updated = true;
    }

    public void setFill(Color color) {
        if (h.a((Object)color, (Object)this.fill)) {
            return;
        }
        this.fill = color;
        this.updated = true;
    }

    public void setShowArrow(boolean bl2) {
        this.showArrow = bl2;
    }

    public boolean isShowArrow() {
        return this.showArrow;
    }

    public void setShowMeter(boolean bl2) {
        this.showMeter = bl2;
    }

    public boolean isShowMeter() {
        return this.showMeter;
    }
}

