/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.common.h;
import com.motivewave.platform.databean.Flag;
import com.motivewave.platform.databean.cell.TextRenderer;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;

public class FlagRenderer
extends TextRenderer {
    private String flagId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void draw() {
        Flag flag = Flag.get(this.flagId);
        GraphicsContext graphicsContext = this.getGC();
        graphicsContext.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        if (flag == null) return;
        if (flag.getType() == null) {
            return;
        }
        this.drawBG();
        this.drawHighlightColor();
        double d2 = this.getWidth() / 2.0;
        double d3 = this.getHeight() / 2.0;
        graphicsContext.setFill((Paint)flag.getColor());
        graphicsContext.translate(d2, d3);
        try {
            switch (flag.getType()) {
                case CIRCLE: {
                    graphicsContext.fillOval(-6.0, -6.0, 12.0, 12.0);
                    return;
                }
                case SQUARE: {
                    graphicsContext.fillRect(-6.0, -6.0, 12.0, 12.0);
                    return;
                }
                case TRIANGLE: {
                    graphicsContext.fillPolygon(new double[]{0.0, -8.0, 8.0}, new double[]{-6.0, 6.0, 6.0}, 3);
                    return;
                }
                case OCTOGON: {
                    graphicsContext.fillPolygon(new double[]{-2.5, 2.5, 6.0, 6.0, 2.5, -2.5, -6.0, -6.0}, new double[]{-6.0, -6.0, -2.5, 2.5, 6.0, 6.0, 2.5, -2.5}, 8);
                    return;
                }
                case FLAG: {
                    graphicsContext.beginPath();
                    graphicsContext.moveTo(-7.0, -6.0);
                    graphicsContext.lineTo(7.0, -6.0);
                    graphicsContext.lineTo(2.0, 0.0);
                    graphicsContext.lineTo(7.0, 6.0);
                    graphicsContext.lineTo(-7.0, 6.0);
                    graphicsContext.closePath();
                    graphicsContext.fill();
                    return;
                }
                case STAR: {
                    graphicsContext.beginPath();
                    graphicsContext.moveTo(0.0, -7.0);
                    graphicsContext.lineTo(2.0, -1.5);
                    graphicsContext.lineTo(7.0, -1.5);
                    graphicsContext.lineTo(3.0, 2.0);
                    graphicsContext.lineTo(5.0, 7.0);
                    graphicsContext.lineTo(0.0, 4.0);
                    graphicsContext.lineTo(-5.0, 7.0);
                    graphicsContext.lineTo(-3.0, 2.0);
                    graphicsContext.lineTo(-7.0, -1.5);
                    graphicsContext.lineTo(-2.0, -1.5);
                    graphicsContext.closePath();
                    graphicsContext.fill();
                    return;
                }
                case CHECK: {
                    graphicsContext.setLineWidth(3.0);
                    graphicsContext.setLineCap(StrokeLineCap.ROUND);
                    graphicsContext.setStroke((Paint)flag.getColor());
                    graphicsContext.strokeLine(-5.0, 0.0, -1.0, 5.0);
                    graphicsContext.strokeLine(-1.0, 5.0, 6.0, -5.0);
                    return;
                }
            }
            return;
        }
        finally {
            graphicsContext.translate(-d2, -d3);
        }
    }

    @Override
    public void clear() {
        this.setFlag(null);
        super.clear();
    }

    public void setFlag(String string) {
        if (h.a((Object)string, (Object)this.flagId)) {
            return;
        }
        this.flagId = string;
        this.updated = true;
    }
}

