/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.util.j;
import com.motivewave.platform.databean.GroupInfo;
import com.motivewave.platform.databean.PropertyBean;
import com.motivewave.platform.databean.RowFormat;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.databean.cell.BaseProperty;
import com.motivewave.platform.databean.cell.BaseProperty$ByPassListener;
import com.motivewave.platform.databean.cell.TextRenderer;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableRow;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class BaseTreeCell
extends TreeTableCell
implements j,
BaseProperty$ByPassListener {
    private Label overflowLabel = new Label();
    private Group overflowGroup = new Group(new Node[]{this.overflowLabel});
    protected TableColumnInfo info;
    protected TextRenderer renderer;
    protected RowFormatSource formatSrc;
    private BaseProperty propertyBean;
    private ChangeListener selectedListener = (observableValue, bl2, bl3) -> {
        if (bl3.booleanValue() && UIUtil.c) {
            this.renderer.setTextWhite();
        } else {
            this.renderer.setTextBlack();
        }
    };
    private ChangeListener rowListener = (observableValue, treeTableRow, treeTableRow2) -> {
        if (treeTableRow != null) {
            treeTableRow.selectedProperty().removeListener(this.selectedListener);
        }
        if (treeTableRow2 != null) {
            treeTableRow2.selectedProperty().addListener(this.selectedListener);
        }
    };

    public BaseTreeCell(TableColumnInfo tableColumnInfo, RowFormatSource rowFormatSource) {
        this.info = tableColumnInfo;
        this.renderer = this.createRenderer();
        this.formatSrc = rowFormatSource;
        this.clipProperty().addListener((observableValue, node, node2) -> {
            if (node2 != null) {
                this.setClip((Node)(this.isLeaf() ? node2 : null));
            }
        });
        switch (tableColumnInfo.getAlign()) {
            case 0: {
                this.renderer.setAlignment(Pos.CENTER);
                break;
            }
            case 2: {
                this.renderer.setAlignment(Pos.CENTER_LEFT);
                break;
            }
            case 4: {
                this.renderer.setAlignment(Pos.CENTER_RIGHT);
                break;
            }
        }
        this.setGraphic((Node)this.renderer);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.renderer.setFont(this.getFont());
        this.fontProperty().addListener((observableValue, font, font2) -> this.renderer.setFont(this.getFont()));
        if (!UIUtil.c) {
            this.tableRowProperty().addListener(this.rowListener);
        }
    }

    @Override
    public void destroy() {
        if (this.propertyBean != null) {
            this.propertyBean.removeByPassListener(this);
        }
        this.propertyBean = null;
        ReadOnlyObjectProperty readOnlyObjectProperty = this.tableRowProperty();
        if (readOnlyObjectProperty != null) {
            readOnlyObjectProperty.removeListener(this.rowListener);
            if (readOnlyObjectProperty.get() != null) {
                ((TreeTableRow)readOnlyObjectProperty.get()).selectedProperty().removeListener(this.selectedListener);
            }
        }
    }

    boolean isLeaf() {
        TreeItem treeItem = this.getTableRow().getTreeItem();
        return treeItem == null || treeItem.isLeaf();
    }

    public void updateIndex(int n2) {
        super.updateIndex(n2);
        if (n2 >= 0) {
            BaseProperty baseProperty = (BaseProperty)this.getTableColumn().getCellObservableValue(n2);
            if (baseProperty == this.propertyBean) {
                return;
            }
            if (this.propertyBean != null) {
                this.propertyBean.removeByPassListener(this);
            }
            if (baseProperty != null) {
                baseProperty.addByPassListener(this);
            }
            this.propertyBean = baseProperty;
        } else if (this.propertyBean != null) {
            this.propertyBean.removeByPassListener(this);
            this.propertyBean = null;
        }
    }

    protected boolean isDark() {
        if (UIUtil.c) {
            return true;
        }
        TreeTableRow treeTableRow = this.getTableRow();
        return treeTableRow != null && treeTableRow.isSelected();
    }

    @Override
    public void updated(Object object) {
        this.updateItem(object, object == null);
    }

    protected void updateItem(Object object, boolean bl2) {
        super.updateItem(object, bl2);
        TreeTableRow treeTableRow = this.getTableRow();
        TreeItem treeItem = treeTableRow.getTreeItem();
        this.setGraphic((Node)this.renderer);
        this.setBackground(null);
        if (bl2 || treeItem == null) {
            treeTableRow.setStyle(null);
            this.renderer.clear();
            return;
        }
        Object object2 = treeItem.getValue();
        if (treeItem.isLeaf()) {
            RowFormat rowFormat;
            RowFormat rowFormat2 = rowFormat = this.formatSrc == null ? null : this.formatSrc.getFormat(treeTableRow);
            if (this.isDark()) {
                this.renderer.setTextWhite();
            } else {
                this.renderer.setTextBlack();
            }
            this.renderer.setBGColor(null);
            if (rowFormat != null) {
                treeTableRow.setStyle(rowFormat.getStyle());
                if (rowFormat.getForeground() != null) {
                    this.renderer.setTextColor(rowFormat.getForeground());
                } else if (rowFormat.getBackground() != null) {
                    this.renderer.setTextColor(h.a(rowFormat.getBackground()));
                }
            } else {
                treeTableRow.setStyle(null);
            }
            if (object2 == null || object == null) {
                this.renderer.clear();
                return;
            }
            this.formatLeaf(object2, object);
        } else {
            this.updateGroup(object2);
        }
    }

    protected void formatLeaf(Object object, Object object2) {
        PropertyBean propertyBean = (PropertyBean)object;
        this.renderer.setText(propertyBean.format(this.getProperty()));
        this.renderer.postUpdate();
    }

    protected void updateGroup(Object object) {
        int n2 = this.getTreeTableView().getColumns().indexOf((Object)this.getTableColumn());
        TreeTableRow treeTableRow = this.getTableRow();
        if (object instanceof GroupInfo) {
            GroupInfo groupInfo = (GroupInfo)object;
            if (!groupInfo.isDefaultColors()) {
                java.awt.Color color = groupInfo.getBackground();
                treeTableRow.setStyle("-fx-background-color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");");
            } else {
                treeTableRow.setStyle(null);
            }
            if (n2 == 0) {
                this.setClip(null);
                this.overflowLabel.setText(groupInfo.getName());
                this.overflowLabel.setStyle("-fx-padding: 0 0 0 20;");
                if (groupInfo.getLink() != null) {
                    this.overflowLabel.setGraphic(groupInfo.getLink().getIconFX());
                } else {
                    this.overflowLabel.setGraphic(null);
                }
                if (!groupInfo.isDefaultColors()) {
                    UIUtil.a(this.overflowLabel, groupInfo.getForeground());
                } else {
                    this.overflowLabel.setTextFill((Paint)Color.WHITE);
                }
                this.setGraphic((Node)this.overflowGroup);
            } else {
                this.setGraphic(null);
            }
        } else {
            treeTableRow.setStyle(null);
            this.setGraphic(null);
        }
    }

    public String getProperty() {
        return this.info.getProperty();
    }

    protected TextRenderer createRenderer() {
        return new TextRenderer();
    }
}

