/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.common.util.aa;
import com.motivewave.common.util.j;
import com.motivewave.platform.databean.PropertyBean;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.databean.cell.BaseCell;
import com.motivewave.platform.databean.cell.BaseProperty;
import com.motivewave.platform.databean.cell.BaseTreeCell;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.util.Callback;

public class BaseCellFactory
implements aa,
j {
    protected Map valueMap = new HashMap();
    protected TableColumnInfo info;

    public void setInfo(TableColumnInfo tableColumnInfo) {
        this.info = tableColumnInfo;
    }

    public TableColumn createColumn(RowFormatSource rowFormatSource) {
        TableColumn tableColumn = new TableColumn(this.info.getLabel());
        if (this.info.getWidth() > 0) {
            tableColumn.setPrefWidth((double)this.info.getWidth());
        }
        tableColumn.setCellValueFactory(this.createValueFactory());
        tableColumn.setCellFactory(this.createCellFactory(rowFormatSource));
        if (!this.info.isVisible()) {
            tableColumn.setVisible(false);
        }
        tableColumn.setUserData((Object)this.info);
        return tableColumn;
    }

    public TreeTableColumn createTreeColumn(RowFormatSource rowFormatSource) {
        TreeTableColumn treeTableColumn = new TreeTableColumn(this.info.getLabel());
        if (this.info.getWidth() > 0) {
            treeTableColumn.setPrefWidth((double)this.info.getWidth());
        }
        treeTableColumn.setCellValueFactory(this.createTreeValueFactory());
        treeTableColumn.setCellFactory(this.createTreeCellFactory(rowFormatSource));
        if (!this.info.isVisible()) {
            treeTableColumn.setVisible(false);
        }
        treeTableColumn.setUserData((Object)this.info);
        return treeTableColumn;
    }

    @Override
    public void destroy() {
        if (this.valueMap == null) {
            return;
        }
        this.valueMap.clear();
    }

    public void release(PropertyBean propertyBean) {
        BaseProperty baseProperty = (BaseProperty)this.valueMap.remove(propertyBean);
        if (baseProperty != null) {
            propertyBean.removePropertyChangeListener(baseProperty);
            baseProperty.destroy();
        }
    }

    @Override
    public BaseCellFactory clone() {
        try {
            BaseCellFactory baseCellFactory = (BaseCellFactory)super.clone();
            baseCellFactory.valueMap = new HashMap(this.valueMap);
            return baseCellFactory;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Callback createValueFactory() {
        return cellDataFeatures -> {
            PropertyBean propertyBean = (PropertyBean)cellDataFeatures.getValue();
            if (propertyBean == null) {
                return null;
            }
            BaseProperty baseProperty = (BaseProperty)this.valueMap.get(propertyBean);
            if (baseProperty != null) {
                return baseProperty;
            }
            baseProperty = this.createProperty(propertyBean, this.info.getProperty());
            this.valueMap.put(propertyBean, baseProperty);
            return baseProperty;
        };
    }

    protected Callback createTreeValueFactory() {
        return cellDataFeatures -> {
            TreeItem treeItem = cellDataFeatures.getValue();
            if (treeItem == null || !treeItem.isLeaf()) {
                return null;
            }
            Object object = treeItem.getValue();
            if (object == null) {
                return null;
            }
            BaseProperty baseProperty = (BaseProperty)this.valueMap.get(object);
            if (baseProperty != null) {
                return baseProperty;
            }
            baseProperty = this.createProperty((PropertyBean)object, this.info.getProperty());
            this.valueMap.put((PropertyBean)object, baseProperty);
            return baseProperty;
        };
    }

    protected BaseProperty createProperty(PropertyBean propertyBean, String string) {
        return new BaseProperty(propertyBean, this.info.getProperty());
    }

    protected Callback createCellFactory(RowFormatSource rowFormatSource) {
        return tableColumn -> new BaseCell(this.info, rowFormatSource);
    }

    protected Callback createTreeCellFactory(RowFormatSource rowFormatSource) {
        return treeTableColumn -> new BaseTreeCell(this.info, rowFormatSource);
    }
}

