/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean.cell;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.util.j;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.PropertyBean;
import com.motivewave.platform.databean.RowFormat;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.databean.cell.BaseProperty;
import com.motivewave.platform.databean.cell.BaseProperty$ByPassListener;
import com.motivewave.platform.databean.cell.MeterArrowRenderer;
import com.motivewave.platform.databean.cell.TextRenderer;
import java.awt.FontMetrics;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableRow;
import javafx.scene.paint.Color;

public class BaseCell
extends TableCell
implements j,
BaseProperty$ByPassListener {
    public static final double STRIPE_FACTOR = 0.85;
    protected TableColumnInfo info;
    protected TextRenderer renderer;
    protected RowFormatSource formatSrc;
    protected Color bgColor1;
    protected Color bgColor2;
    protected Color textColor;
    private BaseProperty propertyBean;
    private FontMetrics fm;
    private ChangeListener selectedListener = (observableValue, bl2, bl3) -> {
        if (this.textColor != null) {
            return;
        }
        if (bl3.booleanValue() && UIUtil.c) {
            this.renderer.setTextWhite();
        } else {
            this.renderer.setTextBlack();
        }
    };
    private ChangeListener rowListener = (observableValue, tableRow, tableRow2) -> {
        if (tableRow != null) {
            tableRow.selectedProperty().removeListener(this.selectedListener);
        }
        if (tableRow2 != null) {
            tableRow2.selectedProperty().addListener(this.selectedListener);
        }
    };

    public BaseCell(TableColumnInfo tableColumnInfo, RowFormatSource rowFormatSource) {
        this.info = tableColumnInfo;
        this.renderer = this.createRenderer();
        this.formatSrc = rowFormatSource;
        switch (tableColumnInfo.getAlign()) {
            case 0: {
                this.renderer.setAlignment(Pos.CENTER);
                break;
            }
            case 2: {
                this.renderer.setAlignment(Pos.CENTER_LEFT);
                break;
            }
            case 4: {
                this.renderer.setAlignment(Pos.CENTER_RIGHT);
                break;
            }
        }
        this.renderer.setFont(this.getFont());
        this.fontProperty().addListener((observableValue, font, font2) -> {
            this.renderer.setFont(this.getFont());
            this.fm = null;
        });
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.setGraphic((Node)this.renderer);
        if (!UIUtil.c) {
            this.tableRowProperty().addListener(this.rowListener);
        }
    }

    public BaseCell(TableColumnInfo tableColumnInfo, Color color, Color color2, Color color3, RowFormatSource rowFormatSource) {
        this(tableColumnInfo, rowFormatSource);
        this.bgColor1 = color;
        this.bgColor2 = color2;
        this.textColor = color3;
    }

    @Override
    public void destroy() {
        if (this.propertyBean != null) {
            this.propertyBean.removeByPassListener(this);
        }
        this.propertyBean = null;
        ReadOnlyObjectProperty readOnlyObjectProperty = this.tableRowProperty();
        if (readOnlyObjectProperty != null) {
            readOnlyObjectProperty.removeListener(this.rowListener);
            if (readOnlyObjectProperty.get() != null) {
                ((TableRow)readOnlyObjectProperty.get()).selectedProperty().removeListener(this.selectedListener);
            }
        }
    }

    protected boolean isDark() {
        return UIUtil.c || this.getTableRow().isSelected();
    }

    public void updateIndex(int n2) {
        super.updateIndex(n2);
        if (n2 >= 0) {
            BaseProperty baseProperty = (BaseProperty)this.getTableColumn().getCellObservableValue(n2);
            if (baseProperty == this.propertyBean) {
                return;
            }
            if (this.propertyBean != null) {
                this.propertyBean.removeByPassListener(this);
            }
            if (baseProperty != null) {
                baseProperty.addByPassListener(this);
            }
            this.propertyBean = baseProperty;
        } else if (this.propertyBean != null) {
            this.propertyBean.removeByPassListener(this);
            this.propertyBean = null;
        }
    }

    @Override
    public final void updated(Object object) {
        this.updateItem(object, object == null);
    }

    protected void updateItem(Object object, boolean bl2) {
        RowFormat rowFormat;
        super.updateItem(object, bl2);
        TableRow tableRow = this.getTableRow();
        if (tableRow == null) {
            this.renderer.clear();
            return;
        }
        RowFormat rowFormat2 = rowFormat = this.formatSrc == null ? null : this.formatSrc.getFormat(tableRow);
        if (this.isDark()) {
            this.renderer.setTextWhite();
        } else {
            this.renderer.setTextBlack();
        }
        this.renderer.setBGColor(null);
        if (this.textColor != null) {
            this.renderer.setTextColor(this.textColor);
        }
        if (rowFormat != null) {
            tableRow.setStyle(rowFormat.getStyle());
            if (rowFormat.getForeground() != null) {
                this.renderer.setTextColor(rowFormat.getForeground());
            } else if (rowFormat.getBackground() != null) {
                this.renderer.setTextColor(h.a(rowFormat.getBackground()));
            }
        } else {
            tableRow.setStyle(null);
        }
        if (object == null || bl2) {
            this.renderer.clear();
            return;
        }
        PropertyBean propertyBean = (PropertyBean)tableRow.getItem();
        if (propertyBean == null) {
            this.renderer.clear();
            return;
        }
        try {
            this.format(propertyBean, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void format(PropertyBean propertyBean, Object object) {
        String string = propertyBean.format(this.getProperty());
        this.renderer.setText(string);
        this.renderer.postUpdate();
    }

    public String getProperty() {
        return this.info.getProperty();
    }

    protected TextRenderer createRenderer() {
        return new TextRenderer();
    }

    protected Color stripe(java.awt.Color color) {
        if (color == null) {
            return null;
        }
        if (this.formatSrc != null && !this.formatSrc.isStripe()) {
            return UIUtil.a(color);
        }
        if (UIUtil.c) {
            return UIUtil.a(this.getTableRow().getIndex() % 2 == 0 ? UIUtil.d(color, 0.85) : color);
        }
        return UIUtil.a(this.getTableRow().getIndex() % 2 == 0 ? color : UIUtil.d(color, 0.85));
    }

    protected Color stripe(Color color) {
        if (this.formatSrc != null && !this.formatSrc.isStripe()) {
            return color;
        }
        if (color == null) {
            return null;
        }
        if (UIUtil.c) {
            return this.getTableRow().getIndex() % 2 == 0 ? UIUtil.a(color, 0.85) : color;
        }
        return this.getTableRow().getIndex() % 2 == 0 ? color : UIUtil.a(color, 0.85);
    }

    public static Color getTextColor(Color color) {
        if (color == null) {
            return UIUtil.c ? Color.WHITE : Color.BLACK;
        }
        return h.a(color);
    }

    public static Color getPriceUpColor(boolean bl2) {
        if (b.o()) {
            return bl2 ? MeterArrowRenderer.LIGHTGREEN : Color.DARKGREEN;
        }
        return bl2 ? MeterArrowRenderer.LIGHTBLUE : Color.DARKBLUE;
    }

    public static Color getPriceUpBgColor(boolean bl2) {
        return BaseCell.getPriceUpColor(bl2).darker().darker().darker().darker();
    }

    public static Color getPriceDownColor(boolean bl2) {
        return bl2 ? MeterArrowRenderer.PINK : Color.DARKRED;
    }

    public static Color getPriceDownBgColor(boolean bl2) {
        return BaseCell.getPriceDownColor(bl2).darker().darker().darker().darker();
    }

    protected FontMetrics getFM() {
        if (this.fm != null) {
            return this.fm;
        }
        this.fm = UIUtil.a(this.getFont());
        return this.fm;
    }

    protected int computeWidth(String string) {
        return (int)UIUtil.a(string, this.getFont());
    }
}

