/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import cj.e;
import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.util.g;
import com.motivewave.common.util.w;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.Enums$WSLocation;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.af;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.f;
import com.motivewave.platform.databean.AnalysisSource;
import com.motivewave.platform.databean.DirectoryListener;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.ServiceInfo;
import com.motivewave.platform.databean.ct;
import com.motivewave.platform.databean.cu;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.ui.component.n;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class Workspace
extends ObservableBean {
    private String name;
    private String oldName = null;
    private Enums$ServiceType service;
    private Enums$WSLocation location = Enums$WSLocation.LOCAL;
    private String wsBucket;
    private List instances = new ArrayList();
    private Map settingsMap = new HashMap();
    private boolean useDatabase = true;
    private File directory;
    private boolean includePreferences = true;
    private boolean includeWindows = true;
    private boolean includeWatchLists = true;
    private boolean includeScans = true;
    private boolean includeTemplates = true;
    private boolean includeAlerts = true;
    private boolean overrideRepository = true;
    private g analysisSources = new g();
    private boolean modifiedOrNew = false;
    private static File workspacesDir;
    private static g workspaces;
    private static List removedWorkspaces;
    private static Map name2Workspace;
    private static File workingDir;
    private static String SYNC;
    private static g listeners;

    public Workspace(String string, Enums$ServiceType enums$ServiceType) {
        if (h.g(string)) {
            System.err.println("Workspace() name is empty!");
            h.c();
        }
        this.name = string;
        if (h.b((Object)enums$ServiceType)) {
            enums$ServiceType = Enums$ServiceType.IB;
        }
        this.service = enums$ServiceType;
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "name": {
                return this.getName();
            }
            case "service": {
                return this.getService().toString();
            }
            case "location": {
                return this.getLocation().toString();
            }
        }
        return super.format(string);
    }

    public File getConfigDir() {
        return this.getConfigDir(true);
    }

    public File getAnalysisDir() {
        if (!this.isUseDatabase() && this.directory != null && this.directory.exists()) {
            return new File(this.directory, "analysis");
        }
        return new File(Workspace.getWorkspaceDir(), "analysis");
    }

    public File getConfigDir(boolean bl2) {
        if (bs.a() == this && !this.isUseDatabase() && bl2) {
            return new File(this.directory, "config");
        }
        File file = new File(this.getDir(), "cfg");
        if (file.exists()) {
            return file;
        }
        return new File(this.getDir(), "config");
    }

    public boolean isVersion4() {
        if (!this.getDir().exists()) {
            return false;
        }
        File file = this.getConfigDir();
        return !file.exists();
    }

    public void read() {
        if (!h.a((Collection)this.instances)) {
            return;
        }
        String string = h.c(new File(this.getConfigDir(false), "workspace.json"));
        if (!this.isJSON(string)) {
            String string2 = ab.k(string);
            if (!this.isJSON(string2)) {
                string2 = ab.g(string);
            }
            string = string2;
        }
        try {
            this.b(string);
        }
        catch (Exception exception) {
            h.a.severe("Workspace::read() error reading workspace: " + string);
        }
    }

    private boolean isJSON(String string) {
        try {
            new JSONObject(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void save() {
        File file = this.getConfigDir(false);
        file.mkdirs();
        h.c(new File(file, "workspace.json"), ab.j(this.toJSON()));
        Workspace.notifyUpdated(this);
    }

    public String getSetting(String string) {
        return (String)this.settingsMap.get(string);
    }

    public void setSetting(String string, String string2) {
        this.settingsMap.put(string, string2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (!h.g(string2) && !h.a((Object)string, (Object)string2)) {
            this.oldName = string2;
        }
        this.notify("name", string2, string);
    }

    public boolean isLocal() {
        return this.location == null || this.location == Enums$WSLocation.LOCAL || !ai.b();
    }

    public boolean isRemote() {
        return !this.isLocal();
    }

    public Enums$WSLocation getLocation() {
        return ai.b() ? this.location : Enums$WSLocation.LOCAL;
    }

    public void setLocation(Enums$WSLocation enums$WSLocation) {
        Enums$WSLocation enums$WSLocation2 = this.location;
        this.location = enums$WSLocation;
        this.notify("location", (Object)enums$WSLocation2, (Object)this.location);
    }

    public String getWsBucket() {
        return this.wsBucket;
    }

    public void setWsBucket(String string) {
        String string2 = this.wsBucket;
        this.wsBucket = string;
        this.notify("wsBucket", string2, this.wsBucket);
    }

    public Enums$ServiceType getService() {
        if (h.a((Collection)this.instances)) {
            return this.service;
        }
        ServiceInfo serviceInfo = this.getPrimaryService();
        if (serviceInfo == null || serviceInfo.getPrimaryInfo() == null) {
            return this.service;
        }
        return serviceInfo.getPrimaryInfo().getType();
    }

    @Override
    public List getNVPs() {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : this.settingsMap.keySet()) {
            Object object3;
            if (h.a((String)object2, "lastOrderId", "clientOrders", "console", "repository") || h.g((String)(object3 = (String)this.settingsMap.get(object2)))) continue;
            arrayList.add(this.a((String)object2, (String)object3));
        }
        Object object4 = h.b(new String[]{this.a("useDatabase", this.useDatabase), this.a("includePreferences", this.includePreferences), this.a("includeWindows", this.includeWindows), this.a("includeWatchLists", this.includeWatchLists), this.a("includeScans", this.includeScans), this.a("includeTemplates", this.includeTemplates), this.a("includeAlerts", this.includeAlerts), this.a("directory", this.directory), this.a("overrideRepository", this.overrideRepository)});
        object2 = h.b(new String[0]);
        for (AnalysisSource analysisSource : this.analysisSources.a()) {
            File file;
            if (analysisSource == null || (file = analysisSource.getDirectory()) == null || !file.exists() || !file.isDirectory()) continue;
            object2.add(this.a(this.b("name", analysisSource.getName()), this.a("readOnly", analysisSource.isReadOnly()), this.a("dir", file)));
        }
        object4.add(this.a("sources", (Collection)object2));
        return h.b(new String[]{this.b("name", this.name), this.a("location", (Object)this.location), this.a("wsBucket", this.wsBucket), this.a("instances", this.instances), this.a("repository", this.a((Collection)object4)), this.a("settings", this.a(arrayList))});
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        Object object2;
        this.name = jSONObject.str("name");
        if (h.g(this.name)) {
            System.err.println("Workspace::fromJSON() name is empty!");
            System.err.println(jSONObject);
            h.c();
        }
        if (jSONObject.has("location")) {
            try {
                this.location = Enums$WSLocation.valueOf(jSONObject.str("location"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.wsBucket = jSONObject.str("wsBucket");
        this.instances = new ArrayList();
        for (Object object2 : jSONObject.getObjList("instances")) {
            this.instances.add(new ServiceInfo((JSONObject)object2));
        }
        Object object3 = jSONObject.obj("repository");
        if (object3 == null && !h.g((String)(object2 = Workspace.get("repository"))) && this.isJSON((String)object2)) {
            try {
                object3 = new JSONObject((String)object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (object3 != null) {
            this.includePreferences = ((JSONObject)object3).is("includePreferences");
            this.includeWindows = ((JSONObject)object3).is("includeWindows");
            this.includeWatchLists = ((JSONObject)object3).is("includeWatchLists");
            this.includeScans = ((JSONObject)object3).is("includeScans");
            this.includeTemplates = ((JSONObject)object3).is("includeTemplates");
            this.includeAlerts = ((JSONObject)object3).is("includeAlerts");
            this.overrideRepository = ((JSONObject)object3).is("overrideRepository");
            this.useDatabase = true;
            this.directory = null;
            if (((JSONObject)object3).has("directory")) {
                object2 = ((JSONObject)object3).getFile("directory");
                if (object2 == null || !((File)object2).exists()) {
                    h.a.warning("RepositorySettings::fromJSON() directory not found: " + ((JSONObject)object3).str("directory"));
                } else {
                    this.useDatabase = ((JSONObject)object3).is("useDatabase");
                    this.directory = object2;
                }
            }
            this.analysisSources.b();
            for (Object object4 : ((JSONObject)object3).getObjList("sources")) {
                Object object5 = ((JSONObject)object4).getFile("dir");
                if (object5 == null || !((File)object5).exists()) {
                    h.a.warning("RepositorySettings::fromJSON() source directory not found: " + ((JSONObject)object4).str("dir"));
                    continue;
                }
                AnalysisSource analysisSource = new AnalysisSource(((JSONObject)object4).str("name"), (File)object5, ((JSONObject)object4).is("readOnly"));
                if (this.analysisSources.c(analysisSource)) continue;
                this.analysisSources.a((Object)analysisSource);
            }
        }
        this.settingsMap.clear();
        if (!jSONObject.has("settings")) {
            return;
        }
        object2 = jSONObject.obj("settings");
        for (Object object5 : ((JSONObject)object2).keySet()) {
            this.settingsMap.put(object5, ((JSONObject)object2).str(new String[]{object5}));
        }
        this.settingsMap.remove("repository");
    }

    public ServiceInfo getPrimaryService() {
        if (h.a((Collection)this.instances)) {
            return null;
        }
        return (ServiceInfo)this.instances.get(0);
    }

    public List getServiceTypes() {
        ArrayList<Enums$ServiceType> arrayList = new ArrayList<Enums$ServiceType>();
        for (ServiceInfo serviceInfo : this.instances) {
            if (serviceInfo.getPrimaryInfo() == null || arrayList.contains((Object)serviceInfo.getPrimaryInfo().getType())) continue;
            arrayList.add(serviceInfo.getPrimaryInfo().getType());
        }
        return arrayList;
    }

    public List getInstances() {
        return this.instances;
    }

    public void setInstances(List list) {
        this.instances = new ArrayList(list);
        this.service = this.getService();
    }

    public boolean isUseDatabase() {
        return this.useDatabase || this.directory == null || !this.directory.exists();
    }

    public void setUseDatabase(boolean bl2) {
        this.useDatabase = bl2;
    }

    public File getRepoDir() {
        return this.directory;
    }

    public void setRepoDir(File file) {
        this.directory = file;
    }

    public boolean supportsExternalSave() {
        for (AnalysisSource analysisSource : this.analysisSources.a()) {
            if (analysisSource.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public boolean isIncludePreferences() {
        return this.includePreferences;
    }

    public void setIncludePreferences(boolean bl2) {
        this.includePreferences = bl2;
    }

    public boolean isIncludeWindows() {
        return this.includeWindows;
    }

    public void setIncludeWindows(boolean bl2) {
        this.includeWindows = bl2;
    }

    public boolean isIncludeWatchLists() {
        return this.includeWatchLists;
    }

    public void setIncludeWatchLists(boolean bl2) {
        this.includeWatchLists = bl2;
    }

    public boolean isIncludeScans() {
        return this.includeScans;
    }

    public void setIncludeScans(boolean bl2) {
        this.includeScans = bl2;
    }

    public boolean isIncludeTemplates() {
        return this.includeTemplates;
    }

    public void setIncludeTemplates(boolean bl2) {
        this.includeTemplates = bl2;
    }

    public boolean isIncludeAlerts() {
        return this.includeAlerts;
    }

    public void setIncludeAlerts(boolean bl2) {
        this.includeAlerts = bl2;
    }

    public boolean isOverrideRepository() {
        return this.overrideRepository;
    }

    public void setOverrideRepository(boolean bl2) {
        this.overrideRepository = bl2;
    }

    public List getAnalysisSources() {
        return this.analysisSources.a();
    }

    public void setAnalysisSources(List list) {
        this.analysisSources.d(list);
    }

    public void setModified() {
        this.modifiedOrNew = true;
    }

    private boolean isCheckRepository(String string) {
        String string2 = string;
        if (string2.indexOf(46) >= 0) {
            string2 = string2.substring(0, string2.indexOf(46));
        }
        switch (string2 = string2.toLowerCase()) {
            case "config": 
            case "journal": 
            case "account": 
            case "defaults": 
            case "commissions": 
            case "components": 
            case "keymap": 
            case "order_presets": 
            case "orders": 
            case "trading_hours": 
            case "ofa": 
            case "hurst": 
            case "trade_history": 
            case "instruments": 
            case "currencies": 
            case "exchanges": 
            case "custom_columns": 
            case "custom_orders": 
            case "gauges": 
            case "gauge_panels": 
            case "flags": {
                return this.isIncludePreferences();
            }
            case "desktops": 
            case "windows": {
                return this.isIncludeWindows();
            }
            case "alerts": 
            case "alert_history": {
                return this.isIncludeAlerts();
            }
            case "scans": 
            case "strategy_analysis": {
                return this.isIncludeScans();
            }
            case "watchlists": {
                return this.isIncludeWatchLists();
            }
            case "templates": 
            case "generic_templates": 
            case "cmp_templates": 
            case "dom_templates": 
            case "pack_templates": 
            case "page_export_templates": 
            case "exit_strategies": 
            case "note_styles": {
                return this.isIncludeTemplates();
            }
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public File getDir() {
        return new File(Workspace.getWorkspacesDir(), this.getName());
    }

    public static void addListener(DirectoryListener directoryListener) {
        listeners.a((Object)directoryListener);
    }

    public static void removeListener(DirectoryListener directoryListener) {
        listeners.a((Object)directoryListener);
    }

    private static void notifyCreated(Workspace workspace) {
        for (DirectoryListener directoryListener : listeners.a()) {
            directoryListener.created(workspace);
        }
    }

    private static void notifyUpdated(Workspace workspace) {
        for (DirectoryListener directoryListener : listeners.a()) {
            directoryListener.updated(workspace);
        }
    }

    private static void notifyDeleted(Workspace workspace) {
        for (DirectoryListener directoryListener : listeners.a()) {
            directoryListener.deleted(workspace);
        }
    }

    private static void notifyUpdated() {
        for (DirectoryListener directoryListener : listeners.a()) {
            directoryListener.updated();
        }
    }

    public static File findDir(String string) {
        Workspace workspace = bs.a();
        if (workspace == null) {
            return null;
        }
        return workspace.getConfigDir(workspace.isCheckRepository(string));
    }

    public static File findFile(String string) {
        return Workspace.findFile(bs.a(), string);
    }

    public static File findFile(Workspace workspace, String string) {
        File file;
        if (workspace == null) {
            return null;
        }
        boolean bl2 = workspace.isCheckRepository(string);
        if (string.indexOf(46) < 0) {
            File file2;
            if (bl2 && !workspace.isUseDatabase() && workspace.directory != null && workspace.directory.exists()) {
                file2 = new File(workspace.directory, "config");
                File file3 = new File(file2, string + ".json");
                if (file3.exists()) {
                    return file3;
                }
                file3 = new File(file2, string + ".xml");
                if (file3.exists()) {
                    return file3;
                }
                file3 = new File(file2, string + ".csv");
                if (file3.exists()) {
                    return file3;
                }
            }
            if ((file2 = new File(workspace.getConfigDir(false), string + ".json")).exists()) {
                return file2;
            }
            file2 = new File(workspace.getConfigDir(false), string + ".csv");
            return file2.exists() ? file2 : null;
        }
        if (bl2 && !workspace.isUseDatabase() && workspace.directory != null && workspace.directory.exists() && (file = new File(new File(workspace.directory, "config"), string)).exists()) {
            return file;
        }
        file = new File(workspace.getConfigDir(false), string);
        return file.exists() ? file : null;
    }

    public static String get(String string) {
        Workspace workspace = bs.a();
        if (workspace == null) {
            return null;
        }
        return workspace.getSetting(string);
    }

    public static void set(String string, String string2) {
        Workspace workspace = bs.a();
        if (workspace == null) {
            return;
        }
        workspace.setSetting(string, string2);
    }

    public static File getWorkspaceDir() {
        Workspace workspace = bs.a();
        if (workspace == null) {
            return null;
        }
        return workspace.getDir();
    }

    public static File getWorkspacesDir() {
        if (workspacesDir == null && !(workspacesDir = new File(Workspace.getWorkingDir(), "workspaces")).exists()) {
            workspacesDir.mkdir();
        }
        return workspacesDir;
    }

    public static File getMediaDir() {
        File file;
        if (h.g()) {
            File file2 = new File(Workspace.getInstallDir(), "sounds");
            return file2.exists() ? file2 : null;
        }
        if (h.e()) {
            File file3 = new File("/System/Library/Sounds");
            return file3.exists() ? file3 : null;
        }
        String string = System.getenv("SystemRoot");
        if (h.g(string)) {
            string = System.getenv("windir");
        }
        if (h.g(string)) {
            string = "c:/Windows";
        }
        if (!(file = new File(string)).exists()) {
            h.a.severe("Config::getMediaDir()::unable to locate system root!");
            return null;
        }
        File file4 = new File(file, "Media");
        if (!file4.exists()) {
            h.a.severe("Config::getMediaDir()::unable to locate media directory!");
            return null;
        }
        return file4;
    }

    public static File getLogDir() {
        File file = new File(Workspace.getWorkingDir(), "output");
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    public static File getWorkingDir() {
        if (workingDir == null) {
            File file;
            File file2 = new File("./dev.txt");
            if (file2.exists()) {
                workingDir = new File("..");
                return workingDir;
            }
            if (h.e()) {
                String string = System.getProperty("user.home");
                String string2 = string + "/Library/" + cj.h.k();
                File file3 = new File(string2);
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                workingDir = file3;
                return workingDir;
            }
            if (h.g()) {
                File file4 = new File(h.a(), "." + cj.h.k().toLowerCase());
                if (!file4.exists()) {
                    file4.mkdir();
                }
                workingDir = file4;
                return workingDir;
            }
            File file5 = new File(h.a(), "." + cj.h.k().toLowerCase());
            if (file5.exists()) {
                workingDir = file5;
                return workingDir;
            }
            String string = System.getenv("APPDATA");
            if (!h.g(string) && (file = new File(string)).exists()) {
                File file6 = new File(file, cj.h.k());
                if (!file6.exists()) {
                    file6.mkdir();
                }
                workingDir = file6;
                return workingDir;
            }
            file5.mkdir();
            workingDir = file5;
        }
        return workingDir;
    }

    public static File getInstallDir() {
        Object object;
        File file = new File("./dev.txt");
        if (file.exists()) {
            return new File(".");
        }
        if (h.e()) {
            String string = System.getProperty("appDir");
            if (!h.g(string)) {
                File file2 = new File(string + "/Contents");
                if (!file2.exists()) {
                    h.a.severe("App Directory not found! " + string);
                } else {
                    return file2;
                }
            }
            return new File("..");
        }
        if (h.g()) {
            object = new File(System.getProperty("appDir"));
            if (!((File)object).exists()) {
                h.a.severe("App Directory not found!: " + System.getProperty("appDir"));
            } else {
                return object;
            }
        }
        object = cj.h.k();
        String string = com.motivewave.common.util.ai.a(-2147483646, "SOFTWARE\\MotiveWave Software\\" + (String)object, "InstallLocation");
        if (cj.h.b()) {
            string = com.motivewave.common.util.ai.a(-2147483646, "SOFTWARE\\Edge Clear\\" + (String)object, "InstallLocation");
        }
        if (h.g(string)) {
            File file3 = new File("c:/Program Files/" + (String)object);
            if (file3.exists()) {
                return file3;
            }
            file3 = new File("c:/Program Files (x86)/" + (String)object);
            if (file3.exists()) {
                return file3;
            }
            file3 = new File("d:/Program Files/" + (String)object);
            if (file3.exists()) {
                return file3;
            }
            file3 = new File("d:/Program Files (x86)/" + (String)object);
            if (file3.exists()) {
                return file3;
            }
            file3 = new File("c:/" + (String)object);
            if (file3.exists()) {
                return file3;
            }
            file3 = new File("d:/" + (String)object);
            if (file3.exists()) {
                return file3;
            }
            return new File(".");
        }
        return new File(string);
    }

    public static File getDownloadDir() {
        return Workspace.getWorkingDir() == null ? null : new File(Workspace.getWorkingDir(), "download");
    }

    public static File getLibDir() {
        return new File(Workspace.getInstallDir(), "lib");
    }

    public static List getWorkspaces() {
        return workspaces.a();
    }

    public static void setWorkspaces(List list) {
        if (h.c(list, Workspace.getWorkspaces())) {
            return;
        }
        workspaces.d(list);
        Workspace.saveAll();
        Workspace.notifyUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSupportedWorkspaces() {
        List list = bs.y();
        ArrayList<Workspace> arrayList = new ArrayList<Workspace>();
        String string = SYNC;
        synchronized (string) {
            for (Workspace workspace : workspaces.a()) {
                if (!list.contains((Object)workspace.getService())) {
                    h.a.warning("Config::getSupportedWorkspaces() skipping unsupported service: " + String.valueOf((Object)workspace.getService()) + " edition: " + String.valueOf((Object)cj.h.a()));
                    continue;
                }
                arrayList.add(workspace);
            }
        }
        return arrayList;
    }

    public static Workspace getWorkspace(String string) {
        for (Workspace workspace : Workspace.getWorkspaces()) {
            if (!h.b((Object)string, (Object)workspace.getName())) continue;
            return workspace;
        }
        return null;
    }

    public static void create(Workspace workspace, n n2) {
        File file = new File(Workspace.getWorkspacesDir(), workspace.getName());
        if (file.exists()) {
            throw new MWException(f.E_CREATE_WORKSPACE, af.a("MSG_WORKSPACE_EXISTS", workspace.getName()));
        }
        n2.b(40.0);
        n2.a(af.a("MSG_REGISTER_WORKSPACE", new Object[0]), 10.0);
        file.mkdirs();
        workspace.save();
        ArrayList<ServiceInfo> arrayList = new ArrayList<ServiceInfo>();
        block0: for (Enums$ServiceType enums$ServiceType : workspace.getServiceTypes()) {
            for (ServiceInfo serviceInfo : workspace.getInstances()) {
                if (serviceInfo.getType() != enums$ServiceType) continue;
                arrayList.add(serviceInfo);
                continue block0;
            }
        }
        if (!h.a(arrayList)) {
            bs.a(workspace, arrayList, n2);
        }
        UIUtil.c(() -> {
            String string = SYNC;
            synchronized (string) {
                if (name2Workspace.containsKey(workspace.getName())) {
                    workspaces.a((Object)((Workspace)name2Workspace.get(workspace.getName())));
                    name2Workspace.remove(workspace.getName());
                }
                name2Workspace.put(workspace.getName(), workspace);
                workspaces.a(0, (Object)workspace);
                removedWorkspaces.remove(workspace.getName());
            }
            Workspace.notifyCreated(workspace);
        });
        Workspace.saveAll();
        workspace.setModified();
        if (workspace.isRemote()) {
            e.d();
            n2.b(af.a("TITLE_SYNCHRONIZING", new Object[0]));
            n2.a(af.a("MSG_SYNCHRONIZING_WORKSPACE", new Object[0]), 0.0);
            Workspace.writeRemoteWorkspaces();
            e.b(workspace);
        }
        n2.c(5.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRemoteWorkspaces() {
        Object object2;
        if (!e.a()) {
            return;
        }
        String string = e.a("workspaces.json");
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if (!h.g(string)) {
            for (Object object2 : Workspace.readWorkspaces(string, true)) {
                ((Workspace)object2).setLocation(Enums$WSLocation.MWCLOUD);
                ((Workspace)object2).setWsBucket(e.a());
                linkedHashMap.put(((Workspace)object2).getName(), object2);
            }
        }
        for (Object object2 : workspaces.a()) {
            if (((Workspace)object2).getLocation() != Enums$WSLocation.MWCLOUD) {
                linkedHashMap.remove(((Workspace)object2).getName());
                continue;
            }
            if (!h.a((Object)((Workspace)object2).getWsBucket(), (Object)e.a()) || !((Workspace)object2).modifiedOrNew) continue;
            linkedHashMap.put(((Workspace)object2).getName(), object2);
            if (h.g(((Workspace)object2).oldName) || h.a((Object)((Workspace)object2).oldName, (Object)((Workspace)object2).getName())) continue;
            linkedHashMap.remove(((Workspace)object2).oldName);
        }
        for (Object object2 : removedWorkspaces) {
            linkedHashMap.remove(object2);
        }
        ct ct2 = new ct();
        object2 = h.b(new String[0]);
        String string2 = SYNC;
        synchronized (string2) {
            for (Workspace workspace : linkedHashMap.values()) {
                object2.add(ct2.a(new String[]{ct2.b("name", workspace.getName()), ct2.a("service", (Object)workspace.getService())}));
            }
        }
        string2 = ct2.b((Collection)object2);
        if (h.a((Object)string2, (Object)string)) {
            return;
        }
        e.a("workspaces.json", string2);
        removedWorkspaces.clear();
        for (Workspace workspace : workspaces.a()) {
            workspace.modifiedOrNew = false;
            workspace.oldName = null;
        }
    }

    public static int getRemoteWorkspaceCount() {
        int n2 = 0;
        for (Workspace workspace : workspaces.a()) {
            if (workspace.getLocation() != Enums$WSLocation.MWCLOUD || !h.a((Object)workspace.getWsBucket(), (Object)e.a())) continue;
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWorkspace(Workspace workspace) {
        try {
            String string = SYNC;
            synchronized (string) {
                if (name2Workspace.containsKey(workspace.getName())) {
                    name2Workspace.remove(workspace.getName());
                    workspaces.a((Object)workspace);
                }
                if (!removedWorkspaces.contains(workspace.getName())) {
                    removedWorkspaces.add(workspace.getName());
                }
            }
            Workspace.notifyDeleted(workspace);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWorkspaceName(Workspace workspace, String string) {
        File file;
        if (h.g(string)) {
            System.err.println("Workspace::updateWorkspaceName() name is empty! ");
            h.c();
            return;
        }
        if (h.a((Object)string, (Object)workspace.getName())) {
            return;
        }
        File file2 = workspace.getDir();
        if (!file2.renameTo(file = new File(Workspace.getWorkspacesDir(), string))) {
            throw new MWException(f.E_RENAME_WORKSPACE_DIR, string);
        }
        String string2 = SYNC;
        synchronized (string2) {
            if (name2Workspace.containsKey(workspace.getName())) {
                name2Workspace.remove(workspace.getName());
            }
            workspace.setName(string);
            name2Workspace.put(workspace.getName(), workspace);
            workspace.save();
            removedWorkspaces.remove(workspace.getName());
        }
        Workspace.saveAll();
    }

    public static void loadFromCloud() {
        if (!e.a()) {
            return;
        }
        try {
            LinkedHashMap<String, Workspace> linkedHashMap = new LinkedHashMap<String, Workspace>();
            String string = e.a("workspaces.json");
            if (!h.g(string)) {
                for (Workspace workspace : Workspace.readWorkspaces(string, true)) {
                    if (h.g(workspace.getName())) continue;
                    workspace.setLocation(Enums$WSLocation.MWCLOUD);
                    workspace.setWsBucket(e.a());
                    linkedHashMap.put(workspace.getName(), workspace);
                }
            }
            UIUtil.a(() -> {
                String string = SYNC;
                synchronized (string) {
                    Workspace workspace;
                    for (String string2 : linkedHashMap.keySet()) {
                        workspace = (Workspace)linkedHashMap.get(string2);
                        if (workspace == null || h.g(workspace.getName())) continue;
                        int n2 = -1;
                        if (name2Workspace.containsKey(string2)) {
                            Workspace workspace2 = (Workspace)name2Workspace.remove(string2);
                            n2 = workspaces.a((Object)workspace2);
                            workspaces.a((Object)workspace2);
                        }
                        if (n2 >= 0) {
                            workspaces.a(n2, (Object)workspace);
                        } else {
                            workspaces.a((Object)workspace);
                        }
                        name2Workspace.put(workspace.getName(), workspace);
                    }
                    for (String string2 : new ArrayList(name2Workspace.keySet())) {
                        workspace = (Workspace)name2Workspace.get(string2);
                        if (workspace.isLocal() || linkedHashMap.containsKey(string2) && h.a((Object)workspace.getWsBucket(), (Object)e.a())) continue;
                        h.a.warning("Workspace::loadFromCloud() removing remote workspace: " + string2 + " wsBucket: " + workspace.getWsBucket());
                        name2Workspace.remove(string2);
                        workspaces.a((Object)workspace);
                    }
                    Workspace.notifyUpdated();
                }
            });
        }
        catch (Exception exception) {
            h.a.warning("Workspace::load() error loading remote workspaces " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        String string;
        File file = new File(Workspace.getWorkspacesDir(), "workspaces.json");
        if (!file.exists()) {
            file = new File(Workspace.getWorkspacesDir(), ".workspaces");
        }
        if (h.g(string = h.c(file))) {
            return;
        }
        String string2 = SYNC;
        synchronized (string2) {
            workspaces.b();
            name2Workspace.clear();
            try {
                for (Workspace workspace : Workspace.readWorkspaces(string, false)) {
                    if (h.g(workspace.getName())) continue;
                    workspaces.a((Object)workspace);
                    name2Workspace.put(workspace.getName(), workspace);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Workspace.notifyUpdated();
        }
    }

    private static List readWorkspaces(String string, boolean bl2) {
        ArrayList<Workspace> arrayList = new ArrayList<Workspace>();
        try {
            if (!w.a(string)) {
                return arrayList;
            }
            for (JSONObject jSONObject : new JSONArray(string).asObjList()) {
                Enums$ServiceType enums$ServiceType = null;
                try {
                    enums$ServiceType = Enums$ServiceType.read(jSONObject.str("service"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (enums$ServiceType == null) {
                    h.a.warning("Workspace::readWorkspaces() unrecognized service type: " + jSONObject.str("service"));
                    continue;
                }
                String string2 = jSONObject.str("name");
                if (h.g(string2)) {
                    string2 = jSONObject.str("database");
                }
                if (h.g(string2)) {
                    System.err.println("Workspace::readWorkspaces() name is empty!");
                    System.err.println(jSONObject);
                }
                Workspace workspace = new Workspace(string2, enums$ServiceType);
                if (jSONObject.has("location")) {
                    try {
                        workspace.location = Enums$WSLocation.valueOf(jSONObject.str("location"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (jSONObject.has("wsBucket")) {
                    workspace.wsBucket = jSONObject.str("wsBucket");
                }
                if (!workspace.getDir().exists() && !bl2 && workspace.isLocal()) {
                    h.a.warning("Workspace::load() skipping workspace: " + workspace.getName() + " since the directory does not exist");
                    continue;
                }
                arrayList.add(workspace);
            }
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAll() {
        cu cu2 = new cu();
        Object object = h.b(new String[0]);
        String string = SYNC;
        synchronized (string) {
            for (Workspace workspace : workspaces.a()) {
                object.add(cu2.a(cu2.b("name", workspace.getName()), cu2.a("service", (Object)workspace.getService()), cu2.a("location", (Object)workspace.getLocation()), cu2.a("wsBucket", workspace.getLocation() == Enums$WSLocation.MWCLOUD ? workspace.getWsBucket() : null)));
            }
        }
        h.a(new File(Workspace.getWorkspacesDir(), "workspaces.json"), cu2.b((Collection)object));
    }

    static {
        workspaces = new g();
        removedWorkspaces = new ArrayList();
        name2Workspace = new HashMap();
        SYNC = new String(h.a());
        listeners = new g();
    }
}

