/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.b;
import com.motivewave.common.h;
import com.motivewave.common.util.g;
import com.motivewave.common.util.w;
import com.motivewave.platform.databean.UpdateListener;
import com.motivewave.platform.databean.WLEntry;
import com.motivewave.platform.databean.WatchList;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.cs;
import com.motivewave.platform.service.bs;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WatchLists {
    private static g allWatchlists = new g();
    private static g listeners = new g();
    private static g destroyList = new g();
    private static Runnable onUpdated = () -> {
        Object object2;
        for (Object object2 : listeners.a()) {
            object2.updated();
        }
        List list = destroyList.a();
        destroyList.b();
        object2 = list.iterator();
        while (object2.hasNext()) {
            WatchList watchList = (WatchList)object2.next();
            watchList.destroy();
        }
    };

    public static WatchList byName(String string) {
        for (WatchList watchList : allWatchlists.a()) {
            if (!h.a((Object)watchList.getName(), (Object)string)) continue;
            return watchList;
        }
        return null;
    }

    public static WatchList byId(String string) {
        for (WatchList watchList : allWatchlists.a()) {
            if (!h.a((Object)watchList.getId(), (Object)string)) continue;
            return watchList;
        }
        return null;
    }

    public static List getAll() {
        return allWatchlists.a();
    }

    public static List getAllByName() {
        ArrayList arrayList = new ArrayList(WatchLists.getAll());
        arrayList.sort((watchList, watchList2) -> watchList.getName().compareTo(watchList2.getName()));
        return arrayList;
    }

    public static List getNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WatchList watchList : allWatchlists.a()) {
            if (watchList == null) continue;
            arrayList.add(watchList.getName());
        }
        return arrayList;
    }

    public static void create(WatchList watchList) {
        if (watchList == null || allWatchlists.c(watchList)) {
            return;
        }
        allWatchlists.a((Object)watchList);
        WatchLists.notifyUpdated();
    }

    public static void notifyAllUpdated(String string) {
        for (WatchList watchList : allWatchlists.a()) {
            if (!h.g(string) && !watchList.containsKey(string)) continue;
            watchList.notifyUpdated();
        }
    }

    public static WatchList replace(WatchList watchList) {
        if (watchList == null) {
            return null;
        }
        WatchList watchList2 = WatchLists.byName(watchList.getName());
        if (watchList2 != null) {
            for (WLEntry wLEntry : watchList2.getEntries()) {
                wLEntry.destroy();
            }
            for (WLEntry wLEntry : watchList.getEntries()) {
                watchList2.getEntries().add(wLEntry);
            }
            watchList2.notifyUpdated();
            return watchList2;
        }
        allWatchlists.a((Object)watchList);
        WatchLists.notifyUpdated();
        return watchList;
    }

    public static void remove(WatchList watchList) {
        if (watchList == null || !allWatchlists.c(watchList)) {
            return;
        }
        allWatchlists.a((Object)watchList);
        destroyList.a((Object)watchList);
        WatchLists.notifyUpdated();
    }

    public static void save() {
        h.c(new File(Workspace.findDir("watchlists"), "watchlists.json"), WatchLists.toJson());
    }

    public static void write(File file) {
        h.a(new File(file, "watchlists.json"), WatchLists.toJson());
    }

    private static String toJson() {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        for (WatchList watchList : WatchLists.getAll()) {
            arrayList.add(watchList.toJson());
        }
        return new cs().b(arrayList);
    }

    public static void read() {
        Workspace workspace = bs.a();
        allWatchlists.b();
        File file = Workspace.findFile(workspace, "watchlists");
        if (file == null || !file.exists()) {
            return;
        }
        String string = h.c(file);
        try {
            if (w.a(string)) {
                if (!h.g(string)) {
                    for (JSONObject jSONObject : new JSONArray(string).asObjList()) {
                        allWatchlists.a((Object)WatchList.fromJson(jSONObject.toMap()));
                    }
                }
            } else {
                for (WatchList watchList : WatchLists.readWatchLists(com.motivewave.common.util.h.a(string))) {
                    allWatchlists.a((Object)watchList);
                }
            }
        }
        catch (Exception exception) {
            h.a.warning("WatchLists::read(File) error loading watch lists: " + exception.getMessage());
            h.a.warning(string);
        }
    }

    public static List readWatchLists(Element element) {
        ArrayList<WatchList> arrayList = new ArrayList<WatchList>();
        List list = com.motivewave.common.util.h.c("wl_wrapper", element);
        if (h.a((Collection)list)) {
            return arrayList;
        }
        for (Element element2 : list) {
            try {
                Node node = com.motivewave.common.util.h.b("watchlist", element2);
                if (node == null && (node = com.motivewave.common.util.h.b("folder", element2)) == null) continue;
                arrayList.add(WatchList.fromXML(element2));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return arrayList;
    }

    public static void addListener(UpdateListener updateListener) {
        listeners.a((Object)updateListener);
    }

    public static void removeListener(UpdateListener updateListener) {
        listeners.a((Object)updateListener);
    }

    private static void notifyUpdated() {
        b.a(onUpdated, 50L);
    }
}

