/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.util.aa;
import com.motivewave.common.util.g;
import com.motivewave.platform.common.Enums$ChartLink;
import com.motivewave.platform.common.Enums$InstrumentType;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.w;
import com.motivewave.platform.databean.Columns$Instrument;
import com.motivewave.platform.databean.Columns$Ticker;
import com.motivewave.platform.databean.GroupInfo;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.OptionInfo;
import com.motivewave.platform.databean.RowFormat;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.WLEntry;
import com.motivewave.platform.databean.WLTicker;
import com.motivewave.platform.databean.WatchList;
import com.motivewave.platform.service.SymbolUtil;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.by;
import com.motivewave.platform.service.srvc.x;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import v.ac;

public class WatchListOld
extends ObservableBean
implements w,
Comparable {
    private int id;
    private String name;
    private String type = "W";
    private List columns = new ArrayList();
    private g tickers = new g();
    private g groups = new g();
    private Enums$ServiceType serviceType;
    private Map formatMap = new HashMap();

    public WatchListOld(JSONObject jSONObject) {
        this(jSONObject, false);
    }

    public WatchListOld(JSONObject jSONObject, boolean bl2) {
        this.fromJSON(jSONObject, bl2);
    }

    public WatchListOld() {
        this(-1);
    }

    public WatchListOld(int n2) {
        this.id = n2;
        x x2 = bs.a((Enums$ServiceType)null);
        if (x2 != null) {
            for (TableColumnInfo tableColumnInfo : x2.d()) {
                this.columns.add(tableColumnInfo.clone());
            }
        }
    }

    @Override
    public String format(String string) {
        if (h.g(string)) {
            return "";
        }
        if (string.equals("name")) {
            return this.getName();
        }
        return super.format(string);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List getTickers() {
        return this.tickers.a();
    }

    public void setTickers(List list) {
        this.tickers.d(list);
    }

    public boolean replace(LiveTicker liveTicker, LiveTicker liveTicker2) {
        boolean bl2 = false;
        if (this.isWatchList()) {
            ArrayList<LiveTicker> arrayList = new ArrayList<LiveTicker>();
            for (LiveTicker liveTicker3 : this.tickers.a()) {
                if (liveTicker3 == liveTicker) {
                    arrayList.add(liveTicker2);
                    bl2 = true;
                    continue;
                }
                arrayList.add(liveTicker3);
            }
            this.tickers.d(arrayList);
            return bl2;
        }
        for (GroupInfo groupInfo : this.groups.a()) {
            ArrayList<LiveTicker> arrayList = new ArrayList<LiveTicker>();
            for (LiveTicker liveTicker4 : groupInfo.getTickers()) {
                if (liveTicker4 == liveTicker) {
                    arrayList.add(liveTicker2);
                    bl2 = true;
                    continue;
                }
                arrayList.add(liveTicker4);
            }
            groupInfo.setTickers(arrayList);
        }
        return bl2;
    }

    public List getActiveTickers() {
        if (this.isWatchList()) {
            return this.tickers.a();
        }
        ArrayList<LiveTicker> arrayList = new ArrayList<LiveTicker>();
        for (GroupInfo groupInfo : this.groups.a()) {
            for (LiveTicker liveTicker : groupInfo.getTickers()) {
                if (liveTicker == null || arrayList.contains(liveTicker)) continue;
                arrayList.add(liveTicker);
            }
        }
        return arrayList;
    }

    public int size() {
        return this.tickers == null ? 0 : this.tickers.a();
    }

    public List getGroups() {
        return this.groups.a();
    }

    public void setGroups(List list) {
        this.groups.d(list);
    }

    public List getGroupNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GroupInfo groupInfo : this.groups.a()) {
            arrayList.add(groupInfo.getName());
        }
        return arrayList;
    }

    public GroupInfo getGroup(String string) {
        for (GroupInfo groupInfo : this.groups.a()) {
            if (!h.a((Object)groupInfo.getName(), (Object)string)) continue;
            return groupInfo;
        }
        return null;
    }

    public void addTickers(List list) {
        this.tickers.a(list);
    }

    public void addTicker(int n2, LiveTicker liveTicker) {
        if (liveTicker == null) {
            return;
        }
        this.tickers.a(n2, (Object)liveTicker);
        ArrayList<LiveTicker> arrayList = new ArrayList<LiveTicker>(this.tickers.a());
        arrayList.remove(liveTicker);
        arrayList.add(n2, liveTicker);
        this.tickers.d(arrayList);
    }

    public void removeTicker(LiveTicker liveTicker) {
        this.tickers.a((Object)liveTicker);
    }

    public boolean removeTickers(List list) {
        boolean bl2 = false;
        for (LiveTicker liveTicker : list) {
            if (!this.tickers.a((Object)liveTicker)) continue;
            bl2 = true;
        }
        return bl2;
    }

    public void removeGroup(GroupInfo groupInfo) {
        this.groups.a((Object)groupInfo);
    }

    public void addGroup(GroupInfo groupInfo) {
        this.groups.a((Object)groupInfo);
    }

    @Override
    public List getNVPs() {
        Object object = h.b(new String[]{this.b("name", this.name), this.b("type", this.type), this.a("srvc", (Object)this.serviceType)});
        Object object2 = h.b(new String[0]);
        for (TableColumnInfo tableColumnInfo : this.columns) {
            object2.add(this.a(this.b("id", tableColumnInfo.getProperty()), this.a("visible", tableColumnInfo.isVisible()), this.a("width", tableColumnInfo.getWidth())));
        }
        object.add(this.a("columns", (Collection)object2));
        if (this.isQuoteSheet()) {
            object.add(this.a("groups", (Object)this.groups));
        } else {
            object.add(this.a("instruments", this.a(this.tickers.a())));
        }
        if (!h.a(this.formatMap)) {
            object.add(this.a("formats", this.formatMap.values()));
        }
        return object;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        this.fromJSON(jSONObject, false);
    }

    public void fromJSON(JSONObject jSONObject, boolean bl2) {
        aa aa2;
        this.name = jSONObject.str("name");
        this.type = jSONObject.str("type");
        try {
            this.serviceType = Enums$ServiceType.read(jSONObject.str("srvc"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.columns = new ArrayList();
        for (Object object : jSONObject.getObjList("columns")) {
            aa2 = TableColumnInfo.getTickerColumn(((JSONObject)object).str("id"));
            if (aa2 == null) continue;
            ((TableColumnInfo)aa2).setWidth(((JSONObject)object).getInt("width"));
            ((TableColumnInfo)aa2).setVisible(((JSONObject)object).is("visible"));
            this.columns.add(aa2);
        }
        if (this.columns.isEmpty()) {
            this.loadDefaultColumns();
        }
        this.groups.b();
        for (Object object : jSONObject.getObjList("groups")) {
            this.groups.a((Object)new GroupInfo((JSONObject)object));
        }
        this.tickers.b();
        for (Object object : jSONObject.getStringList("instruments")) {
            aa2 = MWInstrument.resolveExpiredContract(w.a((String)object, false, bl2));
            if (aa2 == null) {
                System.err.println("WatchList::fromJSON() unable to resolve instrument: " + (String)object);
                continue;
            }
            this.tickers.a((Object)LiveTicker.get((MWInstrument)aa2));
        }
        if (jSONObject.has("formats")) {
            for (Object object : jSONObject.getObjList("formats")) {
                aa2 = new RowFormat((JSONObject)object);
                this.formatMap.put(((RowFormat)aa2).getKey(), aa2);
            }
        }
    }

    public boolean isWatchList() {
        return h.g(this.type) || h.a((Object)this.type, (Object)"W");
    }

    public boolean isQuoteSheet() {
        return h.a((Object)this.type, (Object)"Q");
    }

    public void updateColumns(List list) {
        ArrayList<TableColumnInfo> arrayList = new ArrayList<TableColumnInfo>();
        for (TableColumnInfo tableColumnInfo : list) {
            arrayList.add(tableColumnInfo.clone());
        }
        this.columns = arrayList;
    }

    public List getColumns() {
        return this.columns;
    }

    public RowFormat getFormat(Ticker ticker) {
        if (ticker == null) {
            return null;
        }
        Object object = ticker.getSymbol();
        if (!h.g(ticker.getExchangeSymbol())) {
            object = (String)object + ":" + ticker.getExchangeSymbol();
        }
        return (RowFormat)this.formatMap.get(object);
    }

    public void setFormat(Ticker ticker, RowFormat rowFormat) {
        Object object = ticker.getSymbol();
        if (!h.g(ticker.getExchangeSymbol())) {
            object = (String)object + ":" + ticker.getExchangeSymbol();
        }
        if (rowFormat == null) {
            this.formatMap.remove(object);
        } else {
            this.formatMap.put(object, rowFormat);
        }
    }

    @Override
    public WatchListOld clone() {
        try {
            WatchListOld watchListOld = (WatchListOld)super.clone();
            watchListOld.tickers = this.tickers.a();
            watchListOld.columns = new ArrayList();
            if (!h.a((Collection)this.columns)) {
                for (aa aa2 : this.columns) {
                    watchListOld.columns.add(((TableColumnInfo)aa2).clone());
                }
            }
            watchListOld.groups = new g();
            if (!h.b((Object)this.groups)) {
                for (aa aa2 : this.groups.a()) {
                    watchListOld.groups.a((Object)((GroupInfo)aa2).clone());
                }
            }
            watchListOld.formatMap = new HashMap();
            if (!h.a(this.formatMap)) {
                for (aa aa2 : this.formatMap.values()) {
                    watchListOld.formatMap.put(((RowFormat)aa2).getKey(), ((RowFormat)aa2).clone());
                }
            }
            return watchListOld;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(WatchListOld watchListOld) {
        if (watchListOld == null || watchListOld.getName() == null) {
            return 1;
        }
        if (this.getName() == null) {
            return -1;
        }
        return this.getName().compareTo(watchListOld.getName());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            WatchListOld watchListOld = (WatchListOld)object;
            return h.a((Object)watchListOld.getName(), (Object)this.getName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private List readTickers(Element element) {
        ArrayList<LiveTicker> arrayList = new ArrayList<LiveTicker>();
        Node node = com.motivewave.common.util.h.b("instruments", element);
        List list = com.motivewave.common.util.h.c("instrument", node);
        if (h.a((Collection)list)) {
            list = com.motivewave.common.util.h.c("instr", node);
        }
        for (Element element2 : list) {
            MWInstrument mWInstrument = MWInstrument.resolveExpiredContract(this.readInstrument(element2));
            if (mWInstrument == null) continue;
            arrayList.add(LiveTicker.get(mWInstrument));
        }
        return arrayList;
    }

    private void loadDefaultColumns() {
        ArrayList<TableColumnInfo> arrayList = new ArrayList<TableColumnInfo>();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        x x2 = bs.a(this.serviceType);
        boolean bl2 = x2 != null;
        LinkedHashMap<String, TableColumnInfo> linkedHashMap2 = new LinkedHashMap<String, TableColumnInfo>();
        List list = bs.n();
        for (TableColumnInfo tableColumnInfo : list) {
            if (tableColumnInfo == null) continue;
            linkedHashMap2.put(tableColumnInfo.getProperty(), tableColumnInfo);
        }
        if (!bl2) {
            this.addColumn(Columns$Instrument.SYMBOL, linkedHashMap2, linkedHashMap);
            this.addColumn(Columns$Instrument.DESCRIPTION, linkedHashMap2, linkedHashMap);
            this.addColumn(Columns$Ticker.CHANGE, linkedHashMap2, linkedHashMap);
            this.addColumn(Columns$Ticker.CHANGE_PER, linkedHashMap2, linkedHashMap);
            this.addColumn(Columns$Ticker.BID_PRICE, linkedHashMap2, linkedHashMap);
            this.addColumn(Columns$Ticker.ASK_PRICE, linkedHashMap2, linkedHashMap);
            this.addColumn(Columns$Ticker.LAST_PRICE, linkedHashMap2, linkedHashMap);
            this.addColumn(Columns$Ticker.VOLUME, linkedHashMap2, linkedHashMap);
            return;
        }
        if (x2 != null) {
            for (TableColumnInfo tableColumnInfo : x2.d()) {
                arrayList.add(tableColumnInfo.clone());
                linkedHashMap.put(tableColumnInfo.getProperty(), tableColumnInfo);
            }
        }
        for (TableColumnInfo tableColumnInfo : list) {
            if (linkedHashMap.containsKey(tableColumnInfo.getProperty())) continue;
            tableColumnInfo = tableColumnInfo.clone();
            tableColumnInfo.setVisible(false);
            arrayList.add(tableColumnInfo);
        }
        this.columns = arrayList;
    }

    public WatchList convert() {
        WatchList watchList = new WatchList(this.getName());
        ArrayList<WLEntry> arrayList = new ArrayList<WLEntry>();
        if (this.isWatchList()) {
            for (LiveTicker liveTicker : this.tickers.a()) {
                arrayList.add(this.toTkr(liveTicker));
            }
        } else {
            for (GroupInfo groupInfo : this.groups.a()) {
                arrayList.add(groupInfo.toSection());
                for (LiveTicker liveTicker : groupInfo.getTickers()) {
                    arrayList.add(this.toTkr(liveTicker));
                }
            }
        }
        watchList.setEntries(arrayList);
        return watchList;
    }

    WLTicker toTkr(Ticker ticker) {
        WLTicker wLTicker = new WLTicker(ticker.getKey());
        RowFormat rowFormat = (RowFormat)this.formatMap.get(ticker.getKey());
        if (rowFormat != null) {
            wLTicker.setStyle(new ac(rowFormat.getFont(), UIUtil.a(rowFormat.getForeground()), UIUtil.a(rowFormat.getBackground()), true));
        }
        return wLTicker;
    }

    private void addColumn(TableColumnInfo tableColumnInfo, Map map, Map map2) {
        if (!h.a(map) && !map.containsKey(tableColumnInfo.getProperty())) {
            return;
        }
        tableColumnInfo = tableColumnInfo.clone();
        tableColumnInfo.setVisible(true);
        ArrayList<TableColumnInfo> arrayList = new ArrayList<TableColumnInfo>(this.columns);
        arrayList.add(tableColumnInfo);
        this.columns = arrayList;
        map2.put(tableColumnInfo.getProperty(), tableColumnInfo);
    }

    public void setConfig(String string) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList;
        List list;
        this.type = "W";
        this.tickers.b();
        if (h.g(string)) {
            this.loadDefaultColumns();
            return;
        }
        Element element = com.motivewave.common.util.h.a(string);
        String string2 = element.getAttribute("type");
        if (!h.g(string2)) {
            this.type = string2;
        }
        if (!h.g(string2 = element.getAttribute("srvc"))) {
            this.serviceType = Enums$ServiceType.read(string2);
        }
        if (h.a((Collection)(list = com.motivewave.common.util.h.c("column", com.motivewave.common.util.h.b("columns", element))))) {
            try {
                this.loadDefaultColumns();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            arrayList = new ArrayList<Object>();
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Object object3 : list) {
                object2 = object3.getAttribute("id");
                if (h.a(object2, (Object)"symbol")) {
                    object2 = "symbolDisplay";
                }
                if ((object = TableColumnInfo.getTickerColumn((String)object2)) == null) continue;
                string2 = object3.getAttribute("width");
                if (!h.g(string2)) {
                    ((TableColumnInfo)object).setWidth(h.b(string2));
                }
                ((TableColumnInfo)object).setVisible(true);
                string2 = object3.getAttribute("visible");
                if (!h.g(string2)) {
                    ((TableColumnInfo)object).setVisible(h.c((Object)string2));
                }
                arrayList.add(object);
                linkedHashMap.put(((TableColumnInfo)object).getProperty(), object);
            }
            if (this.isWatchList()) {
                for (Object object3 : bs.n()) {
                    if (linkedHashMap.containsKey(((TableColumnInfo)object3).getProperty())) continue;
                    object3 = ((TableColumnInfo)object3).clone();
                    ((TableColumnInfo)object3).setVisible(false);
                    arrayList.add(object3);
                }
            }
            this.columns = arrayList;
        }
        if (this.isQuoteSheet()) {
            arrayList = new ArrayList();
            for (Object object4 : com.motivewave.common.util.h.c("group", element)) {
                Node node;
                Object object3;
                object3 = object4.getAttribute("name");
                object2 = new GroupInfo((String)object3, this.readTickers((Element)object4));
                object = object4.getAttribute("link");
                if (!h.g((String)object)) {
                    ((GroupInfo)object2).setLink(Enums$ChartLink.fromString((String)object));
                }
                if ((node = com.motivewave.common.util.h.b("foreground", (Node)object4)) != null) {
                    ((GroupInfo)object2).setForeground(h.a((Element)node));
                }
                if ((node = com.motivewave.common.util.h.b("background", (Node)object4)) != null) {
                    ((GroupInfo)object2).setBackground(h.a((Element)node));
                }
                arrayList.add(object2);
            }
            this.groups.d(arrayList);
        } else {
            this.tickers.d(this.readTickers(element));
        }
    }

    private MWInstrument readInstrument(Element element) {
        MWInstrument mWInstrument;
        Object object3;
        MWInstrument mWInstrument2;
        String string;
        String string2 = element.getAttribute("id");
        String string3 = element.getAttribute("sym");
        if (h.g(string3)) {
            string3 = element.getAttribute("symbol");
        }
        if (h.g(string = element.getAttribute("e"))) {
            string = element.getAttribute("exchange");
        }
        if (h.g(string)) {
            string = element.getAttribute("exch");
        }
        if (h.g(string2) && h.g(string3)) {
            h.a.warning("WatchList::readInstrument() bad instrument, missing id and/or symbol");
            return null;
        }
        if (!h.g(string2) && (mWInstrument2 = MWInstrument.get(h.b(string2))) != null && h.a((Object)string3, (Object)mWInstrument2.getSymbol())) {
            return mWInstrument2;
        }
        mWInstrument2 = MWInstrument.get(string3, string);
        if (mWInstrument2 != null) {
            return mWInstrument2;
        }
        Enums$ServiceType enums$ServiceType = this.serviceType;
        if (!h.g(element.getAttribute("s"))) {
            try {
                enums$ServiceType = Enums$ServiceType.read(element.getAttribute("s"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((mWInstrument2 = MWInstrument.get(string3, enums$ServiceType)) != null) {
            return mWInstrument2;
        }
        if (h.g(element.getAttribute("t"))) {
            h.a.warning("WatchList::readInstrument() instrument not found: " + string3 + ":" + string);
            return null;
        }
        String string4 = element.getAttribute("u");
        if (h.g(string4)) {
            string4 = string3;
        }
        Enums$InstrumentType enums$InstrumentType = Enums$InstrumentType.STOCK;
        if (!h.g(element.getAttribute("t"))) {
            try {
                enums$InstrumentType = Enums$InstrumentType.valueOf(element.getAttribute("t"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double d2 = 0.01;
        if (!h.g(element.getAttribute("mt"))) {
            d2 = h.a(element.getAttribute("mt"));
        }
        Date date = null;
        if (!h.g(element.getAttribute("exp"))) {
            try {
                date = h.a(element.getAttribute("exp"), "yyyy-MM-dd");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string5 = "USD";
        if (!h.g(element.getAttribute("c"))) {
            string5 = element.getAttribute("c");
        }
        double d3 = 1.0;
        if (!h.g(element.getAttribute("pm"))) {
            d3 = h.a(element.getAttribute("pm"));
        }
        double d4 = 1.0;
        if (!h.g(element.getAttribute("pld"))) {
            d4 = h.a(element.getAttribute("pld"));
        }
        String string6 = string;
        if (!h.g(element.getAttribute("pe"))) {
            string6 = element.getAttribute("pe");
        }
        Object object2 = null;
        for (Object object3 : bs.w()) {
            if (object3.a().a().a() != enums$ServiceType) continue;
            object2 = object3;
            break;
        }
        if (object2 == null) {
            for (Object object3 : bs.w()) {
                if (!object3.a().a().a(enums$InstrumentType)) continue;
                object2 = object3;
                break;
            }
        }
        if (object2 == null) {
            return null;
        }
        Object object4 = enums$ServiceType;
        object3 = ((by)object2).a().a();
        if (object4 != object3 && (mWInstrument2 = MWInstrument.get(string3 = SymbolUtil.a(string4, string3, enums$InstrumentType, date, (Enums$ServiceType)((Object)object4), (Enums$ServiceType)((Object)object3)), string = SymbolUtil.a(string, string6, enums$InstrumentType, (Enums$ServiceType)((Object)object4), (Enums$ServiceType)((Object)object3)))) != null) {
            return mWInstrument2;
        }
        if (object3 == Enums$ServiceType.METASTOCK) {
            string3 = string3.toUpperCase();
            try {
                mWInstrument = ((by)object2).a().a(string3, enums$InstrumentType, string5, string);
                if (mWInstrument != null) {
                    return mWInstrument;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        mWInstrument = new MWInstrument(string3, enums$InstrumentType, string, string5, ((by)object2).a().getConnectionID());
        if (object3 == Enums$ServiceType.IB && !h.g(string6) && !h.a((Object)string, (Object)string6)) {
            mWInstrument.setPrimaryExchange(string6);
        }
        mWInstrument.setMinTick(d2);
        if (date != null) {
            mWInstrument.setExpiryDate(date);
        }
        mWInstrument.setUnderlying(string4);
        if (mWInstrument.isCash()) {
            mWInstrument.setPointSize(SymbolUtil.b(string3));
        }
        if (mWInstrument.isFuture()) {
            mWInstrument.setPointSize(1.0);
            mWInstrument.setPointValue(SymbolUtil.e(string4));
        }
        mWInstrument.setPriceMagnifier(d3);
        mWInstrument.setPLDivisor(d4);
        if (enums$InstrumentType == Enums$InstrumentType.OPTION) {
            OptionInfo optionInfo = ab.a(string3, enums$ServiceType);
            mWInstrument.setStrikePrice(optionInfo.strikePrice);
            mWInstrument.setOptionType(optionInfo.putCall);
        }
        try {
            mWInstrument = MWInstrument.create(mWInstrument);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return mWInstrument;
    }
}

