/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.b;
import com.motivewave.common.h;
import com.motivewave.common.util.aa;
import com.motivewave.common.util.g;
import com.motivewave.common.util.j;
import com.motivewave.platform.common.Enums$ChartLink;
import com.motivewave.platform.common.w;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.RowFormat;
import com.motivewave.platform.databean.UpdateListener;
import com.motivewave.platform.databean.WLEntry;
import com.motivewave.platform.databean.WLSection;
import com.motivewave.platform.databean.WLTicker;
import com.motivewave.platform.databean.WatchListOld;
import com.motivewave.platform.databean.cq;
import com.motivewave.platform.databean.cr;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import v.ac;

public class WatchList
implements aa,
j,
Comparable {
    private String id;
    private String name;
    private List entries;
    private g listeners = new g();
    private Runnable notifyTask = () -> {
        for (UpdateListener updateListener : this.listeners.a()) {
            try {
                updateListener.updated();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };

    public WatchList(String string) {
        this(h.a(), string, new ArrayList());
    }

    private WatchList(String string, String string2, List list) {
        this.name = string2;
        this.id = string;
        this.entries = list;
    }

    @Override
    public void destroy() {
        this.listeners.b();
        for (WLEntry wLEntry : this.entries) {
            wLEntry.destroy();
        }
    }

    public int getSymbolCount() {
        int n2 = 0;
        for (WLEntry wLEntry : this.entries) {
            if (!(wLEntry instanceof WLTicker)) continue;
            ++n2;
        }
        return n2;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List getEntries() {
        return this.entries;
    }

    public void setEntries(List list) {
        this.entries = list;
    }

    public void removeTickers(List list) {
        boolean bl2 = false;
        for (LiveTicker liveTicker : list) {
            for (WLEntry wLEntry : new ArrayList(this.entries)) {
                if (!h.a((Object)wLEntry.getKey(), (Object)liveTicker.getKey())) continue;
                this.entries.remove(wLEntry);
                bl2 = true;
            }
        }
        if (bl2) {
            this.notifyUpdated();
        }
    }

    public void replace(LiveTicker liveTicker, LiveTicker liveTicker2) {
        boolean bl2 = false;
        for (WLEntry wLEntry : this.entries) {
            if (!h.a((Object)wLEntry.getKey(), (Object)liveTicker.getKey())) continue;
            ((WLTicker)wLEntry).setKey(liveTicker2.getKey());
            bl2 = true;
        }
        if (bl2) {
            this.notifyUpdated();
        }
    }

    public List getTickers() {
        ArrayList<LiveTicker> arrayList = new ArrayList<LiveTicker>();
        for (WLEntry wLEntry : this.entries) {
            if (wLEntry.getTicker() == null) continue;
            arrayList.add(wLEntry.getTicker());
        }
        return arrayList;
    }

    public boolean containsKey(String string) {
        for (WLEntry wLEntry : this.entries) {
            if (!h.a((Object)wLEntry.getKey(), (Object)string)) continue;
            return true;
        }
        return false;
    }

    public WLSection getSection(String string) {
        for (WLEntry wLEntry : this.entries) {
            if (!wLEntry.isSection() || !h.a((Object)((WLSection)wLEntry).getName(), (Object)string)) continue;
            return (WLSection)wLEntry;
        }
        return null;
    }

    public List getSections() {
        ArrayList<WLSection> arrayList = new ArrayList<WLSection>();
        for (WLEntry wLEntry : this.entries) {
            if (!(wLEntry instanceof WLSection)) continue;
            arrayList.add((WLSection)wLEntry);
        }
        return arrayList;
    }

    public List getSectionTickers(WLSection wLSection) {
        WLEntry wLEntry;
        int n2 = this.entries.indexOf(wLSection);
        ArrayList<WLTicker> arrayList = new ArrayList<WLTicker>();
        if (n2 < 0) {
            return arrayList;
        }
        for (int i2 = n2 + 1; i2 < this.entries.size() && (wLEntry = (WLEntry)this.entries.get(i2)) instanceof WLTicker; ++i2) {
            arrayList.add((WLTicker)wLEntry);
        }
        return arrayList;
    }

    public void moveUp(WLSection wLSection) {
        if (wLSection == null) {
            return;
        }
        int n2 = this.entries.indexOf(wLSection);
        if (n2 <= 0) {
            return;
        }
        int n3 = -1;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (!((WLEntry)this.entries.get(i2)).isSection()) continue;
            n3 = i2;
            break;
        }
        if (n3 < 0) {
            return;
        }
        ArrayList<WLEntry> arrayList = new ArrayList<WLEntry>();
        arrayList.add((WLEntry)this.entries.remove(n2));
        while (n2 < this.entries.size() && !((WLEntry)this.entries.get(n2)).isSection()) {
            arrayList.add((WLEntry)this.entries.remove(n2));
        }
        this.entries.addAll(n3, arrayList);
        this.notifyUpdated();
    }

    public void moveDown(WLSection wLSection) {
        if (wLSection == null) {
            return;
        }
        int n2 = this.entries.indexOf(wLSection);
        if (n2 < 0) {
            return;
        }
        int n3 = -1;
        for (int i2 = n2 + 1; i2 < this.entries.size(); ++i2) {
            if (!((WLEntry)this.entries.get(i2)).isSection()) continue;
            n3 = i2;
            break;
        }
        if (n3 < 0) {
            return;
        }
        ArrayList<WLEntry> arrayList = new ArrayList<WLEntry>();
        arrayList.add((WLEntry)this.entries.remove(n2));
        --n3;
        while (n2 < this.entries.size() && !((WLEntry)this.entries.get(n2)).isSection()) {
            arrayList.add((WLEntry)this.entries.remove(n2));
            --n3;
        }
        for (int i3 = n3 + 1; i3 < this.entries.size(); ++i3) {
            if (!((WLEntry)this.entries.get(i3)).isSection() && i3 != this.entries.size() - 1) continue;
            n3 = i3;
            break;
        }
        if (n3 == this.entries.size() - 1) {
            this.entries.addAll(arrayList);
        } else {
            this.entries.addAll(n3, arrayList);
        }
        this.notifyUpdated();
    }

    public static WatchList fromJson(Map map) {
        Object object;
        if (map.containsKey("type") || map.containsKey("groups") || map.containsKey("instruments")) {
            try {
                Object object2;
                Object object3;
                JSONObject jSONObject = new JSONObject(h.a(map));
                cq cq2 = new cq();
                HashMap<String, RowFormat> hashMap = new HashMap<String, RowFormat>();
                for (Iterator iterator : jSONObject.getObjList("formats")) {
                    Object object4 = new RowFormat((JSONObject)((Object)iterator));
                    hashMap.put(((RowFormat)object4).getKey(), (RowFormat)object4);
                }
                ArrayList arrayList = new ArrayList();
                for (Object object4 : jSONObject.getObjList("groups")) {
                    object3 = ((JSONObject)object4).getColor("fg");
                    object2 = ((JSONObject)object4).getColor("bg");
                    ac ac2 = object2 != null || object3 != null ? new ac(null, (Color)object3, (Color)object2, true) : null;
                    arrayList.add(new WLSection(((JSONObject)object4).str("name"), ac2, Enums$ChartLink.fromString(((JSONObject)object4).str("link"))));
                    for (String string : ((JSONObject)object4).getStringList("tickers")) {
                        LiveTicker liveTicker = cq2.a(string);
                        if (liveTicker == null) continue;
                        RowFormat rowFormat = (RowFormat)hashMap.get(liveTicker.getKey());
                        arrayList.add(new WLTicker(liveTicker.getKey(), rowFormat == null ? null : rowFormat.toStyle()));
                    }
                }
                for (Object object4 : jSONObject.getStringList("instruments")) {
                    object3 = MWInstrument.resolveExpiredContract(w.a((String)object4, false, true));
                    if (object3 == null) {
                        System.err.println("WatchList2::fromJSON() unable to resolve instrument: " + (String)object4);
                        continue;
                    }
                    object2 = (RowFormat)hashMap.get(((MWInstrument)object3).getKey());
                    arrayList.add(new WLTicker(((MWInstrument)object3).getKey(), object2 == null ? null : ((RowFormat)object2).toStyle()));
                }
                return new WatchList(h.a(), jSONObject.str("name"), arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ArrayList<WLEntry> arrayList = new ArrayList<WLEntry>();
        if (map.containsKey("entries")) {
            object = ((List)map.get("entries")).iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                WLEntry wLEntry = WLEntry.fromJson(e2);
                if (wLEntry == null) continue;
                arrayList.add(wLEntry);
            }
        }
        if (h.g((String)(object = h.b(map.get("id"))))) {
            object = h.a();
        }
        return new WatchList((String)object, h.b(map.get("name")), arrayList);
    }

    public static WatchList fromXML(Element element) {
        if (element == null) {
            return null;
        }
        String string = element.getAttribute("name");
        WatchListOld watchListOld = new WatchListOld(-1);
        watchListOld.setName(string);
        watchListOld.setConfig(com.motivewave.common.util.h.a((Node)element));
        return watchListOld.convert();
    }

    public Map toJson() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", this.id);
        hashMap.put("name", this.name);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WLEntry wLEntry : this.entries) {
            String string = wLEntry.toJson();
            if (h.g(string)) continue;
            arrayList.add(string);
        }
        hashMap.put("entries", arrayList);
        return hashMap;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public WatchList clone() {
        try {
            WatchList watchList = (WatchList)super.clone();
            watchList.id = h.a();
            watchList.listeners = new g();
            watchList.entries = new ArrayList();
            for (WLEntry wLEntry : this.entries) {
                watchList.entries.add(wLEntry.clone());
            }
            watchList.notifyTask = new cr(this, watchList);
            return watchList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int compareTo(WatchList watchList) {
        if (watchList == null) {
            return 1;
        }
        if (this.getName() == null) {
            return -1;
        }
        return this.getName().compareTo(watchList.getName());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            WatchList watchList = (WatchList)object;
            if (h.g(watchList.getId()) && !h.g(this.id)) {
                return h.a((Object)watchList.getName(), (Object)this.getName());
            }
            return h.a((Object)watchList.getId(), (Object)this.getId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        if (h.g(this.id)) {
            return this.name.hashCode();
        }
        return this.id.hashCode();
    }

    public void addListener(UpdateListener updateListener) {
        this.listeners.a((Object)updateListener);
    }

    public void removeListener(UpdateListener updateListener) {
        this.listeners.a((Object)updateListener);
    }

    public void notifyUpdated() {
        b.a(this.notifyTask, 10L);
    }

    public boolean replace(String string, String string2) {
        boolean bl2 = false;
        for (WLEntry wLEntry : this.getEntries()) {
            WLTicker wLTicker;
            if (wLEntry.isSection() || !h.a((Object)(wLTicker = (WLTicker)wLEntry).getKey(), (Object)string)) continue;
            wLTicker.setKey(string2);
            bl2 = true;
        }
        if (bl2) {
            this.notifyUpdated();
        }
        return bl2;
    }
}

