/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.Enums$DayOfWeek;
import com.motivewave.common.h;
import com.motivewave.common.util.o;
import com.motivewave.platform.common.Enums$InstrumentType;
import com.motivewave.platform.common.af;
import com.motivewave.platform.common.w;
import com.motivewave.platform.databean.BarBuildSettings;
import com.motivewave.platform.databean.DailyHours;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.TradingHours$TradingTimes;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.cm;
import com.motivewave.platform.service.bs;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public class TradingHours
extends ObservableBean
implements w {
    public static String FXCM = "FXCM";
    public static String CRYPTO = "CRYPTO";
    public static String CRYPTO_UTC = "CRYPTO_UTC";
    public static String FOREX = "FOREX";
    public static String NYSE = "NYSE";
    public static String OTC = "OTC";
    public static String NASDAQ = "NASDAQ";
    public static String BATS = "BATS";
    public static String PINK_SHEET = "Pink Sheet";
    public static String TSX = "TSX";
    public static String PFG_FOREX = "PFG_FOREX";
    public static String IB_FOREX = "IB_FOREX";
    public static String TS_FOREX = "TS_FOREX";
    public static String OANDA = "OANDA";
    public static String CHX = "CHX";
    public static String XETRA = "XETRA";
    public static String ASX = "ASX";
    public static String NSE = "NSE";
    public static String NSE_IDX = "NSE_IDX";
    public static String MCX = "MCX";
    public static String NFO = "NFO";
    public static String CDS = "CDS";
    public static String CME_ENERGY = "CME_ENERGY";
    public static String CME_CURRENCY = "CME_CURRENCY";
    public static String CME_METALS = "CME_METALS";
    public static String CME_WEATHER = "CME_WEATHER";
    public static String CME_EQUITY = "CME_EQUITY";
    public static String CME_INTEREST = "CME_INTEREST";
    public static String CME_AGRICULTURE = "CME_AGRICULTURE";
    public static String CME_FARM = "CME_FARM";
    public static String CME_WHEAT = "CME_WHEAT";
    public static String CME_CRYPTO = "CME_CRYPTO";
    public static String ICE_SUGAR11 = "ICE_SUGAR11";
    public static String ICE_SUGAR16 = "ICE_SUGAR16";
    public static String ICE_COTTON2 = "ICE_COTTON2";
    public static String ICE_COFFEE = "ICE_COFFEE";
    public static String ICE_COCOA = "ICE_COCOA";
    public static String ICE_FCOJ_A = "ICE_FCOJ_A";
    public static String ICE_GRAINS = "ICE_GRAINS";
    public static String ICE_RUSSELL = "ICE_RUSSELL";
    public static String ICE_CURRENCY = "ICE_CURRENCY";
    public static String ICE_METALS = "ICE_METALS";
    public static String ICE_ENERGY = "ICE_ENERGY";
    public static String ICE_CREDIT = "ICE_CREDIT";
    public static String BRENT_CRUDE = "BRENT_CRUDE";
    public static String JPX_TSE = "JPX_TSE";
    public static String JPX_EQUITY_INDEX_FUTURES = "JPX_EQUITY_INDEX_FUTURES";
    public static String JPX_NIKKEI_FUTURES = "JPX_NIKKEI_FUTURES";
    public static String JPX_TAIEX_FUTURES = "JPX_TAIEX_FUTURES";
    public static String JPX_JGB_FUTURES = "JPX_JGB_FUTURES";
    public static String EUREX = "EUREX";
    public static String NONE = "NONE";
    protected String name;
    protected String label;
    protected TimeZone timeZone;
    protected Map regularHours = new LinkedHashMap();
    protected Map extendedHours = new LinkedHashMap();
    protected Map specialDays = new LinkedHashMap();
    protected Map specialExtDays = new LinkedHashMap();
    protected Set holidays = new HashSet();
    protected boolean filterEnabled = true;
    protected List exchanges = new ArrayList();
    protected boolean weekBeginSaturday = false;
    protected int minutesInWeekRth = -1;
    protected int minutesInWeekExt = -1;
    protected long cacheInterval = 300000L;
    protected BarBuildSettings barBuildSettings;
    protected Calendar calendar;
    protected Boolean hasSession2RTH = null;
    protected Boolean hasSession2EXT = null;
    protected Map sodMap = Collections.synchronizedMap(new HashMap(1));
    protected Map sod2Map = Collections.synchronizedMap(new HashMap(1));
    protected Map eodMap = Collections.synchronizedMap(new HashMap(1));
    protected Map eod1Map = Collections.synchronizedMap(new HashMap(1));
    protected Map eod2Map = Collections.synchronizedMap(new HashMap(1));
    protected Map sodExt = Collections.synchronizedMap(new HashMap(1));
    protected Map sod2Ext = Collections.synchronizedMap(new HashMap(1));
    protected Map eodExt = Collections.synchronizedMap(new HashMap(1));
    protected Map eod1Ext = Collections.synchronizedMap(new HashMap(1));
    protected Map eod2Ext = Collections.synchronizedMap(new HashMap(1));
    protected Map insideRTHMap = Collections.synchronizedMap(new HashMap(1));
    protected Map insideETHMap = Collections.synchronizedMap(new HashMap(1));
    private TradingHours$TradingTimes today;
    private TradingHours$TradingTimes todayRTH;
    private TradingHours$TradingTimes tomorrow;
    private TradingHours$TradingTimes tomorrowRTH;
    private TradingHours$TradingTimes lastTT;
    private TradingHours$TradingTimes nextTT;
    private String TT_SYNC = new String("TT_SYNC:" + h.a());
    private static boolean unsavedChanges = false;
    private static Map directory = new LinkedHashMap();
    private static Map defaults = new LinkedHashMap();
    private static Map origDefaults = new LinkedHashMap();
    private static Map exchange2Hours = new HashMap();

    public TradingHours() {
    }

    public TradingHours(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public TradingHours(String string, String string2, TimeZone timeZone) {
        this.name = string;
        this.label = string2;
        this.timeZone = timeZone;
    }

    public void setRegularHours(Enums$DayOfWeek enums$DayOfWeek, DailyHours dailyHours) {
        if (dailyHours == null || !dailyHours.isEnabled()) {
            this.regularHours.remove((Object)enums$DayOfWeek);
        } else {
            this.regularHours.put(enums$DayOfWeek, dailyHours);
        }
        this.hasSession2RTH = null;
        this.updateCacheInterval();
    }

    public void addMonFriRegularHours(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setRegularHours(Enums$DayOfWeek.MON, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setRegularHours(Enums$DayOfWeek.TUES, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setRegularHours(Enums$DayOfWeek.WED, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setRegularHours(Enums$DayOfWeek.THUR, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setRegularHours(Enums$DayOfWeek.FRI, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void addMonFriRegularHours(int n2, int n3, int n4, int n5) {
        this.setRegularHours(Enums$DayOfWeek.MON, n2, n3, n4, n5);
        this.setRegularHours(Enums$DayOfWeek.TUES, n2, n3, n4, n5);
        this.setRegularHours(Enums$DayOfWeek.WED, n2, n3, n4, n5);
        this.setRegularHours(Enums$DayOfWeek.THUR, n2, n3, n4, n5);
        this.setRegularHours(Enums$DayOfWeek.FRI, n2, n3, n4, n5);
    }

    public void addMonFriExtendedHours(int n2, int n3, int n4, int n5) {
        this.setExtendedHours(Enums$DayOfWeek.MON, n2, n3, n4, n5);
        this.setExtendedHours(Enums$DayOfWeek.TUES, n2, n3, n4, n5);
        this.setExtendedHours(Enums$DayOfWeek.WED, n2, n3, n4, n5);
        this.setExtendedHours(Enums$DayOfWeek.THUR, n2, n3, n4, n5);
        this.setExtendedHours(Enums$DayOfWeek.FRI, n2, n3, n4, n5);
    }

    public void addMonFriExtendedHours(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setExtendedHours(Enums$DayOfWeek.MON, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setExtendedHours(Enums$DayOfWeek.TUES, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setExtendedHours(Enums$DayOfWeek.WED, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setExtendedHours(Enums$DayOfWeek.THUR, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setExtendedHours(Enums$DayOfWeek.FRI, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    protected void setRegularHours(Enums$DayOfWeek enums$DayOfWeek, int n2, int n3, int n4, int n5) {
        int n6 = n2 * 60 * 60 * 1000 + n3 * 60 * 1000;
        int n7 = n4 * 60 * 60 * 1000 + n5 * 60 * 1000;
        this.setRegularHours(enums$DayOfWeek, new DailyHours(enums$DayOfWeek, n6, n7, true));
    }

    protected void setRegularHours(Enums$DayOfWeek enums$DayOfWeek, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n2 * 60 * 60 * 1000 + n3 * 60 * 1000;
        int n11 = n4 * 60 * 60 * 1000 + n5 * 60 * 1000;
        int n12 = n6 * 60 * 60 * 1000 + n7 * 60 * 1000;
        int n13 = n8 * 60 * 60 * 1000 + n9 * 60 * 1000;
        this.setRegularHours(enums$DayOfWeek, new DailyHours(enums$DayOfWeek, n10, n11, n12, n13, true));
    }

    protected void setExtendedHours(Enums$DayOfWeek enums$DayOfWeek, int n2, int n3, int n4, int n5) {
        int n6 = n2 * 60 * 60 * 1000 + n3 * 60 * 1000;
        int n7 = n4 * 60 * 60 * 1000 + n5 * 60 * 1000;
        this.setExtendedHours(enums$DayOfWeek, new DailyHours(enums$DayOfWeek, n6, n7, true));
    }

    public void setExtendedHours(Enums$DayOfWeek enums$DayOfWeek, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n2 * 60 * 60 * 1000 + n3 * 60 * 1000;
        int n11 = n4 * 60 * 60 * 1000 + n5 * 60 * 1000;
        int n12 = n6 * 60 * 60 * 1000 + n7 * 60 * 1000;
        int n13 = n8 * 60 * 60 * 1000 + n9 * 60 * 1000;
        this.setExtendedHours(enums$DayOfWeek, new DailyHours(enums$DayOfWeek, n10, n11, n12, n13, true));
    }

    public void setExtendedHours(Enums$DayOfWeek enums$DayOfWeek, DailyHours dailyHours) {
        if (dailyHours == null || !dailyHours.isEnabled()) {
            this.extendedHours.remove((Object)enums$DayOfWeek);
        } else {
            this.extendedHours.put(enums$DayOfWeek, dailyHours);
        }
        this.hasSession2EXT = null;
        this.updateCacheInterval();
    }

    private void updateCacheInterval() {
        int n2;
        this.cacheInterval = 300000L;
        int n3 = 60;
        for (DailyHours dailyHours : this.regularHours.values()) {
            n2 = (int)((long)dailyHours.getStartTime1() % 3600000L / 60000L);
            n3 = this.check(n2, n3);
            n2 = (int)((long)dailyHours.getEndTime1() % 3600000L / 60000L);
            n3 = this.check(n2, n3);
            if (!dailyHours.hasSecondaryTime()) continue;
            n2 = (int)((long)dailyHours.getStartTime2() % 3600000L / 60000L);
            n3 = this.check(n2, n3);
            n2 = (int)((long)dailyHours.getEndTime2() % 3600000L / 60000L);
            n3 = this.check(n2, n3);
        }
        for (DailyHours dailyHours : this.extendedHours.values()) {
            n2 = (int)((long)dailyHours.getStartTime1() % 3600000L / 60000L);
            n3 = this.check(n2, n3);
            n2 = (int)((long)dailyHours.getEndTime1() % 3600000L / 60000L);
            n3 = this.check(n2, n3);
            if (!dailyHours.hasSecondaryTime()) continue;
            n2 = (int)((long)dailyHours.getStartTime2() % 3600000L / 60000L);
            n3 = this.check(n2, n3);
            n2 = (int)((long)dailyHours.getEndTime2() % 3600000L / 60000L);
            n3 = this.check(n2, n3);
        }
        this.cacheInterval = (long)n3 * 60000L;
        this.sodMap.clear();
        this.sod2Map.clear();
        this.eodMap.clear();
        this.eod1Map.clear();
        this.eod2Map.clear();
        this.sodExt.clear();
        this.sod2Ext.clear();
        this.eodExt.clear();
        this.eod1Ext.clear();
        this.eod2Ext.clear();
        this.insideRTHMap.clear();
        this.insideETHMap.clear();
    }

    private int check(int n2, int n3) {
        if (n2 == 0 || n2 % n3 == 0) {
            return n3;
        }
        if (n2 % 30 == 0 && 30 <= n3) {
            return 30;
        }
        if (n2 % 20 == 0 && 20 <= n3) {
            return 20;
        }
        if (n2 % 15 == 0 && 15 <= n3) {
            return 15;
        }
        if (n2 % 10 == 0 && 10 <= n3) {
            return 10;
        }
        if (n2 % 5 == 0 && 5 <= n3) {
            return 5;
        }
        return 1;
    }

    public void clearExtendedHours() {
        this.extendedHours.clear();
        this.updateCacheInterval();
    }

    public void clearRegularHours() {
        this.regularHours.clear();
        this.updateCacheInterval();
    }

    public void addSpecialDay(long l2, DailyHours dailyHours) {
        this.specialDays.put(l2, dailyHours);
    }

    public void addSpecialExtDay(long l2, DailyHours dailyHours) {
        this.specialExtDays.put(l2, dailyHours);
    }

    public void addHoliday(long l2) {
        this.holidays.add(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHoliday(int n2, int n3, int n4) {
        Calendar calendar;
        Calendar calendar2 = calendar = this.getCalendar();
        synchronized (calendar2) {
            calendar.set(2, n2 - 1);
            calendar.set(1, n4);
            calendar.set(5, n3);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            this.addHoliday(calendar.getTimeInMillis());
        }
    }

    public DailyHours getHours(boolean bl2, Enums$DayOfWeek enums$DayOfWeek, long l2) {
        if (this.holidays.contains(l2)) {
            return null;
        }
        if (bl2) {
            DailyHours dailyHours = (DailyHours)this.specialDays.get(l2);
            if (dailyHours != null) {
                return dailyHours;
            }
            dailyHours = (DailyHours)this.regularHours.get((Object)enums$DayOfWeek);
            if (dailyHours != null) {
                return dailyHours;
            }
            return null;
        }
        DailyHours dailyHours = (DailyHours)this.specialExtDays.get(l2);
        if (dailyHours != null) {
            return dailyHours;
        }
        dailyHours = (DailyHours)this.specialDays.get(l2);
        if (dailyHours != null) {
            return dailyHours;
        }
        dailyHours = (DailyHours)this.extendedHours.get((Object)enums$DayOfWeek);
        if (dailyHours != null) {
            return dailyHours;
        }
        dailyHours = (DailyHours)this.regularHours.get((Object)enums$DayOfWeek);
        if (dailyHours != null) {
            return dailyHours;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void delete() {
        directory.remove(this.getName());
    }

    public int getMinutesInWeek(boolean bl2) {
        if (bl2 || h.a(this.extendedHours)) {
            if (this.minutesInWeekRth > 0) {
                return this.minutesInWeekRth;
            }
            int n2 = 0;
            for (DailyHours dailyHours : this.regularHours.values()) {
                n2 += dailyHours.getMinutesInDay();
            }
            this.minutesInWeekRth = n2;
            return n2;
        }
        if (this.minutesInWeekExt > 0) {
            return this.minutesInWeekExt;
        }
        int n3 = 0;
        for (DailyHours dailyHours : this.extendedHours.values()) {
            n3 += dailyHours.getMinutesInDay();
        }
        this.minutesInWeekExt = n3;
        return n3;
    }

    public int getDaysInWeek(boolean bl2) {
        if (bl2 || h.a(this.extendedHours)) {
            return this.regularHours.size();
        }
        return this.extendedHours.size();
    }

    public boolean isSameRTH() {
        return this.isSame(this.getRegularHours());
    }

    public boolean isSameExt() {
        return this.isSame(this.getExtendedHours());
    }

    private boolean isSame(List list) {
        if (list.size() <= 1) {
            return true;
        }
        for (int i2 = 1; i2 < list.size(); ++i2) {
            DailyHours dailyHours;
            DailyHours dailyHours2 = (DailyHours)list.get(i2 - 1);
            if (dailyHours2.isSameHours(dailyHours = (DailyHours)list.get(i2))) continue;
            return false;
        }
        return true;
    }

    public List getRegularHours() {
        return this.getEnabled(this.regularHours.values());
    }

    public List getExtendedHours() {
        return this.getEnabled(this.extendedHours.values());
    }

    private List getEnabled(Collection collection) {
        ArrayList<DailyHours> arrayList = new ArrayList<DailyHours>();
        for (DailyHours dailyHours3 : collection) {
            if (!dailyHours3.isEnabled()) continue;
            arrayList.add(dailyHours3);
        }
        Collections.sort(arrayList, (dailyHours, dailyHours2) -> dailyHours.getDayOfWeek().compareTo(dailyHours2.getDayOfWeek()));
        return arrayList;
    }

    public DailyHours getRegularHours(Enums$DayOfWeek enums$DayOfWeek) {
        return (DailyHours)this.regularHours.get((Object)enums$DayOfWeek);
    }

    public DailyHours getHours(Enums$DayOfWeek enums$DayOfWeek, boolean bl2) {
        if (bl2) {
            return this.getRegularHours(enums$DayOfWeek);
        }
        return this.getExtendedHours(enums$DayOfWeek);
    }

    public DailyHours getHours(long l2, boolean bl2) {
        if (bl2) {
            return this.getRegularHours(l2);
        }
        return this.getExtendedHours(l2);
    }

    public DailyHours getExtendedHours(Enums$DayOfWeek enums$DayOfWeek) {
        DailyHours dailyHours = (DailyHours)this.extendedHours.get((Object)enums$DayOfWeek);
        if (dailyHours != null) {
            return dailyHours;
        }
        return this.getRegularHours(enums$DayOfWeek);
    }

    public DailyHours getExtendedHoursOnly(Enums$DayOfWeek enums$DayOfWeek) {
        DailyHours dailyHours = (DailyHours)this.extendedHours.get((Object)enums$DayOfWeek);
        if (dailyHours != null) {
            return dailyHours;
        }
        return this.getRegularHours(enums$DayOfWeek);
    }

    public DailyHours getRegularHours(long l2) {
        DailyHours dailyHours;
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l3 = h.a(l2, this.timeZone);
        DailyHours dailyHours2 = (DailyHours)this.specialDays.get(l3);
        if (dailyHours2 == null && !this.holidays.contains(l3)) {
            dailyHours2 = this.getRegularHours(enums$DayOfWeek);
        }
        if ((dailyHours = this.getRegularHours(enums$DayOfWeek.nextDay())) == null) {
            if (dailyHours2 == null) {
                return null;
            }
            int n2 = (int)(l2 - l3);
            if (n2 >= dailyHours2.getEndTime()) {
                return null;
            }
            return dailyHours2;
        }
        if (dailyHours.getStartTime1() < 0 && (l3 = h.w(l3, this.timeZone)) + (long)dailyHours.getStartTime1() <= l2) {
            return dailyHours;
        }
        return dailyHours2;
    }

    public DailyHours getExtendedHours(long l2) {
        DailyHours dailyHours;
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l3 = h.a(l2, this.timeZone);
        DailyHours dailyHours2 = (DailyHours)this.specialExtDays.get(l3);
        if (dailyHours2 == null && !this.holidays.contains(l3)) {
            dailyHours2 = this.getExtendedHours(enums$DayOfWeek);
        }
        if ((dailyHours = this.getExtendedHours(enums$DayOfWeek.nextDay())) == null) {
            if (dailyHours2 == null) {
                return null;
            }
            int n2 = (int)(l2 - l3);
            if (n2 >= dailyHours2.getEndTime()) {
                return null;
            }
            return dailyHours2;
        }
        if (dailyHours.getStartTime1() < 0 && (l3 = h.w(l3, this.timeZone)) + (long)dailyHours.getStartTime1() <= l2) {
            return dailyHours;
        }
        return dailyHours2;
    }

    public long calcTradingTime(long l2, long l3, boolean bl2) {
        long l4;
        if (l2 == Long.MIN_VALUE || l3 == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        if (l2 > l3) {
            l4 = l2;
            l2 = l3;
            l3 = l4;
        }
        if (l3 - l2 > 63115200000L) {
            return l3 - l2;
        }
        l4 = l2;
        DailyHours dailyHours = this.getHours(l2, bl2);
        while (l2 < l3 && dailyHours == null) {
            dailyHours = this.getHours(l2 += 86400000L, bl2);
        }
        if (dailyHours == null) {
            return 0L;
        }
        if (l2 - l3 > 86400000L) {
            return 0L;
        }
        long l5 = h.a(l2, this.timeZone);
        int n2 = (int)(l2 - l5);
        if (n2 >= dailyHours.getEndTime()) {
            l5 = h.w(l5, this.timeZone);
            n2 = (int)(l2 - l5);
        }
        if (l2 > l4) {
            n2 = dailyHours.getStartTime1();
        }
        if (dailyHours.getStartTime1() < 0 && n2 >= dailyHours.getEndTime() && (n2 = (int)(l2 - (l5 = h.w(l5, this.timeZone)))) < dailyHours.getStartTime1()) {
            n2 = dailyHours.getStartTime1();
        }
        DailyHours dailyHours2 = this.getHours(l3, bl2);
        long l6 = l3;
        while (l6 > l2 && dailyHours2 == null) {
            dailyHours2 = this.getHours(l6 -= 86400000L, bl2);
        }
        if (dailyHours2 == null) {
            return 0L;
        }
        long l7 = h.a(l6, this.timeZone);
        int n3 = (int)(l6 - l7);
        if (n3 >= dailyHours2.getEndTime()) {
            l7 = h.w(l7, this.timeZone);
            n3 = (int)(l3 - l7);
        }
        if (l7 < l5) {
            return dailyHours.getRemainingTime(n2);
        }
        if (l7 == l5 && n3 == n2) {
            return 0L;
        }
        if (l3 - l2 <= 86400000L) {
            l7 = h.a(l3, this.timeZone);
            n3 = (int)(l3 - l7);
            if (n3 > dailyHours.getEndTime() && n2 < 0) {
                l7 = h.w(l3, this.timeZone);
                n3 = (int)(l3 - l7);
                if (l7 <= l5) {
                    if (n3 < n2) {
                        return 0L;
                    }
                    return dailyHours.getTradingTime(n2, n3);
                }
            }
            if (l5 + (long)dailyHours.getEndTime() >= l3) {
                return dailyHours.getTradingTime(n2, n3);
            }
            DailyHours dailyHours3 = this.getHours(l3, bl2);
            if (dailyHours3 == null) {
                return dailyHours.getRemainingTime(n2);
            }
            long l8 = dailyHours.getRemainingTime(n2);
            long l9 = dailyHours3.getConsumedTime(n3);
            return l8 + l9;
        }
        long l10 = dailyHours.getRemainingTime(n2);
        l5 = h.w(l5, this.timeZone);
        int n4 = 0;
        while (l5 <= l7) {
            long l11;
            if (++n4 > 1000) {
                System.err.println("calcTradingTime() too many iterations " + h.h(l5) + " - " + h.h(l7) + " days: " + (l3 - l2) / 86400000L);
                return l10;
            }
            dailyHours = this.getHours(l5, bl2);
            if (dailyHours == null) {
                l11 = h.w(l5, this.timeZone);
                if (l11 <= l5 + 82800000L) {
                    l5 += 86400000L;
                    continue;
                }
                l5 = l11;
                continue;
            }
            l11 = l5 + (long)dailyHours.getEndTime();
            if (l3 < l11) {
                n3 = (int)(l3 - l7);
                return l10 + (long)dailyHours.getConsumedTime(n3);
            }
            l10 += (long)dailyHours.getTradingTime();
            long l12 = h.w(l5, this.timeZone);
            if (l12 <= l5 + 82800000L) {
                l5 += 86400000L;
                continue;
            }
            l5 = l12;
        }
        return l10;
    }

    public boolean isTradeOnWeekend(boolean bl2) {
        if (bl2 && !this.hasRegularHours()) {
            bl2 = false;
        }
        if (!bl2 && !this.hasExtendedHours()) {
            bl2 = true;
        }
        if (bl2) {
            return this.regularHours.containsKey((Object)Enums$DayOfWeek.SAT) || this.regularHours.containsKey((Object)Enums$DayOfWeek.SUN);
        }
        return this.extendedHours.containsKey((Object)Enums$DayOfWeek.SAT) || this.extendedHours.containsKey((Object)Enums$DayOfWeek.SUN);
    }

    public boolean isTradeOnSaturday(boolean bl2) {
        if (bl2 && !this.hasRegularHours()) {
            bl2 = false;
        }
        if (!bl2 && !this.hasExtendedHours()) {
            bl2 = true;
        }
        if (bl2) {
            return this.regularHours.containsKey((Object)Enums$DayOfWeek.SAT);
        }
        return this.extendedHours.containsKey((Object)Enums$DayOfWeek.SAT);
    }

    public boolean isTradeOnSunday(boolean bl2) {
        if (bl2 && !this.hasRegularHours()) {
            bl2 = false;
        }
        if (!bl2 && !this.hasExtendedHours()) {
            bl2 = true;
        }
        if (bl2) {
            if (this.regularHours.containsKey((Object)Enums$DayOfWeek.SUN)) {
                return true;
            }
            DailyHours dailyHours = (DailyHours)this.regularHours.get((Object)Enums$DayOfWeek.MON);
            return dailyHours != null && dailyHours.getStartTime1() < 0;
        }
        if (this.extendedHours.containsKey((Object)Enums$DayOfWeek.SUN)) {
            return true;
        }
        DailyHours dailyHours = (DailyHours)this.extendedHours.get((Object)Enums$DayOfWeek.MON);
        return dailyHours != null && dailyHours.getStartTime1() < 0;
    }

    public boolean isTradingDay(long l2) {
        long l3;
        if (!h.a(this.holidays) && this.holidays.contains(l3 = h.a(l2, this.timeZone))) {
            return false;
        }
        DailyHours dailyHours = this.getRegularHours(this.getDayOfWeek(l2));
        return dailyHours != null;
    }

    public boolean isTradingDay(long l2, boolean bl2) {
        long l3;
        if (!h.a(this.holidays) && this.holidays.contains(l3 = h.a(l2, this.timeZone))) {
            return false;
        }
        DailyHours dailyHours = this.getHours(this.getDayOfWeek(l2), bl2);
        return dailyHours != null;
    }

    public int getMinutesInDay(boolean bl2) {
        if (h.a(this.regularHours)) {
            return 1440;
        }
        DailyHours dailyHours = (DailyHours)this.regularHours.get(this.regularHours.keySet().iterator().next());
        if (!bl2 && !h.a(this.extendedHours)) {
            dailyHours = (DailyHours)this.extendedHours.get(this.extendedHours.keySet().iterator().next());
        }
        if (dailyHours == null) {
            return 0;
        }
        return dailyHours.getMinutesInDay();
    }

    public boolean hasHours(Enums$DayOfWeek enums$DayOfWeek, boolean bl2) {
        if (bl2 || this.extendedHours.isEmpty()) {
            return this.regularHours.containsKey((Object)enums$DayOfWeek);
        }
        return this.extendedHours.containsKey((Object)enums$DayOfWeek);
    }

    public long getStartOfWeek(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        long l3 = h.i(l2, this.timeZone);
        if (this.isTradeOnSaturday(bl2)) {
            l3 = h.x(l3, this.timeZone);
        }
        return this.getStartOfDay(l3, bl2);
    }

    public long getEndOfWeek(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        long l3 = h.j(l2, this.timeZone);
        l3 = h.x(l3, this.timeZone);
        l3 = h.x(l3, this.timeZone);
        return this.getEndOfDay(l3, bl2);
    }

    private long roundInterval(long l2) {
        return l2 / this.cacheInterval * this.cacheInterval;
    }

    public long getStartOfDay(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        Map map = bl2 ? this.sodMap : this.sodExt;
        Long l3 = (Long)map.get(l2 = this.roundInterval(l2));
        if (l3 != null) {
            return l3;
        }
        l3 = this._getStartOfDay(l2, bl2);
        map.put(l2, l3);
        return l3;
    }

    private long _getStartOfDay(long l2, boolean bl2) {
        long l3;
        DailyHours dailyHours;
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l4 = h.a(l2, this.timeZone);
        DailyHours dailyHours2 = null;
        if (enums$DayOfWeek == Enums$DayOfWeek.SAT && !this.hasHours(Enums$DayOfWeek.SAT, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.FRI;
            l4 -= 86400000L;
        } else if (enums$DayOfWeek == Enums$DayOfWeek.SUN && !this.hasHours(Enums$DayOfWeek.SUN, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.MON;
            l4 = h.w(l2, this.timeZone);
        }
        if (bl2) {
            long l5;
            Enums$DayOfWeek enums$DayOfWeek2;
            DailyHours dailyHours3;
            dailyHours2 = (DailyHours)this.specialDays.get(l4);
            if (dailyHours2 == null && !this.holidays.contains(l4)) {
                dailyHours2 = this.getRegularHours(enums$DayOfWeek);
            }
            if ((dailyHours3 = this.getRegularHours(enums$DayOfWeek2 = enums$DayOfWeek.nextDay())) != null && dailyHours3.getStartTime1() < 0 && (l5 = h.w(l2, this.timeZone) + (long)dailyHours3.getStartTime1()) <= l2) {
                return l5;
            }
            if (dailyHours2 != null) {
                return l4 + (long)dailyHours2.getStartTime1();
            }
            if (dailyHours3 != null) {
                return l4 + (long)dailyHours3.getStartTime1();
            }
            return l4;
        }
        dailyHours2 = (DailyHours)this.specialExtDays.get(l4);
        if (dailyHours2 == null && !this.holidays.contains(l4)) {
            dailyHours2 = this.getExtendedHours(enums$DayOfWeek);
        }
        if ((dailyHours = this.getExtendedHours(enums$DayOfWeek.nextDay())) != null && dailyHours.getStartTime1() < 0 && (l3 = h.w(l2, this.timeZone) + (long)dailyHours.getStartTime1()) <= l2) {
            return l3;
        }
        if (dailyHours2 != null) {
            return l4 + (long)dailyHours2.getStartTime1();
        }
        if (dailyHours != null) {
            return l4 + (long)dailyHours.getStartTime1();
        }
        return l4;
    }

    public long getStartOfDay2(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        Map map = bl2 ? this.sod2Map : this.sod2Ext;
        Long l3 = (Long)map.get(l2 = this.roundInterval(l2));
        if (l3 != null) {
            return l3;
        }
        l3 = this._getStartOfDay2(l2, bl2);
        map.put(l2, l3);
        return l3;
    }

    private long _getStartOfDay2(long l2, boolean bl2) {
        long l3;
        if (!this.hasSession2(bl2)) {
            return -1L;
        }
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l4 = h.a(l2, this.timeZone);
        DailyHours dailyHours = null;
        if (enums$DayOfWeek == Enums$DayOfWeek.SAT && !this.hasHours(Enums$DayOfWeek.SAT, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.FRI;
            l4 -= 86400000L;
        } else if (enums$DayOfWeek == Enums$DayOfWeek.SUN && !this.hasHours(Enums$DayOfWeek.SUN, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.MON;
            l4 = h.w(l2, this.timeZone);
        }
        if (bl2) {
            long l5;
            dailyHours = (DailyHours)this.specialDays.get(l4);
            if (dailyHours == null && !this.holidays.contains(l4)) {
                dailyHours = this.getRegularHours(enums$DayOfWeek);
            }
            DailyHours dailyHours2 = this.getRegularHours(enums$DayOfWeek.nextDay());
            if (dailyHours == null && dailyHours2 == null) {
                return -1L;
            }
            if (dailyHours2 != null && dailyHours2.getStartTime2() < 0 && dailyHours2.hasSecondaryTime() && (l5 = h.w(l2, this.timeZone) + (long)dailyHours2.getStartTime2()) <= l2) {
                return l5;
            }
            if (dailyHours != null && dailyHours.hasSecondaryTime()) {
                return l4 + (long)dailyHours.getStartTime2();
            }
            if (dailyHours2 != null && dailyHours2.hasSecondaryTime()) {
                return l4 + (long)dailyHours2.getStartTime2();
            }
            return -1L;
        }
        dailyHours = (DailyHours)this.specialExtDays.get(l4);
        if (dailyHours == null && !this.holidays.contains(l4)) {
            dailyHours = this.getExtendedHours(enums$DayOfWeek);
        }
        DailyHours dailyHours3 = this.getExtendedHours(enums$DayOfWeek.nextDay());
        if (dailyHours == null && dailyHours3 == null) {
            return -1L;
        }
        if (dailyHours3 != null && dailyHours3.getStartTime2() < 0 && dailyHours3.hasSecondaryTime() && (l3 = h.w(l2, this.timeZone) + (long)dailyHours3.getStartTime2()) <= l2) {
            return l3;
        }
        if (dailyHours != null && dailyHours.hasSecondaryTime()) {
            return l4 + (long)dailyHours.getStartTime2();
        }
        if (dailyHours3 != null && dailyHours3.hasSecondaryTime()) {
            return l4 + (long)dailyHours3.getStartTime2();
        }
        return -1L;
    }

    public long getEndOfDay1(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        Map map = bl2 ? this.eod1Map : this.eod1Ext;
        Long l3 = (Long)map.get(l2 = this.roundInterval(l2));
        if (l3 != null) {
            return l3;
        }
        l3 = this._getEndOfDay1(l2, bl2);
        map.put(l2, l3);
        return l3;
    }

    private long _getEndOfDay1(long l2, boolean bl2) {
        long l3;
        long l4;
        DailyHours dailyHours;
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l5 = h.a(l2, this.timeZone);
        DailyHours dailyHours2 = null;
        if (enums$DayOfWeek == Enums$DayOfWeek.SAT && !this.hasHours(Enums$DayOfWeek.SAT, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.FRI;
            l5 -= 86400000L;
        } else if (enums$DayOfWeek == Enums$DayOfWeek.SUN && !this.hasHours(Enums$DayOfWeek.SUN, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.MON;
            l5 = h.w(l2, this.timeZone);
        }
        if (bl2) {
            long l6;
            long l7;
            DailyHours dailyHours3;
            dailyHours2 = (DailyHours)this.specialDays.get(l5);
            if (dailyHours2 == null && !this.holidays.contains(l5)) {
                dailyHours2 = this.getRegularHours(enums$DayOfWeek);
            }
            if ((dailyHours3 = this.getRegularHours(enums$DayOfWeek.nextDay())) == null) {
                if (dailyHours2 == null) {
                    return h.w(l5, this.timeZone);
                }
                return l5 + (long)dailyHours2.getEndTime1();
            }
            if (dailyHours3.getStartTime1() < 0 && (l7 = (l6 = h.w(l2, this.timeZone)) + (long)dailyHours3.getStartTime1()) <= l2) {
                return l6 + (long)dailyHours3.getEndTime1();
            }
            if (dailyHours2 == null) {
                return h.w(l5, this.timeZone);
            }
            return l5 + (long)dailyHours2.getEndTime1();
        }
        dailyHours2 = (DailyHours)this.specialExtDays.get(l5);
        if (dailyHours2 == null && !this.holidays.contains(l5)) {
            dailyHours2 = this.getExtendedHours(enums$DayOfWeek);
        }
        if ((dailyHours = this.getExtendedHours(enums$DayOfWeek.nextDay())) == null) {
            if (dailyHours2 == null) {
                return h.w(l5, this.timeZone);
            }
            return l5 + (long)dailyHours2.getEndTime1();
        }
        if (dailyHours.getStartTime1() < 0 && (l4 = (l3 = h.w(l2, this.timeZone)) + (long)dailyHours.getStartTime1()) <= l2) {
            return l3 + (long)dailyHours.getEndTime1();
        }
        if (dailyHours2 == null) {
            return h.w(l5, this.timeZone);
        }
        return l5 + (long)dailyHours2.getEndTime1();
    }

    public long getEndOfDay(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        Map map = bl2 ? this.eodMap : this.eodExt;
        Long l3 = (Long)map.get(l2 = this.roundInterval(l2));
        if (l3 != null) {
            return l3;
        }
        l3 = this._getEndOfDay(l2, bl2);
        map.put(l2, l3);
        return l3;
    }

    private long _getEndOfDay(long l2, boolean bl2) {
        long l3;
        long l4;
        DailyHours dailyHours;
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l5 = h.a(l2, this.timeZone);
        DailyHours dailyHours2 = null;
        if (enums$DayOfWeek == Enums$DayOfWeek.SAT && !this.hasHours(Enums$DayOfWeek.SAT, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.FRI;
            l5 -= 86400000L;
        } else if (enums$DayOfWeek == Enums$DayOfWeek.SUN && !this.hasHours(Enums$DayOfWeek.SUN, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.MON;
            l5 = h.w(l2, this.timeZone);
        }
        if (bl2) {
            long l6;
            long l7;
            DailyHours dailyHours3;
            dailyHours2 = (DailyHours)this.specialDays.get(l5);
            if (dailyHours2 == null && !this.holidays.contains(l5)) {
                dailyHours2 = this.getRegularHours(enums$DayOfWeek);
            }
            if ((dailyHours3 = this.getRegularHours(enums$DayOfWeek.nextDay())) == null) {
                if (dailyHours2 == null) {
                    return h.w(l5, this.timeZone);
                }
                if (dailyHours2.hasSecondaryTime()) {
                    if (dailyHours2.getEndTime2() < 0) {
                        long l8 = l5 + 86400000L + (long)dailyHours2.getEndTime2();
                        if (l8 >= l2) {
                            return l8;
                        }
                        return l8 + 86400000L;
                    }
                    return l5 + (long)dailyHours2.getEndTime2();
                }
                return l5 + (long)dailyHours2.getEndTime1();
            }
            if (dailyHours3.getStartTime1() < 0 && (l7 = (l6 = h.w(l2, this.timeZone)) + (long)dailyHours3.getStartTime1()) <= l2) {
                if (dailyHours3.hasSecondaryTime()) {
                    return l6 + (long)dailyHours3.getEndTime2();
                }
                return l6 + (long)dailyHours3.getEndTime1();
            }
            if (dailyHours2 == null) {
                return h.w(l5, this.timeZone);
            }
            if (dailyHours2.hasSecondaryTime()) {
                if (dailyHours2.getEndTime2() < 0) {
                    l6 = l5 + 86400000L + (long)dailyHours2.getEndTime2();
                    if (l6 >= l2) {
                        return l6;
                    }
                    return l6 + 86400000L;
                }
                return l5 + (long)dailyHours2.getEndTime2();
            }
            return l5 + (long)dailyHours2.getEndTime1();
        }
        dailyHours2 = (DailyHours)this.specialExtDays.get(l5);
        if (dailyHours2 == null && !this.holidays.contains(l5)) {
            dailyHours2 = this.getExtendedHours(enums$DayOfWeek);
        }
        if ((dailyHours = this.getExtendedHours(enums$DayOfWeek.nextDay())) == null) {
            if (dailyHours2 == null) {
                return h.w(l5, this.timeZone);
            }
            if (dailyHours2.hasSecondaryTime()) {
                if (dailyHours2.getEndTime2() < 0) {
                    long l9 = l5 + 86400000L + (long)dailyHours2.getEndTime2();
                    if (l9 >= l2) {
                        return l9;
                    }
                    return l9 + 86400000L;
                }
                return l5 + (long)dailyHours2.getEndTime2();
            }
            return l5 + (long)dailyHours2.getEndTime1();
        }
        if (dailyHours.getStartTime1() < 0 && (l4 = (l3 = h.w(l2, this.timeZone)) + (long)dailyHours.getStartTime1()) <= l2) {
            if (dailyHours.hasSecondaryTime()) {
                return l3 + (long)dailyHours.getEndTime2();
            }
            return l3 + (long)dailyHours.getEndTime1();
        }
        if (dailyHours2 == null) {
            return h.w(l5, this.timeZone);
        }
        if (dailyHours2.hasSecondaryTime()) {
            if (dailyHours2.getEndTime2() < 0) {
                l3 = l5 + 86400000L + (long)dailyHours2.getEndTime2();
                if (l3 >= l2) {
                    return l3;
                }
                return l3 + 86400000L;
            }
            return l5 + (long)dailyHours2.getEndTime2();
        }
        return l5 + (long)dailyHours2.getEndTime1();
    }

    public long getEndOfDay2(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        Map map = bl2 ? this.eod2Map : this.eod2Ext;
        Long l3 = (Long)map.get(l2 = this.roundInterval(l2));
        if (l3 != null) {
            return l3;
        }
        l3 = this._getEndOfDay2(l2, bl2);
        map.put(l2, l3);
        return l3;
    }

    private long _getEndOfDay2(long l2, boolean bl2) {
        if (!this.hasSession2(bl2)) {
            return -1L;
        }
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l3 = h.a(l2, this.timeZone);
        DailyHours dailyHours = null;
        if (enums$DayOfWeek == Enums$DayOfWeek.SAT && !this.hasHours(Enums$DayOfWeek.SAT, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.FRI;
            l3 -= 86400000L;
        } else if (enums$DayOfWeek == Enums$DayOfWeek.SUN && !this.hasHours(Enums$DayOfWeek.SUN, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.MON;
            l3 = h.w(l2, this.timeZone);
        }
        if (bl2) {
            dailyHours = (DailyHours)this.specialDays.get(l3);
            if (dailyHours == null && !this.holidays.contains(l3)) {
                dailyHours = this.getRegularHours(enums$DayOfWeek);
            }
            DailyHours dailyHours2 = this.getRegularHours(enums$DayOfWeek.nextDay());
            if (dailyHours == null && dailyHours2 == null) {
                return -1L;
            }
            if (dailyHours2 != null && dailyHours2.getEndTime2() < 0 && dailyHours2.hasSecondaryTime()) {
                long l4 = h.w(l2, this.timeZone) + (long)dailyHours2.getEndTime2();
                if (l4 >= l2) {
                    return l4;
                }
                return l4 + 86400000L;
            }
            if (dailyHours != null && dailyHours.hasSecondaryTime()) {
                return l3 + (long)dailyHours.getEndTime2();
            }
            if (dailyHours2 != null && dailyHours2.hasSecondaryTime()) {
                return l3 + (long)dailyHours2.getEndTime2();
            }
            return -1L;
        }
        dailyHours = (DailyHours)this.specialExtDays.get(l3);
        if (dailyHours == null && !this.holidays.contains(l3)) {
            dailyHours = this.getExtendedHours(enums$DayOfWeek);
        }
        DailyHours dailyHours3 = this.getExtendedHours(enums$DayOfWeek.nextDay());
        if (dailyHours == null && dailyHours3 == null) {
            return -1L;
        }
        if (dailyHours3 != null && dailyHours3.getEndTime2() < 0 && dailyHours3.hasSecondaryTime()) {
            long l5 = h.w(l2, this.timeZone) + (long)dailyHours3.getEndTime2();
            if (l5 >= l2) {
                return l5;
            }
            return l5 + 86400000L;
        }
        if (dailyHours != null && dailyHours.hasSecondaryTime()) {
            return l3 + (long)dailyHours.getEndTime2();
        }
        if (dailyHours3 != null && dailyHours3.hasSecondaryTime()) {
            return l3 + (long)dailyHours3.getEndTime2();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enums$DayOfWeek getDayOfWeek(long l2) {
        Calendar calendar;
        Calendar calendar2 = calendar = this.getCalendar();
        synchronized (calendar2) {
            calendar.setTimeInMillis(l2);
            return this.convert(calendar.get(7));
        }
    }

    public Calendar getCalendar() {
        if (this.calendar != null) {
            return this.calendar;
        }
        this.calendar = h.a(this.timeZone);
        return this.calendar;
    }

    public boolean isBuiltIn() {
        return TradingHours.isDefault(this);
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilterEnabled(boolean bl2) {
        this.filterEnabled = bl2;
    }

    public boolean hasRegularHours() {
        return !h.a(this.regularHours);
    }

    public boolean hasExtendedHours() {
        return !h.a(this.extendedHours);
    }

    public List getExchanges() {
        return this.exchanges;
    }

    public void addExchange(String string) {
        this.exchanges.add(string);
    }

    public boolean isWeekBeginSaturday() {
        return this.weekBeginSaturday;
    }

    public void setWeekBeginSaturday(boolean bl2) {
        this.weekBeginSaturday = bl2;
    }

    public BarBuildSettings getBarBuildSettings() {
        return this.barBuildSettings;
    }

    public void setBarBuildSettings(BarBuildSettings barBuildSettings) {
        this.barBuildSettings = barBuildSettings;
    }

    @Override
    public List getNVPs() {
        Object object = h.b(new String[]{this.b("name", this.name), this.b("label", this.label), this.a("exchanges", (Collection)this.exchanges), this.a("timeZone", (Object)this.timeZone), this.a("filterEnabled", this.filterEnabled), this.a("weekSaturday", this.weekBeginSaturday, false), this.a("regularHours", this.regularHours.values()), this.a("extHours", this.extendedHours.values()), this.a("barBuild", this.barBuildSettings)});
        return object;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        DailyHours dailyHours;
        this.name = jSONObject.str("name");
        this.label = jSONObject.str("label");
        this.exchanges.clear();
        if (jSONObject.has("exchange")) {
            this.exchanges.add(jSONObject.str("exchange"));
        } else if (jSONObject.has("exchanges")) {
            for (Object object : jSONObject.getStringList("exchanges")) {
                this.exchanges.add(object);
            }
        }
        this.timeZone = jSONObject.has("timeZone") ? TimeZone.getTimeZone(jSONObject.str("timeZone")) : TimeZone.getDefault();
        this.filterEnabled = jSONObject.is("filterEnabled");
        this.weekBeginSaturday = jSONObject.is("weekSaturday", false);
        this.regularHours.clear();
        for (Object object : jSONObject.getObjList("regularHours")) {
            dailyHours = new DailyHours((JSONObject)object);
            this.regularHours.put(dailyHours.getDayOfWeek(), dailyHours);
        }
        this.extendedHours.clear();
        for (Object object : jSONObject.getObjList("extHours")) {
            dailyHours = new DailyHours((JSONObject)object);
            this.extendedHours.put(dailyHours.getDayOfWeek(), dailyHours);
        }
        if (jSONObject.has("barBuild")) {
            this.barBuildSettings = new BarBuildSettings(jSONObject.obj("barBuild"));
        }
        this.updateCacheInterval();
    }

    private Enums$DayOfWeek convert(int n2) {
        return switch (n2) {
            case 1 -> Enums$DayOfWeek.SUN;
            case 2 -> Enums$DayOfWeek.MON;
            case 3 -> Enums$DayOfWeek.TUES;
            case 4 -> Enums$DayOfWeek.WED;
            case 5 -> Enums$DayOfWeek.THUR;
            case 6 -> Enums$DayOfWeek.FRI;
            case 7 -> Enums$DayOfWeek.SAT;
            default -> Enums$DayOfWeek.MON;
        };
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            TradingHours tradingHours = (TradingHours)object;
            if (!h.a((Object)this.name, (Object)tradingHours.name)) {
                return false;
            }
            if (!h.a((Object)this.label, (Object)tradingHours.label)) {
                return false;
            }
            if (!h.a((Object)this.timeZone, (Object)tradingHours.timeZone)) {
                return false;
            }
            if (!h.c(this.exchanges, tradingHours.exchanges)) {
                return false;
            }
            if (this.filterEnabled != tradingHours.filterEnabled) {
                return false;
            }
            if (this.weekBeginSaturday != tradingHours.weekBeginSaturday) {
                return false;
            }
            if (!h.a(this.regularHours, tradingHours.regularHours)) {
                return false;
            }
            if (!h.a(this.extendedHours, tradingHours.extendedHours)) {
                return false;
            }
            if (!h.a(this.specialDays, tradingHours.specialDays)) {
                return false;
            }
            if (!h.a(this.specialExtDays, tradingHours.specialExtDays)) {
                return false;
            }
            if (!h.a((Object)this.holidays, (Object)tradingHours.holidays)) {
                return false;
            }
            return h.a((Object)this.barBuildSettings, (Object)tradingHours.barBuildSettings);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public TradingHours clone() {
        TradingHours tradingHours = (TradingHours)super.clone();
        if (this.regularHours != null) {
            tradingHours.regularHours = new LinkedHashMap(this.regularHours);
        }
        if (this.extendedHours != null) {
            tradingHours.extendedHours = new LinkedHashMap(this.extendedHours);
        }
        if (this.exchanges != null) {
            tradingHours.exchanges = new ArrayList(this.exchanges);
        }
        if (this.barBuildSettings != null) {
            tradingHours.barBuildSettings = (BarBuildSettings)this.barBuildSettings.clone();
        }
        if (this.specialDays != null) {
            tradingHours.specialDays = new LinkedHashMap(this.specialDays);
        }
        if (this.holidays != null) {
            tradingHours.holidays = new HashSet(this.holidays);
        }
        if (this.specialExtDays != null) {
            tradingHours.specialExtDays = new LinkedHashMap(this.specialExtDays);
        }
        return tradingHours;
    }

    public boolean hasSession2(boolean bl2) {
        return bl2 ? this.hasSession2RTH() : this.hasSession2EXT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSession2RTH() {
        if (this.hasSession2RTH != null) {
            return this.hasSession2RTH;
        }
        TradingHours tradingHours = this;
        synchronized (tradingHours) {
            boolean bl2 = false;
            for (DailyHours dailyHours : this.regularHours.values()) {
                if (!dailyHours.hasSecondaryTime()) continue;
                bl2 = true;
                break;
            }
            this.hasSession2RTH = bl2;
            return this.hasSession2RTH;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSession2EXT() {
        if (this.hasSession2EXT != null) {
            return this.hasSession2EXT;
        }
        TradingHours tradingHours = this;
        synchronized (tradingHours) {
            boolean bl2 = false;
            for (DailyHours dailyHours : this.extendedHours.values()) {
                if (!dailyHours.hasSecondaryTime()) continue;
                bl2 = true;
                break;
            }
            this.hasSession2EXT = bl2;
            return this.hasSession2EXT;
        }
    }

    public int getTradingDay(long l2) {
        DailyHours dailyHours = this.getHours(l2, false);
        if (dailyHours == null) {
            return 1;
        }
        switch (dailyHours.getDayOfWeek()) {
            case SUN: {
                return 0;
            }
            case MON: {
                return 1;
            }
            case TUES: {
                return 2;
            }
            case WED: {
                return 3;
            }
            case THUR: {
                return 4;
            }
            case FRI: {
                return 5;
            }
            case SAT: {
                return 6;
            }
        }
        return 0;
    }

    public long getStartOfPreviousDay(long l2, boolean bl2) {
        long l3 = this.getStartOfDay(l2, bl2);
        l2 = l3 - 86400000L;
        long l4 = this.getStartOfDay(l2, bl2);
        while (l4 >= l3) {
            l4 = this.getStartOfDay(l2 -= 86400000L, bl2);
        }
        return l4;
    }

    public long getStartOfNextDay(long l2, boolean bl2) {
        long l3 = this.getStartOfDay(l2, bl2);
        l2 = l3 + 86400000L;
        long l4 = this.getStartOfDay(l2, bl2);
        while (l4 <= l3) {
            l4 = this.getStartOfDay(l2 += 86400000L, bl2);
        }
        return l4;
    }

    public long getEndOfNextDay(long l2, boolean bl2) {
        long l3 = this.getEndOfDay(l2, bl2);
        l2 = l3 + 86400000L - 1L;
        long l4 = this.getEndOfDay(l2, bl2);
        while (l4 <= l3) {
            l4 = this.getEndOfDay(l2 += 86400000L, bl2);
        }
        return l4;
    }

    public long getEndOfPreviousDay(long l2, boolean bl2) {
        long l3;
        long l4 = l3 = this.getEndOfDay(l2, bl2);
        while (l3 >= l2) {
            l3 = this.getEndOfDay(l4 -= 86400000L, bl2);
        }
        return l3;
    }

    public long getStartOfMonth(long l2, boolean bl2) {
        long l3;
        DailyHours dailyHours;
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        TimeZone timeZone = this.getTimeZone();
        if (timeZone == null && this.isCrypto()) {
            timeZone = h.b;
        }
        if ((dailyHours = this.getHours(l3 = h.k(l2, timeZone), bl2)) != null && dailyHours.getStartTime1() < 0) {
            l3 += (long)dailyHours.getStartTime1();
        }
        if ((l2 = this.getStartOfDay(l3, bl2)) < l3) {
            l2 = this.getStartOfNextDay(l2, bl2);
        }
        return l2;
    }

    public long getEndOfMonth(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        TimeZone timeZone = this.getTimeZone();
        if (timeZone == null && this.isCrypto()) {
            timeZone = h.b;
        }
        l2 = h.c(l2, timeZone) - 43200000L;
        long l3 = this.getEndOfDay(l2, bl2);
        long l4 = l2 + 21600000L;
        while (l3 > l4) {
            l3 = this.getEndOfDay(l2 -= 86400000L, bl2);
        }
        return l3;
    }

    public boolean isCrypto() {
        return h.a((Object)this.getName(), (Object)CRYPTO);
    }

    public long getStartOfYear(long l2, boolean bl2) {
        long l3;
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        TimeZone timeZone = this.getTimeZone();
        if (timeZone == null && this.isCrypto()) {
            timeZone = h.b;
        }
        if ((l3 = this.getStartOfDay(l2 = h.n(l2, timeZone), bl2)) < l2 - 36000000L) {
            l3 = this.getStartOfNextDay(l3, bl2);
        }
        return l3;
    }

    public long getEndOfYear(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        TimeZone timeZone = this.getTimeZone();
        if (timeZone == null && this.isCrypto()) {
            timeZone = h.b;
        }
        l2 = h.t(l2, timeZone) - 43200000L;
        long l3 = this.getEndOfDay(l2, bl2);
        long l4 = l2 + 21600000L;
        while (l3 > l4) {
            l3 = this.getEndOfDay(l2 -= 86400000L, bl2);
        }
        return l3;
    }

    public boolean isTradeableDay(long l2, boolean bl2) {
        return this.isTradingDay(l2, bl2);
    }

    public boolean isInsideTradingHours(long l2, boolean bl2) {
        return this.isInsideTradingHours(l2, bl2, true);
    }

    public boolean isInsideTradingHours(long l2, long l3, boolean bl2) {
        long l4;
        if (l2 > l3) {
            l4 = l2;
            l2 = l3;
            l3 = l4;
        }
        if (l3 - l2 > 345600000L) {
            return true;
        }
        if (this.isInsideTradingHours(l2, bl2) || this.isInsideTradingHours(l3, bl2)) {
            return true;
        }
        for (l4 = l2 + 1800000L; l4 < l3; l4 += 1800000L) {
            if (!this.isInsideTradingHours(l4, bl2)) continue;
            return true;
        }
        return false;
    }

    public boolean isInsideTradingHours(long l2, boolean bl2, boolean bl3) {
        long l3;
        if (l2 == Long.MIN_VALUE || l2 == Long.MAX_VALUE) {
            return true;
        }
        Map map = bl2 ? this.insideRTHMap : this.insideETHMap;
        Boolean bl4 = (Boolean)map.get(l3 = this.roundInterval(l2));
        if (bl4 != null) {
            return bl4;
        }
        bl4 = this.checkTradingHours(l2, bl2, bl3) == 0;
        map.put(l3, bl4);
        return bl4;
    }

    public boolean isInsideTradingDay(long l2, boolean bl2, boolean bl3) {
        int n2 = this.checkTradingHours(l2, bl2, bl3);
        return n2 == 0 || n2 == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TradingHours$TradingTimes getTradingTimes(long l2, boolean bl2) {
        String string = this.TT_SYNC;
        synchronized (string) {
            int n2;
            if (bl2 && this.todayRTH != null) {
                n2 = this.todayRTH.checkBounds(l2);
                if (n2 == 0 || n2 == 2) {
                    return this.todayRTH;
                }
                if (n2 == 1 && this.tomorrowRTH.checkBounds(l2) == -1) {
                    return this.todayRTH;
                }
            } else if (!bl2 && this.today != null) {
                n2 = this.today.checkBounds(l2);
                if (n2 == 0 || n2 == 2) {
                    return this.today;
                }
                if (n2 == 1 && this.tomorrow.checkBounds(l2) == -1) {
                    return this.today;
                }
            }
            if (this.lastTT != null && this.lastTT.rth == bl2) {
                n2 = this.lastTT.checkBounds(l2);
                if (n2 == 0 || n2 == 2) {
                    return this.lastTT;
                }
                if (n2 == 1 && this.nextTT.checkBounds(l2) == -1) {
                    return this.lastTT;
                }
            }
            long l3 = l2;
            long l4 = this.getStartOfDay(l3, bl2);
            while (l3 < l4) {
                l4 = this.getStartOfDay(l3 -= 86400000L, bl2);
            }
            TradingHours$TradingTimes tradingHours$TradingTimes = new TradingHours$TradingTimes(this, l3, l4, bl2, this);
            long l5 = l3 + 86400000L;
            l4 = this.getStartOfDay(l5, bl2);
            while (l4 <= tradingHours$TradingTimes.sod1) {
                l4 = this.getStartOfDay(l5 += 86400000L, bl2);
            }
            TradingHours$TradingTimes tradingHours$TradingTimes2 = new TradingHours$TradingTimes(this, l5, l4, bl2, this);
            long l6 = bs.a();
            if (l6 >= tradingHours$TradingTimes.sod1 && l6 <= (tradingHours$TradingTimes.hasSession2 ? tradingHours$TradingTimes.eod2 : tradingHours$TradingTimes.eod1)) {
                if (bl2) {
                    this.todayRTH = tradingHours$TradingTimes;
                    this.tomorrowRTH = tradingHours$TradingTimes2;
                } else {
                    this.today = tradingHours$TradingTimes;
                    this.tomorrow = tradingHours$TradingTimes2;
                }
            } else {
                this.lastTT = tradingHours$TradingTimes;
                this.nextTT = tradingHours$TradingTimes2;
            }
            return tradingHours$TradingTimes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkTradingHours(long l2, boolean bl2, boolean bl3) {
        String string = this.TT_SYNC;
        synchronized (string) {
            long l3;
            int n2;
            if (bl2 && this.todayRTH != null) {
                n2 = this.todayRTH.checkBounds(l2);
                if (n2 == 0 || n2 == 2) {
                    return n2;
                }
                if (n2 == 1 && this.tomorrowRTH.checkBounds(l2) == -1) {
                    return n2;
                }
            } else if (!bl2 && this.today != null) {
                n2 = this.today.checkBounds(l2);
                if (n2 == 0 || n2 == 2) {
                    return n2;
                }
                if (n2 == 1 && this.tomorrow.checkBounds(l2) == -1) {
                    return n2;
                }
            }
            if (this.lastTT != null && this.lastTT.rth == bl2) {
                n2 = this.lastTT.checkBounds(l2);
                if (n2 == 0 || n2 == 2) {
                    return n2;
                }
                if (n2 == 1 && this.nextTT.checkBounds(l2) == -1) {
                    return n2;
                }
            }
            long l4 = l2;
            long l5 = l3 = this.getStartOfDay(l4, bl2);
            int n3 = 0;
            while (l2 < l3) {
                l3 = this.getStartOfDay(l4 -= 86400000L, bl2);
                if (++n3 <= 3) continue;
                System.err.println("MWInstrument::checkTradingHours() infinite loop? " + this.getKey() + " " + h.g(l2) + " " + h.g(l5) + " " + l2);
                break;
            }
            TradingHours$TradingTimes tradingHours$TradingTimes = new TradingHours$TradingTimes(this, l4, l3, bl2, this);
            long l6 = l4 + 86400000L;
            l3 = this.getStartOfDay(l6, bl2);
            while (l3 <= tradingHours$TradingTimes.sod1) {
                l3 = this.getStartOfDay(l6 += 86400000L, bl2);
            }
            TradingHours$TradingTimes tradingHours$TradingTimes2 = new TradingHours$TradingTimes(this, l6, l3, bl2, this);
            long l7 = bs.a();
            if (l7 >= tradingHours$TradingTimes.sod1 && l7 <= (tradingHours$TradingTimes.hasSession2 ? tradingHours$TradingTimes.eod2 : tradingHours$TradingTimes.eod1)) {
                if (bl2) {
                    this.todayRTH = tradingHours$TradingTimes;
                    this.tomorrowRTH = tradingHours$TradingTimes2;
                } else {
                    this.today = tradingHours$TradingTimes;
                    this.tomorrow = tradingHours$TradingTimes2;
                }
            } else {
                this.lastTT = tradingHours$TradingTimes;
                this.nextTT = tradingHours$TradingTimes2;
            }
            return tradingHours$TradingTimes.checkBounds(l2);
        }
    }

    public static void saveAll(File file) {
        ArrayList<TradingHours> arrayList = new ArrayList<TradingHours>();
        for (String string : directory.keySet()) {
            TradingHours tradingHours;
            TradingHours tradingHours2 = (TradingHours)directory.get(string);
            if (tradingHours2 == null || (tradingHours = (TradingHours)defaults.get(string)) != null && tradingHours2.equals(tradingHours)) continue;
            arrayList.add(tradingHours2);
        }
        h.a(new File(file, "trading_hours.json"), new cm().b(arrayList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAll() {
        Map map = directory;
        synchronized (map) {
            ArrayList arrayList = new ArrayList(directory.values());
            for (String string : defaults.keySet()) {
                if (directory.containsKey(string)) continue;
                arrayList.add((TradingHours)defaults.get(string));
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAll(List list) {
        Map map = directory;
        synchronized (map) {
            for (Object object : new ArrayList(directory.keySet())) {
                TradingHours tradingHours = (TradingHours)directory.get(object);
                directory.remove(object);
                for (String string : tradingHours.getExchanges()) {
                    exchange2Hours.remove(string);
                }
            }
            for (Object object : list) {
                TradingHours.register((TradingHours)object);
            }
        }
        unsavedChanges = true;
        for (Object object : MWInstrument.getAll()) {
            ((MWInstrument)object).tradingHoursUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TradingHours get(String string) {
        Map map = directory;
        synchronized (map) {
            TradingHours tradingHours = (TradingHours)directory.get(string);
            if (tradingHours == null) {
                tradingHours = (TradingHours)defaults.get(string);
            }
            return tradingHours;
        }
    }

    public static boolean isDefault(TradingHours tradingHours) {
        if (tradingHours == null) {
            return false;
        }
        return defaults.get(tradingHours.getName()) == tradingHours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TradingHours getDefault(String string) {
        Map map = directory;
        synchronized (map) {
            return (TradingHours)defaults.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TradingHours byExchange(String string) {
        Map map = exchange2Hours;
        synchronized (map) {
            List list = (List)exchange2Hours.get(string);
            if (h.a((Collection)list)) {
                return null;
            }
            if (list.size() == 1) {
                return (TradingHours)list.get(0);
            }
            for (TradingHours tradingHours : list) {
                if (defaults.containsKey(tradingHours.getName())) continue;
                return tradingHours;
            }
            return (TradingHours)list.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(TradingHours tradingHours) {
        if (TradingHours.isDefault(tradingHours)) {
            return;
        }
        Map map = directory;
        synchronized (map) {
            directory.put(tradingHours.getName(), tradingHours);
        }
        TradingHours.updateExchanges(tradingHours);
        unsavedChanges = true;
    }

    private static void registerDefault(TradingHours tradingHours) {
        defaults.put(tradingHours.getName(), tradingHours);
        origDefaults.put(tradingHours.getName(), tradingHours);
        TradingHours.updateExchanges(tradingHours);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateExchanges(TradingHours tradingHours) {
        if (!h.a((Collection)tradingHours.getExchanges())) {
            Map map = exchange2Hours;
            synchronized (map) {
                for (String string : tradingHours.getExchanges()) {
                    ArrayList<TradingHours> arrayList = (ArrayList<TradingHours>)exchange2Hours.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<TradingHours>();
                        exchange2Hours.put(string, arrayList);
                    }
                    if (arrayList.contains(tradingHours)) continue;
                    arrayList.add(tradingHours);
                }
            }
        }
    }

    public static void saveAll() {
        if (!unsavedChanges) {
            return;
        }
        TradingHours.saveAll(Workspace.findDir("trading_hours"));
        unsavedChanges = false;
    }

    public static void initFutures() {
        TradingHours tradingHours = new TradingHours(CME_ENERGY, af.a("TH_CME_ENERGY", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(9, 0, 17, 0);
        tradingHours.addMonFriExtendedHours(-6, 0, 17, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CME_CURRENCY, af.a("TH_CME_CURRENCY", new Object[0]), h.a);
        tradingHours.addMonFriRegularHours(-7, 0, 16, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CME_METALS, af.a("TH_CME_METALS", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(9, 30, 17, 0);
        tradingHours.addMonFriExtendedHours(-6, 0, 17, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CME_WEATHER, af.a("TH_CME_WEATHER", new Object[0]), h.a);
        tradingHours.addMonFriRegularHours(8, 30, 15, 15);
        tradingHours.addMonFriExtendedHours(-7, 0, 15, 15);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CME_INTEREST, af.a("TH_CME_INTEREST", new Object[0]), h.a);
        tradingHours.addMonFriRegularHours(7, 20, 14, 0);
        tradingHours.addMonFriExtendedHours(-7, 0, 16, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CME_EQUITY, af.a("TH_CME_EQUITY", new Object[0]), h.a);
        tradingHours.addMonFriRegularHours(8, 30, 16, 0);
        tradingHours.addMonFriExtendedHours(-7, 0, 16, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CME_AGRICULTURE, af.a("TH_CME_AGRICULTURE", new Object[0]), h.a);
        tradingHours.addMonFriRegularHours(8, 30, 14, 30);
        tradingHours.addMonFriExtendedHours(-7, 0, 16, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CME_FARM, af.a("TH_CME_FARM", new Object[0]), h.a);
        tradingHours.addMonFriRegularHours(8, 30, 13, 5);
        tradingHours.addMonFriExtendedHours(-7, 0, 17, 45);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CME_WHEAT, af.a("TH_CME_WHEAT", new Object[0]), h.a);
        tradingHours.addMonFriRegularHours(8, 30, 13, 15);
        tradingHours.addMonFriExtendedHours(-7, 0, 7, 45, 8, 30, 13, 20);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CME_CRYPTO, af.a("TH_CME_CRYPTO", new Object[0]), h.a);
        tradingHours.addMonFriRegularHours(-7, 0, 16, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_SUGAR11, af.a("TH_ICE_SUGAR11", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(3, 30, 13, 0);
        tradingHours.addMonFriExtendedHours(-11, 30, -6, 0, 3, 30, 13, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_SUGAR16, af.a("TH_ICE_SUGAR16", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(9, 0, 13, 0);
        tradingHours.addMonFriExtendedHours(-11, 30, -6, 0, 9, 0, 13, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_COTTON2, af.a("TH_ICE_COTTON2", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(-3, 0, 14, 20);
        tradingHours.addMonFriExtendedHours(-10, 50, -6, 0, -3, 0, 14, 20);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_COCOA, af.a("TH_ICE_COCOA", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(4, 45, 13, 30);
        tradingHours.addMonFriExtendedHours(-10, 0, -6, 0, 4, 45, 13, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_COFFEE, af.a("TH_ICE_COFFEE", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(4, 15, 13, 30);
        tradingHours.addMonFriExtendedHours(-10, 0, -6, 0, 4, 15, 13, 30);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_FCOJ_A, af.a("TH_ICE_FCOJ_A", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(8, 0, 14, 0);
        tradingHours.addMonFriExtendedHours(-10, 30, -6, 0, 8, 0, 14, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_GRAINS, af.a("TH_ICE_GRAINS", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(-4, 0, 14, 30);
        tradingHours.addMonFriExtendedHours(-10, 50, -6, 0, -4, 0, 14, 30);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_RUSSELL, af.a("TH_ICE_RUSSELL", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(-4, 0, 18, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -6, 0, 18, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_CURRENCY, af.a("TH_ICE_CURRENCY", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(-4, 0, 17, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -6, 0, 17, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_METALS, af.a("TH_ICE_METALS", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(-4, 0, 18, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -6, 0, 18, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_ENERGY, af.a("TH_ICE_ENERGY", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(-5, 50, 18, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -7, 50, 18, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(BRENT_CRUDE, af.a("TH_BRENT_CRUDE", new Object[0]), h.g);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -1, 0, 23, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.TUES, 1, 0, 23, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.WED, 1, 0, 23, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.THUR, 1, 0, 23, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.FRI, 1, 0, 23, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ICE_CREDIT, af.a("TH_ICE_CREDIT", new Object[0]), h.b);
        tradingHours.addMonFriRegularHours(2, 0, 18, 0);
        TradingHours.addCMEHolidays(tradingHours);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(EUREX, af.a("TH_EUREX", new Object[0]), h.h);
        tradingHours.addMonFriRegularHours(1, 10, 22, 0);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(JPX_EQUITY_INDEX_FUTURES, af.a("TH_JPX_EQUITY_INDEX_FUTURES", new Object[0]), TimeZone.getTimeZone("JST"));
        tradingHours.addMonFriRegularHours(8, 45, 15, 15);
        tradingHours.addMonFriExtendedHours(-7, -30, 5, 30, 8, 45, 15, 15);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(JPX_NIKKEI_FUTURES, af.a("TH_JPX_NIKKEI_FUTURES", new Object[0]), TimeZone.getTimeZone("JST"));
        tradingHours.addExchange("OSE.JPN");
        tradingHours.addMonFriRegularHours(8, 45, 15, 15);
        tradingHours.addMonFriExtendedHours(8, 45, 15, 15, 16, 30, -18, -30);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(JPX_TAIEX_FUTURES, af.a("TH_JPX_TAIEX_FUTURES", new Object[0]), TimeZone.getTimeZone("JST"));
        tradingHours.addMonFriRegularHours(8, 45, 15, 15);
        TradingHours.registerDefault(tradingHours);
    }

    public static void initCrypto() {
        TradingHours tradingHours = new TradingHours(CRYPTO, af.a("TH_CRYPTO_CURRENCY", new Object[0]), h.b);
        tradingHours.setRegularHours(Enums$DayOfWeek.SUN, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.TUES, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.WED, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.THUR, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.FRI, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.SAT, 0, 0, 24, 0);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CRYPTO_UTC, af.a("TH_CRYPTO_CURRENCY_UTC", new Object[0]), h.e);
        tradingHours.setRegularHours(Enums$DayOfWeek.SUN, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.TUES, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.WED, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.THUR, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.FRI, 0, 0, 24, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.SAT, 0, 0, 24, 0);
        TradingHours.registerDefault(tradingHours);
    }

    public static void initFXCM() {
        TradingHours tradingHours = new TradingHours(FXCM, af.a("TH_FXCM", new Object[0]), h.b);
        tradingHours.addExchange("GFT");
        tradingHours.addExchange("FXCM");
        tradingHours.addExchange("TENFORE");
        tradingHours.setFilterEnabled(false);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -9, 0, 17, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -7, 0, 17, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.WED, -7, 0, 17, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -7, 0, 17, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -7, 0, 17, 0);
        TradingHours.registerDefault(tradingHours);
    }

    public static void initStocks() {
        TradingHours tradingHours = new TradingHours(NASDAQ, af.a("TH_NASDAQ", new Object[0]), h.b);
        tradingHours.addExchange("BATS");
        tradingHours.addExchange("ISLAND");
        tradingHours.addExchange("Pink Sheet");
        tradingHours.addExchange("NASDAQ");
        tradingHours.addExchange("NASD");
        tradingHours.addExchange("NASDS");
        tradingHours.addExchange("NASDQ");
        tradingHours.addExchange("XNAS");
        tradingHours.addExchange("XPSX");
        tradingHours.addMonFriRegularHours(9, 30, 16, 0);
        tradingHours.addMonFriExtendedHours(4, 0, 20, 0);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(NYSE, af.a("TH_NYSE", new Object[0]), h.b);
        tradingHours.addExchange("NYSE");
        tradingHours.addExchange("ARCA");
        tradingHours.addExchange("NYSE ARCA");
        tradingHours.addExchange("NYSE Arca");
        tradingHours.addExchange("NYSE American");
        tradingHours.addExchange("XNYS");
        tradingHours.addExchange("ARCX");
        tradingHours.addExchange("AMEX");
        tradingHours.addExchange("INDEXDJX");
        tradingHours.addExchange("OPRA");
        tradingHours.addExchange("Pacific");
        tradingHours.addExchange("NMS");
        tradingHours.addExchange("DTN");
        tradingHours.addExchange("DJ");
        tradingHours.addMonFriRegularHours(9, 30, 16, 0);
        tradingHours.addMonFriExtendedHours(4, 0, 20, 0);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(TSX, af.a("TH_TSX", new Object[0]), h.b);
        tradingHours.addExchange("TSX");
        tradingHours.addMonFriRegularHours(9, 30, 16, 0);
        tradingHours.addMonFriExtendedHours(9, 0, 17, 0);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(OTC, af.a("TH_OTC", new Object[0]), h.b);
        tradingHours.addExchange("OTC");
        tradingHours.addMonFriRegularHours(9, 30, 16, 0);
        tradingHours.addMonFriExtendedHours(6, 0, 17, 0);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CHX, af.a("TH_CHX", new Object[0]), h.a);
        tradingHours.addExchange("CHX");
        tradingHours.addExchange("XCHI");
        tradingHours.addMonFriRegularHours(8, 30, 15, 0);
        tradingHours.addMonFriExtendedHours(8, 30, 16, 0);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(XETRA, af.a("TH_XETRA", new Object[0]), TimeZone.getTimeZone("Europe/Berlin"));
        tradingHours.addExchange("XETRA");
        tradingHours.addMonFriRegularHours(9, 0, 17, 30);
        tradingHours.addMonFriExtendedHours(8, 0, 20, 0);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(ASX, af.a("TH_ASX", new Object[0]), TimeZone.getTimeZone("Australia/Sydney"));
        tradingHours.addExchange("ASX");
        tradingHours.addMonFriRegularHours(10, 0, 16, 0);
        tradingHours.addMonFriExtendedHours(7, 0, 16, 12);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(NSE, af.a("TH_NSE", new Object[0]), h.c);
        tradingHours.addExchange("NSE");
        tradingHours.addExchange("NSE_IDX");
        tradingHours.addExchange("XCIS");
        tradingHours.addMonFriRegularHours(9, 15, 15, 30);
        tradingHours.addMonFriExtendedHours(9, 0, 16, 0);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(CDS, af.a("TH_CDS", new Object[0]), h.c);
        tradingHours.addExchange("CDS");
        tradingHours.addMonFriRegularHours(9, 0, 17, 0);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(NFO, af.a("TH_NFO", new Object[0]), h.c);
        tradingHours.addExchange("NFO");
        tradingHours.addMonFriRegularHours(9, 15, 15, 30);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(MCX, af.a("TH_MCX", new Object[0]), h.c);
        tradingHours.addExchange("MCX");
        tradingHours.addMonFriRegularHours(9, 0, 23, 55);
        TradingHours.registerDefault(tradingHours);
        tradingHours = new TradingHours(JPX_TSE, af.a("TH_JPX_TSE", new Object[0]), TimeZone.getTimeZone("JST"));
        tradingHours.addExchange("INDEXNIKKEI");
        tradingHours.addMonFriRegularHours(9, 0, 11, 30, 12, 30, 15, 0);
        TradingHours.registerDefault(tradingHours);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDefaults() {
        Map map = directory;
        synchronized (map) {
            directory.clear();
            if (bs.a(Enums$InstrumentType.STOCK)) {
                TradingHours.initStocks();
            }
            if (bs.k() || bs.p() || bs.r()) {
                TradingHours.initFXCM();
            }
            TradingHours tradingHours = new TradingHours(NONE, af.a("TH_NONE", new Object[0]), h.b);
            tradingHours.setFilterEnabled(false);
            tradingHours.setRegularHours(Enums$DayOfWeek.SUN, 0, 0, 24, 0);
            tradingHours.setRegularHours(Enums$DayOfWeek.MON, 0, 0, 24, 0);
            tradingHours.setRegularHours(Enums$DayOfWeek.TUES, 0, 0, 24, 0);
            tradingHours.setRegularHours(Enums$DayOfWeek.WED, 0, 0, 24, 0);
            tradingHours.setRegularHours(Enums$DayOfWeek.THUR, 0, 0, 24, 0);
            tradingHours.setRegularHours(Enums$DayOfWeek.FRI, 0, 0, 24, 0);
            tradingHours.setRegularHours(Enums$DayOfWeek.SAT, 0, 0, 24, 0);
            TradingHours.registerDefault(tradingHours);
            if (bs.r()) {
                tradingHours = TradingHours.get(NASDAQ);
                tradingHours.addExchange("NMS");
                tradingHours.addExchange("NCM");
                tradingHours.addExchange("NGM");
                tradingHours.addExchange("OTC");
                tradingHours.addExchange("OTCBB");
                tradingHours.addExchange("NGSM");
                tradingHours.addExchange("NASDAQ_ADF");
                TradingHours.updateExchanges(tradingHours);
                tradingHours = TradingHours.get(NYSE);
                tradingHours.addExchange("NYSE_AMEX");
                tradingHours.addExchange("ARCA");
                tradingHours.addExchange("NYSE_ARCA");
                tradingHours.addExchange("NYSE_American");
                tradingHours.addExchange("NYSE_AMERICAN");
                TradingHours.updateExchanges(tradingHours);
            }
            if (bs.o()) {
                tradingHours = new TradingHours(TS_FOREX, af.a("TH_TS_FOREX", new Object[0]), h.b);
                tradingHours.setFilterEnabled(false);
                tradingHours.setRegularHours(Enums$DayOfWeek.MON, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.WED, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -7, 0, 17, 0);
                TradingHours.registerDefault(tradingHours);
            }
            if (bs.m()) {
                tradingHours = new TradingHours(OANDA, af.a("TH_OANDA", new Object[0]), h.b);
                tradingHours.setFilterEnabled(true);
                tradingHours.setRegularHours(Enums$DayOfWeek.MON, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.WED, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -7, 0, 17, 0);
                TradingHours.registerDefault(tradingHours);
            }
            if (bs.l() || bs.p() || bs.r()) {
                tradingHours = new TradingHours(FOREX, af.a("TH_FOREX", new Object[0]), h.b);
                tradingHours.addExchange("GFT");
                tradingHours.setFilterEnabled(true);
                tradingHours.setRegularHours(Enums$DayOfWeek.MON, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.WED, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -7, 0, 17, 0);
                TradingHours.registerDefault(tradingHours);
            }
            if (bs.n()) {
                tradingHours = new TradingHours(IB_FOREX, af.a("TH_IB_FOREX", new Object[0]), h.b);
                tradingHours.setFilterEnabled(false);
                tradingHours.setRegularHours(Enums$DayOfWeek.MON, -6, -45, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -6, -45, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.WED, -6, -45, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -6, -45, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -6, -45, 17, 0);
                TradingHours.registerDefault(tradingHours);
            }
            if (bs.a(Enums$InstrumentType.FUTURE)) {
                TradingHours.initFutures();
            }
            if (bs.a(Enums$InstrumentType.CRYPTO_CURRENCY) || bs.a(Enums$InstrumentType.CRYPTO_MCFUT) || bs.a(Enums$InstrumentType.CRYPTO_SCFUT)) {
                TradingHours.initCrypto();
            }
        }
    }

    public static void load() {
        TradingHours.loadDefaults();
        TradingHours.read(Workspace.findFile("trading_hours"));
    }

    private static void read(File file) {
        String string = h.c(file);
        if (h.g(string) || !com.motivewave.common.util.w.a(string)) {
            unsavedChanges = false;
            return;
        }
        try {
            for (JSONObject jSONObject : new JSONArray(string).asObjList()) {
                TradingHours.register(new TradingHours(jSONObject));
            }
            unsavedChanges = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void addCMEHolidays(TradingHours tradingHours) {
        int n2 = h.c(System.currentTimeMillis());
        for (int i2 = n2 - 30; i2 < n2 + 20; ++i2) {
            tradingHours.addHoliday(o.E(tradingHours.getCalendar(), i2));
            tradingHours.addHoliday(o.b(tradingHours.getCalendar(), i2));
        }
    }
}

