/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.af;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.Execution;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.service.bs;

public class Trade
extends ObservableBean {
    private float pips = Float.NaN;
    private int tradeNumber;
    private Instrument instrument;
    private String account;
    private float position;
    private float quantity;
    private float remainingQty;
    private float entryPrice;
    private long entryTime;
    private float exitPrice;
    private long exitTime;
    private double pnl;
    private double commission;
    private double cumulativePnl;
    private double cumulativeCommission;
    private boolean isLong = true;
    private float maxPrice;
    private float minPrice;
    private int bars;
    private double accountValue;
    private double accountValueLong;
    private double accountValueShort;

    public Trade(int n2, Instrument instrument, String string) {
        this.tradeNumber = n2;
        this.instrument = instrument;
        this.account = string;
    }

    public Trade(int n2, Execution execution, float f2, double d2) {
        this(n2, execution.getInstrument(), execution.getAccountId());
        this.setEntryTime(execution.getTime());
        this.setEntryPrice(execution.getAvgPrice());
        this.setQuantity(f2);
        this.setPosition(f2);
        this.setLong(f2 > 0.0f);
        this.setCommission(d2);
    }

    public int getTradeNumber() {
        return this.tradeNumber;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public String getAccount() {
        return this.account;
    }

    public String getCurrency() {
        if (this.instrument == null) {
            return "USD";
        }
        return ((Ticker)this.instrument).getInstrument().getCurrency();
    }

    public float getPosition() {
        return this.position;
    }

    public void setPosition(float f2) {
        this.position = f2;
    }

    public float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(float f2) {
        this.quantity = f2;
        this.remainingQty = f2;
    }

    public float getRemainingQuantity() {
        return this.remainingQty;
    }

    public void setRemainingQuantity(float f2) {
        this.remainingQty = f2;
    }

    public boolean isOpen() {
        return this.remainingQty != 0.0f;
    }

    public float getEntryPrice() {
        return this.entryPrice;
    }

    public void setEntryPrice(float f2) {
        this.entryPrice = f2;
    }

    public void adjustEntryPrice(float f2, float f3) {
        if (this.entryPrice == 0.0f) {
            this.entryPrice = f2;
            return;
        }
        if ((f3 = Math.abs(f3)) > Math.abs(this.remainingQty)) {
            f3 = Math.abs(this.remainingQty);
        }
        float f4 = Math.abs(this.quantity - this.remainingQty);
        float f5 = f4 + f3;
        this.entryPrice = this.entryPrice * f4 / f5 + f2 * f3 / f5;
    }

    public long getEntryTime() {
        return this.entryTime;
    }

    public void setEntryTime(long l2) {
        this.entryTime = l2;
    }

    public float getPips() {
        if (Float.isNaN(this.pips)) {
            float f2 = (this.exitPrice - this.entryPrice) / (float)this.instrument.getPointSize();
            if (!this.isLong()) {
                f2 *= -1.0f;
            }
            return f2;
        }
        return this.pips;
    }

    public void setPips(float f2) {
        this.pips = f2;
    }

    public float getExitPrice() {
        return this.exitPrice;
    }

    public void setExitPrice(float f2) {
        this.exitPrice = f2;
    }

    public void adjustExitPrice(float f2, float f3) {
        if (this.exitPrice == 0.0f) {
            this.exitPrice = f2;
            return;
        }
        if ((f3 = Math.abs(f3)) > Math.abs(this.remainingQty)) {
            f3 = Math.abs(this.remainingQty);
        }
        float f4 = Math.abs(this.quantity - this.remainingQty);
        float f5 = f4 + f3;
        this.exitPrice = this.exitPrice * f4 / f5 + f2 * f3 / f5;
    }

    public long getExitTime() {
        return this.exitTime;
    }

    public void setExitTime(long l2) {
        this.exitTime = l2;
    }

    public double getPnl() {
        return this.pnl;
    }

    public void setPnl(double d2) {
        this.pnl = d2;
    }

    public void addPnl(double d2) {
        this.pnl += d2;
    }

    public double getNetPnl() {
        return this.pnl - this.commission;
    }

    public double getCommission() {
        return this.commission;
    }

    public void setCommission(double d2) {
        this.commission = d2;
    }

    public void addCommission(double d2) {
        this.commission += d2;
    }

    public double getCumulativePnl() {
        return this.cumulativePnl;
    }

    public void setCumulativePnl(double d2) {
        this.cumulativePnl = d2;
    }

    public double getCumulativeCommission() {
        return this.cumulativeCommission;
    }

    public void setCumulativeCommisssion(double d2) {
        this.cumulativeCommission = d2;
    }

    public double getCumulativeNetPnl() {
        return this.getCumulativePnl() - this.getCumulativeCommission();
    }

    public boolean isLong() {
        return this.isLong;
    }

    public void setLong(boolean bl2) {
        this.isLong = bl2;
    }

    public int getBars() {
        return this.bars;
    }

    public void setBars(int n2) {
        this.bars = n2;
    }

    public void setMaxPrice(float f2) {
        this.maxPrice = f2;
    }

    public float getMaxPrice() {
        return this.maxPrice == 0.0f ? this.getEntryPrice() : this.maxPrice;
    }

    public void setMinPrice(float f2) {
        this.minPrice = f2;
    }

    public float getMinPrice() {
        return this.minPrice == 0.0f ? this.getEntryPrice() : this.minPrice;
    }

    public double getAccountValue() {
        return this.accountValue;
    }

    public void setAccountValue(double d2) {
        this.accountValue = d2;
    }

    public double getAccountValueLong() {
        return this.accountValueLong;
    }

    public void setAccountValueLong(double d2) {
        this.accountValueLong = d2;
    }

    public double getAccountValueShort() {
        return this.accountValueShort;
    }

    public void setAccountValueShort(double d2) {
        this.accountValueShort = d2;
    }

    public double getMFE() {
        return Math.abs((this.isLong() ? this.getMaxPrice() : this.getMinPrice()) - this.getEntryPrice());
    }

    public double getMAE() {
        return Math.abs((this.isLong() ? this.getMinPrice() : this.getMaxPrice()) - this.getEntryPrice()) * -1.0f;
    }

    public double getMAEPnl() {
        return Math.abs(this.getInstrument().calcPnL(this.getMAE(), this.getQuantity())) * -1.0;
    }

    public double getMAEPercent() {
        return Math.abs(this.getMAE() * (double)this.getQuantity() / (double)this.getEntryPrice());
    }

    public double getMAEPoints() {
        return Math.abs(this.getMAE() * (double)this.getQuantity()) * -1.0;
    }

    public double getMFEPnl() {
        return Math.abs(this.getInstrument().calcPnL(this.getMFE(), this.getQuantity()));
    }

    public double getMFEPercent() {
        return Math.abs(this.getMFE() * (double)this.getQuantity() / (double)this.getEntryPrice());
    }

    public double getMFEPoints() {
        return Math.abs(this.getMFE() * (double)this.getQuantity());
    }

    public double getETDPnl() {
        return Math.abs(this.getPnl() - this.getMFEPnl()) * -1.0;
    }

    public double getEntryEfficiency() {
        if (this.isLong()) {
            return (this.getMaxPrice() - this.getEntryPrice()) / (this.getMaxPrice() - this.getMinPrice());
        }
        return (this.getEntryPrice() - this.getMinPrice()) / (this.getMaxPrice() - this.getMinPrice());
    }

    public double getExitEfficiency() {
        if (this.isLong()) {
            return (this.getExitPrice() - this.getMinPrice()) / (this.getMaxPrice() - this.getMinPrice());
        }
        return (this.getMaxPrice() - this.getExitPrice()) / (this.getMaxPrice() - this.getMinPrice());
    }

    public double getTotalEfficiency() {
        if (this.isLong()) {
            return (this.getExitPrice() - this.getEntryPrice()) / (this.getMaxPrice() - this.getMinPrice());
        }
        return (this.getEntryPrice() - this.getExitPrice()) / (this.getMaxPrice() - this.getMinPrice());
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "symbol": {
                return this.getInstrument().getSymbol();
            }
            case "account": {
                return this.getAccount();
            }
            case "accountValue": {
                return this.getAccountValue();
            }
            case "accountValueLong": {
                return this.getAccountValueLong();
            }
            case "accountValueShort": {
                return this.getAccountValueShort();
            }
            case "bars": {
                return this.getBars();
            }
            case "commission": {
                return this.getCommission();
            }
            case "cumulativeCommission": {
                return this.getCumulativeCommission();
            }
            case "cumulativeNetPnl": {
                return this.getCumulativeNetPnl();
            }
            case "cumulativePnl": {
                return this.getCumulativePnl();
            }
            case "entryEfficiency": {
                return this.getEntryEfficiency();
            }
            case "entryPrice": {
                return Float.valueOf(this.getEntryPrice());
            }
            case "entryTime": {
                return this.getEntryTime();
            }
            case "eTDPnl": {
                return this.getETDPnl();
            }
            case "exitEfficiency": {
                return this.getExitEfficiency();
            }
            case "exitPrice": {
                return Float.valueOf(this.getExitPrice());
            }
            case "exitTime": {
                return this.getExitTime();
            }
            case "mAE": {
                return this.getMAE();
            }
            case "mAEPercent": {
                return this.getMAEPercent();
            }
            case "mAEPnl": {
                return this.getMAEPnl();
            }
            case "mAEPoints": {
                return this.getMAEPoints();
            }
            case "maxPrice": {
                return Float.valueOf(this.getMaxPrice());
            }
            case "mFE": {
                return this.getMFE();
            }
            case "mFEPercent": {
                return this.getMFEPercent();
            }
            case "mFEPnl": {
                return this.getMFEPnl();
            }
            case "mFEPoints": {
                return this.getMFEPoints();
            }
            case "minPrice": {
                return Float.valueOf(this.getMinPrice());
            }
            case "netPnl": {
                return this.getNetPnl();
            }
            case "pips": {
                return Float.valueOf(this.getPips());
            }
            case "pnl": {
                return this.getPnl();
            }
            case "position": {
                return Float.valueOf(this.getPosition());
            }
            case "quantity": {
                return Float.valueOf(this.getQuantity());
            }
            case "remainingQuantity": {
                return Float.valueOf(this.getRemainingQuantity());
            }
            case "totalEfficiency": {
                return this.getTotalEfficiency();
            }
            case "tradeNumber": {
                return this.getTradeNumber();
            }
            case "long": {
                return this.isLong();
            }
            case "instrument": {
                return this.getInstrument();
            }
            case "currency": {
                return this.getCurrency();
            }
        }
        return super.getProperty(string);
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "symbol": {
                return this.getInstrument().getSymbol();
            }
            case "type": {
                return this.isLong() ? af.a("LBL_LONG", new Object[0]) : af.a("LBL_SHORT", new Object[0]);
            }
            case "account": {
                return this.getAccount();
            }
            case "accountValue": {
                return h.a(this.getAccountValue(), bs.b());
            }
            case "accountValueLong": {
                return h.a(this.getAccountValueLong(), bs.b());
            }
            case "accountValueShort": {
                return h.a(this.getAccountValueShort(), bs.b());
            }
            case "bars": {
                return "" + this.getBars();
            }
            case "commission": {
                return h.a(this.getCommission(), bs.b());
            }
            case "cumulativeCommission": {
                return h.a(this.getCumulativeCommission(), bs.b());
            }
            case "cumulativeNetPnl": {
                return h.a(this.getCumulativeNetPnl(), bs.b());
            }
            case "cumulativePnl": {
                return h.a(this.getCumulativePnl(), bs.b());
            }
            case "entryTime": {
                return ab.j(this.getEntryTime(), b.b());
            }
            case "exitTime": {
                return this.getExitTime() == 0L ? "" : ab.j(this.getExitTime(), b.b());
            }
            case "entryPrice": {
                return this.getEntryPrice() == 0.0f ? "" : ((Ticker)this.getInstrument()).formatPrice(this.getEntryPrice());
            }
            case "exitPrice": {
                return this.getExitPrice() == 0.0f ? "" : ((Ticker)this.getInstrument()).formatPrice(this.getExitPrice());
            }
            case "maxPrice": {
                return this.getMaxPrice() == 0.0f ? "" : ((Ticker)this.getInstrument()).formatPrice(this.getMaxPrice());
            }
            case "minPrice": {
                return this.getMinPrice() == 0.0f ? "" : ((Ticker)this.getInstrument()).formatPrice(this.getMinPrice());
            }
            case "eTDPnl": 
            case "ETDPnl": {
                return h.a(this.getETDPnl(), bs.b());
            }
            case "mAEPnl": 
            case "MAEPnl": {
                return h.a(this.getMAEPnl(), bs.b());
            }
            case "mFEPnl": 
            case "MFEPnl": {
                return h.a(this.getMFEPnl(), bs.b());
            }
            case "pips": {
                return h.c((double)this.getPips(), 1);
            }
            case "pnl": 
            case "netPnl": {
                return h.a(this.getPnl(), bs.b());
            }
            case "position": {
                return ab.a(this.getPosition());
            }
            case "quantity": {
                return ab.a(this.getQuantity());
            }
            case "remainingQuantity": {
                return ab.a(this.getRemainingQuantity());
            }
            case "tradeNumber": {
                return "" + this.getTradeNumber();
            }
            case "currency": {
                return this.getCurrency();
            }
        }
        return h.b(this.getProperty(string));
    }

    @Override
    public Trade clone() {
        try {
            return (Trade)super.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

