/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import bh.c;
import bh.f;
import bh.p;
import bo.aj;
import bo.ap;
import bo.aq;
import bo.at;
import bo.ay;
import bo.n;
import bo.o;
import cf.fg;
import com.motivewave.common.h;
import com.motivewave.common.util.j;
import com.motivewave.platform.common.Enums$BarType;
import com.motivewave.platform.databean.FormatRule;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.StudyInfo;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.sdk.common.AggregateFilter;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.ui.strategy_analysis.r;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import k.b;
import k.v;

public abstract class TickerStudyProperty
implements f,
aq,
ay,
j {
    protected boolean destroyed = false;
    private Object value;
    private LiveTicker ticker;
    protected bh.h dataSource;
    protected Study study;
    protected at model;
    protected StudyInfo studyInfo;
    protected n dataContext;
    private boolean formatMK = false;
    private Double minTick = null;
    private boolean barUpdateInProgress = false;
    private AggregateFilter filter = null;

    protected TickerStudyProperty(LiveTicker liveTicker) {
        this.ticker = liveTicker;
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (this.dataSource != null) {
            this.dataSource.b(this);
            this.dataSource.destroy();
        }
        if (this.study != null) {
            this.study.destroy();
        }
        if (this.dataContext != null) {
            for (o o2 : this.dataContext.a()) {
                o2.destroy();
            }
            this.dataContext.destroy();
        }
        ap.b(this);
        this.dataSource = null;
        this.study = null;
        this.model = null;
        this.studyInfo = null;
        this.ticker = null;
        this.dataContext = null;
    }

    protected void reinitialize() {
        this.dataSource.b(this);
        this.dataSource.destroy();
        this.study.destroy();
        ap.b(this);
        if (this.dataContext != null) {
            for (o o2 : this.dataContext.a()) {
                o2.destroy();
            }
            this.dataContext.destroy();
        }
        this.dataSource = null;
        this.study = null;
        this.model = null;
        this.studyInfo = null;
        this.dataContext = null;
        this.initialize();
    }

    protected void initialize() {
        Object object;
        Object object2;
        Object object32;
        this.setValue(null);
        if (this.ticker == null) {
            return;
        }
        MWInstrument mWInstrument = this.ticker.getInstrument();
        r r2 = new r(mWInstrument, this.getBarSize(), this.isRthData(), Enums$BarType.CANDLESTICK, bs.t(mWInstrument) ? Enums.BarData.PRICE : Enums.BarData.MIDPOINT);
        p p2 = new p();
        this.dataSource = new bh.h(r2, p2, false);
        fg fg2 = this.getStudyWithModel();
        if (fg2 == null) {
            return;
        }
        this.study = fg2.a().clone();
        this.model = fg2.a().a();
        this.studyInfo = fg2.a().a();
        this.updateStudySettings();
        n n2 = new n(this.study, this.model, this.dataSource);
        LinkedHashMap<String, c> linkedHashMap = new LinkedHashMap<String, c>();
        Long l2 = this.study.getMinStartTime((DataContext)n2);
        if (l2 == null) {
            l2 = -1L;
        }
        linkedHashMap.put(c.a(this.ticker.getInstrument(), this.getBarSize()), new c(mWInstrument, this.getBarSize(), true, 100, this.study.getMinBars((DataContext)n2, this.getBarSize()), l2));
        for (Object object32 : this.model.a()) {
            int n3 = this.study.getMinBars((DataContext)n2, (BarSize)object32);
            for (Instrument instrument : this.model.b()) {
                object2 = c.a(((Ticker)instrument).getInstrument(), (BarSize)object32);
                object = (c)linkedHashMap.get(object2);
                if (object == null) {
                    object = new c(mWInstrument, (BarSize)object32, false, -1, n3, l2);
                    linkedHashMap.put((String)object2, (c)object);
                    continue;
                }
                if (n3 <= ((c)object).b()) continue;
                linkedHashMap.put((String)object2, ((c)object).a(n3));
            }
        }
        this.dataSource.a(new ArrayList(linkedHashMap.values()));
        try {
            this.dataSource.b().get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.destroyed) {
            return;
        }
        List list = this.dataSource.a();
        if (list == null) {
            list = new ArrayList();
        }
        object32 = new o(list, this.getBarSize(), r2.a(), r2.a(), r2.a(), this.ticker);
        ((o)object32).a(0);
        ((o)object32).b(list.size() - 1);
        this.dataContext = new n(this.study, this.model, this.dataSource);
        this.dataContext.a((o)object32);
        for (Object object4 : this.dataSource.b()) {
            Instrument instrument;
            instrument = ((c)object4).a();
            mWInstrument = ((c)object4).a();
            object2 = (o)this.dataContext.a((BarSize)instrument, mWInstrument);
            object = this.dataSource.a((BarSize)instrument, mWInstrument);
            if (h.a((Collection)object) || object2 != null) continue;
            object2 = new o((List)object, (BarSize)instrument, r2.a(), r2.a(), r2.a(), p2.a(mWInstrument));
            ((o)object2).a(0);
            ((o)object2).b(object.size() - 1);
            this.dataContext.d();
            this.dataContext.a((o)object2);
        }
        this.study.onLoad(this.dataContext.getDefaults());
        this.study.clearState();
        this.study.onNewDataSeries((DataContext)this.dataContext);
        ValueDescriptor valueDescriptor = this.getStudyValue();
        if (valueDescriptor != null) {
            this.setValue(((o)object32).getValue(valueDescriptor.getKey()));
        }
        ((o)object32).a(this);
        this.dataSource.a(this);
        ap.a(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBarOpen(b b2, Ticker ticker) {
        if (this.destroyed || !this.model.a().isBarUpdates()) {
            return;
        }
        MWInstrument mWInstrument = ticker.getInstrument();
        BarSize barSize = b2.getBarSize();
        o o2 = (o)this.dataContext.a(barSize, mWInstrument);
        List list = this.dataSource.a(barSize, mWInstrument);
        if (h.a((Collection)list)) {
            return;
        }
        o2.a(list, (Instrument)ticker);
        o2.b(list.size() - 1);
        if (!h.a((Object)barSize, (Object)this.getBarSize())) {
            return;
        }
        this.dataContext.f();
        try {
            this.study.beginFigureUpdate();
            this.study.onBarOpen((DataContext)this.dataContext);
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
        finally {
            this.study.endFigureUpdate();
            this.dataContext.g();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBarClose(b b2, Ticker ticker) {
        if (this.destroyed) {
            return;
        }
        MWInstrument mWInstrument = ticker.getInstrument();
        BarSize barSize = b2.getBarSize();
        o o2 = (o)this.dataContext.a(barSize, mWInstrument);
        List list = this.dataSource.a(barSize, mWInstrument);
        if (h.a((Collection)list)) {
            return;
        }
        o2.a(list, (Instrument)ticker);
        o2.b(list.size() - 1);
        if (!h.a((Object)barSize, (Object)this.getBarSize())) {
            return;
        }
        this.dataContext.f();
        try {
            this.study.beginFigureUpdate();
            this.study.onBarClose((DataContext)this.dataContext);
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
        finally {
            this.study.endFigureUpdate();
            this.dataContext.g();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBarUpdate(b b2, Ticker ticker) {
        block10: {
            if (this.destroyed || !this.model.c() || !h.a((Object)ticker.getKey(), (Object)this.ticker.getKey())) {
                return;
            }
            if (this.barUpdateInProgress) {
                return;
            }
            this.barUpdateInProgress = true;
            try {
                this.dataContext.f();
                try {
                    this.study.beginFigureUpdate();
                    this.study.onBarUpdate((DataContext)this.dataContext);
                }
                catch (Throwable throwable) {
                    try {
                        this.logTrace(throwable);
                        break block10;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        this.study.endFigureUpdate();
                        this.dataContext.g();
                    }
                }
                this.study.endFigureUpdate();
                this.dataContext.g();
            }
            finally {
                this.barUpdateInProgress = false;
            }
        }
    }

    @Override
    public void onTimeAndSale(Tick tick) {
        v v2 = (v)tick;
        if (this.destroyed || !this.model.c() || !h.a((Object)v2.a().getKey(), (Object)this.ticker.getKey())) {
            return;
        }
        if (this.filter != null) {
            this.filter.onTick(tick);
        } else {
            this.doTick(tick);
        }
    }

    private void doTick(Tick tick) {
        this.dataContext.f();
        try {
            this.study.onTick((DataContext)this.dataContext, tick);
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
        finally {
            this.dataContext.g();
        }
    }

    @Override
    public void studyClassLoaded(StudyInfo studyInfo) {
        if (this.destroyed) {
            return;
        }
        if (studyInfo == null || !h.a((Object)studyInfo.getId(), (Object)this.studyInfo.getId()) || !h.a((Object)studyInfo.getNamespace(), (Object)this.studyInfo.getNamespace())) {
            return;
        }
        Study study = ap.a(studyInfo);
        if (study == null) {
            h.a.warning("StudyWrapper::studyClassLoaded() unable to create study! " + studyInfo.getId());
            return;
        }
        this.studyInfo = studyInfo;
        this.study = study;
        try {
            this.updateStudySettings();
            this.reset();
            this.recalculate();
            ((o)this.dataContext.getDataSeries()).d();
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (h.a(object, this.value)) {
            return;
        }
        Object object2 = this.value;
        this.value = object;
        this.ticker.notify(this.getProperty(), object2, object);
    }

    public String getFormattedValue() {
        Object object = this.getValue();
        if (object == null || this.study == null) {
            return "";
        }
        if (object instanceof Number) {
            double d2;
            double d3 = ((Number)object).doubleValue();
            if (this.formatMK) {
                if (d3 >= 2.5E12) {
                    double d4 = h.a(d3 / 1.0E12, 1);
                    return h.c(d4, 1) + "T";
                }
                if (d3 >= 2.5E9) {
                    double d5 = h.a(d3 / 1.0E9, 1);
                    return h.c(d5, 1) + "B";
                }
                if (d3 >= 1000000.0 || d3 <= -1000000.0) {
                    double d6 = h.a(d3 / 1000000.0, 1);
                    return h.c(d6, 1) + "M";
                }
                if (d3 >= 10000.0 || d3 <= -10000.0) {
                    double d7 = h.a(d3 / 1000.0, 1);
                    return h.c(d7, 1) + "K";
                }
            }
            double d8 = d2 = this.minTick == null ? 1.0E-5 : this.minTick;
            if (this.minTick == null) {
                if (d3 >= 1000.0 || d3 <= -1000.0) {
                    d2 = 0.1;
                } else if (d3 >= 100.0 || d3 <= -100.0) {
                    d2 = 0.01;
                } else if (d3 >= 10.0 || d3 <= -10.0) {
                    d2 = 0.001;
                } else if (d3 >= 1.0 || d3 <= -1.0) {
                    d2 = 1.0E-4;
                } else if (d3 >= 0.1 || d3 <= -0.1) {
                    d2 = 1.0E-5;
                } else if (d3 >= 0.01 || d3 <= -0.01) {
                    d2 = 1.0E-6;
                } else if (d3 >= 0.001 || d3 <= -0.001) {
                    d2 = 1.0E-7;
                }
            }
            return h.a(d3, d2);
        }
        return object.toString();
    }

    public FormatRule getApplicableRule() {
        return null;
    }

    protected abstract ValueDescriptor getStudyValue();

    protected abstract fg getStudyWithModel();

    protected abstract String getProperty();

    protected abstract BarSize getBarSize();

    protected abstract boolean isRthData();

    @Override
    public void valueUpdated(Object object, Object object2, Object object3) {
        ValueDescriptor valueDescriptor = this.getStudyValue();
        if (valueDescriptor == null || !h.a(valueDescriptor.getKey(), object)) {
            return;
        }
        this.setValue(object3);
    }

    private void updateStudySettings() {
        if (this.destroyed) {
            return;
        }
        Settings settings = this.getStudyWithModel().a().a();
        if (h.a(settings.getInstruments())) {
            this.study.setSettings(settings);
        }
        this.study.setSettings((Settings)new aj(settings, this.dataSource, null));
        this.formatMK = this.study.getRuntimeDescriptor().getDefaultPlot().isFormatMK();
        this.minTick = this.study.getRuntimeDescriptor().getMinTick();
        this.updateFilter();
    }

    private void reset() {
        try {
            Study study = this.study;
            if (study == null) {
                return;
            }
            study.clearState();
            this.dataContext.b();
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
    }

    private void recalculate() {
        try {
            if (this.destroyed) {
                return;
            }
            this.study.onDataSeriesUpdated((DataContext)this.dataContext);
            ((o)this.dataContext.getDataSeries()).d();
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
    }

    private void logTrace(Throwable throwable) {
        throwable.printStackTrace();
        String string = h.a(throwable);
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            String string3 = bufferedReader.readLine();
            String string4 = bufferedReader.readLine();
            String string5 = bufferedReader.readLine();
            String string6 = bufferedReader.readLine();
            String string7 = bufferedReader.readLine();
            String string8 = string2 + " " + h.b((Object)string3);
            if (this.study != null) {
                this.study.error(string8);
            }
            if (string2 != null) {
                System.err.println(string2);
            }
            if (string3 != null) {
                System.err.println(string3);
            }
            if (string4 != null) {
                System.err.println(string4);
            }
            if (string5 != null) {
                System.err.println(string5);
            }
            if (string6 != null) {
                System.err.println(string6);
            }
            if (string7 != null) {
                System.err.println(string7);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateFilter() {
        if (this.model == null) {
            return;
        }
        this.filter = this.model.a(this.ticker);
        if (this.filter != null) {
            this.filter.setOperation(tick -> this.doTick(tick));
        }
    }
}

