/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.platform.common.af;
import com.motivewave.platform.common.f;
import com.motivewave.platform.databean.MWInstrument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;

public class TickImportFormat {
    private Boolean trimNs = null;
    private int trimLength = 0;
    private MWInstrument instrument;
    private File file;
    private int priceIndex = -1;
    private int bidIndex = -1;
    private int bidSizeIndex = -1;
    private int askIndex = -1;
    private int askSizeIndex = -1;
    private int volumeIndex = -1;
    private int dateIndex = -1;
    private int timeIndex = -1;
    private SimpleDateFormat dateTimeFormat;
    private TimeZone timeZone;
    private boolean validNameFormat = false;
    private char separator = (char)44;
    private boolean ignoreEmpty = false;
    private boolean ascending = true;

    public TickImportFormat(MWInstrument mWInstrument, TimeZone timeZone) {
        this.instrument = mWInstrument;
        this.timeZone = timeZone;
    }

    public void detectFormat(File file) {
        try {
            String string;
            int n2;
            List list;
            String string2;
            this.file = file;
            this.dateTimeFormat = null;
            this.validNameFormat = false;
            this.timeIndex = -1;
            this.dateIndex = -1;
            this.volumeIndex = -1;
            this.askIndex = -1;
            this.bidIndex = -1;
            this.priceIndex = -1;
            String string3 = file.getName().toUpperCase();
            this.separator = (char)44;
            this.ignoreEmpty = false;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string4 = bufferedReader.readLine();
            while (h.a((Object)string4, (Object)"")) {
                string4 = bufferedReader.readLine();
            }
            if (string4 != null && string4.indexOf(44) < 0) {
                string4 = bufferedReader.readLine();
            }
            if (string4 == null || (string3.endsWith(".CSV") || string3.endsWith(".TXT")) && string4.indexOf(44) < 0) {
                bufferedReader.close();
                throw new MWException(af.a("E_CSV_NOT_CSV_FILE", new Object[0]));
            }
            if (string3.endsWith(".PRN") && string4.indexOf(44) < 0) {
                this.separator = (char)32;
                this.ignoreEmpty = true;
            }
            if ((string2 = string3).indexOf(46) > 0) {
                string2 = string2.substring(0, string2.lastIndexOf(46));
            }
            if (string2.indexOf(45) < 0 || (list = h.a(string2, '-')).size() != 3 || ((String)list.get(1)).length() != 4 || !h.b((String)list.get(1)) || ((String)list.get(2)).length() != 2 || h.b((String)list.get(2))) {
                // empty if block
            }
            this.validNameFormat = true;
            list = this.tokenize(string4);
            if (string4.toUpperCase().indexOf("DTYYYYMMDD") >= 0 || string4.toUpperCase().indexOf("DATE") >= 0) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    string = (String)list.get(n2);
                    string = h.a(string, "\"", "");
                    if (h.a(string = h.a(string, "'", ""), "DATE") || h.a((Object)string, (Object)"DTYYYMMDD")) {
                        this.dateIndex = n2;
                        continue;
                    }
                    if (h.a(string, "TIME")) {
                        this.timeIndex = n2;
                        continue;
                    }
                    if (h.a(string, "PRICE")) {
                        this.priceIndex = n2;
                        continue;
                    }
                    if (h.a(string, "INC VOL")) {
                        this.volumeIndex = n2;
                        continue;
                    }
                    if (h.a(string, "VOL") && this.volumeIndex < 0) {
                        this.volumeIndex = n2;
                        continue;
                    }
                    if (h.a(string, "BID")) {
                        this.bidIndex = n2;
                        continue;
                    }
                    if (!h.a(string, "ASK")) continue;
                    this.askIndex = n2;
                }
                string4 = bufferedReader.readLine();
                list = this.tokenize(string4);
            }
            if (this.dateIndex < 0) {
                int n3;
                string4 = bufferedReader.readLine();
                list = this.tokenize(string4);
                this.dateIndex = -1;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (h.a((String)list.get(n2)) == null) continue;
                    this.dateIndex = n2;
                    break;
                }
                this.timeIndex = -1;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (n2 == this.dateIndex || (string = (String)list.get(n2)).length() < 4 || string.length() > 12 || string.indexOf(58) <= 0) continue;
                    this.timeIndex = n2;
                    break;
                }
                this.volumeIndex = -1;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (n2 == this.dateIndex || n2 == this.timeIndex || !h.b((String)list.get(n2))) continue;
                    int n4 = h.b((String)list.get(n2));
                    this.volumeIndex = n2;
                    if (n4 > 0) break;
                }
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                for (n3 = 0; n3 < list.size(); ++n3) {
                    String string5;
                    if (n3 == this.dateIndex || n3 == this.volumeIndex || n3 == this.timeIndex || (string5 = (String)list.get(n3)).indexOf(46) < 0 || !h.e(string5)) continue;
                    double d5 = h.a(string5);
                    if (d2 == 0.0) {
                        d2 = d5;
                        this.priceIndex = n3;
                        continue;
                    }
                    if (d3 == 0.0) {
                        d3 = d5;
                        this.bidIndex = n3;
                        continue;
                    }
                    if (d4 != 0.0) continue;
                    d4 = d5;
                    this.askIndex = n3;
                }
                if ((this.instrument.isCash() || this.instrument.isCFD()) && this.askIndex < 0 && this.bidIndex > 0) {
                    if (d2 <= d3) {
                        this.askIndex = this.bidIndex;
                        this.bidIndex = this.priceIndex;
                    } else {
                        this.askIndex = this.priceIndex;
                    }
                    this.priceIndex = -1;
                } else if (this.askIndex < 0 && this.bidIndex > 0) {
                    this.bidIndex = -1;
                } else if (this.askIndex > 0 && d3 > d4) {
                    n3 = this.askIndex;
                    this.askIndex = this.bidIndex;
                    this.bidIndex = n3;
                }
            }
            if ((string4 = bufferedReader.readLine()) == null) {
                h.a.warning("ImportFormat::detectFormat() no data");
                bufferedReader.close();
                throw new MWException(f.E_IMPORT_UNRECOGNIZED_FORMAT);
            }
            list = this.tokenize(string4);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getTimeStr(list));
            for (int i2 = 0; i2 < 100 && (string4 = bufferedReader.readLine()) != null; ++i2) {
                list = this.tokenize(string4);
                arrayList.add(this.getTimeStr(list));
            }
            bufferedReader.close();
            this.dateTimeFormat = TickImportFormat.detectDateFormat(arrayList);
            if (this.dateTimeFormat == null) {
                h.a.warning("ImportFormat::detectFormat() Invalid date format: " + (String)list.get(this.dateIndex));
                throw new MWException(f.E_IMPORT_UNRECOGNIZED_DATE_FORMAT, list.get(this.dateIndex));
            }
            if (this.timeZone != null) {
                this.dateTimeFormat.setTimeZone(this.timeZone);
            }
            long l2 = -1L;
            for (String string6 : arrayList) {
                long l3 = this.parseTime(string6);
                if (l3 == -1L) continue;
                if (l2 == -1L) {
                    l2 = l3;
                    continue;
                }
                if (l2 < l3) {
                    this.ascending = true;
                    break;
                }
                if (l2 <= l3) continue;
                this.ascending = false;
                break;
            }
            h.a.info("TickImportFormat() dataTimeFormat: " + this.dateTimeFormat.toPattern() + " ascending: " + this.ascending);
        }
        catch (MWException mWException) {
            throw mWException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MWException(f.E_IMPORT_DETECT_FORMAT, exception.getMessage());
        }
    }

    public float getPrice(List list) {
        if (this.priceIndex < 0 || this.priceIndex >= list.size()) {
            return 0.0f;
        }
        return Float.valueOf((String)list.get(this.priceIndex)).floatValue();
    }

    public void setPriceIndex(int n2) {
        this.priceIndex = n2;
    }

    public float getBid(List list) {
        if (this.bidIndex < 0 || this.bidIndex >= list.size()) {
            return 0.0f;
        }
        return Float.valueOf(h.e((String)list.get(this.bidIndex), "<<")).floatValue();
    }

    public void setBidIndex(int n2) {
        this.bidIndex = n2;
    }

    public int getBidSize(List list) {
        if (this.bidSizeIndex < 0 || this.bidSizeIndex >= list.size()) {
            return 0;
        }
        return Integer.valueOf((String)list.get(this.bidSizeIndex));
    }

    public void setBidSizeIndex(int n2) {
        this.bidSizeIndex = n2;
    }

    public float getAsk(List list) {
        if (this.askIndex < 0 || this.askIndex >= list.size()) {
            return 0.0f;
        }
        return Float.valueOf(h.e((String)list.get(this.askIndex), "<<")).floatValue();
    }

    public void setAskIndex(int n2) {
        this.askIndex = n2;
    }

    public int getAskSize(List list) {
        if (this.askSizeIndex < 0 || this.askSizeIndex >= list.size()) {
            return 0;
        }
        return Integer.valueOf((String)list.get(this.askSizeIndex));
    }

    public void setAskSizeIndex(int n2) {
        this.askSizeIndex = n2;
    }

    public int getVolume(List list) {
        if (this.volumeIndex < 0 || this.volumeIndex >= list.size()) {
            return 0;
        }
        return Integer.valueOf((String)list.get(this.volumeIndex));
    }

    public void setVolumeIndex(int n2) {
        this.volumeIndex = n2;
    }

    public List tokenize(String string) {
        return h.a(string, this.separator, this.ignoreEmpty);
    }

    public long getTime(List list) {
        if (h.a((Collection)list)) {
            return -1L;
        }
        return this.parseTime(this.getTimeStr(list));
    }

    private long parseTime(String string) {
        if (h.g(string)) {
            return -1L;
        }
        long l2 = -1L;
        String string2 = h.n(string);
        if (h.g(string2)) {
            return -1L;
        }
        try {
            l2 = this.dateTimeFormat.parse(string2).getTime();
        }
        catch (Exception exception) {
            h.a.warning("parseTime() invalid time: " + string2);
            return -1L;
        }
        return l2;
    }

    public String getTimeStr(List list) {
        if (h.a((Collection)list)) {
            return "";
        }
        Object object = (String)list.get(this.dateIndex);
        if (this.timeIndex >= 0) {
            object = (String)object + " " + (String)list.get(this.timeIndex);
        }
        if (this.trimNs == null) {
            int n2 = ((String)object).lastIndexOf(46);
            int n3 = ((String)object).length() - n2 - 1;
            if (n3 > 3 && n3 < 10 && h.b(((String)object).substring(n2 + 1))) {
                this.trimNs = true;
                this.trimLength = n2 + 4;
            }
            if (this.trimNs == null) {
                this.trimNs = false;
            }
        }
        if (this.trimNs.booleanValue() && ((String)object).length() > this.trimLength) {
            object = ((String)object).substring(0, this.trimLength);
        }
        return object;
    }

    public MWInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(MWInstrument mWInstrument) {
        this.instrument = mWInstrument;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isValidNameFormat() {
        return this.validNameFormat;
    }

    public char getSeparator() {
        return this.separator;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public static SimpleDateFormat detectDateFormat(List list) {
        String[] stringArray = new String[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            stringArray[i2] = h.n((String)list.get(i2));
        }
        String string = stringArray[0];
        if (h.b(string)) {
            if (string.length() > 14) {
                if (h.a(stringArray, "yyyyMMddHHmmssSSS")) {
                    return new SimpleDateFormat("yyyyMMddHHmmssSSS");
                }
                if (h.a(stringArray, "ddMMyyyyHHmmssSSS")) {
                    return new SimpleDateFormat("ddMMyyyyHHmmssSSS");
                }
                if (h.a(stringArray, "MMddyyyyHHmmssSSS")) {
                    return new SimpleDateFormat("MMddyyyyHHmmssSSS");
                }
                return null;
            }
            if (string.length() > 8) {
                if (h.a(stringArray, "yyyyMMddHHmmss")) {
                    return new SimpleDateFormat("yyyyMMddHHmmss");
                }
                if (h.a(stringArray, "ddMMyyyyHHmmss")) {
                    return new SimpleDateFormat("ddMMyyyyHHmmss");
                }
                if (h.a(stringArray, "yyMMddHHmmss")) {
                    return new SimpleDateFormat("yyyyMMddHHmmss");
                }
                if (h.a(stringArray, "ddMMyyHHmmss")) {
                    return new SimpleDateFormat("ddMMyyyyHHmmss");
                }
                if (h.a(stringArray, "MMddyyyyHHmmss")) {
                    return new SimpleDateFormat("MMddyyyyHHmmss");
                }
                if (h.a(stringArray, "yyyyMMddHHmm")) {
                    return new SimpleDateFormat("yyyyMMddHHmm");
                }
                if (h.a(stringArray, "ddMMyyyyHHmm")) {
                    return new SimpleDateFormat("ddMMyyyyHHmm");
                }
                if (h.a(stringArray, "MMddyyyyHHmm")) {
                    return new SimpleDateFormat("MMddyyyyHHmm");
                }
                return null;
            }
        }
        if (string.length() > 9) {
            if (h.a(stringArray, "ddMMMyyyyHHmmss")) {
                return new SimpleDateFormat("ddMMMyyyyHHmmss");
            }
            if (h.a(stringArray, "yyyyMMMddHHmmss")) {
                return new SimpleDateFormat("yyyyMMMddHHmmss");
            }
            if (h.a(stringArray, "MMMddyyyyHHmmss")) {
                return new SimpleDateFormat("MMMddyyyyHHmmss");
            }
            if (h.a(stringArray, "ddMMMyyHHmmss")) {
                return new SimpleDateFormat("ddMMMyyHHmmss");
            }
            if (h.a(stringArray, "yyMMMddHHmmss")) {
                return new SimpleDateFormat("yyMMMddHHmmss");
            }
            if (h.a(stringArray, "MMMddyyHHmmss")) {
                return new SimpleDateFormat("MMMddyyHHmmss");
            }
            if (h.a(stringArray, "ddMMMyyyyHHmmssSSS")) {
                return new SimpleDateFormat("ddMMMyyyyHHmmssSSS");
            }
            if (h.a(stringArray, "yyyyMMMddHHmmssSSS")) {
                return new SimpleDateFormat("yyyyMMMddHHmmssSSS");
            }
            if (h.a(stringArray, "MMMddyyyyHHmmssSSS")) {
                return new SimpleDateFormat("MMMddyyyyHHmmssSSS");
            }
            if (h.a(stringArray, "ddMMMyyHHmmssSSS")) {
                return new SimpleDateFormat("ddMMMyyHHmmssSSS");
            }
            if (h.a(stringArray, "yyMMMddHHmmssSSS")) {
                return new SimpleDateFormat("yyMMMddHHmmssSSS");
            }
            if (h.a(stringArray, "MMMddyyHHmmssSSS")) {
                return new SimpleDateFormat("MMMddyyHHmmssSSS");
            }
            return null;
        }
        return null;
    }
}

