/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.databean.RowFormatSource;
import com.motivewave.platform.databean.TableColumnInfo;
import com.motivewave.platform.ui.table.af;
import com.motivewave.platform.ui.table.o;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;

public class TableConfig {
    private List columns = Collections.synchronizedList(new ArrayList());
    private Map label2Column = Collections.synchronizedMap(new HashMap());
    private int defaultSortColumn = 0;
    private boolean defaultSortAscending = true;
    private boolean defaultSorted = true;
    private int totalPadding = 0;
    private boolean bindWidth = true;

    public TableConfig() {
    }

    public TableConfig(List list) {
        this(list.toArray(new TableColumnInfo[0]));
    }

    public TableConfig(List list, TableColumnInfo tableColumnInfo, boolean bl2) {
        this(list.toArray(new TableColumnInfo[0]), tableColumnInfo, bl2);
    }

    public TableConfig(TableColumnInfo ... tableColumnInfoArray) {
        this(tableColumnInfoArray, null, true);
    }

    public TableConfig(TableColumnInfo[] tableColumnInfoArray, TableColumnInfo tableColumnInfo, boolean bl2) {
        int n2 = -1;
        for (int i2 = 0; i2 < tableColumnInfoArray.length; ++i2) {
            TableColumnInfo tableColumnInfo2 = tableColumnInfoArray[i2];
            if (tableColumnInfo2 == null) continue;
            this.add(tableColumnInfo2);
            if (tableColumnInfo == null || !h.a((Object)tableColumnInfo2, (Object)tableColumnInfo)) continue;
            n2 = i2;
        }
        if (n2 >= 0) {
            this.setDefaultSortColumn(n2);
            this.setDefaultSortAscending(bl2);
        }
    }

    public List toVisibleCols() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (TableColumnInfo tableColumnInfo : this.columns) {
            if (!tableColumnInfo.isVisible()) continue;
            arrayList.add(tableColumnInfo.toColumnInfo());
        }
        return arrayList;
    }

    public af toTableSettings() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (TableColumnInfo tableColumnInfo : this.columns) {
            if (!tableColumnInfo.isVisible()) continue;
            arrayList.add(tableColumnInfo.toColumnInfo());
        }
        af af2 = new af(arrayList);
        if (this.defaultSorted) {
            af2.a(this.defaultSortAscending);
            af2.a(this.getDefaultSortColumnId());
        }
        af2.a(1);
        return af2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibleColumns(List list) {
        List list2 = this.columns;
        synchronized (list2) {
            for (TableColumnInfo tableColumnInfo : this.columns) {
                tableColumnInfo.setVisible(false);
            }
        }
        for (Object object : list) {
            TableColumnInfo tableColumnInfo;
            tableColumnInfo = (TableColumnInfo)this.label2Column.get(((TableColumnInfo)object).getLabel());
            if (tableColumnInfo == null) {
                h.a.warning("TableConfig::setVisibleColumns() column not found: " + ((TableColumnInfo)object).getLabel());
                continue;
            }
            tableColumnInfo.setVisible(true);
            tableColumnInfo.setWidth(((TableColumnInfo)object).getWidth());
        }
    }

    public void configure(TableView tableView) {
        this.configure(tableView, null);
    }

    public void configure(TableView tableView, RowFormatSource rowFormatSource) {
        TableColumn tableColumn;
        ArrayList arrayList = new ArrayList(this.columns);
        ArrayList<TableColumn> arrayList2 = new ArrayList<TableColumn>();
        double d2 = 0.0;
        for (TableColumnInfo tableColumnInfo : arrayList) {
            d2 += (double)tableColumnInfo.getWidth();
        }
        d2 += tableView.isTableMenuButtonVisible() ? 8.0 : 24.0;
        d2 += (double)this.totalPadding;
        for (TableColumnInfo tableColumnInfo : arrayList) {
            tableColumn = tableColumnInfo.getCellFactory().createColumn(rowFormatSource);
            if (tableColumnInfo.isVisible() && this.bindWidth) {
                tableColumn.prefWidthProperty().bind((ObservableValue)tableView.widthProperty().multiply((double)tableColumnInfo.getWidth() / d2));
            }
            arrayList2.add(tableColumn);
        }
        for (TableColumnInfo tableColumnInfo : tableView.getColumns()) {
            tableColumn = (TableColumn)tableColumnInfo;
            tableColumn.setUserData(null);
        }
        tableView.getColumns().setAll(arrayList2);
    }

    public void configure(TreeTableView treeTableView, RowFormatSource rowFormatSource) {
        ArrayList arrayList = new ArrayList(this.columns);
        ArrayList<TreeTableColumn> arrayList2 = new ArrayList<TreeTableColumn>();
        double d2 = 0.0;
        for (TableColumnInfo tableColumnInfo : arrayList) {
            if (!tableColumnInfo.isVisible()) continue;
            d2 += (double)tableColumnInfo.getWidth();
        }
        d2 += treeTableView.isTableMenuButtonVisible() ? 8.0 : 24.0;
        d2 += (double)this.totalPadding;
        for (TableColumnInfo tableColumnInfo : arrayList) {
            TreeTableColumn treeTableColumn = tableColumnInfo.getCellFactory().createTreeColumn(rowFormatSource);
            if (tableColumnInfo.isVisible() && this.bindWidth) {
                treeTableColumn.prefWidthProperty().bind((ObservableValue)treeTableView.widthProperty().multiply((double)tableColumnInfo.getWidth() / d2));
            }
            arrayList2.add(treeTableColumn);
        }
        treeTableView.getColumns().setAll(arrayList2);
    }

    public void setBindWidth(boolean bl2) {
        this.bindWidth = bl2;
    }

    public void configureSort(TableView tableView) {
        if (!this.isDefaultSorted()) {
            return;
        }
        int n2 = this.getDefaultSortColumn();
        if (n2 >= tableView.getColumns().size()) {
            n2 = 0;
        }
        if (n2 < 0) {
            return;
        }
        TableColumn tableColumn = (TableColumn)tableView.getColumns().get(n2);
        tableView.getSortOrder().setAll(new Object[]{tableColumn});
        tableColumn.setSortType(this.isDefaultSortAscending() ? TableColumn.SortType.ASCENDING : TableColumn.SortType.DESCENDING);
        tableColumn.setSortable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TableColumnInfo ... tableColumnInfoArray) {
        for (TableColumnInfo tableColumnInfo : tableColumnInfoArray) {
            if (tableColumnInfo == null) continue;
            tableColumnInfo = tableColumnInfo.clone();
            Object object = this.columns;
            synchronized (object) {
                if (!this.columns.contains(tableColumnInfo)) {
                    this.columns.add(tableColumnInfo);
                }
            }
            object = this.label2Column;
            synchronized (object) {
                this.label2Column.put(tableColumnInfo.getLabel(), tableColumnInfo);
            }
        }
    }

    public List getColumns() {
        return this.columns;
    }

    public void setDefaultSort(int n2, boolean bl2) {
        this.defaultSortColumn = n2;
        this.defaultSortAscending = bl2;
        this.defaultSorted = true;
    }

    public int getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    public void setDefaultSortColumn(int n2) {
        this.defaultSortColumn = n2;
    }

    public String getDefaultSortColumnId() {
        if (this.defaultSortColumn < 0 || this.defaultSortColumn >= this.columns.size()) {
            return "";
        }
        return ((TableColumnInfo)this.columns.get(this.defaultSortColumn)).getProperty();
    }

    public boolean isDefaultSortAscending() {
        return this.defaultSortAscending;
    }

    public void setDefaultSortAscending(boolean bl2) {
        this.defaultSortAscending = bl2;
    }

    public boolean isDefaultSorted() {
        return this.defaultSorted;
    }

    public void setDefaultSorted(boolean bl2) {
        this.defaultSorted = bl2;
    }

    public void setTotalPadding(int n2) {
        this.totalPadding = n2;
    }

    public int getTotalPadding() {
        return this.totalPadding;
    }
}

