/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import bo.ap;
import bo.at;
import com.motivewave.common.h;
import com.motivewave.common.util.an;
import com.motivewave.common.util.g;
import com.motivewave.common.util.j;
import com.motivewave.platform.common.Enums$BackTestType;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.af;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.w;
import com.motivewave.platform.databean.BTExecutionReport;
import com.motivewave.platform.databean.DataSettings;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.WatchLists;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.ui.strategy_analysis.ai;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class StrategyAnalysis
extends ObservableBean
implements w {
    private String name;
    private String config;
    private long lastModified;
    private Study strategy;
    private at model;
    private ai optimizeSettings = new ai();
    private List instruments = new ArrayList();
    private DataSettings dataSettings = new DataSettings();
    private List backTestReports = new ArrayList();
    private List optimizeReports = new ArrayList();
    private List walkForwardReports = new ArrayList();
    private float initialAccountValue = 100000.0f;
    private int slippage = 0;
    private boolean fillOnBidAsk = bs.r(null);
    private boolean includeCommission = false;
    private boolean modified = false;
    private Enums$BackTestType type = Enums$BackTestType.BACKTEST;
    private static g loadedAnalyses = new g();
    private static an untitledAnalyses = new an();

    public static StrategyAnalysis load(String string) {
        File file = StrategyAnalysis.getFile(string);
        if (file == null || !file.exists()) {
            return null;
        }
        for (StrategyAnalysis strategyAnalysis : loadedAnalyses.a()) {
            if (!h.a((Object)strategyAnalysis.getName(), (Object)string)) continue;
            return strategyAnalysis;
        }
        StrategyAnalysis strategyAnalysis = new StrategyAnalysis(string, file.lastModified(), h.c(file));
        loadedAnalyses.a((Object)strategyAnalysis);
        return strategyAnalysis;
    }

    private static File getDir() {
        return new File(Workspace.findDir("strategy_analysis"), "strategy_analysis");
    }

    public static void remove(String string) {
        File file = new File(StrategyAnalysis.getDir(), string + ".json");
        file.delete();
        for (StrategyAnalysis strategyAnalysis : loadedAnalyses.a()) {
            if (!h.a((Object)strategyAnalysis.getName(), (Object)string)) continue;
            loadedAnalyses.a((Object)strategyAnalysis);
        }
    }

    public static void rename(String string, String string2) {
        if (h.a((Object)string, (Object)string2)) {
            return;
        }
        StrategyAnalysis.getFile(string).renameTo(StrategyAnalysis.getFile(string2));
        for (StrategyAnalysis strategyAnalysis : loadedAnalyses.a()) {
            if (!h.a((Object)strategyAnalysis.getName(), (Object)string)) continue;
            strategyAnalysis.setName(string2);
        }
    }

    public static List getUntitled() {
        return untitledAnalyses.a();
    }

    public static void registerUntitled(StrategyAnalysis strategyAnalysis) {
        if (strategyAnalysis == null || !h.g(strategyAnalysis.getName())) {
            return;
        }
        if (untitledAnalyses.a(strategyAnalysis)) {
            return;
        }
        untitledAnalyses.a(strategyAnalysis);
    }

    public static void discardUntitled(StrategyAnalysis strategyAnalysis) {
        if (strategyAnalysis == null) {
            return;
        }
        untitledAnalyses.b(strategyAnalysis);
    }

    private static File getFile(String string) {
        return new File(StrategyAnalysis.getDir(), string + ".json");
    }

    public static List getNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = StrategyAnalysis.getDir();
        if (file == null || !file.exists()) {
            return arrayList;
        }
        for (File file2 : StrategyAnalysis.getDir().listFiles()) {
            if (file2.isDirectory() || !file2.getName().toUpperCase().endsWith(".JSON")) continue;
            arrayList.add(file2.getName().substring(0, h.b(file2.getName(), ".JSON")));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List getModified() {
        ArrayList<StrategyAnalysis> arrayList = new ArrayList<StrategyAnalysis>();
        for (StrategyAnalysis strategyAnalysis : loadedAnalyses.a()) {
            if (!strategyAnalysis.isModified()) continue;
            arrayList.add(strategyAnalysis);
        }
        return arrayList;
    }

    public StrategyAnalysis() {
    }

    public StrategyAnalysis(String string, long l2, String string2) {
        this.name = string;
        this.lastModified = l2;
        this.config = string2;
        if (com.motivewave.common.util.w.a(this.config)) {
            this.b(this.config);
        }
    }

    @Override
    public String format(String string) {
        if (h.g(string)) {
            return "";
        }
        if (string.equals("name")) {
            return this.getName();
        }
        if (string.equals("lastModified")) {
            return ab.h(this.getLastModified(), b.b());
        }
        return super.format(string);
    }

    public boolean isModified() {
        return this.modified || h.g(this.name);
    }

    public void setModified() {
        this.modified = true;
        this.notify("modified", this.modified, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (h.a((Object)string, (Object)this.name)) {
            return;
        }
        this.modified = true;
        this.name = string;
        this.notify("name", this.name, this.name);
    }

    public String getUntitledName() {
        if (!h.g(this.name)) {
            return this.name;
        }
        if (this.strategy == null) {
            return "";
        }
        return this.strategy.getLabel();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long l2) {
        this.lastModified = l2;
    }

    public at getModel() {
        return this.model;
    }

    public void setModel(at at2) {
        if (h.a((Object)this.model, (Object)at2)) {
            return;
        }
        this.modified = true;
        this.model = at2;
        this.notify("model", this.model, this.model);
    }

    public ai getOptimizeSettings() {
        return this.optimizeSettings;
    }

    public void setOptimizeSettings(ai ai2) {
        if (h.a((Object)this.optimizeSettings, (Object)ai2)) {
            return;
        }
        this.optimizeSettings = ai2;
        this.setModified();
    }

    public Study getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Study study) {
        if (h.a((Object)study, (Object)this.strategy)) {
            return;
        }
        this.strategy = study;
        this.setModified();
    }

    public List getInstruments() {
        return this.instruments;
    }

    public void setInstruments(List list) {
        this.instruments = list;
        this.setModified();
    }

    public DataSettings getDataSettings() {
        return this.dataSettings;
    }

    public List getBackTestReports() {
        return this.backTestReports;
    }

    public void setBackTestReports(List list) {
        this.backTestReports = list;
        this.setModified();
    }

    public List getOptimizeReports() {
        return this.optimizeReports;
    }

    public void setOptimizeReports(List list) {
        this.optimizeReports = list;
        this.setModified();
    }

    public List getWalkForwardReports() {
        return this.walkForwardReports;
    }

    public void setWalkForwardReports(List list) {
        this.walkForwardReports = list;
        this.setModified();
    }

    public void setInitialAccountValue(float f2) {
        this.initialAccountValue = f2;
    }

    public float getInitialAccountValue() {
        return this.initialAccountValue;
    }

    public void setSlippage(int n2) {
        this.slippage = n2;
    }

    public int getSlippage() {
        return this.slippage;
    }

    public void setFillOnBidAsk(boolean bl2) {
        this.fillOnBidAsk = bl2;
    }

    public boolean isFillOnBidAsk() {
        return this.fillOnBidAsk;
    }

    public void setIncludeCommission(boolean bl2) {
        this.includeCommission = bl2;
    }

    public boolean isIncludeCommission() {
        return this.includeCommission;
    }

    public void setType(Enums$BackTestType enums$BackTestType) {
        if (enums$BackTestType == this.type) {
            return;
        }
        this.setModified();
        this.type = enums$BackTestType;
        this.notify("type", (Object)this.type, (Object)this.type);
    }

    public Enums$BackTestType getType() {
        return this.type;
    }

    public void update(StrategyAnalysis strategyAnalysis) {
        this.setName(strategyAnalysis.name);
        this.strategy = strategyAnalysis.strategy;
        this.setType(strategyAnalysis.type);
        this.setModel(strategyAnalysis.model);
        this.optimizeSettings = strategyAnalysis.optimizeSettings;
        this.instruments = new ArrayList(strategyAnalysis.instruments);
        this.dataSettings = strategyAnalysis.dataSettings.clone();
        this.backTestReports = new ArrayList(strategyAnalysis.backTestReports);
        this.optimizeReports = new ArrayList(strategyAnalysis.optimizeReports);
        this.walkForwardReports = new ArrayList(strategyAnalysis.walkForwardReports);
        this.initialAccountValue = strategyAnalysis.initialAccountValue;
        this.slippage = strategyAnalysis.slippage;
        this.fillOnBidAsk = strategyAnalysis.fillOnBidAsk;
        this.includeCommission = strategyAnalysis.includeCommission;
        this.setModified();
    }

    @Override
    public StrategyAnalysis clone() {
        try {
            StrategyAnalysis strategyAnalysis = (StrategyAnalysis)super.clone();
            strategyAnalysis.strategy = this.strategy.clone();
            strategyAnalysis.dataSettings = this.dataSettings.clone();
            strategyAnalysis.model = this.model.a();
            strategyAnalysis.optimizeSettings = this.optimizeSettings.a();
            strategyAnalysis.instruments = new ArrayList(this.instruments);
            strategyAnalysis.backTestReports = new ArrayList();
            strategyAnalysis.dataSettings = this.dataSettings.clone();
            for (BTExecutionReport bTExecutionReport : this.backTestReports) {
                strategyAnalysis.backTestReports.add(bTExecutionReport.clone());
            }
            strategyAnalysis.optimizeReports = new ArrayList();
            for (BTExecutionReport bTExecutionReport : this.optimizeReports) {
                strategyAnalysis.optimizeReports.add(bTExecutionReport.clone());
            }
            strategyAnalysis.walkForwardReports = new ArrayList();
            for (BTExecutionReport bTExecutionReport : this.walkForwardReports) {
                strategyAnalysis.walkForwardReports.add(bTExecutionReport.clone());
            }
            return strategyAnalysis;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void save() {
        if (h.g(this.name)) {
            h.a.severe("StrategyAnalysis::update() name is null!");
            return;
        }
        this.lastModified = bs.a();
        this.config = this.toJSON();
        File file = StrategyAnalysis.getDir();
        file.mkdirs();
        h.a(StrategyAnalysis.getFile(this.name), this.config);
        this.modified = false;
        this.notify("modified", true, false);
        StrategyAnalysis.discardUntitled(this);
    }

    @Override
    public List getNVPs() {
        if (this.model == null) {
            return new ArrayList();
        }
        HashMap hashMap = new HashMap();
        this.model.b(hashMap);
        Object object = h.b(new String[]{this.a("type", (Object)this.type), this.a("acctValue", this.initialAccountValue), this.a("fillOnBidAsk", this.fillOnBidAsk), this.a("includeCommission", this.includeCommission), this.a("slippage", this.slippage)});
        object.add(this.a("instruments", (Collection)this.instruments));
        object.add(this.a("data", this.dataSettings));
        object.add(this.a("strategy", hashMap));
        object.add(this.a("optSettings", this.optimizeSettings));
        object.add(this.a("backtestReports", (Collection)this.backTestReports));
        object.add(this.a("optimizeReports", (Collection)this.optimizeReports));
        object.add(this.a("walkforwardReports", (Collection)this.walkForwardReports));
        return object;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        j j2;
        this.type = Enums$BackTestType.valueOf(jSONObject.str("type"));
        this.initialAccountValue = jSONObject.getFloat("acctValue");
        this.fillOnBidAsk = jSONObject.is("fillOnBidAsk");
        this.includeCommission = jSONObject.is("includeCommission");
        this.slippage = jSONObject.getInt("slippage");
        this.instruments = new ArrayList();
        for (Object object : jSONObject.getStringList("instruments")) {
            j2 = WatchLists.byName((String)object);
            if (j2 == null) {
                j2 = this.a((String)object);
            }
            if (j2 != null) {
                this.instruments.add(j2);
                continue;
            }
            h.a.warning("ScanInfo::fromJSON() unable to resolve instrument/watch list: " + (String)object);
        }
        this.dataSettings.fromJSON(jSONObject.obj("data"));
        this.model = at.a(jSONObject.obj("strategy").toMap());
        if (this.model == null) {
            return;
        }
        this.strategy = ap.a(this.model.a());
        this.optimizeSettings = new ai();
        this.optimizeSettings.fromJSON(jSONObject.obj("optSettings"));
        this.backTestReports.clear();
        for (Object object : jSONObject.getObjList("backtestReports")) {
            j2 = MWInstrument.get(((JSONObject)object).str("symbol"), ((JSONObject)object).str("exchange"));
            if (j2 == null) continue;
            try {
                this.backTestReports.add(new BTExecutionReport(this, (JSONObject)object));
            }
            catch (Exception exception) {
                h.a.severe("StrategyAnalysis::fromJSON() error loading back test report: " + String.valueOf(object));
                exception.printStackTrace();
            }
        }
        this.optimizeReports.clear();
        for (Object object : jSONObject.getObjList("optimizeReports")) {
            j2 = MWInstrument.get(((JSONObject)object).str("symbol"), ((JSONObject)object).str("exchange"));
            if (j2 == null) continue;
            try {
                this.optimizeReports.add(new BTExecutionReport(this, (JSONObject)object));
            }
            catch (Exception exception) {
                h.a.severe("StrategyAnalysis::fromJSON() error loading execution report: " + String.valueOf(object));
                exception.printStackTrace();
            }
        }
        this.walkForwardReports.clear();
        for (Object object : jSONObject.getObjList("walkforwardReports")) {
            j2 = MWInstrument.get(((JSONObject)object).str("symbol"), ((JSONObject)object).str("exchange"));
            if (j2 == null) continue;
            try {
                this.walkForwardReports.add(new BTExecutionReport(this, (JSONObject)object));
            }
            catch (Exception exception) {
                h.a.severe("StrategyAnalysis::fromJSON() error loading walk forward report: " + String.valueOf(object));
                exception.printStackTrace();
            }
        }
    }

    public String toString() {
        if (!h.g(this.name)) {
            return this.name;
        }
        return af.a("UNTITLED", new Object[0]) + " - " + this.getUntitledName();
    }
}

