/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.common.util.g;
import com.motivewave.common.util.w;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.databean.ConnectionID;
import com.motivewave.platform.databean.ConnectionInfo;
import com.motivewave.platform.databean.NonObservable;
import com.motivewave.platform.databean.PropertyBean;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.srvc.x;
import java.util.Collection;
import java.util.List;
import org.json.JSONObject;
import org.w3c.dom.Element;

public class ServiceInfo
implements w,
NonObservable,
PropertyBean {
    private ConnectionInfo primaryInfo;
    private ConnectionInfo realTimeInfo;
    private ConnectionInfo historicalInfo;
    private ConnectionInfo newsInfo;
    private g connections = new g();
    private String name;
    private boolean googleStocks = false;
    private String id = Long.toUnsignedString(System.currentTimeMillis(), 32);

    public ServiceInfo(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public ServiceInfo() {
    }

    public void updateFrom(ServiceInfo serviceInfo) {
        this.name = serviceInfo.name;
        this.googleStocks = serviceInfo.googleStocks;
        this.primaryInfo = serviceInfo.primaryInfo;
        this.realTimeInfo = serviceInfo.realTimeInfo;
        this.historicalInfo = serviceInfo.historicalInfo;
        this.newsInfo = serviceInfo.newsInfo;
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "name": {
                return this.getName();
            }
            case "service": {
                return this.getService();
            }
        }
        Object object = this.getProperty(string);
        return h.b(object);
    }

    public String getName() {
        if (!h.g(this.name)) {
            return this.name;
        }
        if (this.primaryInfo == null || this.primaryInfo.getDescriptor() == null) {
            return "";
        }
        return this.primaryInfo.getDescriptor().v();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getId() {
        return this.id;
    }

    public ConnectionID getConnectionID() {
        return ConnectionID.get(this.getName(), this.getId(), this.primaryInfo == null ? null : this.primaryInfo.getType());
    }

    public String getService() {
        if (this.primaryInfo == null || this.primaryInfo.getDescriptor() == null) {
            return "";
        }
        return this.primaryInfo.getDescriptor().v();
    }

    public Enums$ServiceType getType() {
        return this.primaryInfo == null ? null : this.primaryInfo.getType();
    }

    public ConnectionInfo getPrimaryInfo() {
        return this.primaryInfo;
    }

    public void setPrimaryInfo(ConnectionInfo connectionInfo) {
        this.primaryInfo = connectionInfo;
        if (connectionInfo == null) {
            return;
        }
        if (this.realTimeInfo == null) {
            this.realTimeInfo = connectionInfo;
        }
        if (this.historicalInfo == null) {
            this.historicalInfo = connectionInfo;
        }
        if (this.newsInfo == null && connectionInfo.getDescriptor().m()) {
            this.newsInfo = connectionInfo;
        }
    }

    public ConnectionInfo getRealTimeInfo() {
        return this.realTimeInfo;
    }

    public void setRealTimeInfo(ConnectionInfo connectionInfo) {
        this.realTimeInfo = connectionInfo;
    }

    public ConnectionInfo getHistoricalInfo() {
        return this.historicalInfo;
    }

    public void setHistoricalInfo(ConnectionInfo connectionInfo) {
        this.historicalInfo = connectionInfo;
    }

    public ConnectionInfo getNewsInfo() {
        return this.newsInfo;
    }

    public void setNewsInfo(ConnectionInfo connectionInfo) {
        this.newsInfo = connectionInfo;
    }

    public boolean isGoogleStocks() {
        return this.googleStocks;
    }

    public void setGoogleStocks(boolean bl2) {
        this.googleStocks = bl2;
    }

    @Override
    public List getNVPs() {
        List list;
        x x2;
        Object object;
        Object object2 = h.b(new String[]{this.b("name", this.getName()), this.b("id", this.getId()), this.a("googleStocks", this.googleStocks, false)});
        Object object3 = h.b(new String[0]);
        if (this.primaryInfo != null) {
            object = "BROKER";
            x2 = bs.a(this.primaryInfo.getType());
            if (this.realTimeInfo == this.primaryInfo || this.realTimeInfo == null) {
                object = (String)object + "|REALTIME";
            }
            if (this.historicalInfo == this.primaryInfo || this.historicalInfo == null) {
                object = (String)object + "|HISTORICAL";
            }
            if (x2.m() && (this.newsInfo == this.primaryInfo || this.newsInfo == null)) {
                object = (String)object + "|NEWS";
            }
            list = this.primaryInfo.getNVPs();
            list.add(this.a("services", (String)object));
            object3.add(this.a(list));
        }
        if (this.realTimeInfo != null && this.realTimeInfo != this.primaryInfo) {
            object = "REALTIME";
            x2 = bs.a(this.realTimeInfo.getType());
            if (this.historicalInfo == this.realTimeInfo) {
                object = (String)object + "|HISTORICAL";
            }
            if (x2.m() && this.newsInfo == this.realTimeInfo) {
                object = (String)object + "|NEWS";
            }
            list = this.realTimeInfo.getNVPs();
            list.add(this.a("services", (String)object));
            object3.add(this.a(list));
        }
        if (this.historicalInfo != null && !h.a((Object)this.historicalInfo, new Object[]{this.newsInfo, this.primaryInfo})) {
            object = "HISTORICAL";
            x2 = bs.a(this.historicalInfo.getType());
            if (x2.m() && this.newsInfo == this.historicalInfo) {
                object = (String)object + "|NEWS";
            }
            list = this.historicalInfo.getNVPs();
            list.add(this.a("services", (String)object));
            object3.add(this.a(list));
        }
        if (this.newsInfo != null && !h.a((Object)this.newsInfo, new Object[]{this.primaryInfo, this.realTimeInfo, this.historicalInfo}) && this.newsInfo.getDescriptor().m()) {
            object = this.newsInfo.getNVPs();
            object.add(this.a("services", "NEWS"));
            object3.add(this.a((Collection)object));
        }
        object2.add(this.a("connections", (Collection)object3));
        return object2;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        this.name = jSONObject.str("name");
        this.id = jSONObject.str("id");
        this.googleStocks = jSONObject.is("googleStocks", false);
        for (JSONObject jSONObject2 : jSONObject.getObjList("connections")) {
            String string;
            ConnectionInfo connectionInfo = new ConnectionInfo(jSONObject2);
            x x2 = connectionInfo.getDescriptor();
            if (x2 == null) {
                h.a.warning("ServiceInfo::fromJSON() descriptor not found: " + String.valueOf((Object)connectionInfo.getType()));
                continue;
            }
            if (this.primaryInfo == null) {
                this.setPrimaryInfo(connectionInfo);
            }
            if ((string = jSONObject2.str("services")).indexOf("BROKER") >= 0) {
                this.primaryInfo = connectionInfo;
            }
            if (string.indexOf("REALTIME") >= 0) {
                this.realTimeInfo = connectionInfo;
            }
            if (string.indexOf("HISTORICAL") >= 0) {
                this.historicalInfo = connectionInfo;
            }
            if (string.indexOf("NEWS") < 0 || !x2.m()) continue;
            this.newsInfo = connectionInfo;
        }
    }

    public boolean read(Element element) {
        List list;
        if (element.getNodeName().equals("broker")) {
            ConnectionInfo connectionInfo = new ConnectionInfo(Enums$ServiceType.read(com.motivewave.common.util.h.c("provider", element)), com.motivewave.common.util.h.c("username", element), com.motivewave.common.util.h.c("server", element), com.motivewave.common.util.h.b("port", element), com.motivewave.common.util.h.b("connectionType", element));
            String string = com.motivewave.common.util.h.c("password", element);
            if (!h.g(string)) {
                connectionInfo.setPassword(string);
            }
            this.primaryInfo = connectionInfo;
            this.realTimeInfo = connectionInfo;
            this.historicalInfo = connectionInfo;
            if (connectionInfo.getDescriptor().m()) {
                this.newsInfo = connectionInfo;
            }
            return true;
        }
        String string = element.getAttribute("googleStocks");
        if (!h.g(string)) {
            this.googleStocks = h.c((Object)string);
        }
        if (!h.g(string = element.getAttribute("name"))) {
            this.name = string;
        }
        if (!h.g(string = element.getAttribute("id"))) {
            this.id = string;
        }
        if (h.a((Collection)(list = com.motivewave.common.util.h.c("service", element)))) {
            h.a.warning("ServiceInfo::read() no services defined!");
            return false;
        }
        for (Element element2 : list) {
            ConnectionInfo connectionInfo = this.readInfo(element2);
            x x2 = bs.a(connectionInfo.getType());
            if (x2 == null) {
                h.a.warning("ServiceInfo::read() descriptor not found: " + String.valueOf((Object)connectionInfo.getType()));
                continue;
            }
            if (this.primaryInfo == null) {
                this.setPrimaryInfo(connectionInfo);
            }
            if (this.connections.c(connectionInfo)) {
                for (ConnectionInfo connectionInfo2 : this.connections.a()) {
                    if (!connectionInfo2.equals(connectionInfo)) continue;
                    connectionInfo = connectionInfo2;
                }
            } else {
                this.connections.a((Object)connectionInfo);
            }
            String string2 = element2.getAttribute("services");
            if (string2.indexOf("BROKER") >= 0) {
                this.primaryInfo = connectionInfo;
            }
            if (string2.indexOf("REALTIME") >= 0) {
                this.realTimeInfo = connectionInfo;
            }
            if (string2.indexOf("HISTORICAL") >= 0) {
                this.historicalInfo = connectionInfo;
            }
            if (string2.indexOf("NEWS") < 0 || !x2.m()) continue;
            this.newsInfo = connectionInfo;
        }
        return true;
    }

    private ConnectionInfo readInfo(Element element) {
        String string;
        ConnectionInfo connectionInfo = new ConnectionInfo(Enums$ServiceType.read(com.motivewave.common.util.h.b("type", element)), com.motivewave.common.util.h.b("username", element), com.motivewave.common.util.h.b("server", element), com.motivewave.common.util.h.b("port", element), com.motivewave.common.util.h.b("connectionType", element));
        String string2 = com.motivewave.common.util.h.b("clientId", element);
        if (!h.g(string2)) {
            connectionInfo.setClientId(h.b(string2));
        }
        if (!h.g(string = com.motivewave.common.util.h.b("password", element))) {
            connectionInfo.setPassword(string);
        }
        return connectionInfo;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            ServiceInfo serviceInfo = (ServiceInfo)object;
            if (!h.a((Object)this.getName(), (Object)serviceInfo.getName())) {
                return false;
            }
            if (this.googleStocks != serviceInfo.googleStocks) {
                return false;
            }
            if (!h.a((Object)this.primaryInfo, (Object)serviceInfo.primaryInfo)) {
                return false;
            }
            if (!h.a((Object)this.realTimeInfo, (Object)serviceInfo.realTimeInfo)) {
                return false;
            }
            if (!h.a((Object)this.historicalInfo, (Object)serviceInfo.historicalInfo)) {
                return false;
            }
            return h.a((Object)this.newsInfo, (Object)serviceInfo.newsInfo);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ServiceInfo clone() {
        try {
            ServiceInfo serviceInfo = (ServiceInfo)super.clone();
            serviceInfo.primaryInfo = this.primaryInfo == null ? null : this.primaryInfo.clone();
            serviceInfo.realTimeInfo = this.realTimeInfo == null ? null : this.realTimeInfo.clone();
            serviceInfo.historicalInfo = this.historicalInfo == null ? null : this.historicalInfo.clone();
            serviceInfo.newsInfo = this.newsInfo == null ? null : this.newsInfo.clone();
            serviceInfo.id = this.id;
            return serviceInfo;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

