/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import bo.ap;
import bo.at;
import cf.fg;
import com.motivewave.common.h;
import com.motivewave.common.util.aa;
import com.motivewave.common.util.an;
import com.motivewave.common.util.g;
import com.motivewave.platform.common.Enums$ElliottWaveScanPattern;
import com.motivewave.platform.common.Enums$EvalMethod;
import com.motivewave.platform.common.Enums$HarmonicScanPattern;
import com.motivewave.platform.common.Enums$ScanType;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.w;
import com.motivewave.platform.databean.InstrumentListener;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.StudyCondition;
import com.motivewave.platform.databean.UpdateListener;
import com.motivewave.platform.databean.WatchLists;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.by;
import com.motivewave.platform.databean.bz;
import com.motivewave.platform.sdk.study.Study;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ScanInfo
extends ObservableBean
implements w,
InstrumentListener {
    private static g allScans = new g();
    private int id;
    private Enums$ScanType type = Enums$ScanType.ELLIOTT_WAVE;
    private String name;
    private String config;
    private long modified;
    private List scanList = new ArrayList();
    private int minBars = 250;
    private int maxBars = 250;
    private boolean extendedData = false;
    private boolean useAllData = false;
    private boolean decomposeAll = false;
    private int decomposeLevels = 2;
    private int lookbackBars = 0;
    private List barSizes = new ArrayList();
    private Enums$ElliottWaveScanPattern ewPattern = Enums$ElliottWaveScanPattern.WAVE2;
    private Enums$HarmonicScanPattern gartleyPattern = Enums$HarmonicScanPattern.XABCD;
    private Enums$EvalMethod evalMethod = Enums$EvalMethod.ALL;
    private List studies = new ArrayList();
    private List conditions = new ArrayList();
    private static an listeners = new an();

    public ScanInfo() {
        this(-1);
    }

    public ScanInfo(String string) {
        this(-1);
        this.name = string;
    }

    public ScanInfo(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public ScanInfo(int n2) {
        this.id = n2;
    }

    @Override
    public String format(String string) {
        if (h.g(string)) {
            return "";
        }
        if (string.equals("name")) {
            return this.getName();
        }
        if (string.equals("type")) {
            return this.getType().toString();
        }
        if (string.equals("modified")) {
            return ab.h(this.getModified(), b.b());
        }
        return super.format(string);
    }

    public boolean isSupported() {
        if (!ai.s()) {
            return false;
        }
        if (this.getType() == Enums$ScanType.ELLIOTT_WAVE && !ai.t()) {
            return false;
        }
        if (this.getType() == Enums$ScanType.HARMONIC && !ai.y()) {
            return false;
        }
        return this.getType() != Enums$ScanType.STUDY || ai.z();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public int getLookback() {
        return this.lookbackBars;
    }

    public void setLookback(int n2) {
        this.lookbackBars = n2;
    }

    public boolean isNew() {
        return this.id == -1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Enums$ScanType getType() {
        return this.type;
    }

    public void setType(Enums$ScanType enums$ScanType) {
        this.type = enums$ScanType;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String string) {
        this.config = string;
        if (com.motivewave.common.util.w.a(string)) {
            this.b(string);
        }
    }

    public long getModified() {
        return this.modified;
    }

    public void setModified(long l2) {
        this.modified = l2;
    }

    public List getScanList() {
        return this.scanList;
    }

    public void setScanList(List list) {
        this.scanList = list;
    }

    public int getMinBars() {
        return this.minBars;
    }

    public void setMinBars(int n2) {
        this.minBars = n2;
    }

    public int getMaxBars() {
        return this.maxBars;
    }

    public void setMaxBars(int n2) {
        this.maxBars = n2;
    }

    public boolean isExtendedData() {
        return this.extendedData;
    }

    public void setExtendedData(boolean bl2) {
        this.extendedData = bl2;
    }

    public boolean isUseAllData() {
        return this.useAllData;
    }

    public void setUseAllData(boolean bl2) {
        this.useAllData = bl2;
    }

    public boolean isDecomposeAll() {
        return this.decomposeAll;
    }

    public void setDecomposeAll(boolean bl2) {
        this.decomposeAll = bl2;
    }

    public int getDecomposeLevels() {
        return this.decomposeLevels;
    }

    public void setDecomposeLevels(int n2) {
        this.decomposeLevels = n2;
    }

    public List getBarSizes() {
        return this.barSizes;
    }

    public void setBarSizes(List list) {
        this.barSizes = new ArrayList(list);
    }

    public Enums$ElliottWaveScanPattern getEWPattern() {
        return this.ewPattern;
    }

    public void setEWPattern(Enums$ElliottWaveScanPattern enums$ElliottWaveScanPattern) {
        this.ewPattern = enums$ElliottWaveScanPattern;
    }

    public Enums$HarmonicScanPattern getGartleyPattern() {
        return this.gartleyPattern;
    }

    public void setGartleyPattern(Enums$HarmonicScanPattern enums$HarmonicScanPattern) {
        this.gartleyPattern = enums$HarmonicScanPattern;
    }

    public Enums$EvalMethod getEvalMethod() {
        return this.evalMethod;
    }

    public void setEvalMethod(Enums$EvalMethod enums$EvalMethod) {
        this.evalMethod = enums$EvalMethod;
    }

    public List getStudies() {
        return this.studies;
    }

    public void setStudies(List list) {
        this.studies = list;
    }

    public List getConditions() {
        return this.conditions;
    }

    public void setConditions(List list) {
        this.conditions = list;
    }

    @Override
    public List getNVPs() {
        Object object = h.b(new String[]{this.b("name", this.name), this.a("type", (Object)this.type)});
        object.add(this.a("scanList", (Collection)this.scanList));
        object.add(this.a("barSizes", (Collection)this.barSizes));
        object.add(this.a("data", this.a(this.a("min", this.minBars, 250), this.a("max", this.maxBars, 250), this.a("ext", this.extendedData, false), this.a("useAll", this.useAllData, false))));
        if (this.type == Enums$ScanType.ELLIOTT_WAVE) {
            object.add(this.a("pattern", (Object)this.ewPattern));
            object.add(this.a("decompose", this.a(new String[]{this.a("all", this.decomposeAll, false), this.a("levels", this.decomposeLevels)})));
        } else if (this.type == Enums$ScanType.HARMONIC) {
            object.add(this.a("pattern", (Object)this.gartleyPattern));
        } else if (this.type == Enums$ScanType.STUDY) {
            h.a((Collection)object, (Object[])new String[]{this.a("eval", (Object)this.evalMethod), this.a("lookback", this.lookbackBars)});
            Object object2 = h.b(new String[0]);
            for (fg fg2 : this.studies) {
                object2.add(com.motivewave.common.util.w.a(fg2.a().d()));
            }
            object.add(this.a("studies", (Collection)object2));
            object.add(this.a("conditions", (Collection)this.conditions));
        }
        System.err.println("SCANINFO: " + this.a((Collection)object));
        return object;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        this.name = jSONObject.str("name");
        if (h.a((Object)jSONObject.str("type"), (Object)"GARTLEY")) {
            this.type = Enums$ScanType.HARMONIC;
        } else {
            try {
                this.type = Enums$ScanType.valueOf(jSONObject.str("type"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.scanList = new ArrayList();
        for (Object object : jSONObject.getStringList("scanList")) {
            aa aa2 = WatchLists.byName((String)object);
            if (aa2 == null) {
                aa2 = WatchLists.byId((String)object);
            }
            if (aa2 == null) {
                aa2 = MWInstrument.resolveExpiredContract(this.a((String)object));
            }
            if (aa2 != null) {
                this.scanList.add(aa2);
                continue;
            }
            h.a.warning("ScanInfo::fromJSON() unable to resolve instrument/watch list: " + (String)object);
        }
        this.barSizes.clear();
        for (Object object : jSONObject.getStringList("barSizes")) {
            this.barSizes.add(w.a((String)object));
        }
        JSONObject jSONObject2 = jSONObject.obj("data");
        if (jSONObject2 != null) {
            this.minBars = jSONObject2.getInt("min", 250);
            this.maxBars = jSONObject2.getInt("max", 250);
            this.extendedData = jSONObject2.is("ext", false);
            this.useAllData = jSONObject2.is("useAll", false);
        }
        if (this.type == Enums$ScanType.ELLIOTT_WAVE) {
            Object object;
            this.ewPattern = Enums$ElliottWaveScanPattern.valueOf(jSONObject.str("pattern"));
            object = jSONObject.obj("decompose");
            this.decomposeLevels = ((JSONObject)object).getInt("levels");
            this.decomposeAll = ((JSONObject)object).is("all", false);
        } else if (this.getType() == Enums$ScanType.HARMONIC) {
            this.gartleyPattern = Enums$HarmonicScanPattern.valueOf(jSONObject.str("pattern"));
        } else if (this.getType() == Enums$ScanType.STUDY) {
            aa aa3;
            this.evalMethod = Enums$EvalMethod.valueOf(jSONObject.str("eval"));
            this.lookbackBars = jSONObject.getInt("lookback");
            this.studies.clear();
            for (aa aa2 : jSONObject.getObjList("studies")) {
                aa3 = at.a(((JSONObject)aa2).toMap());
                if (aa3 == null) continue;
                Study study = ap.a(aa3.a());
                if (study == null) {
                    h.a.warning("ScanInfo::fromJSON() unable to create study: " + String.valueOf(aa3.a()));
                    continue;
                }
                this.studies.add(new fg(study, (at)aa3));
            }
            this.conditions.clear();
            for (aa aa2 : jSONObject.getObjList("conditions")) {
                aa3 = StudyCondition.fromJSON((JSONObject)aa2, this.studies);
                if (aa3 == null) continue;
                this.conditions.add(aa3);
            }
        }
    }

    public void update() {
        if (h.g(this.name)) {
            h.a.severe("ScanInfo::update() name is null!");
            return;
        }
        this.config = this.toJSON();
        ScanInfo._register(this);
        ScanInfo.notifyUpdated();
    }

    public void delete() {
        try {
            allScans.a((Object)this);
            ScanInfo.notifyUpdated();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public ScanInfo clone() {
        try {
            ScanInfo scanInfo = (ScanInfo)super.clone();
            scanInfo.studies = new ArrayList();
            if (!h.a((Collection)this.studies)) {
                for (aa aa2 : this.studies) {
                    scanInfo.studies.add(((fg)aa2).a());
                }
            }
            scanInfo.conditions = new ArrayList();
            if (!h.a((Collection)this.conditions)) {
                for (aa aa2 : this.conditions) {
                    scanInfo.conditions.add(((StudyCondition)aa2).clone());
                }
            }
            scanInfo.barSizes = new ArrayList(this.barSizes);
            scanInfo.scanList = new ArrayList(this.scanList);
            return scanInfo;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            ScanInfo scanInfo = (ScanInfo)object;
            if (scanInfo.type != this.type) {
                return false;
            }
            if (!h.a((Object)this.name, (Object)scanInfo.name)) {
                return false;
            }
            if (!h.c(this.scanList, scanInfo.scanList)) {
                return false;
            }
            if (this.minBars != scanInfo.minBars) {
                return false;
            }
            if (this.maxBars != scanInfo.maxBars) {
                return false;
            }
            if (this.extendedData != scanInfo.extendedData) {
                return false;
            }
            if (this.useAllData != scanInfo.useAllData) {
                return false;
            }
            if (this.decomposeAll != scanInfo.decomposeAll) {
                return false;
            }
            if (this.decomposeLevels != scanInfo.decomposeLevels) {
                return false;
            }
            if (h.c(this.barSizes, scanInfo.barSizes)) {
                return false;
            }
            if (this.ewPattern != scanInfo.ewPattern) {
                return false;
            }
            if (this.gartleyPattern != scanInfo.gartleyPattern) {
                return false;
            }
            if (this.evalMethod != scanInfo.evalMethod) {
                return false;
            }
            if (this.lookbackBars != scanInfo.lookbackBars) {
                return false;
            }
            if (!h.c(this.studies, scanInfo.studies)) {
                return false;
            }
            return h.c(this.conditions, scanInfo.conditions);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void addListener(UpdateListener updateListener) {
        listeners.a(updateListener);
    }

    public static void removeListener(UpdateListener updateListener) {
        listeners.b(updateListener);
    }

    private static void notifyUpdated() {
        for (UpdateListener updateListener : listeners.a()) {
            updateListener.updated();
        }
    }

    public static void read(File file) {
        allScans.b();
        String string = h.c(file);
        if (h.g(string)) {
            return;
        }
        try {
            ArrayList<ScanInfo> arrayList = new ArrayList<ScanInfo>();
            for (JSONObject jSONObject : new JSONArray(string).asObjList()) {
                arrayList.add(new ScanInfo(jSONObject));
            }
            allScans.d(arrayList);
            ScanInfo.notifyUpdated();
        }
        catch (Exception exception) {
            h.a.warning("ScanInfo::load() error reading scans: " + exception.getMessage() + " " + string);
            exception.printStackTrace();
        }
    }

    public static void read() {
        allScans.b();
        File file = Workspace.findFile("scans");
        if (file != null) {
            ScanInfo.read(file);
        }
        ScanInfo.notifyUpdated();
    }

    public static void saveAll() {
        h.c(new File(Workspace.findDir("scans"), "scans.json"), new by().b(ScanInfo.getAll()));
    }

    public static void saveAll(File file) {
        h.a(new File(file, "scans.json"), new bz().b(ScanInfo.getAll()));
    }

    public static void remove(ScanInfo scanInfo) {
        allScans.a((Object)scanInfo);
        scanInfo.delete();
        ScanInfo.notifyUpdated();
    }

    public static ScanInfo find(String string) {
        for (ScanInfo scanInfo : allScans.a()) {
            if (!h.a((Object)scanInfo.getName(), (Object)string) || !scanInfo.isSupported()) continue;
            return scanInfo;
        }
        return null;
    }

    public static ScanInfo find(int n2) {
        for (ScanInfo scanInfo : allScans.a()) {
            if (n2 != scanInfo.getId() || !scanInfo.isSupported()) continue;
            return scanInfo;
        }
        return null;
    }

    public static void register(ScanInfo scanInfo) {
        if (ScanInfo._register(scanInfo)) {
            ScanInfo.notifyUpdated();
        }
    }

    private static boolean _register(ScanInfo scanInfo) {
        ScanInfo scanInfo2 = null;
        for (ScanInfo scanInfo3 : allScans.a()) {
            if (scanInfo3 == scanInfo) {
                return false;
            }
            if (!h.a((Object)scanInfo3.getName(), (Object)scanInfo.getName())) continue;
            scanInfo2 = scanInfo3;
        }
        if (scanInfo2 != null) {
            allScans.a((Object)scanInfo2);
        }
        allScans.a((Object)scanInfo);
        return true;
    }

    public static List getAll() {
        ArrayList<ScanInfo> arrayList = new ArrayList<ScanInfo>();
        for (ScanInfo scanInfo : allScans.a()) {
            if (!scanInfo.isSupported() || h.g(scanInfo.getName())) continue;
            arrayList.add(scanInfo);
        }
        return arrayList;
    }

    public static List getNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ScanInfo scanInfo : allScans.a()) {
            if (scanInfo == null) continue;
            arrayList.add(scanInfo.getName());
        }
        return arrayList;
    }

    public static void clear() {
        allScans.b();
    }
}

