/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.common.util.aa;
import com.motivewave.common.util.w;
import com.motivewave.platform.common.Enums$ChartLink;
import com.motivewave.platform.common.Enums$ReplayData;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.service.bs;
import java.util.List;
import org.json.JSONObject;

public class ReplaySettings
implements aa,
w {
    public static final int MAX_TICK_BAR_SIZE = 1440;
    public static final int MAX_MINUTE_BAR_SIZE = 1440;
    private Enums$ReplayData sourceData = Enums$ReplayData.TICK;
    private BarSize sourceBarSize = BarSize.minute((int)15);
    private Enums.BarData barData;
    private boolean generateTicks = false;
    private boolean playTillPriceUpdate = true;
    private boolean realDelay = false;
    private double speedFactor = 1.0;
    private int tickDelay = 0;
    private int barDelay = 0;
    private Enums$ChartLink chartLink = Enums$ChartLink.ALL;
    private String accountId;
    private String existingAcctId;
    private boolean useExistingAccount = false;
    private String baseCurrency = null;
    private double cashBalance = 100000.0;
    private boolean includeCommission = true;
    private static int cAccountID = 1;

    public ReplaySettings(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public ReplaySettings() {
    }

    @Override
    public ReplaySettings clone() {
        try {
            return (ReplaySettings)super.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public List getNVPs() {
        Object object = h.b(new String[]{this.a("chartLink", (Object)this.chartLink, (Object)Enums$ChartLink.ALL), this.a("sourceData", (Object)this.sourceData, (Object)Enums$ReplayData.TICK), this.a("tickDelay", this.tickDelay, 0), this.a("generateTicks", this.generateTicks, false), this.a("realDelay", this.realDelay, false), this.a("playTillPriceUpdate", this.playTillPriceUpdate, true), this.a("speedFactor", this.speedFactor, 1.0), this.a("barDelay", this.barDelay, 0), this.b("baseCurrency", this.baseCurrency), this.a("cashBalance", this.cashBalance, 100000.0), this.a("includeCommissions", this.includeCommission, true), this.a("useEA", this.useExistingAccount, false), this.a("eAcctId", this.existingAcctId)});
        return object;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        try {
            this.chartLink = Enums$ChartLink.fromString(jSONObject.str("chartLink"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sourceData = Enums$ReplayData.valueOf(jSONObject.str("sourceData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tickDelay = jSONObject.getInt("tickDelay", 0);
        this.generateTicks = jSONObject.is("generateTicks", false);
        this.playTillPriceUpdate = jSONObject.is("playTillPriceUpdate", true);
        this.realDelay = jSONObject.is("realDelay", false);
        this.speedFactor = jSONObject.getDouble("speedFactor", 1.0);
        this.barDelay = jSONObject.getInt("barDelay", 0);
        this.baseCurrency = jSONObject.str("baseCurrency");
        this.cashBalance = jSONObject.getDouble("cashBalance", 100000.0);
        this.includeCommission = jSONObject.is("includeCommissions", true);
        this.useExistingAccount = jSONObject.is("useEA", false);
        this.existingAcctId = jSONObject.str("eAcctId");
    }

    public Enums$ReplayData getSourceData(BarSize barSize) {
        if (h.a((Object)barSize.getIntervalType(), new Object[]{Enums.IntervalType.SECOND, Enums.IntervalType.MILLISECOND}) && ai.x()) {
            return Enums$ReplayData.TICK;
        }
        int n2 = barSize.getIntervalMinutes();
        if (n2 > 1440) {
            return Enums$ReplayData.BAR;
        }
        if (n2 > 1440 && this.getSourceData() == Enums$ReplayData.TICK) {
            return Enums$ReplayData.MINUTE;
        }
        return this.getSourceData();
    }

    public Enums$ReplayData getSourceData() {
        if (this.sourceData == Enums$ReplayData.TICK && !ai.x()) {
            return Enums$ReplayData.MINUTE;
        }
        return this.sourceData;
    }

    public void setSourceData(Enums$ReplayData enums$ReplayData) {
        this.sourceData = enums$ReplayData;
    }

    public BarSize getSourceBarSize() {
        return this.sourceBarSize;
    }

    public void setSourceBarSize(BarSize barSize) {
        this.sourceBarSize = barSize;
    }

    public Enums.BarData getBarData() {
        return this.barData;
    }

    public void setBarData(Enums.BarData barData) {
        this.barData = barData;
    }

    public boolean isUseTickData() {
        return this.getSourceData() == Enums$ReplayData.TICK;
    }

    public int getTickDelay() {
        return this.tickDelay;
    }

    public void setTickDelay(int n2) {
        this.tickDelay = n2;
    }

    public int getBarDelay() {
        return this.barDelay;
    }

    public void setBarDelay(int n2) {
        this.barDelay = n2;
    }

    public boolean isGenerateTicks() {
        return this.generateTicks;
    }

    public void setGenerateTicks(boolean bl2) {
        this.generateTicks = bl2;
    }

    public boolean isRealDelay() {
        return this.realDelay && ai.x();
    }

    public void setRealDelay(boolean bl2) {
        this.realDelay = bl2;
    }

    public double getSpeedFactor() {
        return this.speedFactor;
    }

    public void setSpeedFactor(double d2) {
        this.speedFactor = d2;
    }

    public Enums$ChartLink getChartLink() {
        return this.chartLink;
    }

    public void setChartLink(Enums$ChartLink enums$ChartLink) {
        this.chartLink = enums$ChartLink;
    }

    public boolean isPlayTillPriceUpdate() {
        return this.playTillPriceUpdate;
    }

    public void setPlayTillPriceUpdate(boolean bl2) {
        this.playTillPriceUpdate = bl2;
    }

    public String getAccountId() {
        if (h.g(this.accountId)) {
            this.accountId = ReplaySettings.getNextReplayAcctID();
        }
        return this.accountId;
    }

    public String getExistingAcctId() {
        return this.existingAcctId;
    }

    public void setExistingAcctId(String string) {
        this.existingAcctId = string;
    }

    public boolean isUseExistingAccount() {
        return this.useExistingAccount;
    }

    public void setUseExistingAccount(boolean bl2) {
        this.useExistingAccount = bl2;
    }

    public static String getNextReplayAcctID() {
        String string = "REPLAY-" + cAccountID++;
        while (ReplaySettings.exists(string)) {
            string = "REPLAY-" + cAccountID++;
        }
        return string;
    }

    private static boolean exists(String string) {
        for (Account account : bs.v()) {
            if (!h.a((Object)account.getAccountName(), (Object)string)) continue;
            return true;
        }
        return false;
    }

    public String getBaseCurrency() {
        if (h.g(this.baseCurrency)) {
            String string = bs.b();
            if (h.g(string)) {
                return "USD";
            }
            return string;
        }
        return this.baseCurrency;
    }

    public void setBaseCurrency(String string) {
        this.baseCurrency = string;
    }

    public double getCashBalance() {
        return this.cashBalance;
    }

    public void setCashBalance(double d2) {
        this.cashBalance = d2;
    }

    public boolean isIncludeCommission() {
        return this.includeCommission;
    }

    public void setIncludeCommission(boolean bl2) {
        this.includeCommission = bl2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReplaySettings)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ReplaySettings replaySettings = (ReplaySettings)object;
        return replaySettings.getSourceData() == this.getSourceData() && replaySettings.tickDelay == this.tickDelay && replaySettings.generateTicks == this.generateTicks && replaySettings.realDelay == this.realDelay && replaySettings.speedFactor == this.speedFactor && replaySettings.barDelay == this.barDelay && replaySettings.chartLink == this.chartLink && h.a((Object)replaySettings.getBaseCurrency(), (Object)this.getBaseCurrency()) && replaySettings.cashBalance == this.cashBalance && replaySettings.includeCommission == this.includeCommission && replaySettings.useExistingAccount == this.useExistingAccount && h.a((Object)replaySettings.existingAcctId, (Object)this.existingAcctId);
    }
}

