/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.common.util.g;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.af;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.ConnectionID;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.PositionBase;
import com.motivewave.platform.databean.Positions;
import com.motivewave.platform.databean.Ticker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import o.c;

public class PositionSummary
extends PositionBase
implements PropertyChangeListener,
Comparable,
c {
    private double buyPnl = 0.0;
    private float buyPips = 0.0f;
    private float buyRoll = 0.0f;
    private float buyQuantity = 0.0f;
    private float buyPrice = 0.0f;
    private double sellPnl = 0.0;
    private float sellPips = 0.0f;
    private float sellRoll = 0.0f;
    private float sellQuantity = 0.0f;
    private float sellPrice = 0.0f;
    private ConnectionID connId;
    private float closeBuyPrice = 0.0f;
    private float closeSellPrice = 0.0f;
    private g positions = new g();
    private MWOrder netStopTrailOrder;
    private MWOrder netLimitOrder;

    public PositionSummary(Ticker ticker, String string, ConnectionID connectionID) {
        super(ticker);
        this.connId = connectionID;
        this.accountId = string;
        this.ticker.addPropertyChangeListener(this);
        OrderDirectory.addListener(this);
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        if (this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
        OrderDirectory.removeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.ticker == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (h.a(string, "bidPrice", "askPrice", "lastPrice", "avgPrice", "lastTimestamp", "high", "low", "pips", "spread", "roll", "open", "close")) {
            this.notify(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (!this.ignorePLUpdate(string)) {
            long l2 = System.currentTimeMillis() / 100L * 100L;
            float f2 = this.getCurrentPrice();
            if (l2 - this.lastPlUpdate < 100L) {
                int n2 = (int)((double)Math.abs(this.lastPlPrice - f2) / this.ticker.getTickSize());
                if (this.plUpdateCount < 2 || n2 > 2) {
                    ++this.plUpdateCount;
                    this.lastPlPrice = f2;
                    this.updatePnLPips();
                }
            } else {
                this.lastPlUpdate = l2;
                this.lastPlPrice = f2;
                this.plUpdateCount = 0;
                this.updatePnLPips();
            }
        }
        if (this.buyQuantity > 0.0f && string == "bidPrice") {
            float f3 = this.closeSellPrice;
            this.closeSellPrice = this.ticker.getBidPrice();
            this.notify("closeSellPrice", f3, this.closeSellPrice);
        }
        if (this.sellQuantity < 0.0f && string == "askPrice") {
            float f4 = this.closeBuyPrice;
            this.closeBuyPrice = this.ticker.getAskPrice();
            this.notify("closeBuyPrice", f4, this.closeBuyPrice);
        }
    }

    public ConnectionID getConnId() {
        return this.connId;
    }

    public String toString() {
        if (this.buyQuantity > 0.0f) {
            return this.ticker.getSymbolDisplay() + " " + this.format("buyQuantity") + "@" + this.format("buyPrice");
        }
        return this.ticker.getSymbolDisplay() + " " + this.format("sellQuantity") + "@" + this.format("sellPrice");
    }

    public int compareTo(PositionSummary positionSummary) {
        if (this == positionSummary) {
            return 0;
        }
        int n2 = this.ticker.getSymbolDisplay().compareTo(positionSummary.ticker.getSymbolDisplay());
        if (n2 != 0) {
            return n2;
        }
        if (!h.g(this.accountId) && !h.g(positionSummary.getAccountId())) {
            n2 = this.accountId.compareTo(positionSummary.accountId);
        }
        if (n2 != 0) {
            return n2;
        }
        if (this.buyQuantity == positionSummary.buyQuantity && this.sellQuantity == positionSummary.sellQuantity) {
            return 0;
        }
        if (this.buyQuantity != 0.0f && this.buyQuantity > positionSummary.buyQuantity) {
            return 1;
        }
        if (this.sellQuantity != 0.0f && this.sellQuantity > positionSummary.sellQuantity) {
            return 1;
        }
        return -1;
    }

    private String format1(float f2) {
        if (f2 == 0.0f) {
            return "";
        }
        return h.c((double)f2, 1);
    }

    @Override
    public String format(float f2) {
        MWInstrument mWInstrument = this.getInstrument();
        if (!mWInstrument.isValueValid(f2)) {
            return "";
        }
        return mWInstrument.formatValue(f2);
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "buyQuantity": {
                return ab.a(this.buyQuantity, this.getInstrument());
            }
            case "sellQuantity": {
                return ab.a(this.sellQuantity, this.getInstrument());
            }
            case "quantity": {
                return ab.a(this.getQuantity(), this.getInstrument());
            }
            case "netLimitOrderPL": {
                return ab.a(this.getNetLimitOrderPL());
            }
            case "netStopOrderPL": {
                return ab.a(this.getNetStopOrderPL());
            }
            case "pnl": {
                return ab.a(this.getPnl());
            }
            case "buyPnl": {
                return ab.a(this.getBuyPnl());
            }
            case "sellPnl": {
                return ab.a(this.getSellPnl());
            }
            case "netLimitPrice": {
                return this.formatPrice(this.getNetLimitPrice());
            }
            case "netStopTrailPrice": {
                return this.formatPrice(this.getNetStopTrailPrice());
            }
            case "buyPrice": {
                return this.formatPrice(this.getBuyPrice());
            }
            case "sellPrice": {
                return this.formatPrice(this.getSellPrice());
            }
            case "closeBuyPrice": {
                return this.formatPrice(this.getCloseBuyPrice());
            }
            case "closeSellPrice": {
                return this.formatPrice(this.getCloseSellPrice());
            }
            case "pips": {
                return this.format1(this.getPips());
            }
            case "buyPips": {
                return this.format1(this.getBuyPips());
            }
            case "sellPips": {
                return this.format1(this.getSellPips());
            }
            case "roll": {
                return h.c((double)(this.buyRoll + this.sellRoll), 2);
            }
            case "buyRoll": {
                return h.c((double)this.buyRoll, 2);
            }
            case "sellRoll": {
                return h.c((double)this.sellRoll, 2);
            }
            case "close": {
                return af.a("LBL_CLOSE", new Object[0]);
            }
            case "accountId": {
                return this.getAccountId();
            }
            case "accountName": {
                return this.getAccountName();
            }
            case "accountCurrency": {
                return this.getAccountCurrency();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "avgPrice": {
                float f2 = this.getAvgPrice();
                return f2 == 0.0f ? "" : this.ticker.format(f2);
            }
            case "lastTimestamp": {
                long l2 = this.ticker.getLastTimestamp();
                if (l2 == 0L) {
                    return "";
                }
                return ab.a(l2, b.b());
            }
        }
        return this.ticker.format(string);
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "askPrice": 
            case "bidPrice": 
            case "lastPrice": 
            case "askSize": 
            case "bidSize": 
            case "lastSize": 
            case "lastTimestamp": 
            case "high": 
            case "low": 
            case "change": 
            case "spread": {
                return this.ticker.getProperty(string);
            }
            case "avgPrice": {
                return Float.valueOf(this.getAvgPrice());
            }
            case "buyPips": {
                return Float.valueOf(this.getBuyPips());
            }
            case "buyPnl": {
                return this.getBuyPnl();
            }
            case "buyPrice": {
                return Float.valueOf(this.getBuyPrice());
            }
            case "buyQuantity": {
                return Float.valueOf(this.getBuyQuantity());
            }
            case "buyRoll": {
                return Float.valueOf(this.getBuyRoll());
            }
            case "close": {
                return af.a("LBL_CLOSE", new Object[0]);
            }
            case "closeBuyPrice": {
                return Float.valueOf(this.getCloseBuyPrice());
            }
            case "closeSellPrice": {
                return Float.valueOf(this.getCloseSellPrice());
            }
            case "netLimitOrder": {
                return this.getNetLimitOrder();
            }
            case "netLimitOrderPL": {
                return this.getNetLimitOrderPL();
            }
            case "netLimitPrice": {
                return Float.valueOf(this.getNetLimitPrice());
            }
            case "netStopTrailOrder": {
                return this.getNetStopTrailOrder();
            }
            case "netStopOrderPL": {
                return this.getNetStopOrderPL();
            }
            case "netStopTrailPrice": {
                return Float.valueOf(this.getNetStopTrailPrice());
            }
            case "pips": {
                return Float.valueOf(this.getPips());
            }
            case "pnl": {
                return this.getPnl();
            }
            case "quantity": {
                return Float.valueOf(this.getQuantity());
            }
            case "roll": {
                return Float.valueOf(this.getRoll());
            }
            case "sellPips": {
                return Float.valueOf(this.getSellPips());
            }
            case "sellPnl": {
                return this.getSellPnl();
            }
            case "sellPrice": {
                return Float.valueOf(this.getSellPrice());
            }
            case "sellQuantity": {
                return Float.valueOf(this.getSellQuantity());
            }
            case "sellRoll": {
                return Float.valueOf(this.getSellRoll());
            }
            case "symbolDisplay": {
                return this.ticker.getSymbolDisplay();
            }
            case "ticker": {
                return this.getTicker();
            }
            case "instrument": {
                return this.getInstrument();
            }
            case "accountId": {
                return this.getAccountId();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "accountCurrency": {
                return this.getAccountCurrency();
            }
        }
        return super.getProperty(string);
    }

    public String getId() {
        return this.getAccountId() + ":" + this.getInstrument().getKey();
    }

    public float getBuyQuantity() {
        return this.buyQuantity;
    }

    private void setBuyQuantity(float f2) {
        float f3 = this.buyQuantity;
        this.buyQuantity = f2;
        this.notify("buyQuantity", f3, this.buyQuantity);
        this.notify("quantity", -9999999.0f, this.getQuantity());
    }

    @Override
    public float getQuantity() {
        return this.buyQuantity + this.sellQuantity;
    }

    public float getAvgPrice() {
        if (this.buyQuantity == 0.0f && this.sellQuantity == 0.0f) {
            return 0.0f;
        }
        return (this.buyPrice * this.buyQuantity + this.sellPrice * Math.abs(this.sellQuantity)) / (this.buyQuantity + Math.abs(this.sellQuantity));
    }

    public float getBuyPrice() {
        return this.buyPrice;
    }

    private void setBuyPrice(float f2) {
        float f3 = this.buyPrice;
        this.buyPrice = f2;
        this.notify("buyPrice", f3, this.buyPrice);
    }

    public double getBuyPnl() {
        return this.buyPnl;
    }

    private void setBuyPnl(double d2) {
        double d3 = this.buyPnl;
        this.buyPnl = d2;
        this.notify("buyPnl", d3, this.buyPnl);
    }

    public float getBuyPips() {
        return this.buyPips;
    }

    private void setBuyPips(float f2) {
        float f3 = this.buyPips;
        this.buyPips = f2;
        this.notify("buyPips", f3, this.buyPips);
    }

    public float getBuyRoll() {
        return this.buyRoll;
    }

    private void setBuyRoll(float f2) {
        float f3 = this.buyRoll;
        this.buyRoll = f2;
        this.notify("buyRoll", f3, this.buyRoll);
    }

    public float getSellQuantity() {
        return this.sellQuantity;
    }

    private void setSellQuantity(float f2) {
        float f3 = this.sellQuantity;
        this.sellQuantity = f2;
        this.notify("sellQuantity", f3, this.sellQuantity);
        this.notify("quantity", -9999999.0f, this.getQuantity());
    }

    public float getSellPrice() {
        return this.sellPrice;
    }

    private void setSellPrice(float f2) {
        float f3 = this.sellPrice;
        this.sellPrice = f2;
        this.notify("sellPrice", f3, this.sellPrice);
    }

    public double getSellPnl() {
        return this.sellPnl;
    }

    private void setSellPnl(double d2) {
        double d3 = this.sellPnl;
        this.sellPnl = d2;
        this.notify("sellPnl", d3, this.sellPnl);
    }

    public float getSellPips() {
        return this.sellPips;
    }

    private void setSellPips(float f2) {
        float f3 = this.sellPips;
        this.sellPips = f2;
        this.notify("pips", f3, this.sellPips);
    }

    public float getSellRoll() {
        return this.sellRoll;
    }

    private void setSellRoll(float f2) {
        float f3 = this.sellRoll;
        this.sellRoll = f2;
        this.notify("sellRoll", f3, this.sellRoll);
    }

    public float getRoll() {
        return this.sellRoll + this.buyRoll;
    }

    private void setRoll(float f2) {
        this.notify("roll", 0.0f, f2);
    }

    public float getPips() {
        return this.sellPips + this.buyPips;
    }

    private void setPips(float f2) {
        this.notify("pips", 0.0f, f2);
    }

    public double getPnl() {
        return this.sellPnl + this.buyPnl;
    }

    private void setPnl(double d2) {
        this.notify("pnl", 0.0, d2);
    }

    public MWOrder getNetStopTrailOrder() {
        return this.netStopTrailOrder;
    }

    public void setNetStopTrailOrder(MWOrder mWOrder) {
        if (mWOrder != null && (mWOrder.isCancelled() || mWOrder.isFilled())) {
            mWOrder = null;
        }
        if (this.netStopTrailOrder != null) {
            this.netStopTrailOrder.setPositionSummary(null);
        }
        if (mWOrder != null) {
            mWOrder.setPositionSummary(this);
        }
        this.netStopTrailOrder = mWOrder;
        this.notify("netStopTrailPrice", 0.0f, this.getNetStopTrailPrice());
        this.notify("netStopOrderPL", 0.0, this.getNetStopOrderPL());
    }

    public float getNetStopTrailPrice() {
        if (this.netStopTrailOrder == null) {
            return 0.0f;
        }
        return this.netStopTrailOrder.getAdjustedAuxPrice();
    }

    public double getNetStopOrderPL() {
        if (this.netStopTrailOrder == null) {
            return 0.0;
        }
        return this.netStopTrailOrder.getOrderPL();
    }

    public MWOrder getNetLimitOrder() {
        return this.netLimitOrder;
    }

    public void setNetLimitOrder(MWOrder mWOrder) {
        if (mWOrder != null && (mWOrder.isCancelled() || mWOrder.isFilled())) {
            mWOrder = null;
        }
        if (this.netLimitOrder != null) {
            this.netLimitOrder.setPositionSummary(null);
        }
        if (mWOrder != null) {
            mWOrder.setPositionSummary(this);
        }
        this.netLimitOrder = mWOrder;
        this.notify("netLimitPrice", 0.0f, this.getNetLimitPrice());
        this.notify("netLimitOrderPL", 0.0, this.getNetLimitOrderPL());
    }

    public float getNetLimitPrice() {
        return this.netLimitOrder == null ? 0.0f : this.netLimitOrder.getLimitPrice();
    }

    public double getNetLimitOrderPL() {
        return this.netLimitOrder == null ? 0.0 : this.netLimitOrder.getOrderPL();
    }

    public float getCloseBuyPrice() {
        return this.closeBuyPrice;
    }

    public float getCloseSellPrice() {
        return this.closeSellPrice;
    }

    private void updatePnLPips() {
        float f2 = this.ticker.getCurrentPrice(this.buyQuantity);
        float f3 = this.ticker.getCurrentPrice(this.sellQuantity);
        MWInstrument mWInstrument = this.getInstrument();
        if (mWInstrument.isValueValid(f2)) {
            this.setBuyPnl(mWInstrument.calcPnLAndConvert(this.buyPrice, f2, this.buyQuantity, this.getAccountCurrency()));
            this.setBuyPips(this.calcBuyPips());
        } else {
            this.buyPnl = 0.0;
            this.buyPips = 0.0f;
        }
        if (mWInstrument.isValueValid(f3)) {
            this.setSellPnl(mWInstrument.calcPnLAndConvert(this.sellPrice, f3, this.sellQuantity, this.getAccountCurrency()));
            this.setSellPips(this.calcSellPips());
        } else {
            this.sellPnl = 0.0;
            this.sellPips = 0.0f;
        }
        this.setPips(this.buyPips + this.sellPips);
        this.setPnl(this.buyPnl + this.sellPnl);
    }

    private float calcBuyPips() {
        if (this.buyQuantity <= 0.0f) {
            return 0.0f;
        }
        float f2 = this.ticker.getBidPrice();
        if (f2 == 0.0f) {
            f2 = this.ticker.getLastPrice();
        }
        if (f2 == 0.0f) {
            return 0.0f;
        }
        if (this.ticker.getPointSize() != 0.0) {
            return (f2 - this.buyPrice) / (float)this.ticker.getPointSize();
        }
        return f2 - this.buyPrice;
    }

    private float calcSellPips() {
        if (this.sellQuantity >= 0.0f) {
            return 0.0f;
        }
        float f2 = this.ticker.getAskPrice();
        if (f2 == 0.0f) {
            f2 = this.ticker.getLastPrice();
        }
        if (f2 == 0.0f) {
            return 0.0f;
        }
        if (this.ticker.getPointSize() != 0.0) {
            return (this.sellPrice - f2) / (float)this.ticker.getPointSize();
        }
        return this.sellPrice - f2;
    }

    void addOrUpdate(Position position) {
        if (!h.a((Object)position.getAccountId(), (Object)this.getAccountId())) {
            return;
        }
        for (Position position2 : this.positions.a()) {
            if (!h.a((Object)position2.getId(), (Object)position.getId())) continue;
            this.positions.a((Object)position2);
        }
        this.positions.a((Object)position);
    }

    void remove(Position position) {
        for (Position position2 : this.positions.a()) {
            if (position2 != position && !h.a((Object)position2.getId(), (Object)position.getId())) continue;
            this.positions.a((Object)position2);
        }
    }

    boolean hasPositions() {
        if (this.getQuantity() == 0.0f && !this.positions.a()) {
            for (Position position : this.positions.a()) {
                if (position.isClosed()) continue;
                return true;
            }
            return false;
        }
        return !this.positions.a();
    }

    void refresh() {
        this.positions.b();
        for (Position position : Positions.byInstrument(this.getInstrument(), this.getAccountId())) {
            this.positions.a((Object)position);
        }
        this.update();
    }

    void update() {
        int n2 = 0;
        int n3 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        for (Position position : this.positions.a()) {
            if (!h.a((Object)position.getAccountId(), (Object)this.accountId) || position.isClosed()) continue;
            if (position.getQuantity() > 0.0f) {
                n2 = (int)((float)n2 + position.getQuantity());
                f2 += position.getEntryPrice() * position.getQuantity();
                f3 += position.getRoll();
                continue;
            }
            n3 = (int)((float)n3 + position.getQuantity());
            f4 += position.getEntryPrice() * position.getQuantity();
            f5 += position.getRoll();
        }
        this.setBuyQuantity(n2);
        this.setBuyPrice(n2 > 0 ? f2 / (float)n2 : 0.0f);
        this.setBuyRoll(f3);
        this.setSellQuantity(n3);
        this.setSellPrice(n3 < 0 ? f4 / (float)n3 : 0.0f);
        this.setSellRoll(f5);
        this.updatePnLPips();
        this.setRoll(this.sellRoll + this.buyRoll);
        if (this.buyQuantity > 0.0f) {
            this.closeBuyPrice = 0.0f;
            this.closeSellPrice = this.ticker.getBidPrice();
        }
        if (this.sellQuantity < 0.0f) {
            this.closeSellPrice = 0.0f;
            this.closeBuyPrice = this.ticker.getAskPrice();
        }
        this.notify("avgPrice", 0.0f, this.getAvgPrice());
    }

    @Override
    public void removeAllOrders() {
        this.setNetLimitOrder(null);
        this.setNetStopTrailOrder(null);
    }

    @Override
    public void orderCancelled(MWOrder mWOrder) {
        if (mWOrder == this.netLimitOrder) {
            this.setNetLimitOrder(null);
        }
        if (mWOrder == this.netStopTrailOrder) {
            this.setNetStopTrailOrder(null);
        }
    }

    @Override
    public void orderRemoved(MWOrder mWOrder) {
        if (mWOrder == this.netLimitOrder) {
            this.setNetLimitOrder(null);
        }
        if (mWOrder == this.netStopTrailOrder) {
            this.setNetStopTrailOrder(null);
        }
    }

    @Override
    public void orderFilled(MWOrder mWOrder) {
        if (mWOrder.isPartiallyFilled()) {
            return;
        }
        if (mWOrder == this.netLimitOrder) {
            this.setNetLimitOrder(null);
        }
        if (mWOrder == this.netStopTrailOrder) {
            this.setNetStopTrailOrder(null);
        }
    }

    @Override
    public void orderModified(MWOrder mWOrder) {
        if (mWOrder == this.netLimitOrder) {
            this.notify("netLimitPrice", 0.0f, mWOrder.getLimitPrice());
        }
        if (mWOrder == this.netStopTrailOrder) {
            this.notify("netStopTrailPrice", 0.0f, mWOrder.getAuxPrice());
        }
    }
}

