/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.platform.common.ab;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.by;

public abstract class PositionBase
extends ObservableBean {
    private String acctBaseCur = null;
    protected Ticker ticker;
    protected long lastPlUpdate = 0L;
    protected float lastPlPrice = 0.0f;
    protected int plUpdateCount = 0;
    protected String accountId;

    protected PositionBase(Ticker ticker) {
        this.ticker = ticker;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public abstract float getQuantity();

    public MWInstrument getInstrument() {
        return this.ticker == null ? null : this.ticker.getInstrument();
    }

    @Override
    public String formatPrice(float f2) {
        if (f2 == 0.0f) {
            return "";
        }
        return this.ticker.format(f2);
    }

    protected boolean ignorePLUpdate(String string) {
        return ab.a(string, this.getQuantity(), this.ticker);
    }

    protected float getCurrentPrice() {
        if (this.ticker == null) {
            return 0.0f;
        }
        return this.ticker.getCurrentPrice(this.getQuantity());
    }

    public String getAccountCurrency() {
        if (this.acctBaseCur != null) {
            return this.acctBaseCur;
        }
        Account account = this.getAccount();
        String string = ab.a(account);
        if (account != null) {
            this.acctBaseCur = string;
        }
        return string;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountName() {
        Account account = this.getAccount();
        if (account == null) {
            return this.getAccountId();
        }
        return account.getDisplayName();
    }

    public Account getAccount() {
        return bs.a(this.accountId);
    }

    public String getServiceName() {
        by by2 = bs.a(this.getAccount());
        if (by2 != null) {
            return by2.a().getType().toString();
        }
        return "";
    }

    public String getConnectionName() {
        by by2 = bs.a(this.getAccount());
        if (by2 != null) {
            return by2.a().getName();
        }
        return "";
    }
}

