/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.a;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.af;
import com.motivewave.platform.common.w;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.ConnectionID;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.PositionBase;
import com.motivewave.platform.databean.Positions;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.service.bs;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import o.c;
import org.json.JSONObject;
import org.w3c.dom.Element;

public class Position
extends PositionBase
implements w,
PropertyChangeListener,
Comparable,
c {
    public static final String F_CLOSE_SELL_PRICE = "closeSellPrice";
    public static final String F_CLOSE_BUY_PRICE = "closeBuyPrice";
    public static final String F_UNREALIZED_PNL = "unrealizedPnL";
    public static final String F_PIPS = "pips";
    public static final String F_QUANTITY = "quantity";
    public static final String F_CLOSED_QUANTITY = "closedQuantity";
    public static final String F_AVG_PRICE = "avgPrice";
    public static final String F_MARKET_VALUE = "marketValue";
    public static final String F_PNL = "pnl";
    public static final String F_NET_PNL = "netPnl";
    private ConnectionID connId;
    private String positionId;
    private String transactionId;
    private float quantity;
    private float closedQuantity;
    private float avgPrice;
    private float avgClosePrice;
    private double marketValue;
    private double rawMarketValue;
    private String openingOrderId;
    private String closeOrderId;
    private long openTime = 0L;
    private long closeTime = 0L;
    private boolean open;
    private double pnl;
    private double unrealizedPnL;
    private double rawUnrealizedPnL;
    private double commission;
    private double initialMargin;
    private double maintenanceMargin;
    private double interest;
    private float roll;
    private MWOrder stopTrailOrder;
    private MWOrder limitOrder;
    private boolean fixedPnl = false;
    private String _property;
    private Runnable updatePLTask = () -> {
        float f2 = this.getCurrentPrice();
        long l2 = com.motivewave.platform.common.b.n() / 2;
        this.lastPlUpdate = (this.ticker == null ? bs.a() : this.ticker.getLastUpdate(this._property)) / l2 * l2;
        this.lastPlPrice = f2;
        this.plUpdateCount = 0;
        this.updateUnrealizedPnL();
        this.updateMarketValue();
    };

    public static Position from(at.h h2) {
        if (h2 == null) {
            return null;
        }
        LiveTicker liveTicker = LiveTicker.byKey(h2.d());
        if (liveTicker == null) {
            h.a.warning("Position::from() ticker not found: " + h2.d());
            return null;
        }
        Position position = new Position(h2.a(), h2.c(), h2.f(), liveTicker, h2.a(), liveTicker.getInstrument().getSource());
        position.setAvgPrice(h2.c());
        position.setQuantity(h2.a());
        position.setClosedQuantity(h2.b());
        position.setOpenTime(h2.a());
        position.setInitialMargin(h2.d());
        position.setMaintenanceMargin(h2.e());
        position.setMarketValue(h2.c());
        position.setCommission(h2.b());
        position.setInterest(h2.f());
        position.setRoll((float)h2.f());
        position.setClosedQuantity(h2.b());
        if (!h2.a()) {
            position.setCloseTime(h2.b());
            position.setAvgClosePrice(h2.d());
            position.setPnl(h2.a());
        }
        position.updateUnrealizedPnL();
        position.updateMarketValue();
        return position;
    }

    public Position(JSONObject jSONObject) {
        super(null);
        this.fromJSON(jSONObject);
    }

    private Position() {
        super(null);
    }

    public Position(String string, String string2, String string3, Ticker ticker, boolean bl2, ConnectionID connectionID) {
        super(ticker);
        this.connId = connectionID;
        this.positionId = string;
        this.accountId = string2;
        this.openingOrderId = string3;
        this.open = bl2;
        this.openTime = bs.a();
        if (bl2) {
            if (ticker != null) {
                ticker.addPropertyChangeListener(this);
            } else {
                h.a.severe("creating position (ticker is null) : " + string + " " + string2);
                h.c();
            }
            OrderDirectory.addListener(this);
            this.updateUnrealizedPnL();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
        OrderDirectory.removeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (h.a(string, "bidPrice", "askPrice", "lastPrice", F_AVG_PRICE, "lastTimestamp", "high", "low", F_PIPS, "spread", "roll", "open", "close")) {
            this.notify(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (!this.isOpen()) {
            return;
        }
        if (this.ignorePLUpdate(string)) {
            return;
        }
        this._property = string;
        b.a(this.updatePLTask, 100L);
    }

    public String toCSV() {
        return a.a(this.positionId, this.accountId, this.getInstrument().getKey(), Float.valueOf(this.quantity), Float.valueOf(this.closedQuantity), Float.valueOf(this.avgPrice), h.b(this.openTime), h.b(this.closeTime), Float.valueOf(this.avgClosePrice), this.commission, this.open, this.pnl);
    }

    public static Position fromCSV(List list) {
        if (h.a((Collection)list) || list.size() < 10) {
            return null;
        }
        Position position = new Position();
        position.positionId = (String)list.get(0);
        position.accountId = (String)list.get(1);
        MWInstrument mWInstrument = MWInstrument.resolveFromKey((String)list.get(2));
        if (mWInstrument == null) {
            h.a.warning("Position::fromCSV() instrument not found: " + (String)list.get(2));
        } else {
            position.ticker = LiveTicker.get(mWInstrument);
        }
        if (list.size() > 3) {
            position.quantity = h.b((String)list.get(3));
        }
        if (list.size() > 4) {
            position.closedQuantity = h.b((String)list.get(4));
        }
        if (list.size() > 5) {
            position.avgPrice = h.b((String)list.get(5));
        }
        if (list.size() > 6) {
            position.openTime = h.a((String)list.get(6));
        }
        if (list.size() > 7) {
            position.closeTime = h.a((String)list.get(7));
        }
        if (list.size() > 8) {
            position.avgClosePrice = h.b((String)list.get(8));
        }
        if (list.size() > 9) {
            position.commission = h.a((String)list.get(9));
        }
        boolean bl2 = false;
        if (list.size() > 10) {
            bl2 = h.c(list.get(10));
        }
        if (list.size() > 11) {
            position.pnl = h.a((String)list.get(11));
        }
        if (bl2 && position.quantity == 0.0f) {
            bl2 = false;
        }
        position.setOpen(bl2);
        if (bl2) {
            position.updateUnrealizedPnL();
        }
        return position;
    }

    @Override
    public List getNVPs() {
        return h.b(new String[]{this.b("id", this.positionId), this.b("accountId", this.accountId), this.a("instr", this.getInstrument()), this.a(F_QUANTITY, this.quantity), this.a(F_CLOSED_QUANTITY, this.closedQuantity), this.a(F_AVG_PRICE, this.avgPrice), this.a("openTime", this.openTime), this.a("closeTime", this.closeTime), this.a("avgClosePrice", this.avgClosePrice), this.a("commission", this.commission), this.a("open", this.open), this.a(F_PNL, this.pnl)});
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        MWInstrument mWInstrument = this.a(jSONObject, "instr");
        this.ticker = LiveTicker.get(mWInstrument);
        this.positionId = jSONObject.str("id");
        this.accountId = jSONObject.str("accountId");
        this.quantity = jSONObject.getFloat(F_QUANTITY);
        this.closedQuantity = jSONObject.getFloat(F_CLOSED_QUANTITY);
        this.avgPrice = jSONObject.getFloat(F_AVG_PRICE);
        this.avgClosePrice = jSONObject.getFloat("avgClosePrice");
        this.pnl = jSONObject.getDouble(F_PNL);
        this.openTime = jSONObject.getLong("openTime");
        this.closeTime = jSONObject.getLong("closeTime");
        this.commission = jSONObject.getDouble("commission");
        boolean bl2 = jSONObject.is("open");
        if (bl2 && this.quantity == 0.0f) {
            bl2 = false;
        }
        this.setOpen(bl2);
        if (bl2) {
            this.updateUnrealizedPnL();
        }
    }

    public static Position read(Element element) {
        String string;
        String string2 = element.getAttribute("id");
        String string3 = element.getAttribute("accountId");
        String string4 = element.getAttribute("symbol");
        MWInstrument mWInstrument = MWInstrument.get(string4, string = element.getAttribute("exchange"));
        if (mWInstrument == null) {
            h.a.warning("Position::read() instrument not found: " + string4 + "." + string);
            return null;
        }
        LiveTicker liveTicker = LiveTicker.get(mWInstrument);
        Position position = new Position(string2, string3, null, liveTicker, true, null);
        position.setQuantity(h.b(element.getAttribute(F_QUANTITY)));
        position.setClosedQuantity(h.b(element.getAttribute(F_CLOSED_QUANTITY)));
        position.setAvgPrice(h.b(element.getAttribute(F_AVG_PRICE)));
        position.setOpenTime(h.c(element.getAttribute("openTime")));
        position.setOpen(true);
        position.setCommission(h.a(element.getAttribute("commission")));
        return position;
    }

    public String toString() {
        return this.format("accountName") + " " + this.format("ticket") + " " + this.ticker.getSymbolDisplay() + " " + this.format(F_QUANTITY) + "@" + this.format(F_AVG_PRICE);
    }

    public int compareTo(Position position) {
        if (this == position) {
            return 0;
        }
        if (h.a((Object)this.positionId, (Object)position.positionId)) {
            return 0;
        }
        if (position.openTime > this.openTime) {
            return 1;
        }
        if (position.openTime < this.openTime) {
            return -1;
        }
        return this.positionId.compareTo(position.positionId);
    }

    private String formatPL(double d2) {
        return d2 == 0.0 ? "" : ab.a(d2);
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "quantity": 
            case "position": {
                float f2 = this.quantity;
                if (!this.isOpen()) {
                    f2 = this.closedQuantity;
                }
                if (f2 == 0.0f) {
                    return "";
                }
                return ab.b(f2, this.getInstrument());
            }
            case "closedQuantity": {
                if (this.closedQuantity == 0.0f) {
                    return "";
                }
                return ab.b(this.closedQuantity, this.getInstrument());
            }
            case "unrealizedPnL": {
                return ab.a(this.unrealizedPnL);
            }
            case "pnl": {
                return ab.a(this.pnl);
            }
            case "netPnl": {
                return ab.a(this.getNetPnl());
            }
            case "rawUnrealizedPnL": {
                return ab.a(this.rawUnrealizedPnL);
            }
            case "marketValue": {
                return ab.a(this.getMarketValue());
            }
            case "rawMarketValue": {
                return ab.a(this.getRawMarketValue());
            }
            case "commission": {
                return ab.a(this.getCommission());
            }
            case "interest": {
                return ab.a(this.getInterest());
            }
            case "stopOrderPL": {
                return this.formatPL(this.getStopOrderPL());
            }
            case "limitOrderPL": {
                return this.formatPL(this.getLimitOrderPL());
            }
            case "initialMargin": {
                return ab.a(this.getInitialMargin());
            }
            case "maintenanceMargin": {
                return ab.a(this.getMaintenanceMargin());
            }
            case "avgPrice": {
                return this.getAvgPrice() == 0.0f ? "" : this.ticker.format(this.getAvgPrice());
            }
            case "avgClosePrice": {
                return this.getAvgClosePrice() == 0.0f ? "" : this.ticker.format(this.getAvgClosePrice());
            }
            case "entryPrice": {
                return this.ticker.format(this.getEntryPrice());
            }
            case "accountId": {
                return this.getAccountId();
            }
            case "accountName": {
                return this.getAccountName();
            }
            case "accountCurrency": {
                return this.getAccountCurrency();
            }
            case "pips": {
                float f3 = this.getPips();
                if (f3 == 0.0f) {
                    return "";
                }
                return h.c((double)f3, 1);
            }
            case "roll": {
                float f4 = this.getRoll();
                if (f4 == 0.0f) {
                    return "";
                }
                return h.c((double)f4, 2);
            }
            case "stopTrailPrice": {
                if (this.stopTrailOrder == null) {
                    return "";
                }
                if (this.stopTrailOrder.isUsePips()) {
                    return h.b(this.getStopTrailPrice(), 1);
                }
                return this.getInstrument().formatValue(this.getStopTrailPrice());
            }
            case "limitPrice": {
                if (this.limitOrder == null) {
                    return "";
                }
                if (this.limitOrder.isUsePips()) {
                    return h.b(this.getLimitPrice(), 1);
                }
                return this.getInstrument().formatValue(this.getLimitPrice());
            }
            case "ticket": {
                return this.getId();
            }
            case "open": {
                return "" + this.open;
            }
            case "closed": {
                return "" + !this.open;
            }
            case "close": {
                af.a("LBL_CLOSE", new Object[0]);
            }
            case "openTime": {
                return this.openTime == 0L ? "" : ab.a(this.openTime, com.motivewave.platform.common.b.b());
            }
            case "closeTime": {
                return this.closeTime == 0L ? "" : ab.a(this.closeTime, com.motivewave.platform.common.b.b());
            }
            case "openingOrderId": {
                return this.openingOrderId;
            }
            case "transactionId": {
                return this.transactionId;
            }
            case "lastPrice": 
            case "lastSize": 
            case "askPrice": 
            case "askSize": 
            case "bidPrice": 
            case "bidSize": 
            case "change": 
            case "high": 
            case "low": {
                return this.ticker.format(string);
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "symbolDisplay": {
                return this.ticker.getSymbolDisplay();
            }
            case "lastTimestamp": {
                long l2 = this.ticker.getLastTimestamp();
                if (l2 == 0L) {
                    return "";
                }
                return ab.a(l2, com.motivewave.platform.common.b.b());
            }
        }
        return this.ticker.format(string);
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "pips": {
                return Float.valueOf(this.getPips());
            }
            case "pnl": {
                return this.getPnl();
            }
            case "quantity": {
                return Float.valueOf(this.getQuantity());
            }
            case "unrealizedPnL": {
                return this.getUnrealizedPnL();
            }
            case "rawUnrealizedPnL": {
                return this.getRawUnrealizedPnL();
            }
            case "avgPrice": {
                return Float.valueOf(this.getAvgPrice());
            }
            case "accountId": {
                return this.getAccountId();
            }
            case "accountName": {
                return this.getAccountName();
            }
            case "accountCurrency": {
                return this.getAccountCurrency();
            }
            case "avgClosePrice": {
                return Float.valueOf(this.getAvgClosePrice());
            }
            case "low": 
            case "spread": 
            case "high": 
            case "lastPrice": 
            case "lastSize": 
            case "lastTimestamp": 
            case "askPrice": 
            case "askSize": 
            case "bidPrice": 
            case "bidSize": 
            case "change": {
                return this.ticker.getProperty(string);
            }
            case "close": {
                return af.a("LBL_CLOSE", new Object[0]);
            }
            case "closeOrderId": {
                return this.getCloseOrderId();
            }
            case "closeTime": {
                return this.getCloseTime();
            }
            case "commission": {
                return this.getCommission();
            }
            case "initialMargin": {
                return this.getInitialMargin();
            }
            case "maintenanceMargin": {
                return this.getMaintenanceMargin();
            }
            case "currency": {
                return this.ticker.getInstrument().getCurrency();
            }
            case "entryPrice": {
                return Float.valueOf(this.getEntryPrice());
            }
            case "exchange": {
                return this.ticker.getInstrument().getExchange();
            }
            case "netPnl": {
                return this.getNetPnl();
            }
            case "id": {
                return this.getId();
            }
            case "interest": {
                return this.getInterest();
            }
            case "limitOrder": {
                return this.getLimitOrder();
            }
            case "limitOrderPL": {
                return this.getLimitOrderPL();
            }
            case "limitPrice": {
                return Float.valueOf(this.getLimitPrice());
            }
            case "marketValue": {
                return this.getMarketValue();
            }
            case "rawMarketValue": {
                return this.getRawMarketValue();
            }
            case "openingOrderId": {
                return this.getOpeningOrderId();
            }
            case "openTime": {
                return this.getOpenTime();
            }
            case "roll": {
                return Float.valueOf(this.getRoll());
            }
            case "stopOrderPL": {
                return this.getStopOrderPL();
            }
            case "stopTrailOrder": {
                return this.getStopTrailOrder();
            }
            case "symbolDisplay": {
                return this.ticker.getSymbolDisplay();
            }
            case "stopTrailPrice": {
                return Float.valueOf(this.getStopTrailPrice());
            }
            case "ticker": {
                return this.getTicker();
            }
            case "ticket": {
                return this.getTicket();
            }
            case "transactionId": {
                return this.getTransactionId();
            }
            case "underlying": {
                return this.ticker.getUnderlying();
            }
            case "closed": {
                return this.isClosed();
            }
            case "open": {
                return this.isOpen();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
        }
        return super.getProperty(string);
    }

    public String getTicket() {
        return this.positionId;
    }

    public String getId() {
        return this.positionId;
    }

    @Override
    public float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(float f2) {
        if (f2 == this.quantity) {
            return;
        }
        float f3 = this.quantity;
        this.quantity = f2;
        this.notify(F_QUANTITY, f3, this.quantity);
        if (this.quantity == 0.0f) {
            this.setOpen(false);
            this.setCloseTime(bs.a());
        }
    }

    public float getClosedQuantity() {
        return this.closedQuantity;
    }

    public void setClosedQuantity(float f2) {
        float f3 = this.closedQuantity;
        this.closedQuantity = f2;
        this.notify(F_CLOSED_QUANTITY, f3, this.closedQuantity);
    }

    public float getAvgPrice() {
        return this.avgPrice;
    }

    public float getEntryPrice() {
        return this.avgPrice;
    }

    public void setAvgPrice(float f2) {
        if (f2 == this.avgPrice) {
            return;
        }
        float f3 = this.avgPrice;
        this.avgPrice = f2;
        this.notify(F_AVG_PRICE, f3, this.avgPrice);
        this.notify("entryPrice", f3, this.avgPrice);
    }

    public double getMarketValue() {
        return this.marketValue;
    }

    public void setMarketValue(double d2) {
        double d3 = this.marketValue;
        this.marketValue = d2;
        this.notify(F_MARKET_VALUE, d3, this.marketValue);
    }

    public double getRawMarketValue() {
        return this.rawMarketValue;
    }

    public void setRawMarketValue(double d2) {
        double d3 = this.rawMarketValue;
        this.rawMarketValue = d2;
        this.notify("rawMarketValue", d3, this.rawMarketValue);
    }

    public boolean isFixedPnl() {
        return this.fixedPnl;
    }

    public void setFixedPnl(boolean bl2) {
        this.fixedPnl = bl2;
    }

    public void updateUnrealizedPnL() {
        if (this.fixedPnl) {
            return;
        }
        MWInstrument mWInstrument = this.getInstrument();
        float f2 = this.getQuantity();
        float f3 = this.getCurrentPrice();
        double d2 = 0.0;
        if (mWInstrument.isValueValid(f3)) {
            d2 = mWInstrument.calcPnL(this.getAvgPrice(), f3, f2);
        }
        if (!mWInstrument.isFuture() && h.a((Object)mWInstrument.getCurrency(), (Object)"JPY")) {
            this.setRawUnrealizedPnL(d2 * 100.0);
        } else {
            this.setRawUnrealizedPnL(d2);
        }
        this.setRawUnrealizedPnL(d2);
        String string = this.getAccountCurrency();
        if (h.g(string)) {
            return;
        }
        d2 = mWInstrument.convertTo(d2, string);
        if (!mWInstrument.isFuture() && h.a((Object)string, (Object)"JPY")) {
            d2 *= 100.0;
        }
        this.setUnrealizedPnL(d2);
        if (!this.ticker.isReplay()) {
            LiveTicker.get(mWInstrument).updateUnrealizedPnL();
        }
        Positions.notifyPLUpdate(mWInstrument, this.getAccountId());
    }

    public void updateMarketValue() {
        float f2;
        MWInstrument mWInstrument = this.getInstrument();
        if (!mWInstrument.isValueValid(f2 = this.getCurrentPrice())) {
            return;
        }
        double d2 = mWInstrument.calcPnL(f2, this.quantity);
        this.setMarketValue(mWInstrument.convertTo(d2, this.getAccount()));
        if (h.a((Object)mWInstrument.getCurrency(), (Object)"JPY")) {
            this.setRawMarketValue(d2 * 100.0);
        } else {
            this.setRawMarketValue(d2);
        }
    }

    public ConnectionID getConnId() {
        return this.connId;
    }

    public boolean isReplay() {
        Account account = this.getAccount();
        if (account == null) {
            return false;
        }
        return account.isReplay();
    }

    public boolean isSimulated() {
        Account account = this.getAccount();
        if (account == null) {
            return false;
        }
        return account.isSimulatedAccount();
    }

    public String getOpeningOrderId() {
        return this.openingOrderId;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public void setOpenTime(long l2) {
        this.openTime = l2;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void setOpen(boolean bl2) {
        boolean bl3 = this.open;
        this.open = bl2;
        this.notify("open", bl3, this.open);
        if (!this.open) {
            if (this.ticker != null) {
                this.ticker.removePropertyChangeListener(this);
            }
            OrderDirectory.removeListener(this);
        } else {
            if (this.ticker != null) {
                this.ticker.addPropertyChangeListener(this);
            }
            OrderDirectory.addListener(this);
        }
    }

    public float getAvgClosePrice() {
        return this.avgClosePrice;
    }

    public void setAvgClosePrice(float f2) {
        float f3 = this.avgClosePrice;
        this.avgClosePrice = f2;
        this.notify("avgClosePrice", f3, this.avgClosePrice);
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(long l2) {
        long l3 = this.closeTime;
        this.closeTime = l2;
        this.notify("closeTime", l3, this.closeTime);
    }

    public String getCloseOrderId() {
        return this.closeOrderId;
    }

    public void setCloseOrderId(String string) {
        this.closeOrderId = string;
    }

    public double getPnl() {
        return this.pnl;
    }

    public void setPnl(double d2) {
        double d3 = this.pnl;
        double d4 = this.getNetPnl();
        this.pnl = d2;
        this.notify(F_PNL, d3, this.pnl);
        this.notify(F_NET_PNL, d4, this.getNetPnl());
    }

    public double getNetPnl() {
        return this.pnl - this.commission + this.interest;
    }

    public double getUnrealizedPnL() {
        return this.unrealizedPnL;
    }

    public void setUnrealizedPnL(double d2) {
        double d3 = this.unrealizedPnL;
        this.unrealizedPnL = d2;
        this.notify(F_UNREALIZED_PNL, d3, this.unrealizedPnL);
        this.notify(F_PIPS, 0.0f, this.getPips());
    }

    public double getRawUnrealizedPnL() {
        return this.rawUnrealizedPnL;
    }

    public void setRawUnrealizedPnL(double d2) {
        double d3 = this.rawUnrealizedPnL;
        this.rawUnrealizedPnL = d2;
        this.notify("rawUnrealizedPnL", d3, this.rawUnrealizedPnL);
    }

    public float getPips() {
        float f2 = 0.0f;
        if (this.isOpen()) {
            float f3 = this.getCurrentPrice();
            if (f3 == 0.0f) {
                return 0.0f;
            }
            f2 = (f3 - this.avgPrice) / (float)this.ticker.getPointSize();
            if (this.quantity > 0.0f) {
                return f2;
            }
            return -1.0f * f2;
        }
        f2 = (this.avgClosePrice - this.avgPrice) / (float)this.ticker.getPointSize();
        if (this.closedQuantity == 0.0f && this.getPnl() != 0.0) {
            f2 = Math.abs(f2);
            if (this.getPnl() > 0.0) {
                return f2;
            }
            return -1.0f * f2;
        }
        if (this.closedQuantity > 0.0f) {
            return f2;
        }
        return -1.0f * f2;
    }

    public double getCommission() {
        return this.commission;
    }

    public void setCommission(double d2) {
        double d3 = this.commission;
        this.commission = d2;
        this.notify("commission", d3, this.commission);
    }

    public double getInitialMargin() {
        return this.initialMargin;
    }

    public void setInitialMargin(double d2) {
        double d3 = this.initialMargin;
        this.initialMargin = d2;
        this.notify("initialMargin", d3, this.initialMargin);
    }

    public double getMaintenanceMargin() {
        return this.maintenanceMargin;
    }

    public void setMaintenanceMargin(double d2) {
        double d3 = this.maintenanceMargin;
        this.maintenanceMargin = d2;
        this.notify("maintenanceMargin", d3, this.maintenanceMargin);
    }

    public double getInterest() {
        return this.interest;
    }

    public void setInterest(double d2) {
        double d3 = this.interest;
        this.interest = d2;
        this.notify("interest", d3, this.interest);
    }

    public float getRoll() {
        return this.roll;
    }

    public void setRoll(float f2) {
        float f3 = this.roll;
        this.roll = f2;
        this.notify("roll", f3, this.roll);
    }

    public void resolveOrders() {
        if (this.isClosed()) {
            return;
        }
        List list = OrderDirectory.findClosingOrders(this);
        MWOrder mWOrder = null;
        MWOrder mWOrder2 = null;
        if (!bs.e(this.getAccount()) && bs.w(this.getAccount())) {
            for (MWOrder mWOrder3 : list) {
                if (mWOrder3.isLimit()) {
                    mWOrder = mWOrder3;
                    continue;
                }
                if (!mWOrder3.isStop() && !mWOrder3.isTrail()) continue;
                mWOrder2 = mWOrder3;
            }
        } else {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            for (Object object : list) {
                if (((MWOrder)object).isLimit()) {
                    arrayList.add(object);
                    continue;
                }
                if (!((MWOrder)object).isStop() && !((MWOrder)object).isTrail()) continue;
                arrayList2.add(object);
            }
            float f2 = Math.abs(this.getQuantity());
            for (MWOrder mWOrder4 : arrayList) {
                if (mWOrder4.getRemaining() != f2) continue;
                mWOrder = mWOrder4;
                break;
            }
            for (MWOrder mWOrder3 : arrayList2) {
                if (mWOrder3.getRemaining() != f2) continue;
                mWOrder2 = mWOrder3;
                break;
            }
        }
        if (mWOrder != null) {
            if (mWOrder != this.limitOrder) {
                this.setLimitOrder(mWOrder);
            } else {
                mWOrder.setPosition(this);
                this.notify("limitPrice", -99999.0f, this.getLimitPrice());
                this.notify("limitOrderPL", -99999.0, this.getLimitOrderPL());
            }
        } else if (this.limitOrder != null) {
            this.setLimitOrder(null);
        }
        if (mWOrder2 != null) {
            if (mWOrder2 != this.stopTrailOrder) {
                this.setStopTrailOrder(mWOrder2);
            } else {
                mWOrder2.setPosition(this);
                this.notify("stopTrailPrice", -99999.0f, this.getStopTrailPrice());
                this.notify("stopOrderPL", -99999.0, this.getStopOrderPL());
            }
        } else if (this.stopTrailOrder != null) {
            this.setStopTrailOrder(null);
        }
    }

    public MWOrder getStopTrailOrder() {
        return this.stopTrailOrder;
    }

    public void setStopTrailOrder(MWOrder mWOrder) {
        if (mWOrder != null && (mWOrder.isCancelled() || mWOrder.isFilled())) {
            mWOrder = null;
        }
        if (mWOrder == this.stopTrailOrder) {
            return;
        }
        MWOrder mWOrder2 = this.stopTrailOrder;
        this.stopTrailOrder = mWOrder;
        if (mWOrder2 != null) {
            mWOrder2.setPosition(null);
        }
        if (this.stopTrailOrder != null) {
            this.stopTrailOrder.setPosition(this);
        }
        this.notify("stopTrailOrder", mWOrder2, this.stopTrailOrder);
        this.notify("stopTrailPrice", -99999.0f, this.getStopTrailPrice());
        this.notify("stopOrderPL", -99999.0, this.getStopOrderPL());
    }

    public float getStopTrailPrice() {
        if (this.stopTrailOrder == null) {
            return 0.0f;
        }
        return this.stopTrailOrder.getAdjustedAuxPrice();
    }

    public double getStopOrderPL() {
        if (this.stopTrailOrder == null) {
            return 0.0;
        }
        return this.stopTrailOrder.getOrderPL();
    }

    public MWOrder getLimitOrder() {
        return this.limitOrder;
    }

    public void setLimitOrder(MWOrder mWOrder) {
        if (mWOrder != null && (mWOrder.isCancelled() || mWOrder.isFilled())) {
            mWOrder = null;
        }
        if (mWOrder == this.limitOrder) {
            return;
        }
        MWOrder mWOrder2 = this.limitOrder;
        this.limitOrder = mWOrder;
        if (mWOrder2 != null) {
            mWOrder2.setPosition(null);
        }
        if (this.limitOrder != null) {
            this.limitOrder.setPosition(this);
        }
        this.notify("limitOrder", mWOrder2, this.limitOrder);
        this.notify("limitPrice", -99999.0f, this.getLimitPrice());
        this.notify("limitOrderPL", -99999.0, this.getLimitOrderPL());
    }

    public float getLimitPrice() {
        if (this.limitOrder == null) {
            return 0.0f;
        }
        return this.limitOrder.getLimitPrice();
    }

    public double getLimitOrderPL() {
        if (this.limitOrder == null) {
            return 0.0;
        }
        return this.limitOrder.getOrderPL();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String string) {
        this.transactionId = string;
    }

    @Override
    public void orderCancelled(MWOrder mWOrder) {
        if (this.ignore(mWOrder)) {
            return;
        }
        if (this.is(this.limitOrder, mWOrder)) {
            this.setLimitOrder(null);
        }
        if (this.is(this.stopTrailOrder, mWOrder)) {
            this.setStopTrailOrder(null);
        }
    }

    private boolean is(MWOrder mWOrder, MWOrder mWOrder2) {
        if (mWOrder == mWOrder2) {
            return true;
        }
        if (mWOrder == null || mWOrder2 == null) {
            return false;
        }
        return h.a((Object)mWOrder.getOrderId(), (Object)mWOrder2.getOrderId());
    }

    @Override
    public void orderCreated(MWOrder mWOrder) {
        if (this.ignore(mWOrder)) {
            return;
        }
        if (mWOrder.isFilled()) {
            return;
        }
        if (!MWInstrument.isRelated(this.getInstrument(), mWOrder.getAcctInstrument())) {
            return;
        }
        this.resolveOrders();
    }

    @Override
    public void orderFilled(MWOrder mWOrder) {
        if (this.ignore(mWOrder)) {
            return;
        }
        if (mWOrder.isPartiallyFilled()) {
            return;
        }
        if (this.is(mWOrder, this.limitOrder)) {
            this.setLimitOrder(null);
        }
        if (this.is(mWOrder, this.stopTrailOrder)) {
            this.setStopTrailOrder(null);
        }
    }

    @Override
    public void orderModified(MWOrder mWOrder) {
        if (this.ignore(mWOrder)) {
            return;
        }
        if (this.is(mWOrder, this.limitOrder) && !mWOrder.isLimit() || this.is(mWOrder, this.stopTrailOrder) && mWOrder.isLimit()) {
            this.resolveOrders();
        } else if (this.is(mWOrder, this.limitOrder)) {
            this.notify("limitPrice", -99999.0f, mWOrder.getLimitPrice());
            this.notify("limitOrderPL", -99999.0, this.getLimitOrderPL());
        } else if (this.is(mWOrder, this.stopTrailOrder)) {
            this.notify("stopTrailPrice", -99999.0f, mWOrder.getAuxPrice());
            this.notify("stopOrderPL", -99999.0, this.getStopOrderPL());
        } else if (h.a(mWOrder.getSymbol(), new String[]{this.ticker.getSymbolDisplay(), this.ticker.getSymbol()})) {
            this.resolveOrders();
        }
    }

    @Override
    public void orderRejected(MWOrder mWOrder) {
        if (this.ignore(mWOrder)) {
            return;
        }
        if (this.is(mWOrder, this.limitOrder)) {
            this.setLimitOrder(null);
        }
        if (this.is(mWOrder, this.stopTrailOrder)) {
            this.setStopTrailOrder(null);
        }
    }

    @Override
    public void orderRemoved(MWOrder mWOrder) {
        if (this.ignore(mWOrder)) {
            return;
        }
        if (this.is(mWOrder, this.limitOrder)) {
            this.setLimitOrder(null);
        }
        if (this.is(mWOrder, this.stopTrailOrder)) {
            this.setStopTrailOrder(null);
        }
    }

    private boolean ignore(MWOrder mWOrder) {
        return mWOrder == null || !h.a((Object)mWOrder.getAccountId(), (Object)this.getAccountId()) || !h.a((Object)mWOrder.getInstrument(), (Object)this.getInstrument());
    }

    @Override
    public void removeAllOrders() {
        this.setLimitOrder(null);
        this.setStopTrailOrder(null);
    }
}

