/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import cf.gf;
import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.util.aa;
import com.motivewave.common.util.g;
import com.motivewave.common.util.j;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.OrderAction$ActionType;
import com.motivewave.platform.databean.OrderAction$TriggerType;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.Settings;
import com.motivewave.platform.databean.Settings$Definition;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.bg;
import com.motivewave.platform.databean.bh;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.ui.console.Console;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javafx.stage.Stage;
import o.c;
import org.json.JSONArray;
import org.json.JSONObject;

public class OrderAction
extends Settings
implements PropertyChangeListener,
c {
    private Ticker ticker;
    private static Settings$Definition def = new bg();
    private static g all = new g();

    private OrderAction() {
    }

    public OrderAction(OrderAction$ActionType orderAction$ActionType, MWOrder mWOrder, float f2, float f3) {
        this.set("type", (Object)orderAction$ActionType);
        this.set("instr", mWOrder.getInstrument());
        this.set("orderId", mWOrder.getOrderId());
        this.set("replay", mWOrder.isReplay());
        this.set("trigger", (Object)(mWOrder.isBuy() ? OrderAction$TriggerType.ASK : OrderAction$TriggerType.BID));
        this.set("triggerValue", Float.valueOf(f2));
        this.set("targetValue", Float.valueOf(f3));
        this.set("gte", !mWOrder.isBuy());
        this.set("created", bs.a());
    }

    public void activate(Ticker ticker) {
        this.ticker = ticker;
        this.set("instr", ticker.getInstrument());
        ticker.addPropertyChangeListener(this);
        OrderDirectory.addListener(this);
        all.a((Object)this);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
        OrderDirectory.removeListener(this);
        all.a((Object)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        OrderAction$TriggerType orderAction$TriggerType = (OrderAction$TriggerType)((Object)this.get("trigger"));
        if (orderAction$TriggerType == OrderAction$TriggerType.BID && propertyChangeEvent.getPropertyName() != "bidPrice") {
            return;
        }
        if (orderAction$TriggerType == OrderAction$TriggerType.ASK && propertyChangeEvent.getPropertyName() != "askPrice") {
            return;
        }
        if (orderAction$TriggerType == OrderAction$TriggerType.LAST && propertyChangeEvent.getPropertyName() != "lastPrice") {
            return;
        }
        float f2 = h.a(propertyChangeEvent.getNewValue());
        float f3 = ((Float)this.get("triggerValue")).floatValue();
        if (this.get("type") == OrderAction$ActionType.BREAK_EVEN) {
            boolean bl2 = this.is("gte");
            if (bl2 && f2 < f3 || !bl2 && f2 > f3) {
                return;
            }
            MWOrder mWOrder = OrderDirectory.findOrder((String)this.get("orderId"));
            if (mWOrder == null) {
                return;
            }
            if (mWOrder.isActive()) {
                float f4 = ((Float)this.get("targetValue")).floatValue();
                h.a.info("OrderAction::propertyChange() moving stop/trail: " + mWOrder.getOrderId() + " to break even: " + f4);
                if (mWOrder.isNew()) {
                    h.a.info("OrderAction::propertyChange() unable to move stop/trail order is in new state!");
                } else {
                    if (mWOrder.isStop()) {
                        mWOrder.setAdjustedAuxPrice(f4);
                    } else if (mWOrder.isTrail()) {
                        mWOrder.setAdjustedTrailPrice(f4);
                    } else {
                        mWOrder.setLimitPrice(f4);
                    }
                    Stage stage = UIUtil.a();
                    if (!(stage instanceof gf)) {
                        stage = Console.a();
                    }
                    bs.c(mWOrder, (gf)stage);
                }
            }
            this.destroy();
        }
    }

    @Override
    public void orderCancelled(MWOrder mWOrder) {
        if (this.is(mWOrder)) {
            this.destroy();
        }
    }

    @Override
    public void orderRejected(MWOrder mWOrder) {
        if (this.is(mWOrder)) {
            this.destroy();
        }
    }

    @Override
    public void orderRemoved(MWOrder mWOrder) {
        if (this.is(mWOrder)) {
            this.destroy();
        }
    }

    @Override
    public void orderFilled(MWOrder mWOrder) {
        if (this.is(mWOrder)) {
            this.destroy();
        }
    }

    @Override
    public void orderIdChanged(String string, String string2) {
        if (h.a((Object)string, this.get("orderId"))) {
            this.set("orderId", string2);
        }
    }

    private boolean is(MWOrder mWOrder) {
        return mWOrder != null && h.a((Object)mWOrder.getOrderId(), this.get("orderId"));
    }

    @Override
    public Settings$Definition getDefinition() {
        return def;
    }

    public static void validate() {
        for (OrderAction orderAction : all.a()) {
            MWOrder mWOrder = OrderDirectory.findOrder((String)orderAction.get("orderId"));
            if (mWOrder == null) {
                if (bs.a() - (Long)orderAction.get("created", 0L) <= 259200000L) continue;
                orderAction.destroy();
                continue;
            }
            if (mWOrder.isActive()) continue;
            orderAction.destroy();
        }
    }

    public static void read() {
        all.b();
        File file = Workspace.findFile("order_actions");
        String string = h.c(file);
        if (h.g(string)) {
            return;
        }
        try {
            j j2;
            ArrayList<OrderAction> arrayList = new ArrayList<OrderAction>();
            JSONArray jSONArray = new JSONArray(string);
            for (aa aa2 : jSONArray.asObjList()) {
                j2 = new OrderAction();
                j2.fromJSON((JSONObject)aa2);
                arrayList.add((OrderAction)j2);
            }
            all.d(arrayList);
            for (aa aa2 : all.a()) {
                j2 = LiveTicker.get((MWInstrument)((Settings)aa2).get("instr"));
                if (j2 == null) continue;
                ((OrderAction)aa2).activate((Ticker)j2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void saveAll() {
        ArrayList<OrderAction> arrayList = new ArrayList<OrderAction>();
        for (OrderAction orderAction : all.a()) {
            if (orderAction.is("replay")) continue;
            arrayList.add(orderAction);
        }
        h.c(new File(bs.a().getConfigDir(), "order_actions.json"), new bh().b(arrayList));
    }
}

