/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.a;
import com.motivewave.platform.databean.NewsFilter;
import com.motivewave.platform.databean.ObservableBean;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class News
extends ObservableBean
implements Comparable {
    private String storyId;
    private String headline;
    private String symbols;
    private String keywords;
    private String source;
    private String url;
    private long released;
    private long updated = 0L;
    private boolean viewed = false;
    private Enums$ServiceType service;

    public static News fromCSV(String string, Map map) {
        List list = a.a(string);
        if (h.a((Collection)list)) {
            return null;
        }
        News news = new News();
        news.storyId = (String)list.get(0);
        news.source = a.a((String)list.get(1), map);
        news.headline = (String)list.get(2);
        news.url = (String)list.get(3);
        news.keywords = (String)list.get(4);
        news.symbols = (String)list.get(5);
        news.viewed = a.a((String)list.get(6));
        news.released = a.a((String)list.get(7));
        news.updated = a.a((String)list.get(8));
        news.service = Enums$ServiceType.read(a.a((String)list.get(9), map));
        return news;
    }

    public static void toCSV(News news, Map map, PrintWriter printWriter) {
        a.a(printWriter, news.storyId, a.a(news.source, map), news.headline, news.url, news.keywords, news.symbols, news.viewed, news.released, news.updated, a.a(news.service == null ? "" : news.service.name(), map));
    }

    public static int addIds(News news, Map map, int n2) {
        n2 = a.a(news.source, map, n2);
        String string = news.service == null ? "" : news.service.name();
        return a.a(string, map, n2);
    }

    private News() {
    }

    public News(String string, String string2, String string3, String string4, String string5, String string6, long l2, Enums$ServiceType enums$ServiceType) {
        this.storyId = string;
        this.headline = string3;
        this.released = l2;
        this.source = string2;
        this.url = string4;
        this.keywords = string5;
        this.viewed = false;
        this.service = enums$ServiceType;
        this.addSymbols(string6);
        this.addSymbols(string5);
    }

    public boolean matches(NewsFilter newsFilter) {
        long l2;
        if (newsFilter == null || newsFilter.isEmpty()) {
            return true;
        }
        long l3 = l2 = this.updated > this.released ? this.updated : this.released;
        if (newsFilter.getSince() > l2) {
            return false;
        }
        if (!h.a(newsFilter.getSymbols())) {
            boolean bl2 = false;
            for (String string : newsFilter.getSymbols()) {
                if (this.symbols == null || this.symbols.indexOf(string) < 0) continue;
                bl2 = true;
            }
            if (!bl2) {
                return false;
            }
        }
        if (!h.g(newsFilter.getSearchText())) {
            if (h.g(this.headline)) {
                return false;
            }
            if (h.b(this.headline, newsFilter.getSearchText()) < 0) {
                return false;
            }
        }
        return true;
    }

    public int compareTo(News news) {
        if (this == news) {
            return 0;
        }
        long l2 = h.b(this.released, this.updated);
        long l3 = h.b(news.released, news.updated);
        if (l3 > l2) {
            return 1;
        }
        if (l3 < l2) {
            return -1;
        }
        return this.headline.compareTo(news.headline);
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "headline": {
                return this.getHeadline();
            }
            case "storyId": {
                return this.getStoryId();
            }
            case "keywords": {
                return this.getKeywords();
            }
            case "released": {
                return this.getReleased() <= 0L ? "" : h.a(this.getReleased(), "yyyy-MM-dd HH:mm z");
            }
            case "source": {
                return this.getSource();
            }
            case "symbols": {
                return h.b((Object)this.symbols);
            }
            case "updated": {
                return this.getUpdated() <= 0L ? "" : h.a(this.getUpdated(), "yyyy-MM-dd HH:mm z");
            }
            case "url": {
                return this.getUrl();
            }
            case "viewed": {
                return this.isViewed() ? "Y" : "N";
            }
        }
        return h.b(this.getProperty(string));
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "headline": {
                return this.getHeadline();
            }
            case "storyId": {
                return this.getStoryId();
            }
            case "keywords": {
                return this.getKeywords();
            }
            case "released": {
                return this.getReleased();
            }
            case "source": {
                return this.getSource();
            }
            case "symbols": {
                return this.symbols;
            }
            case "updated": {
                return this.getUpdated();
            }
            case "url": {
                return this.getUrl();
            }
            case "viewed": {
                return this.isViewed();
            }
        }
        return super.getProperty(string);
    }

    public String getStoryId() {
        return this.storyId;
    }

    public String getHeadline() {
        return this.headline;
    }

    void setHeadline(String string) {
        String string2 = string;
        this.headline = string;
        this.notify("headline", string2, string);
    }

    public long getReleased() {
        return this.released;
    }

    public long getUpdated() {
        return this.updated;
    }

    public void setUpdated(long l2) {
        long l3 = this.updated;
        this.updated = l2;
        this.notify("released", l3, this.updated);
    }

    public String getSource() {
        return this.source;
    }

    void setSource(String string) {
        String string2 = string;
        this.source = string;
        this.notify("source", string2, string);
    }

    public String getUrl() {
        return this.url;
    }

    void setUrl(String string) {
        String string2 = string;
        this.url = string;
        this.notify("url", string2, string);
    }

    public String getKeywords() {
        return this.keywords;
    }

    void setKeywords(String string) {
        String string2 = string;
        this.keywords = string;
        this.notify("keywords", string2, string);
    }

    public Enums$ServiceType getService() {
        return this.service;
    }

    public boolean isViewed() {
        return this.viewed;
    }

    public void setViewed(boolean bl2) {
        boolean bl3 = this.viewed;
        this.viewed = bl2;
        this.notify("viewed", bl3, this.viewed);
    }

    void addSymbols(String string) {
        if (h.g(string)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.symbols == null) {
            this.symbols = "";
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (h.g(string2) || this.symbols.indexOf(string2) >= 0 || string2.indexOf(37) >= 0 || h.a(string2, new String[]{"*HOT*", "*ALL*"}) || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        for (String string3 : arrayList) {
            if (!h.g(this.symbols)) {
                this.symbols = this.symbols + "|";
            }
            this.symbols = this.symbols + string3;
        }
    }

    public boolean containsSymbol(String string) {
        if (h.g(this.symbols)) {
            return false;
        }
        return this.symbols.indexOf(string) >= 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            News news = (News)object;
            if (!h.g(this.url)) {
                return h.a((Object)this.url, (Object)news.url);
            }
            if (!h.g(this.storyId)) {
                return h.a((Object)this.storyId, (Object)news.storyId);
            }
            if (!h.g(this.headline)) {
                return h.a((Object)this.headline, (Object)news.headline) && h.a((Object)this.symbols, (Object)news.symbols);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

