/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import at.g;
import com.motivewave.common.e;
import com.motivewave.common.h;
import com.motivewave.common.util.j;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$OrderExpiry;
import com.motivewave.platform.common.Enums$OrderStatus;
import com.motivewave.platform.common.Enums$OrderType;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.Enums$TIF;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.ag;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.w;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.ExitStep;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder$OnFilled;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.OrderPreset;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.PositionSummary;
import com.motivewave.platform.databean.Positions;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.ba;
import com.motivewave.platform.databean.bb;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.by;
import com.motivewave.platform.service.cd;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import k.v;
import o.c;
import org.json.JSONObject;
import org.w3c.dom.Element;

public class MWOrder
extends ObservableBean
implements w,
PropertyChangeListener,
c {
    boolean removed = false;
    private boolean cancelReplaceInProgress = false;
    private MWInstrument acctInstr;
    private String accountId;
    private Position position;
    private PositionSummary positionSummary;
    private Enums$OrderType orderType;
    private float quantity;
    private float maxShowQty;
    private boolean maxShowQtyEnabled = false;
    private float limitPrice;
    private float auxPrice;
    private float trailStopPrice = 0.0f;
    private float parentOffset = 0.0f;
    private float lastMktPrice = 0.0f;
    private float lastTriggerPrice = 0.0f;
    private Enums$TIF tif;
    private boolean usePips = false;
    private Float adjustedQuantity = null;
    private Float adjustedMaxShowQty = null;
    private Boolean adjustedMaxShowQtyEnabled = null;
    private Float adjustedLimitPrice = null;
    private Float adjustedAuxPrice = null;
    private Boolean adjustedUsePips = null;
    private Enums$TIF adjustedTif = null;
    private Boolean adjustedOutsideRTH = null;
    private Date adjustedGTD = null;
    private boolean adjusted = false;
    private Enums$OrderAction action;
    private String permanentId = h.a();
    private String orderId;
    private String exchOrderId;
    private String origOrderId;
    private String parentId;
    private Color groupColor;
    private com.motivewave.common.util.g childOrders = new com.motivewave.common.util.g();
    private boolean forceClientAttached = false;
    private String clientId;
    private int ibOrderId;
    private String ocaId;
    private boolean outsideRTH = true;
    private Ticker ticker;
    private String tag;
    private String ticket;
    private float positionInQueue = -1.0f;
    private float estPositionInQueue = -1.0f;
    private Enums$OrderStatus status;
    private float filled = 0.0f;
    private float remaining = 0.0f;
    private float avgFillPrice = 0.0f;
    private float lastFillPrice = 0.0f;
    private long created = 0L;
    private long lastModified = 0L;
    private long lastFillTime = 0L;
    private String rejectReason;
    private Object rejectCode;
    private Date gTD;
    private Long expiryDate;
    private Long adjustedExpiryDate;
    private Date orderDate;
    private String chainId;
    private String statusCode;
    private String tradeId = "";
    private boolean netClose = false;
    private Boolean entryOrder;
    private String rateId;
    private float rate;
    private float marketRange;
    private boolean useMarketRange;
    private MWOrder stopTrailOrder;
    private MWOrder limitOrder;
    private int trailPoints = 1;
    private Integer adjustedTrailPoints = null;
    private boolean trailFixed = false;
    private Boolean adjustedTrailFixed = null;
    private double commission;
    private cd tradeRoute;
    private String leverage;
    private String sideEffect;
    private int offsetTicks = 0;
    private long lastCommit = 0L;
    private boolean cancelInProgress = false;
    private ExitStep exitStep;
    private boolean waiting = false;
    private String failedMsg = null;
    private boolean simulatedOrder = false;
    private boolean rejected = false;
    private boolean exists = false;
    private boolean updateInProgress = false;
    private boolean ignoreChildUpdate = false;
    private bb handler = null;
    private ba mitHandler = null;
    private com.motivewave.common.util.g onFilledHandlers;

    public MWOrder(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public MWOrder(g g2) {
        this(g2.b(), LiveTicker.byKey(g2.c()), g2.a(), g2.a(), g2.a(), g2.a(), 0.0f, g2.a());
        this.updateFrom(g2);
        this.orderId = g2.a();
        this.setStatus(g2.a());
    }

    public MWOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$OrderType enums$OrderType) {
        this(string, OrderDirectory.getNextOrderId(), ticker, enums$OrderAction, enums$OrderType, Enums$OrderStatus.NEW);
    }

    public MWOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$OrderType enums$OrderType, Enums$OrderStatus enums$OrderStatus) {
        this(string, OrderDirectory.getNextOrderId(), ticker, enums$OrderAction, enums$OrderType, enums$OrderStatus);
    }

    public MWOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$OrderType enums$OrderType, float f2, Enums$TIF enums$TIF, float f3, Enums$OrderStatus enums$OrderStatus) {
        this(string, OrderDirectory.getNextOrderId(), ticker, enums$OrderAction, enums$OrderType, enums$OrderStatus);
        if (f2 < 0.0f) {
            h.c();
            f2 = Math.abs(f2);
        }
        this.quantity = f2;
        this.tif = enums$TIF;
        if (enums$OrderType.isLimit()) {
            this.limitPrice = f3;
        }
        if (enums$OrderType.isStop() || enums$OrderType.isTrigger()) {
            this.auxPrice = f3;
        }
    }

    public MWOrder(String string, String string2, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$OrderType enums$OrderType, Enums$OrderStatus enums$OrderStatus) {
        ObservableBean observableBean;
        if (h.g(string)) {
            string = bs.b(ticker.getInstrument());
        }
        this.accountId = string;
        this.orderId = string2;
        String string3 = OrderDirectory.getPermId(string2);
        if (string3 != null) {
            this.permanentId = string3;
        }
        this.action = enums$OrderAction;
        Account account = bs.a(string);
        if (!(ticker instanceof LiveTicker) && account != null && !account.isReplay()) {
            ticker = LiveTicker.get(ticker.getInstrument());
        }
        this.ticker = ticker;
        if (account == null) {
            if (bs.O()) {
                h.a.warning("MWOrder() account not found! " + string);
            }
        } else if (account.isReplay()) {
            this.orderId = "RPLY-" + this.orderId;
        } else if (account.isSimulatedAccount()) {
            this.simulatedOrder = true;
        } else {
            observableBean = this.getAcctInstrument();
            if (observableBean != this.getInstrument()) {
                this.ticker = LiveTicker.get((MWInstrument)observableBean);
            }
        }
        this.setType(enums$OrderType);
        this.setStatus(enums$OrderStatus);
        observableBean = ticker.getInstrument().getOrderPreset();
        boolean bl2 = this.outsideRTH = observableBean == null ? true : ((OrderPreset)observableBean).isTriggerOTH();
        if (observableBean != null && !h.g(((OrderPreset)observableBean).getTradeRoute())) {
            for (cd cd2 : this.getTradeRoutes()) {
                if (!h.a((Object)cd2.b(), (Object)((OrderPreset)observableBean).getTradeRoute())) continue;
                this.setTradeRoute(cd2);
            }
        }
        this.orderDate = new Date(bs.a());
        this.addListeners(ticker);
        OrderDirectory.addListener(this);
    }

    public String getFingerprint() {
        Object object = "%s:%s:%s:%s:%s:%f".formatted(this.getInstrument().getKey(), this.getAccountId(), this.orderType.name(), this.getAction().name(), this.tif.name(), Float.valueOf(this.quantity));
        if (this.orderType.isLimit()) {
            object = (String)object + ":%f".formatted(Float.valueOf(this.getLimitPrice()));
        }
        if (this.orderType.isStop()) {
            object = (String)object + ":%f".formatted(Float.valueOf(this.getAuxPrice()));
        }
        return object;
    }

    public void adjustTriggerPrice(float f2) {
        if (this.isMarket() || this.isFilled()) {
            return;
        }
        MWInstrument mWInstrument = this.getAcctInstrument();
        if (this.isAdjustedUsePips()) {
            float f3 = this.getBaseTrailPrice();
            float f4 = h.a((this.isBuy() ? f3 - f2 : f2 - f3) / (float)mWInstrument.getPointSize(), 1);
            if (this.isLimit()) {
                this.setAdjustedLimitPrice(f4);
            } else {
                this.setAdjustedAuxPrice(f4);
            }
        } else if (this.isTrail() && bs.r(this.getAccount())) {
            this.setAdjustedAuxPrice(this.computeTrailAmount(f2, this));
        } else if (h.a((Object)this.getType(), new Object[]{Enums$OrderType.STPLMT, Enums$OrderType.LIT})) {
            this.setAdjustedLimitPrice(f2);
            this.setAdjustedAuxPrice(f2);
        } else if (this.isLimit()) {
            this.setAdjustedLimitPrice(f2);
        } else {
            this.setAdjustedAuxPrice(f2);
        }
    }

    private float computeTrailAmount(float f2, MWOrder mWOrder) {
        if (mWOrder.isBuy()) {
            return mWOrder.getAuxPrice() + (f2 - mWOrder.getTriggerPrice());
        }
        return mWOrder.getAuxPrice() + (mWOrder.getTriggerPrice() - f2);
    }

    public void updateFrom(g g2) {
        if (g2 == null) {
            return;
        }
        this.discardChanges();
        this.tif = g2.a();
        this.outsideRTH = g2.l();
        this.orderType = g2.a();
        this.accountId = g2.b();
        this.created = g2.a();
        this.action = g2.a();
        this.rejected = g2.j();
        this.rejectCode = g2.p();
        this.rejectReason = g2.o();
        this.parentId = g2.h();
        if (h.g(this.ocaId) || !h.g(g2.i())) {
            this.setOCAId(g2.i());
        }
        this.chainId = g2.k();
        this.tradeId = g2.l();
        this.exchOrderId = g2.n();
        this.tag = g2.f();
        this.rejectReason = g2.o();
        this.rejectCode = g2.p();
        this.quantity = g2.a();
        this.filled = g2.b();
        if (this.filled != 0.0f) {
            this.remaining = this.quantity - this.filled;
        }
        this.limitPrice = g2.d();
        this.auxPrice = g2.e();
        this.avgFillPrice = g2.g();
        this.gTD = g2.b() > 0L ? new Date(g2.b()) : null;
        this.lastFillTime = g2.c();
        this.entryOrder = g2.a();
        this.usePips = g2.n();
        if (g2.f() != 0.0f && bs.a(g2.b())) {
            this.auxPrice = g2.f();
            this.setTrailStopPrice(g2.e());
        }
        this.parentOffset = g2.h();
    }

    public List findRelated() {
        MWOrder mWOrder;
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        MWOrder mWOrder2 = this.getLimitOrder();
        if (mWOrder2 != null) {
            arrayList.add(mWOrder2);
        }
        if ((mWOrder = this.getStopTrailOrder()) != null) {
            arrayList.add(mWOrder);
        }
        if (!this.isParentEmpty() || !h.g(this.ocaId)) {
            for (MWOrder mWOrder3 : OrderDirectory.getAllOrders()) {
                if (mWOrder3 == this || !h.a((Object)mWOrder3.getAccountId(), (Object)this.getAccountId())) continue;
                if (!h.g(this.ocaId) && h.a((Object)this.ocaId, (Object)mWOrder3.getOCAId())) {
                    arrayList.add(mWOrder3);
                    continue;
                }
                if (h.g(this.parentId) || !h.a((Object)mWOrder3.getOrderId(), (Object)this.parentId) && !h.a((Object)this.parentId, (Object)mWOrder3.getParentId())) continue;
                arrayList.add(mWOrder3);
            }
        }
        return arrayList;
    }

    public String getServiceName() {
        by by2 = bs.a(this.getAccount());
        if (by2 != null) {
            return by2.a().getType().toString();
        }
        return "";
    }

    public String getConnectionName() {
        by by2 = bs.a(this.getAccount());
        if (by2 != null) {
            return by2.a().getName();
        }
        return "";
    }

    public void copyFrom(MWOrder mWOrder) {
        this.accountId = mWOrder.accountId;
        this.orderType = mWOrder.orderType;
        this.action = mWOrder.action;
        this.adjusted = mWOrder.adjusted;
        this.adjustedUsePips = mWOrder.adjustedUsePips;
        this.adjustedAuxPrice = mWOrder.adjustedAuxPrice;
        this.adjustedExpiryDate = mWOrder.adjustedExpiryDate;
        this.adjustedGTD = mWOrder.adjustedGTD;
        this.adjustedLimitPrice = mWOrder.adjustedLimitPrice;
        this.adjustedOutsideRTH = mWOrder.adjustedOutsideRTH;
        this.adjustedQuantity = mWOrder.adjustedQuantity;
        this.adjustedTif = mWOrder.adjustedTif;
        this.adjustedTrailFixed = mWOrder.adjustedTrailFixed;
        this.adjustedTrailPoints = mWOrder.adjustedTrailPoints;
        this.auxPrice = mWOrder.auxPrice;
        this.parentOffset = mWOrder.parentOffset;
        this.entryOrder = mWOrder.entryOrder;
        this.gTD = mWOrder.gTD;
        this.expiryDate = mWOrder.expiryDate;
        this.limitPrice = mWOrder.limitPrice;
        this.outsideRTH = mWOrder.outsideRTH;
        this.marketRange = mWOrder.marketRange;
        this.netClose = mWOrder.netClose;
        this.quantity = mWOrder.quantity;
        this.maxShowQty = mWOrder.maxShowQty;
        this.maxShowQtyEnabled = mWOrder.maxShowQtyEnabled;
        this.tif = mWOrder.tif;
        this.rate = mWOrder.rate;
        this.rateId = mWOrder.rateId;
        this.trailFixed = mWOrder.trailFixed;
        this.trailPoints = mWOrder.trailPoints;
        this.tradeRoute = mWOrder.tradeRoute;
        this.useMarketRange = mWOrder.useMarketRange;
        this.usePips = mWOrder.usePips;
        this.ticker = mWOrder.ticker;
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (this.handler != null) {
            this.ticker.removeTickListener(this.handler);
        }
        if (this.mitHandler != null) {
            this.ticker.removeTickListener(this.mitHandler);
        }
        this.removeListeners(this.ticker);
        if (!this.removed) {
            OrderDirectory.removeOrder(this);
        }
        OrderDirectory.removeListener(this);
        super.destroy();
    }

    public boolean exists() {
        return this.exists;
    }

    void setExists(boolean bl2) {
        this.exists = bl2;
    }

    public boolean supportsAttachedOrders() {
        MWInstrument mWInstrument = this.getInstrument();
        if (mWInstrument == null) {
            return bs.h(this.getAccount());
        }
        if (mWInstrument.isOption()) {
            return bs.i(this.getAccount());
        }
        return bs.h(this.getAccount());
    }

    public boolean supportsMITOrders() {
        return bs.a(this.getAccount(), this.getInstrument());
    }

    public boolean supportsOTH() {
        by by2 = bs.a(this.getAccount());
        if (by2 == null) {
            return false;
        }
        return by2.a().a(this.getInstrument().getType(), this.getType());
    }

    public boolean isRithmic() {
        by by2 = bs.a(this.getAccount());
        if (by2 == null) {
            return false;
        }
        return by2.l();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (h.a(propertyChangeEvent.getPropertyName(), "lastPrice", "bidPrice", "askPrice")) {
            return;
        }
        if (!this.isTrail() || this.isNew()) {
            return;
        }
        MWOrder mWOrder = this.getParentOrder();
        if (mWOrder != null && mWOrder.isActive()) {
            return;
        }
        float f2 = this.ticker.getLastPrice();
        if (!this.getInstrument().isLevel1PriceSupported()) {
            f2 = this.isBuy() ? this.ticker.getAskPrice() : this.ticker.getBidPrice();
        }
        if (this.lastMktPrice == 0.0f) {
            this.lastMktPrice = f2;
            return;
        }
        if (this.isBuy() && f2 < this.lastMktPrice) {
            this.lastMktPrice = f2;
        } else if (this.isSell() && f2 > this.lastMktPrice) {
            this.lastMktPrice = f2;
        }
    }

    @Override
    public Object getProperty(String string) {
        MWInstrument mWInstrument = this.getAcctInstrument();
        switch (string) {
            case "account": {
                return this.getAccount();
            }
            case "accountID": {
                return this.getAccountId();
            }
            case "accountName": {
                Account account = this.getAccount();
                return account == null ? "" : account.getAccountName();
            }
            case "action": {
                return this.getAction();
            }
            case "positionInQueue": {
                return Float.valueOf(this.getPositionInQueue());
            }
            case "estPositionInQueue": {
                return Float.valueOf(this.getEstPositionInQueue());
            }
            case "adjustedAuxPrice": {
                return Float.valueOf(this.getAdjustedAuxPrice());
            }
            case "adjustedExpiryDate": {
                return this.getAdjustedExpiryDate();
            }
            case "adjustedGTD": {
                return this.getAdjustedGTD();
            }
            case "adjustedLimitPrice": {
                return Float.valueOf(this.getAdjustedLimitPrice());
            }
            case "adjustedQuantity": {
                return Float.valueOf(this.getAdjustedQuantity());
            }
            case "adjustedMaxShowQty": {
                return Float.valueOf(this.getAdjustedMaxShowQty());
            }
            case "adjustedMaxShowQtyEnabled": {
                return this.isAdjustedMaxShowQtyEnabled();
            }
            case "adjustedTif": {
                return this.getAdjustedTif();
            }
            case "adjustedTrailPoints": {
                return this.getAdjustedTrailPoints();
            }
            case "adjustedTrailPrice": {
                return Float.valueOf(this.getAdjustedTrailPrice());
            }
            case "adjustedTriggerPrice": {
                return Float.valueOf(this.getAdjustedTriggerPrice());
            }
            case "auxPrice": {
                return Float.valueOf(this.getAuxPrice());
            }
            case "avgFillPrice": {
                return Float.valueOf(this.getAvgFillPrice());
            }
            case "basePrice": {
                return Float.valueOf(this.getBasePrice());
            }
            case "baseTrailPrice": {
                return Float.valueOf(this.getBaseTrailPrice());
            }
            case "clientId": {
                return this.getClientId();
            }
            case "chainId": {
                return this.getChainId();
            }
            case "commission": {
                return this.getCommission();
            }
            case "currency": {
                return mWInstrument == null ? "" : mWInstrument.getCurrency();
            }
            case "description": {
                return mWInstrument == null ? "" : mWInstrument.getDescription();
            }
            case "destination": 
            case "exchange": 
            case "exchangeSymbol": {
                return mWInstrument == null ? "" : mWInstrument.getExchange();
            }
            case "expiryDate": {
                return this.getExpiryDate();
            }
            case "failedMsg": {
                return this.getFailedMsg();
            }
            case "filled": {
                return Float.valueOf(this.getFilled());
            }
            case "groupColor": {
                return this.getGroupColor();
            }
            case "gTD": 
            case "GTD": {
                return this.getGTD();
            }
            case "iBOrderId": {
                return this.getIBOrderId();
            }
            case "label": {
                return this.getLabel();
            }
            case "lastFillPrice": {
                return Float.valueOf(this.getLastFillPrice());
            }
            case "lastFillTime": {
                return this.getLastFillTime();
            }
            case "limitOrder": {
                return this.getLimitOrder();
            }
            case "limitOrderPL": {
                return this.getLimitOrderPL();
            }
            case "limitPrice": {
                return Float.valueOf(this.getLimitPrice());
            }
            case "marketRange": {
                return Float.valueOf(this.getMarketRange());
            }
            case "mktPrice": {
                return Float.valueOf(this.getMktPrice());
            }
            case "oCAId": {
                return this.getOCAId();
            }
            case "orderDate": {
                return this.getOrderDate();
            }
            case "orderId": {
                return this.getOrderId();
            }
            case "orderPL": {
                return this.getOrderPL();
            }
            case "position": {
                return this.getPosition();
            }
            case "orderPrice": {
                return Float.valueOf(this.getOrderPrice());
            }
            case "origOrderId": {
                return this.getOrigOrderId();
            }
            case "parentId": {
                return this.getParentId();
            }
            case "parentOrder": {
                return this.getParentOrder();
            }
            case "permanentId": {
                return this.getPermanentId();
            }
            case "qualifiedSymbol": {
                if (mWInstrument == null || h.g(mWInstrument.getExchange())) {
                    return this.getSymbol();
                }
                return mWInstrument.getSymbol() + "." + mWInstrument.getExchange();
            }
            case "quantity": {
                return Float.valueOf(this.getQuantity());
            }
            case "maxShowQty": {
                return Float.valueOf(this.getMaxShowQty());
            }
            case "maxShowQtyEnabled": {
                return this.isMaxShowQtyEnabled();
            }
            case "rate": {
                return Float.valueOf(this.getRate());
            }
            case "rateId": {
                return this.getRateId();
            }
            case "rejectCode": {
                return this.getRejectCode();
            }
            case "rejectReason": {
                return this.getRejectReason();
            }
            case "remaining": {
                return Float.valueOf(this.getRemaining());
            }
            case "status": {
                return this.getStatus();
            }
            case "statusCode": {
                return this.getStatusCode();
            }
            case "stopOrderPL": {
                return this.getStopOrderPL();
            }
            case "stopTrailOrder": {
                return this.getStopTrailOrder();
            }
            case "stopTrailOrderPrice": {
                return Float.valueOf(this.getStopTrailOrderPrice());
            }
            case "limitOrderPrice": {
                return Float.valueOf(this.getLimitOrderPrice());
            }
            case "symbol": {
                return this.getSymbol();
            }
            case "symbolDisplay": {
                return mWInstrument == null ? "" : mWInstrument.getSymbolDisplay();
            }
            case "symbolDisplay2": {
                return mWInstrument == null ? "" : mWInstrument.getSymbolDisplay();
            }
            case "tag": {
                return this.getTag();
            }
            case "tif": {
                return this.getTif();
            }
            case "tradeId": {
                return this.getTradeId();
            }
            case "trailPoints": {
                return this.getTrailPoints();
            }
            case "trailPrice": {
                return Float.valueOf(this.getTrailPrice());
            }
            case "trailStopPrice": {
                return Float.valueOf(this.getTrailStopPrice());
            }
            case "triggerPrice": {
                return Float.valueOf(this.getTriggerPrice());
            }
            case "type": {
                return this.getType();
            }
            case "ticker": {
                return this.getTicker();
            }
            case "underlying": {
                return mWInstrument == null ? "" : mWInstrument.getUnderlying();
            }
            case "tradeRoute": {
                return this.getTradeRoute();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "askPrice": 
            case "bidPrice": 
            case "lastPrice": 
            case "midpoint": 
            case "high": 
            case "low": {
                return this.ticker.getProperty(string);
            }
            case "ticket": {
                return this.getTicket();
            }
            case "adjustedExpires": {
                return this.getAdjustedExpires();
            }
        }
        return super.getProperty(string);
    }

    @Override
    public String format(String string) {
        float f2 = 0.0f;
        if (this.ticker == null) {
            return "";
        }
        switch (string) {
            case "accountName": {
                Account account = this.getAccount();
                return account == null ? "" : account.getDisplayName();
            }
            case "orderPrice": {
                float f3 = this.getOrderPrice();
                if (!this.getAcctInstrument().isValueValid(f3) || this.isMarket()) {
                    return "";
                }
                return this.getAcctInstrument().formatValue(f3);
            }
            case "stopTrailOrderPrice": {
                if (this.stopTrailOrder == null || this.isFilled()) {
                    return "";
                }
                f2 = this.getStopTrailOrderPrice();
                if (this.stopTrailOrder.isUsePips()) {
                    return h.c((double)f2, 1);
                }
                if (!this.getAcctInstrument().isValueValid(f2)) {
                    return "";
                }
                return this.getAcctInstrument().formatValue(f2);
            }
            case "limitOrderPrice": {
                if (this.limitOrder == null || this.isFilled()) {
                    return "";
                }
                f2 = this.getLimitOrderPrice();
                if (this.limitOrder.isUsePips()) {
                    return h.c((double)f2, 1);
                }
                if (!this.getAcctInstrument().isValueValid(f2)) {
                    return "";
                }
                return this.getAcctInstrument().formatValue(f2);
            }
            case "triggerPrice": {
                f2 = this.getTriggerPrice();
                if (!this.getAcctInstrument().isValueValid(f2)) {
                    return "";
                }
                return this.getAcctInstrument().formatValue(f2);
            }
            case "adjustedTriggerPrice": {
                f2 = this.getAdjustedTriggerPrice();
                if (!this.getAcctInstrument().isValueValid(f2)) {
                    return "";
                }
                return this.getAcctInstrument().formatValue(f2);
            }
            case "positionInQueue": {
                return this.positionInQueue < 0.0f ? "" : ab.a(this.positionInQueue);
            }
            case "estPositionInQueue": {
                return this.estPositionInQueue < 0.0f ? "" : ab.a(this.estPositionInQueue);
            }
            case "quantity": {
                float f4 = this.getQuantity();
                if (this.getRemaining() > 0.0f) {
                    f4 = this.getRemaining();
                }
                return ab.b(Math.abs(f4), this.getAcctInstrument());
            }
            case "remaining": {
                return ab.b(Math.abs(this.getRemaining()), this.getAcctInstrument());
            }
            case "filled": {
                float f5 = this.getFilled();
                if (f5 == 0.0f) {
                    return "";
                }
                return ab.b(f5, this.getAcctInstrument());
            }
            case "adjustedQuantity": {
                return ab.b(Math.abs(this.getAdjustedQuantity()), this.getAcctInstrument());
            }
            case "adjustedMaxShowQty": {
                return ab.b(Math.abs(this.getAdjustedMaxShowQty()), this.getAcctInstrument());
            }
            case "maxShowQty": {
                return ab.b(Math.abs(this.getMaxShowQty()), this.getAcctInstrument());
            }
            case "orderId": {
                return h.b((Object)this.getOrderId());
            }
            case "tradeId": {
                return h.b((Object)this.getTradeId());
            }
            case "chainId": {
                return h.b((Object)this.getChainId());
            }
            case "orderDate": {
                if (this.orderDate == null) {
                    return "";
                }
                return ab.a(this.orderDate.getTime(), b.b());
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "expiryDate": {
                return h.a(this.getExpiryDate(), b.b());
            }
            case "adjustedExpiryDate": {
                return h.a(this.getAdjustedExpiryDate(), b.b());
            }
            case "adjustedExpires": {
                if (bs.B(this.getAccount())) {
                    return h.a(this.getAdjustedExpiryDate(), b.b());
                }
                if (this.getAdjustedTif() == null) {
                    return "";
                }
                return this.getAdjustedTif().toString();
            }
            case "tradeRoute": {
                if (this.getTradeRoute() == null) {
                    return "";
                }
                return this.getTradeRoute().b();
            }
            case "low": 
            case "high": {
                return this.ticker.format(string);
            }
            case "symbolDisplay": {
                return this.ticker.getInstrument().getSymbolDisplay();
            }
            case "underlying": {
                return this.ticker.getInstrument().getUnderlying();
            }
            case "currency": {
                return h.b((Object)this.ticker.getInstrument().getCurrency());
            }
            case "exchange": {
                return h.b((Object)this.ticker.getInstrument().getExchange());
            }
            case "symbolDisplay2": {
                return this.ticker.getInstrument().getSymbolDisplay();
            }
            case "commission": {
                return this.getCommission() == 0.0 ? "" : ab.a(this.getCommission());
            }
            case "limitPrice": 
            case "auxPrice": {
                if (this.isUsePips()) {
                    return this.formatPips(h.a(this.getProperty(string)));
                }
                return this.formatValue(h.a(this.getProperty(string)));
            }
            case "adjustedLimitPrice": 
            case "adjustedAuxPrice": {
                if (this.isAdjustedUsePips()) {
                    return this.formatPips(h.a(this.getProperty(string)));
                }
                return this.formatValue(h.a(this.getProperty(string)));
            }
            case "stopOrderPL": 
            case "limitOrderPL": 
            case "orderPL": {
                if (this.isFilled()) {
                    return "";
                }
                return this.formatPL(h.a(this.getProperty(string)));
            }
            case "avgFillPrice": 
            case "lastFillPrice": {
                return this.formatValue(h.a(this.getProperty(string)));
            }
            case "groupColor": {
                return "";
            }
            case "lastFillTime": {
                return this.lastFillTime == 0L ? "" : ab.a(this.lastFillTime, b.b());
            }
        }
        Object object = this.getProperty(string);
        if (object == null) {
            return "";
        }
        return h.b(object);
    }

    private String formatPips(float f2) {
        return f2 == 0.0f ? "" : h.b(f2, 1);
    }

    private String formatValue(float f2) {
        if (!this.getAcctInstrument().isValueValid(f2)) {
            return "";
        }
        return this.getAcctInstrument().formatValue(f2);
    }

    private String formatPL(double d2) {
        return d2 == 0.0 ? "" : ab.a(d2);
    }

    public void setLastMktPrice(float f2) {
        this.lastMktPrice = f2;
    }

    public String getExchOrderId() {
        return this.exchOrderId;
    }

    public void setExchOrderId(String string) {
        this.exchOrderId = string;
    }

    public float getPositionInQueue() {
        return this.positionInQueue;
    }

    public void setPositionInQueue(float f2) {
        if (f2 == this.positionInQueue) {
            return;
        }
        float f3 = this.positionInQueue;
        this.positionInQueue = f2;
        this.notify("positionInQueue", f3, this.positionInQueue);
    }

    public float getEstPositionInQueue() {
        return this.estPositionInQueue;
    }

    public void setEstPositionInQueue(float f2) {
        if (f2 == this.estPositionInQueue) {
            return;
        }
        float f3 = this.estPositionInQueue;
        this.estPositionInQueue = f2;
        this.notify("estPositionInQueue", f3, this.estPositionInQueue);
    }

    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(long l2) {
        this.setOrderDate(l2 == 0L ? null : new Date(l2));
    }

    public void setOrderDate(Date date) {
        Date date2 = this.orderDate;
        this.orderDate = date;
        this.notify("orderDate", date2, this.orderDate);
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String string) {
        String string2 = this.statusCode;
        this.statusCode = string;
        this.notify("statusCode", string2, this.statusCode);
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public void setTradeId(String string) {
        String string2 = this.tradeId;
        this.tradeId = string;
        this.notify("tradeId", string2, this.tradeId);
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String string) {
        String string2 = this.chainId;
        this.chainId = string;
        this.notify("chainId", string2, this.chainId);
    }

    public float getMktPrice() {
        if (this.ticker.getLastPrice() > 0.0f) {
            return this.ticker.getLastPrice();
        }
        if (this.isBuy()) {
            if (this.ticker.getAskPrice() > 0.0f) {
                return this.ticker.getAskPrice();
            }
            if (this.ticker.getBidPrice() > 0.0f) {
                return this.ticker.getBidPrice();
            }
            return this.ticker.getMidOrLast();
        }
        if (this.ticker.getBidPrice() > 0.0f) {
            return this.ticker.getBidPrice();
        }
        if (this.ticker.getAskPrice() > 0.0f) {
            return this.ticker.getAskPrice();
        }
        return this.ticker.getMidOrLast();
    }

    public float getTrailOffsetAmount() {
        return Math.abs(this.getBasePrice() - this.getTriggerPrice());
    }

    public float getBasePrice() {
        if (this.isStopOrTrail()) {
            MWOrder mWOrder = this.getParentOrder();
            float f2 = 0.0f;
            f2 = mWOrder == null || mWOrder.getStatus() == Enums$OrderStatus.FILLED ? this.getMktPrice() : (mWOrder.isLimit() ? mWOrder.getLimitPrice() : (mWOrder.isTrail() ? mWOrder.getTrailPrice() : mWOrder.getAuxPrice()));
            return f2;
        }
        return 0.0f;
    }

    public float getTriggerPrice() {
        if (this.getType() == Enums$OrderType.MIT || this.getType() == Enums$OrderType.LIT) {
            return this.isNew() ? this.getAdjustedAuxPrice() : this.getAuxPrice();
        }
        boolean bl2 = this.isNew() ? this.isAdjustedUsePips() : this.isUsePips();
        float f2 = this.ticker.getMidOrLast();
        if (this.isLimit()) {
            float f3;
            float f4 = f3 = this.isNew() ? this.getAdjustedLimitPrice() : this.getLimitPrice();
            if (bl2) {
                float f5;
                f3 = (float)((double)f3 * this.getAcctInstrument().getPointSize());
                MWOrder mWOrder = this.getParentOrder();
                if (mWOrder == null) {
                    return f2 + f3;
                }
                float f6 = f5 = mWOrder.isFilled() ? mWOrder.getLastFillPrice() : mWOrder.getTriggerPrice();
                if (mWOrder.isBuy()) {
                    return f3 + f5;
                }
                return f5 - f3;
            }
            return f3;
        }
        if (this.isStop()) {
            float f7;
            float f8 = f7 = this.isNew() ? this.getAdjustedAuxPrice() : this.getAuxPrice();
            if (bl2) {
                float f9;
                f7 = (float)((double)f7 * this.getAcctInstrument().getPointSize());
                MWOrder mWOrder = this.getParentOrder();
                if (mWOrder == null) {
                    return f2 + f7;
                }
                float f10 = f9 = mWOrder.isFilled() ? mWOrder.getLastFillPrice() : mWOrder.getTriggerPrice();
                if (mWOrder.isBuy()) {
                    return f7 + f9;
                }
                return f9 - f7;
            }
            return f7;
        }
        boolean bl3 = bs.a(this.getAccount());
        if (this.isTrail()) {
            if (bl3 && !bl2) {
                return this.getAuxPrice();
            }
            MWOrder mWOrder = this.getParentOrder();
            if ((mWOrder == null || !mWOrder.isActive() && !mWOrder.isCancelled()) && this.trailStopPrice > 0.0f) {
                return this.trailStopPrice;
            }
            float f11 = Math.abs(this.isNew() ? this.getAdjustedAuxPrice() : this.getAuxPrice());
            if (bs.s(this.getAccount())) {
                return f11;
            }
            if (bl2) {
                f11 = (float)((double)f11 * this.getAcctInstrument().getPointSize());
            }
            float f12 = this.getBaseTrailPrice();
            float f13 = this.isSell() ? this.round(f12 - f11) : this.round(f12 + f11);
            return f13;
        }
        if (this.isMarket()) {
            if (this.isFilled()) {
                return this.getLastFillPrice();
            }
            return this.getMktPrice();
        }
        if (bl3 && !bl2) {
            return this.isNew() ? this.getAdjustedAuxPrice() : this.getAuxPrice();
        }
        return this.isNew() ? this.getAdjustedTrailPrice() : this.getTrailPrice();
    }

    public float getAdjustedTriggerPrice() {
        this.lastTriggerPrice = this._getAdjustedTriggerPrice();
        return this.lastTriggerPrice;
    }

    private float _getAdjustedTriggerPrice() {
        if (h.a((Object)this.getType(), new Object[]{Enums$OrderType.MIT, Enums$OrderType.LIT})) {
            return this.getAdjustedAuxPrice();
        }
        float f2 = this.ticker.getMidOrLast();
        if (this.isLimit()) {
            float f3 = this.getAdjustedLimitPrice();
            if (this.isAdjustedUsePips()) {
                float f4;
                f3 = (float)((double)f3 * this.getAcctInstrument().getPointSize());
                MWOrder mWOrder = this.getParentOrder();
                if (mWOrder == null) {
                    if (this.lastTriggerPrice != 0.0f) {
                        return this.lastTriggerPrice;
                    }
                    return f2 + f3;
                }
                float f5 = f4 = mWOrder.isFilled() ? mWOrder.getLastFillPrice() : mWOrder.getTriggerPrice();
                if (mWOrder.isBuy()) {
                    return f3 + f4;
                }
                return f4 - f3;
            }
            return f3;
        }
        if (this.isStop()) {
            float f6 = this.getAdjustedAuxPrice();
            if (this.isAdjustedUsePips()) {
                float f7;
                f6 = (float)((double)f6 * this.getAcctInstrument().getPointSize());
                MWOrder mWOrder = this.getParentOrder();
                if (mWOrder == null) {
                    if (this.lastTriggerPrice != 0.0f) {
                        return this.lastTriggerPrice;
                    }
                    return f2 + f6;
                }
                float f8 = f7 = mWOrder.isFilled() ? mWOrder.getLastFillPrice() : mWOrder.getTriggerPrice();
                if (mWOrder.isBuy()) {
                    return f6 + f7;
                }
                return f7 - f6;
            }
            return f6;
        }
        boolean bl2 = bs.a(this.getAccount());
        if (this.isTrail()) {
            float f9;
            MWOrder mWOrder = this.getParentOrder();
            if (!this.isAdjusted()) {
                return this.getTriggerPrice();
            }
            if (bl2 && !this.isAdjustedUsePips()) {
                return this.getAdjustedAuxPrice();
            }
            float f10 = Math.abs(this.getAdjustedAuxPrice());
            float f11 = this.getBaseTrailPrice();
            if (this.isAdjustedUsePips()) {
                f10 = (float)((double)f10 * this.getAcctInstrument().getPointSize());
                if (this.trailStopPrice > 0.0f) {
                    f9 = Math.abs((float)((double)this.getAuxPrice() * this.getAcctInstrument().getPointSize()));
                    f11 = this.isSell() ? this.trailStopPrice + f9 : this.trailStopPrice - f9;
                }
            } else if (this.trailStopPrice > 0.0f && (mWOrder == null || mWOrder.isFilled())) {
                f9 = Math.abs(this.getAuxPrice());
                float f12 = f11 = this.isSell() ? this.trailStopPrice + f9 : this.trailStopPrice - f9;
            }
            if (bs.s(this.getAccount())) {
                return f10;
            }
            f9 = this.isSell() ? this.round(f11 - f10) : this.round(f11 + f10);
            return f9;
        }
        if (this.isMarket()) {
            if (this.isFilled()) {
                return this.getLastFillPrice();
            }
            return this.getMktPrice();
        }
        if (bl2 && !this.isAdjustedUsePips()) {
            return this.getAdjustedAuxPrice();
        }
        return this.getAdjustedTrailPrice();
    }

    private void removeListeners(Ticker ticker) {
        if (ticker == null) {
            return;
        }
        ticker.removePropertyChangeListener(this);
    }

    private void addListeners(Ticker ticker) {
        if (ticker == null) {
            return;
        }
        ticker.addPropertyChangeListener(this);
    }

    public MWInstrument getAcctInstrument() {
        if (this.acctInstr != null) {
            return this.acctInstr;
        }
        if (this.ticker == null) {
            return null;
        }
        MWInstrument mWInstrument = this.ticker.getInstrument();
        if (mWInstrument == null) {
            return mWInstrument;
        }
        this.acctInstr = mWInstrument.getAcctInstrument(this.getAccount());
        return this.acctInstr;
    }

    public boolean isInstrument(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return false;
        }
        return this.getInstrument() == mWInstrument || this.getAcctInstrument() == mWInstrument;
    }

    public MWInstrument getInstrument() {
        return this.ticker == null ? null : this.ticker.getInstrument();
    }

    public void setInstrument(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return;
        }
        this.removeListeners(this.ticker);
        this.ticker = LiveTicker.get(mWInstrument);
        boolean bl2 = true;
        OrderPreset orderPreset = null;
        if (this.ticker != null) {
            orderPreset = this.ticker.getInstrument().getOrderPreset();
        }
        if (orderPreset != null) {
            bl2 = orderPreset.isTriggerOTH();
        }
        this.outsideRTH = bl2;
        if (!(this.isReplay() || h.a((Object)this.status, new Object[]{Enums$OrderStatus.CANCELED, Enums$OrderStatus.FILLED}) || this.isRejected())) {
            this.addListeners(this.ticker);
        }
        if (orderPreset != null && !h.g(orderPreset.getTradeRoute())) {
            for (cd cd2 : this.getTradeRoutes()) {
                if (!h.a((Object)cd2.b(), (Object)orderPreset.getTradeRoute())) continue;
                this.setTradeRoute(cd2);
            }
        }
    }

    public float getTrailPrice() {
        if (bs.s(this.getAccount())) {
            return this.getAuxPrice();
        }
        float f2 = this.getBaseTrailPrice();
        float f3 = this.getAuxPrice();
        if (bs.a(this.getAccount())) {
            if (this.isUsePips()) {
                f3 = (float)((double)f3 * this.getAcctInstrument().getPointSize());
            }
            if (this.isBuy()) {
                return f2 - f3;
            }
            return f2 + f3;
        }
        if (this.isUsePips()) {
            f3 = (float)((double)f3 * this.getAcctInstrument().getPointSize());
        }
        if (this.isBuy()) {
            return f2 + f3;
        }
        return f2 - f3;
    }

    public float getAdjustedTrailPrice() {
        if (bs.s(this.getAccount())) {
            return this.getAdjustedAuxPrice();
        }
        float f2 = this.getBaseTrailPrice();
        float f3 = this.getAdjustedAuxPrice();
        if (this.isAdjustedUsePips()) {
            f3 = (float)((double)f3 * this.getAcctInstrument().getPointSize());
        }
        if (bs.a(this.getAccount()) || bs.d(this.getAccount())) {
            if (this.isBuy()) {
                return f2 - f3;
            }
            return f2 + f3;
        }
        if (this.isBuy()) {
            return f2 + f3;
        }
        return f2 - f3;
    }

    public void setAdjustedTrailPrice(float f2) {
        if (bs.s(this.getAccount())) {
            this.setAdjustedAuxPrice(f2);
        } else {
            float f3 = this.getBaseTrailPrice();
            if (this.isBuy()) {
                this.setAdjustedAuxPrice(f2 - f3);
            } else {
                this.setAdjustedAuxPrice(f3 - f2);
            }
        }
    }

    public float getBaseTrailPrice() {
        Position position;
        MWOrder mWOrder = this.getParentOrder();
        if (mWOrder == null && bs.w(this.getAccount()) && !bs.d(this.getAccount()) && (position = Positions.find(this.getTradeId())) != null) {
            return position.getAvgPrice();
        }
        if (mWOrder == null) {
            float f2 = this.getMktPrice();
            if (this.lastMktPrice != 0.0f) {
                f2 = this.lastMktPrice;
            }
            return f2;
        }
        if (mWOrder.isFilled()) {
            return mWOrder.getAvgFillPrice();
        }
        if (mWOrder.isLimit()) {
            return mWOrder.getLimitPrice();
        }
        if (mWOrder.isTrail()) {
            return mWOrder.getTrailPrice();
        }
        if (mWOrder.isMarket()) {
            return mWOrder.isBuy() ? this.ticker.getBuyPrice() : this.ticker.getSellPrice();
        }
        return mWOrder.getAuxPrice();
    }

    public boolean isBuy() {
        return h.a((Object)this.action, new Object[]{Enums$OrderAction.BUY, Enums$OrderAction.BUY_TO_COVER});
    }

    public boolean isSell() {
        return h.a((Object)this.action, new Object[]{Enums$OrderAction.SELL, Enums$OrderAction.SHORT});
    }

    public boolean isNew() {
        return this.status == Enums$OrderStatus.NEW && !this.isFilled();
    }

    public boolean isPreSubmitted() {
        return this.status == Enums$OrderStatus.PRE_SUBMITTED;
    }

    public boolean isCancelled() {
        return this.status == Enums$OrderStatus.CANCELED;
    }

    public boolean isPendingCancel() {
        return this.status == Enums$OrderStatus.PENDING_CANCEL;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void setRejected(boolean bl2) {
        this.rejected = bl2;
    }

    public void clearRejectFlags() {
        this.rejected = false;
        this.rejectCode = null;
        this.rejectReason = "";
    }

    public boolean isAdjusted() {
        return this.adjusted;
    }

    public boolean isStopLimitAdjusted() {
        MWOrder mWOrder = this.stopTrailOrder;
        MWOrder mWOrder2 = this.limitOrder;
        if (mWOrder != null && (mWOrder.isAdjusted() || mWOrder.isNew())) {
            return true;
        }
        return mWOrder2 != null && (mWOrder2.isAdjusted() || mWOrder2.isNew());
    }

    public boolean isLimit() {
        return this.orderType == null ? false : this.orderType.isLimit();
    }

    public boolean isMarket() {
        return this.orderType == null ? true : this.orderType.isMarket();
    }

    public boolean isTrail() {
        return this.orderType == Enums$OrderType.TRAIL;
    }

    public boolean isMIT() {
        return this.orderType == Enums$OrderType.MIT;
    }

    public boolean isTrailPts() {
        if (this.orderType == null) {
            return false;
        }
        if (!this.orderType.isTrail()) {
            return false;
        }
        return bs.p(this.getAccount());
    }

    public boolean isTriggerLimit() {
        return h.a((Object)this.orderType, new Object[]{Enums$OrderType.STPLMT, Enums$OrderType.LIT});
    }

    public boolean isTrigger() {
        return h.a((Object)this.orderType, new Object[]{Enums$OrderType.STP, Enums$OrderType.MIT});
    }

    public boolean isStop() {
        return h.a((Object)this.orderType, new Object[]{Enums$OrderType.STP, Enums$OrderType.STPLMT});
    }

    public boolean isStopOrTrail() {
        return h.a((Object)this.orderType, new Object[]{Enums$OrderType.STP, Enums$OrderType.STPLMT, Enums$OrderType.TRAIL});
    }

    public boolean isOCO() {
        return !h.g(this.ocaId);
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public boolean isModifiable() {
        return !h.g(this.orderId);
    }

    public boolean isAdjustable() {
        return !this.isMarket() && !this.isFilled() && !this.isUpdateInProgress() && !this.isCancelled();
    }

    public Enums$OrderType getType() {
        return this.orderType;
    }

    public void setType(Enums$OrderType enums$OrderType) {
        Enums$OrderType enums$OrderType2 = this.orderType;
        this.orderType = enums$OrderType;
        if (enums$OrderType != null && enums$OrderType.isTrail()) {
            this.usePips = bs.q(this.getAccount());
            if (bs.a(this.getAccount())) {
                this.usePips = b.G();
            }
        }
        this.notify("type", (Object)enums$OrderType2, (Object)this.orderType);
    }

    public void setPrices(Enums$OrderType enums$OrderType) {
        MWInstrument mWInstrument = this.getAcctInstrument();
        OrderPreset orderPreset = mWInstrument.getOrderPreset();
        int n2 = 10;
        if (orderPreset != null) {
            n2 = orderPreset.getTrailOffset();
        }
        int n3 = 10;
        if (orderPreset != null) {
            n3 = orderPreset.getStopOffset();
        }
        int n4 = 10;
        if (orderPreset != null) {
            n4 = orderPreset.getLimitOffset();
        }
        if (enums$OrderType == Enums$OrderType.MKT || enums$OrderType == Enums$OrderType.MOC) {
            this.adjustedAuxPrice = null;
            this.adjustedUsePips = null;
            this.auxPrice = 0.0f;
            this.adjustedLimitPrice = null;
            this.limitPrice = 0.0f;
            this.parentOffset = 0.0f;
            return;
        }
        Ticker ticker = this.ticker;
        float f2 = ticker.getAskPrice();
        if (this.isSell()) {
            f2 = ticker.getBidPrice();
        }
        float f3 = (float)this.getTicker().getTickSize();
        if (enums$OrderType == Enums$OrderType.TRAIL) {
            this.usePips = bs.q(this.getAccount());
            if (bs.a(this.getAccount())) {
                this.usePips = this.isUsePips();
            }
            if (bs.s(this.getAccount())) {
                float f4 = (float)n2 * f3;
                f2 = this.isBuy() ? ticker.round(ticker.getAskPrice() + f4) : ticker.round(ticker.getBidPrice() - f4);
            } else {
                f2 = ag.a(this, this.usePips);
            }
        }
        if (h.a((Object)enums$OrderType, new Object[]{Enums$OrderType.STP, Enums$OrderType.STPLMT, Enums$OrderType.MIT})) {
            f2 = this.isSell() ? (f2 -= (float)n3 * f3) : (f2 += (float)n3 * f3);
        }
        if (this.isTrailPts()) {
            f2 = this.isSell() ? (f2 -= (float)n2 * f3) : (f2 += (float)n2 * f3);
        }
        if (h.a((Object)enums$OrderType, new Object[]{Enums$OrderType.LMT})) {
            f2 = this.isSell() ? (f2 += (float)n4 * f3) : (f2 -= (float)n4 * f3);
        }
        f2 = mWInstrument.round(f2);
        if (h.a((Object)enums$OrderType, new Object[]{Enums$OrderType.STP, Enums$OrderType.MIT, Enums$OrderType.TRAIL})) {
            this.auxPrice = f2;
            this.adjustedAuxPrice = null;
            this.adjustedUsePips = null;
            this.limitPrice = 0.0f;
            this.adjustedLimitPrice = null;
            if (this.isTrailPts()) {
                this.trailPoints = n2;
                this.adjustedTrailPoints = null;
            }
        } else if (h.a((Object)enums$OrderType, new Object[]{Enums$OrderType.STPLMT, Enums$OrderType.LIT})) {
            this.auxPrice = f2;
            this.adjustedAuxPrice = null;
            this.adjustedUsePips = null;
            this.limitPrice = f2;
            this.adjustedLimitPrice = null;
        } else if (enums$OrderType == Enums$OrderType.LMT) {
            this.limitPrice = f2;
            this.adjustedLimitPrice = Float.valueOf(f2);
            this.auxPrice = 0.0f;
            this.adjustedAuxPrice = null;
            this.adjustedUsePips = null;
        }
    }

    public void setFromDefaults() {
        MWInstrument mWInstrument = this.getAcctInstrument();
        OrderPreset orderPreset = mWInstrument.getOrderPreset();
        int n2 = 10;
        int n3 = 10;
        int n4 = 10;
        if (orderPreset != null) {
            this.setTif(mWInstrument.getDefaultTIF());
            n2 = orderPreset.getLimitOffset();
            n3 = orderPreset.getTrailOffset();
            n4 = orderPreset.getStopOffset();
            this.setQuantity(mWInstrument.getDefaultQuantity());
            if (!h.g(orderPreset.getTradeRoute())) {
                for (cd cd2 : this.getTradeRoutes()) {
                    if (!h.a((Object)cd2.b(), (Object)orderPreset.getTradeRoute())) continue;
                    this.setTradeRoute(cd2);
                }
            }
        } else {
            h.a.severe("MWOrder::setFromDefaults() OrderPreset not defined for instrument: " + this.ticker.getKey());
        }
        if (this.isMarket()) {
            this.adjustedAuxPrice = null;
            this.auxPrice = 0.0f;
            this.adjustedLimitPrice = null;
            this.limitPrice = 0.0f;
            this.adjustedUsePips = null;
            this.parentOffset = 0.0f;
            return;
        }
        float f2 = this.ticker.getBidPrice();
        if (this.isSell()) {
            f2 = this.ticker.getAskPrice();
        }
        if (!mWInstrument.isValueValid(f2)) {
            f2 = this.ticker.getMidOrLast();
        }
        float f3 = (float)this.getTicker().getTickSize();
        if (this.isTrail()) {
            f2 = (float)n3 * f3;
        }
        if (this.isStop() || this.getType() == Enums$OrderType.MIT) {
            f2 = this.isTrailPts() ? (this.isSell() ? (f2 -= (float)n3 * f3) : (f2 += (float)n3 * f3)) : (this.isSell() ? (f2 -= (float)n4 * f3) : (f2 += (float)n4 * f3));
        }
        if (this.isLimit()) {
            f2 = this.isSell() ? (f2 += (float)n2 * f3) : (f2 -= (float)n2 * f3);
        }
        if (!mWInstrument.isValueValid(f2)) {
            f2 = this.ticker.getLastPrice();
        }
        if (!mWInstrument.isValueValid(f2)) {
            f2 = this.ticker.getMidpoint();
        }
        if (this.isTrigger() || this.isTrail()) {
            this.auxPrice = f2;
            this.adjustedAuxPrice = null;
            this.limitPrice = 0.0f;
            this.adjustedLimitPrice = null;
            if (this.isTrailPts()) {
                this.trailPoints = n3;
                this.adjustedTrailPoints = null;
            }
            this.adjustedUsePips = null;
        } else if (this.isTriggerLimit()) {
            this.auxPrice = f2;
            this.adjustedAuxPrice = null;
            this.limitPrice = f2;
            this.adjustedLimitPrice = null;
            this.adjustedUsePips = null;
        } else if (this.isLimit()) {
            this.limitPrice = f2;
            this.adjustedLimitPrice = null;
            this.auxPrice = 0.0f;
            this.adjustedAuxPrice = null;
            this.adjustedUsePips = null;
        }
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String string) {
        String string2 = this.accountId;
        Account account = this.getAccount();
        String string3 = this.format("accountName");
        this.accountId = string;
        Account account2 = bs.a(this.accountId);
        if (account2 != null) {
            this.simulatedOrder = account2.isSimulatedAccount();
        }
        this.acctInstr = null;
        this.notify("accountID", string2, this.accountId);
        this.notify("account", account, account2);
        this.notify("accountName", string3, this.format("accountName"));
    }

    public Account getAccount() {
        return bs.a(this.accountId);
    }

    public String getUniqueId() {
        return this.getAccountId() + ":" + this.getOrderId();
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        Position position2 = this.position;
        this.position = position;
        this.notify("position", position2, this.position);
    }

    public PositionSummary getPositionSummary() {
        return this.positionSummary;
    }

    public void setPositionSummary(PositionSummary positionSummary) {
        PositionSummary positionSummary2 = this.positionSummary;
        this.positionSummary = positionSummary;
        this.notify("positionSummary", positionSummary2, this.positionSummary);
    }

    public boolean isUsePips() {
        return this.usePips;
    }

    public void setUsePips(boolean bl2) {
        boolean bl3 = this.usePips;
        if (bl3 == bl2) {
            return;
        }
        this.usePips = bl2;
        this.notify("usePips", bl3, this.usePips);
    }

    public float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(float f2) {
        float f3;
        if (f2 < 0.0f) {
            f2 = Math.abs(f2);
        }
        if ((f3 = this.quantity) == f2) {
            return;
        }
        this.quantity = f2;
        this.notify("quantity", f3, this.quantity);
        this.notify("adjustedQuantity", f3, this.getAdjustedQuantity());
    }

    public float getMaxShowQty() {
        return this.maxShowQty;
    }

    public void setMaxShowQty(float f2) {
        float f3;
        if (f2 < 0.0f) {
            f2 = Math.abs(f2);
        }
        if ((f3 = this.maxShowQty) == f2) {
            return;
        }
        this.maxShowQty = f2;
        this.notify("maxShowQty", f3, this.maxShowQty);
        this.notify("adjustedMaxShowQty", f3, this.getAdjustedMaxShowQty());
    }

    public boolean isMaxShowQtyEnabled() {
        return this.maxShowQtyEnabled;
    }

    public void setMaxShowQtyEnabled(boolean bl2) {
        if (bl2 == this.maxShowQtyEnabled) {
            return;
        }
        boolean bl3 = this.maxShowQtyEnabled;
        this.maxShowQtyEnabled = bl2;
        this.notify("maxShowQtyEnabled", bl3, this.maxShowQtyEnabled);
    }

    public float getLimitPrice() {
        if (this.limitPrice != 0.0f) {
            return this.limitPrice;
        }
        if (this.parentOffset != 0.0f && this.getType().isLimit()) {
            MWOrder mWOrder = OrderDirectory.findOrder(this.accountId, this.getParentId());
            if (mWOrder != null) {
                float f2 = mWOrder.getTriggerPrice();
                if (this.isBuy()) {
                    return f2 - this.parentOffset;
                }
                return f2 + this.parentOffset;
            }
            System.err.println("parent order not found! " + this.getParentId());
        }
        return 0.0f;
    }

    public void setLimitPrice(float f2) {
        float f3 = this.limitPrice;
        if (f3 == (f2 = this.round(f2))) {
            return;
        }
        this.limitPrice = f2;
        this.notify("limitPrice", f3, this.limitPrice);
        this.notify("orderPrice", f3, this.limitPrice);
        this.notify("triggerPrice", f3, this.limitPrice);
        this.notify("adjustedTriggerPrice", f3, this.limitPrice);
        this.notifyAttachedOrders();
        if (this.isLimit() && this.hasParent()) {
            MWOrder mWOrder = this.getParentOrder();
            if (mWOrder != null) {
                mWOrder.notify("limitOrderPL", null, (Object)this.getOrderPL());
            }
            if (this.position != null) {
                this.position.notify("limitOrderPL", null, (Object)this.getOrderPL());
            }
            if (this.positionSummary != null) {
                this.positionSummary.notify("netLimitOrderPL", null, (Object)this.getOrderPL());
            }
        }
    }

    public float getParentOffset() {
        return this.parentOffset;
    }

    public void setParentOffset(float f2) {
        this.parentOffset = f2;
    }

    private float round(float f2) {
        if (this.ticker != null) {
            return this.ticker.round(f2);
        }
        MWInstrument mWInstrument = this.getAcctInstrument();
        return mWInstrument == null ? f2 : mWInstrument.round(f2);
    }

    public float getStopPrice() {
        return this.getAuxPrice();
    }

    public void setStopPrice(float f2) {
        this.setAuxPrice(f2);
    }

    public void setStopLimitPrice(float f2) {
        this.setLimitPrice(f2);
    }

    public float getAuxPrice() {
        MWOrder mWOrder;
        if (this.auxPrice != 0.0f) {
            return this.auxPrice;
        }
        if (this.parentOffset != 0.0f && this.getType().isStopOrTrail() && (mWOrder = OrderDirectory.findOrder(this.accountId, this.getParentId())) != null) {
            float f2 = mWOrder.getTriggerPrice();
            if (this.isBuy()) {
                return f2 + this.parentOffset;
            }
            return f2 - this.parentOffset;
        }
        return 0.0f;
    }

    public void setAuxPrice(float f2) {
        float f3 = this.auxPrice;
        if (f3 == (f2 = this.round(f2))) {
            return;
        }
        double d2 = this.getOrderPL();
        this.auxPrice = f2;
        this.notify("auxPrice", f3, f2);
        this.notify("orderPrice", f3, f2);
        this.notify("triggerPrice", f3, f2);
        this.notifyAttachedOrders();
        if (this.isStopOrTrail() && this.hasParent()) {
            MWOrder mWOrder = this.getParentOrder();
            if (mWOrder != null) {
                mWOrder.notify("stopOrderPL", d2, this.getOrderPL());
            }
            if (this.position != null) {
                this.position.notify("stopOrderPL", d2, this.getOrderPL());
            }
            if (this.positionSummary != null) {
                this.positionSummary.notify("netStopOrderPL", null, (Object)this.getOrderPL());
            }
        }
    }

    public float getTrailStopPrice() {
        return this.trailStopPrice;
    }

    public void setTrailStopPrice(float f2) {
        float f3 = this.trailStopPrice;
        if (f3 == (f2 = this.round(f2))) {
            return;
        }
        this.trailStopPrice = f2;
        this.notify("trailStopPrice", f3, f2);
        this.notify("orderPrice", f3, f2);
        this.notify("triggerPrice", f3, f2);
        this.notify("adjustedTriggerPrice", f3, f2);
    }

    public void setAdjustedTriggerPrice(float f2) {
        j j2;
        if (this.isMarket()) {
            return;
        }
        boolean bl2 = bs.r(this.getAccount());
        float f3 = this.getInstrument().getMinTickFloat();
        if (this.isTrail()) {
            j2 = this.getTicker();
            if (bl2) {
                MWOrder mWOrder;
                if (!h.g(this.parentId) && (mWOrder = this.getParentOrder()) != null && mWOrder.isActive()) {
                    float f4 = mWOrder.getTrailStopPrice() == 0.0f ? mWOrder.getLimitPrice() : mWOrder.getTrailStopPrice();
                    float f5 = this.isBuy() ? f2 - f4 : f4 - f2;
                    this.setOffsetTicks(Math.round(f5 / f3));
                    this.setAdjustedAuxPrice(f5);
                    return;
                }
                float f6 = this.isBuy() ? j2.getAskPrice() : j2.getBidPrice();
                float f7 = this.isBuy() ? f2 - f6 : f6 - f2;
                this.setOffsetTicks(Math.round(f7 / f3));
                this.setAdjustedAuxPrice(f7);
                return;
            }
        }
        if (this.offsetTicks != 0 && !h.g(this.parentId) && (j2 = this.getParentOrder()) != null && ((MWOrder)j2).isActive()) {
            float f8;
            float f9 = f8 = ((MWOrder)j2).getAdjustedAuxPrice() == 0.0f ? ((MWOrder)j2).getAdjustedLimitPrice() : ((MWOrder)j2).getAdjustedAuxPrice();
            if (this.isStopOrTrail()) {
                if (this.isBuy()) {
                    this.setOffsetTicks(Math.round((f2 - f8) / f3));
                } else {
                    this.setOffsetTicks(Math.round((f8 - f2) / f3));
                }
                this.setAdjustedAuxPrice(f2);
                return;
            }
            if (this.isSell()) {
                this.setOffsetTicks(Math.round((f2 - f8) / f3));
            } else {
                this.setOffsetTicks(Math.round((f8 - f2) / f3));
            }
            this.setAdjustedLimitPrice(f2);
            return;
        }
        if (this.getType().isLimit()) {
            this.setAdjustedLimitPrice(f2);
            if (h.a((Object)this.getType(), new Object[]{Enums$OrderType.STPLMT, Enums$OrderType.LIT})) {
                this.setAdjustedAuxPrice(f2);
            }
        } else if (this.orderType == Enums$OrderType.STP) {
            this.setAdjustedAuxPrice(f2);
        } else if (this.orderType.isTrail()) {
            if (!bl2) {
                this.setAdjustedAuxPrice(f2);
            } else {
                float f10 = this.isBuy() ? f2 - this.getTriggerPrice() : this.getTriggerPrice() - f2;
                this.setAdjustedAuxPrice(f10);
            }
        } else {
            this.setAdjustedAuxPrice(f2);
        }
    }

    public Enums$TIF getTif() {
        return this.tif;
    }

    public void setTif(Enums$TIF enums$TIF) {
        Enums$TIF enums$TIF2 = this.tif;
        this.tif = enums$TIF;
        this.notify("tif", (Object)enums$TIF2, (Object)this.tif);
    }

    public void discardChanges() {
        MWOrder mWOrder;
        float f2 = this.getAdjustedQuantity();
        this.adjustedQuantity = null;
        f2 = this.getAdjustedMaxShowQty();
        this.adjustedMaxShowQty = null;
        boolean bl2 = this.isAdjustedMaxShowQtyEnabled();
        this.adjustedMaxShowQtyEnabled = null;
        boolean bl3 = this.isAdjustedUsePips();
        this.adjustedUsePips = null;
        float f3 = this.getAdjustedLimitPrice();
        this.adjustedLimitPrice = null;
        float f4 = this.getAdjustedAuxPrice();
        this.adjustedAuxPrice = null;
        Enums$TIF enums$TIF = this.getAdjustedTif();
        this.adjustedTif = null;
        Long l2 = this.getAdjustedExpiryDate();
        this.adjustedExpiryDate = null;
        boolean bl4 = this.isAdjustedOutsideRTH();
        this.adjustedOutsideRTH = null;
        Date date = this.getAdjustedGTD();
        this.adjustedGTD = null;
        bl4 = this.isAdjustedTrailFixed();
        this.adjustedTrailFixed = null;
        float f5 = this.getAdjustedTrailPoints();
        this.adjustedTrailPoints = null;
        this.updateAdjustedState();
        this.notify("adjustedQuantity", f2, this.getAdjustedQuantity());
        this.notify("adjustedMaxShowQty", f2, this.getAdjustedMaxShowQty());
        this.notify("adjustedMaxShowQtyEnabled", bl2, this.isAdjustedMaxShowQtyEnabled());
        this.notify("adjustedUsePips", bl3, this.isAdjustedUsePips());
        this.notify("adjustedLimitPrice", f3, this.getAdjustedLimitPrice());
        this.notify("adjustedAuxPrice", f4, this.getAdjustedAuxPrice());
        this.notify("adjustedTif", (Object)enums$TIF, (Object)this.getAdjustedTif());
        this.notify("adjustedExpiryDate", l2, this.getAdjustedExpiryDate());
        this.notify("adjustedOutsideRTH", bl4, this.isOutsideRTH());
        this.notify("adjustedGTD", date, this.getAdjustedGTD());
        this.notify("adjustedTrailFixed", bl4, this.isAdjustedTrailFixed());
        this.notify("adjustedTrailPoints", f5, (float)this.getAdjustedTrailPoints());
        this.notify("orderPrice", 0.0f, this.getOrderPrice());
        this.notify("auxPrice", 0.0f, this.getAuxPrice());
        this.notify("limitPrice", 0.0f, this.getLimitPrice());
        this.notify("tif", null, (Object)this.getTif());
        this.notify("quantity", 0.0f, this.getQuantity());
        this.notify("maxShowQty", 0.0f, this.getMaxShowQty());
        this.notify("trailPoints", 0, this.getTrailPoints());
        if (this.hasParent() && (mWOrder = this.getParentOrder()) != null) {
            mWOrder.notify("stopLimitAdjusted", null, (Object)mWOrder.isStopLimitAdjusted());
            if (this.isLimit()) {
                mWOrder.notify("limitOrderPrice", f3, this.getAdjustedLimitPrice());
            } else if (this.isStopOrTrail()) {
                mWOrder.notify("stopTrailOrderPrice", f4, this.getAdjustedAuxPrice());
            }
        }
    }

    public synchronized void commitChanges() {
        this.setQuantity(this.getAdjustedQuantity());
        this.setMaxShowQty(this.getAdjustedMaxShowQty());
        this.setMaxShowQtyEnabled(this.isAdjustedMaxShowQtyEnabled());
        this.setUsePips(this.isAdjustedUsePips());
        this.setLimitPrice(this.getAdjustedLimitPrice());
        this.setAuxPrice(this.getAdjustedAuxPrice());
        this.setTif(this.getAdjustedTif());
        this.setOutsideRTH(this.isAdjustedOutsideRTH());
        this.setGTD(this.getAdjustedGTD());
        this.setExpiryDate(this.getAdjustedExpiryDate());
        this.setTrailFixed(this.isAdjustedTrailFixed());
        this.setTrailPoints(this.getAdjustedTrailPoints());
        this.discardChanges();
        this.lastCommit = System.currentTimeMillis();
    }

    public long getLastCommit() {
        return this.lastCommit;
    }

    public boolean wasCommittedRecently() {
        return System.currentTimeMillis() - this.lastCommit < 1500L;
    }

    public boolean isQuantityAdjusted() {
        return this.getAdjustedQuantity() != this.getQuantity();
    }

    public float getAdjustedQuantity() {
        return this.adjustedQuantity == null ? this.quantity : this.adjustedQuantity.floatValue();
    }

    public void setAdjustedQuantity(float f2) {
        float f3;
        if (this.isExitStep()) {
            return;
        }
        if (f2 < 0.0f) {
            h.c();
            f2 = Math.abs(f2);
        }
        if ((f3 = this.getAdjustedQuantity()) == f2) {
            return;
        }
        this.adjustedQuantity = Float.valueOf(f2);
        this.updateAdjustedState();
        this.notify("adjustedQuantity", f3, f2);
        this.notifyAttachedOrders();
    }

    public float getAdjustedMaxShowQty() {
        return this.adjustedMaxShowQty == null ? this.maxShowQty : this.adjustedMaxShowQty.floatValue();
    }

    public void setAdjustedMaxShowQty(float f2) {
        float f3;
        if (this.isExitStep()) {
            return;
        }
        if (f2 < 0.0f) {
            h.c();
            f2 = Math.abs(f2);
        }
        if ((f3 = this.getAdjustedMaxShowQty()) == f2) {
            return;
        }
        this.adjustedMaxShowQty = Float.valueOf(f2);
        this.updateAdjustedState();
        this.notify("adjustedMaxShowQty", f3, f2);
        this.notifyAttachedOrders();
    }

    public boolean isAdjustedMaxShowQtyEnabled() {
        return this.adjustedMaxShowQtyEnabled == null ? this.maxShowQtyEnabled : this.adjustedMaxShowQtyEnabled;
    }

    public void setAdjustedMaxShowQtyEnabled(boolean bl2) {
        if (this.isExitStep()) {
            return;
        }
        boolean bl3 = this.isAdjustedMaxShowQtyEnabled();
        if (bl3 == bl2) {
            return;
        }
        this.adjustedMaxShowQtyEnabled = bl2;
        this.updateAdjustedState();
        this.notify("adjustedMaxShowQtyEnabled", bl3, bl2);
        this.notifyAttachedOrders();
    }

    public float getAdjustedLimitPrice() {
        Float f2 = this.adjustedLimitPrice;
        if (f2 == null) {
            return this.getLimitPrice();
        }
        if (f2.floatValue() != 0.0f) {
            return f2.floatValue();
        }
        return this.getLimitPrice();
    }

    public void setAdjustedLimitPrice(float f2) {
        MWOrder mWOrder;
        if (this.isAdjustedUsePips()) {
            f2 = h.a(f2, 1);
            if (this.isLimit() && f2 < 1.0f) {
                f2 = 1.0f;
            } else if (this.isStop() && f2 > -1.0f) {
                f2 = -1.0f;
            }
        } else {
            f2 = this.round(f2);
        }
        float f3 = this.getAdjustedLimitPrice();
        if (f3 == f2) {
            return;
        }
        this.adjustedLimitPrice = Float.valueOf(f2);
        this.updateAdjustedState();
        this.notify("adjustedLimitPrice", f3, f2);
        if (this.isNew()) {
            this.setLimitPrice(f2);
        }
        if (this.getType() != Enums$OrderType.STPLMT) {
            this.notify("orderPrice", f3, f2);
            this.notify("triggerPrice", f3, f2);
            this.notify("adjustedTriggerPrice", f3, f2);
        }
        if (this.hasParent() && (mWOrder = this.getParentOrder()) != null) {
            mWOrder.notify("stopLimitAdjusted", null, (Object)mWOrder.isStopLimitAdjusted());
            if (this.isLimit()) {
                mWOrder.notify("limitOrderPrice", f3, f2);
            }
        }
        this.notifyAttachedOrders();
    }

    public float getAdjustedAuxPrice() {
        Float f2 = this.adjustedAuxPrice;
        if (f2 == null) {
            return this.getAuxPrice();
        }
        if (f2.floatValue() != 0.0f) {
            return f2.floatValue();
        }
        return this.getAuxPrice();
    }

    public void setAdjustedAuxPrice(float f2) {
        MWOrder mWOrder;
        float f3;
        if (this.isAdjustedUsePips()) {
            f2 = h.a(f2, 1);
            if (this.isStop() && f2 > -1.0f) {
                f2 = -1.0f;
            }
        } else {
            f2 = this.round(f2);
        }
        if ((f3 = this.getAdjustedAuxPrice()) == f2) {
            return;
        }
        this.adjustedAuxPrice = Float.valueOf(f2);
        this.updateAdjustedState();
        this.notify("adjustedAuxPrice", f3, f2);
        if (this.isNew()) {
            this.setAuxPrice(f2);
        }
        this.notify("orderPrice", f3, f2);
        this.notify("triggerPrice", f3, f2);
        this.notify("adjustedTriggerPrice", f3, f2);
        if (this.hasParent() && (mWOrder = this.getParentOrder()) != null) {
            mWOrder.notify("stopLimitAdjusted", null, (Object)mWOrder.isStopLimitAdjusted());
            if (this.isStopOrTrail()) {
                mWOrder.notify("stopTrailOrderPrice", f3, f2);
            }
        }
        this.notifyAttachedOrders();
    }

    private void notifyAttachedOrders() {
        if (this.getLimitOrder() != null) {
            this.notify("limitOrderPL", 0.0, this.getLimitOrderPL());
        }
        if (this.getStopTrailOrder() != null) {
            this.notify("stopOrderPL", 0.0, this.getStopOrderPL());
        }
    }

    public Object getAdjustedExpires() {
        return bs.B(this.getAccount()) ? this.getAdjustedExpiryDate() : this.getAdjustedTif();
    }

    public void setAdjustedExpires(Object object) {
        if (this.isExitStep()) {
            return;
        }
        if (bs.B(this.getAccount())) {
            Long l2 = null;
            if (object instanceof e) {
                l2 = (Long)((e)object).a();
            } else if (object instanceof Long) {
                l2 = (Long)object;
            } else if (object instanceof Enums$OrderExpiry) {
                l2 = ((Enums$OrderExpiry)((Object)object)).toLong();
            } else {
                return;
            }
            this.setAdjustedExpiryDate(l2);
        } else {
            if (object != null && !(object instanceof Enums$TIF)) {
                return;
            }
            this.setAdjustedTif((Enums$TIF)((Object)object));
        }
    }

    public Enums$TIF getAdjustedTif() {
        return this.adjustedTif == null ? this.tif : this.adjustedTif;
    }

    public void setAdjustedTif(Enums$TIF enums$TIF) {
        if (this.isExitStep()) {
            return;
        }
        Enums$TIF enums$TIF2 = this.getAdjustedTif();
        if (enums$TIF == enums$TIF2) {
            return;
        }
        this.adjustedTif = enums$TIF;
        this.updateAdjustedState();
        this.notify("adjustedTif", (Object)enums$TIF2, (Object)this.adjustedTif);
        this.notify("adjustedExpires", (Object)enums$TIF2, (Object)this.adjustedTif);
    }

    public Date getAdjustedGTD() {
        return this.adjustedGTD == null ? this.gTD : this.adjustedGTD;
    }

    public void setAdjustedGTD(Date date) {
        if (this.isExitStep()) {
            return;
        }
        Date date2 = this.getAdjustedGTD();
        if (h.a((Object)date2, (Object)date)) {
            return;
        }
        this.adjustedGTD = date;
        this.updateAdjustedState();
        this.notify("adjustedGTD", date2, date);
        if (this.isNew()) {
            this.setGTD(date);
        }
    }

    public Long getAdjustedExpiryDate() {
        return this.adjustedExpiryDate == null ? this.expiryDate : this.adjustedExpiryDate;
    }

    public void setAdjustedExpiryDate(Long l2) {
        if (this.isExitStep()) {
            return;
        }
        if (!bs.B(this.getAccount())) {
            return;
        }
        if (h.a((Object)l2, (Object)this.getAdjustedExpiryDate())) {
            return;
        }
        Long l3 = this.getAdjustedExpiryDate();
        this.adjustedExpiryDate = l2;
        this.updateAdjustedState();
        this.notify("adjustedExpiryDate", l3, l2);
        this.notify("adjustedExpires", l3, l2);
        if (this.isNew()) {
            this.setExpiryDate(l2);
        }
    }

    public boolean isAdjustedOutsideRTH() {
        return this.adjustedOutsideRTH == null ? this.outsideRTH : this.adjustedOutsideRTH;
    }

    public void setAdjustedOutsideRTH(boolean bl2) {
        if (this.isExitStep()) {
            return;
        }
        boolean bl3 = this.isAdjustedOutsideRTH();
        if (bl2 == bl3) {
            return;
        }
        this.adjustedOutsideRTH = bl2;
        this.updateAdjustedState();
        this.notify("adjustedOutsideRTH", bl3, bl2);
    }

    public Enums$OrderAction getAction() {
        return this.action;
    }

    public void setAction(Enums$OrderAction enums$OrderAction) {
        Enums$OrderAction enums$OrderAction2 = this.action;
        if (enums$OrderAction2 == enums$OrderAction) {
            return;
        }
        this.action = enums$OrderAction;
        this.notify("action", (Object)enums$OrderAction2, (Object)this.action);
    }

    public String getPermanentId() {
        return this.permanentId;
    }

    public void setPermanentId(String string) {
        String string2 = this.permanentId;
        this.permanentId = string;
        this.notify("permanentId", string2, this.permanentId);
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String string) {
        String string2 = this.orderId;
        this.orderId = string;
        String string3 = OrderDirectory.getPermId(string);
        if (string3 != null) {
            this.setPermanentId(string3);
        }
        if (h.g(this.origOrderId)) {
            this.origOrderId = string;
        }
        this.notify("orderId", string2, string);
        if (h.g(this.ticket)) {
            this.notify("ticket", string2, string);
        }
    }

    public boolean is(String ... stringArray) {
        for (String string : stringArray) {
            if (h.g(string)) {
                return false;
            }
            if (!h.a((Object)string, (Object)this.orderId) && !h.a((Object)string, (Object)this.origOrderId)) continue;
            return true;
        }
        return false;
    }

    public boolean is(List list) {
        for (String string : list) {
            if (h.g(string)) {
                return false;
            }
            if (!h.a((Object)string, (Object)this.orderId) && !h.a((Object)string, (Object)this.origOrderId)) continue;
            return true;
        }
        return false;
    }

    public boolean is(MWOrder mWOrder) {
        if (mWOrder == null) {
            return false;
        }
        if (mWOrder == this) {
            return true;
        }
        return h.a((Object)this.getOrderId(), (Object)mWOrder.getOrderId());
    }

    public String getOrigOrderId() {
        return this.origOrderId;
    }

    public void setOrigOrderId(String string) {
        this.origOrderId = string;
    }

    public String getLabel() {
        Object object = "";
        String string = "";
        if (this.isAdjusted()) {
            if (this.isTrigger() || this.isTrail()) {
                object = this.format("adjustedAuxPrice");
            } else if (this.isTriggerLimit()) {
                object = this.format("adjustedAuxPrice") + "(" + this.format("adjustedLimitPrice") + ")";
            } else if (this.isLimit()) {
                object = this.format("adjustedLimitPrice");
            }
            string = ab.b(this.getAdjustedQuantity(), this.getAcctInstrument());
        } else {
            if (this.isTrigger() || this.isTrail()) {
                object = this.format("auxPrice");
            } else if (this.isTriggerLimit()) {
                object = this.format("auxPrice") + "(" + this.format("limitPrice") + ")";
            } else if (this.isLimit()) {
                object = this.format("limitPrice");
            }
            string = this.isFilled() ? ab.b(this.getFilled(), this.getAcctInstrument()) : (this.getRemaining() > 0.0f ? ab.b(this.getRemaining(), this.getAcctInstrument()) : ab.b(this.getQuantity(), this.getAcctInstrument()));
        }
        Object object2 = "";
        if (bs.w(this.getAccount())) {
            object2 = this.isEntryOrder() && !this.isNetClose() ? "+" : "-";
        }
        if (this.isMarket()) {
            if (this.isFilled()) {
                object = this.format("lastFillPrice");
            } else {
                return (String)object2 + String.valueOf((Object)this.getType()) + " " + string + "@" + this.getInstrument().formatValue(this.getMktPrice());
            }
        }
        if (this.isFilled()) {
            object = this.format("lastFillPrice");
            object2 = this.isBuy() ? (String)object2 + "BOT " : (String)object2 + "SLD ";
            return (String)object2 + String.valueOf((Object)this.getType()) + " " + ab.b(this.getFilled(), this.getInstrument()) + "@" + (String)object;
        }
        return (String)object2 + String.valueOf((Object)this.getType()) + " " + string + "@" + (String)object;
    }

    public String getLabel2() {
        String string = "";
        string = this.remaining == 0.0f && this.filled > 0.0f ? this.format("filled") : (this.remaining > 0.0f ? this.format("remaining") : this.format("adjustedQuantity"));
        Object object = this.orderType.name();
        if (this.isSimulatedOrder()) {
            object = (String)object + "-SIM";
        } else if (this.isReplay()) {
            object = (String)object + "-RP";
        }
        if (this.isMarket() && !this.isFilled()) {
            return (String)object + " " + string + "@" + this.formatPrice(this.getAdjustedTriggerPrice());
        }
        Object object2 = "";
        if (this.isFilled()) {
            object2 = this.isBuy() ? (String)object2 + "BOT " : (String)object2 + "SLD ";
            return (String)object2 + (String)object + " " + this.format("filled");
        }
        Object object3 = "";
        if (this.orderType.isTrail() && bs.r(this.getAccount())) {
            object3 = this.format("adjustedAuxPrice");
        } else if (this.orderType.isTrigger() || this.orderType.isStop()) {
            object3 = "";
        } else if (this.orderType.isTriggerLimit() && this.getLimitPrice() != this.getTrailStopPrice()) {
            object3 = this.format("adjustedLimitPrice");
        }
        if (this.isExitStep()) {
            object2 = "*" + (String)object2;
        }
        if (object3 != "") {
            object3 = "@" + (String)object3;
        }
        return (String)object2 + (String)object + " " + string + (String)object3;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String string) {
        if (!h.g(string) && h.a((Object)string, (Object)this.orderId)) {
            h.a.severe("MWOrder::setParentId() parent ID is the same as the order ID: " + this.orderId + " " + string);
            h.c();
            return;
        }
        String string2 = this.parentId;
        this.parentId = string;
        this.notify("parentId", string2, this.parentId);
    }

    public boolean isParentEmpty() {
        if (h.g(this.parentId)) {
            return true;
        }
        return this.parentId.equals("0");
    }

    public MWOrder getParentOrder() {
        if (this.isParentEmpty() || h.a((Object)this.parentId, (Object)this.orderId)) {
            return null;
        }
        MWOrder mWOrder = OrderDirectory.findOrder(this.parentId);
        if (mWOrder == null && !h.g(this.parentId)) {
            mWOrder = OrderDirectory.findByOrigId(this.parentId);
        }
        if (mWOrder == null || mWOrder == this) {
            return null;
        }
        return mWOrder;
    }

    public Color getGroupColor() {
        if (this.isNetClose()) {
            return null;
        }
        List list = OrderDirectory.findDependentOrders(this);
        return this.getGroupColor(list);
    }

    private Color getGroupColor(List list) {
        if (this.isNetClose()) {
            return null;
        }
        if (h.a((Collection)list)) {
            return null;
        }
        MWOrder mWOrder = this.getParentOrder();
        if (mWOrder != null && mWOrder != this) {
            MWOrder mWOrder22;
            for (int i2 = 0; i2 < 5 && (mWOrder22 = mWOrder.getParentOrder()) != null; ++i2) {
                if (!mWOrder.hasParent() || mWOrder22 == this) continue;
                mWOrder = mWOrder22;
            }
            if (!mWOrder.isActive() && !h.g(this.getOCAId())) {
                for (MWOrder mWOrder22 : list) {
                    if (!h.a((Object)this.getOCAId(), (Object)mWOrder22.getOCAId())) continue;
                    return OrderDirectory.getOCOColor(this.getOCAId());
                }
            }
            if (mWOrder.groupColor != null) {
                return mWOrder.groupColor;
            }
            mWOrder.groupColor = OrderDirectory.getNextColor();
            return mWOrder.groupColor;
        }
        if (!h.g(this.getOCAId())) {
            for (MWOrder mWOrder3 : list) {
                if (!h.a((Object)this.getOCAId(), (Object)mWOrder3.getOCAId())) continue;
                return OrderDirectory.getOCOColor(this.getOCAId());
            }
        }
        if (this.groupColor != null) {
            return this.groupColor;
        }
        this.groupColor = OrderDirectory.getNextColor();
        return this.groupColor;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String string) {
        String string2 = this.clientId;
        this.clientId = string;
        this.notify("clientId", string2, this.clientId);
    }

    public String getTicket() {
        return h.g(this.ticket) ? this.orderId : this.ticket;
    }

    public void setTicket(String string) {
        String string2 = this.ticket;
        this.ticket = string;
        this.notify("ticket", string2, this.ticket);
    }

    public int getIBOrderId() {
        return this.ibOrderId;
    }

    public void setIBOrderId(int n2) {
        int n3 = n2;
        this.ibOrderId = n2;
        this.notify("iBOrderId", n3, this.ibOrderId);
    }

    public String getOCAId() {
        return this.ocaId;
    }

    public void setOCAId(String string) {
        String string2 = this.ocaId;
        this.ocaId = string;
        this.notify("OACId", string2, this.ocaId);
        List list = OrderDirectory.findDependentOrders(this);
        Color color = this.getGroupColor(list);
        if (!h.a((Collection)list)) {
            for (MWOrder mWOrder : list) {
                if (mWOrder == this) continue;
                mWOrder.notify("groupColor", null, color);
            }
        }
        this.notify("groupColor", null, color);
    }

    public boolean isOutsideRTH() {
        return this.outsideRTH;
    }

    public void setOutsideRTH(boolean bl2) {
        boolean bl3 = this.outsideRTH;
        this.outsideRTH = bl2;
        this.notify("outsideRTH", bl3, this.outsideRTH);
    }

    public Enums$OrderStatus getStatus() {
        return this.status == null ? Enums$OrderStatus.NEW : this.status;
    }

    public void setStatus(Enums$OrderStatus enums$OrderStatus) {
        if (this.status == enums$OrderStatus) {
            return;
        }
        if (h.a((Object)this.getStatus(), new Object[]{Enums$OrderStatus.FILLED, Enums$OrderStatus.PARTIALLY_FILLED}) && !h.a((Object)enums$OrderStatus, new Object[]{Enums$OrderStatus.FILLED, Enums$OrderStatus.PARTIALLY_FILLED})) {
            h.a.warning("MWOrder::setStatus() setting to unfilled when it is already filled! (ignoring): " + String.valueOf((Object)this.getStatus()) + " -> " + String.valueOf((Object)enums$OrderStatus) + " " + String.valueOf(this));
            h.c();
            return;
        }
        if (this.getStatus() == Enums$OrderStatus.FILLED && enums$OrderStatus == Enums$OrderStatus.PARTIALLY_FILLED) {
            h.a.warning("MWOrder::setStatus() setting to partially filled with status is already filled! " + String.valueOf((Object)this.getStatus()) + " -> " + String.valueOf((Object)enums$OrderStatus) + " " + String.valueOf(this));
            h.c();
        }
        if (this.isCancelled() && enums$OrderStatus == Enums$OrderStatus.SUBMITTED) {
            h.a.warning("MWOrder::setStatus() setting to submitted when it is already cancelled");
            h.c();
        }
        Enums$OrderStatus enums$OrderStatus2 = this.status;
        this.status = enums$OrderStatus;
        this.notify("status", (Object)enums$OrderStatus2, (Object)this.status);
        if (this.status == Enums$OrderStatus.CANCELED || this.status == Enums$OrderStatus.FILLED || this.isRejected()) {
            this.removeListeners(this.ticker);
        }
    }

    public String getSymbol() {
        return this.ticker.getSymbol();
    }

    public boolean isFilled() {
        return this.status == Enums$OrderStatus.FILLED;
    }

    public boolean isPartiallyFilled() {
        return this.status == Enums$OrderStatus.PARTIALLY_FILLED;
    }

    public boolean isActive() {
        return !this.isFilled() && !this.isCancelled() && !this.isRejected();
    }

    public float getFilled() {
        return this.filled;
    }

    public void setFilled(float f2) {
        float f3 = this.filled;
        this.filled = f2;
        this.notify("filled", f3, this.filled);
    }

    public float getRemaining() {
        if (this.remaining != 0.0f) {
            return this.remaining;
        }
        if (this.filled <= 0.0f) {
            return this.quantity;
        }
        if (this.filled < this.quantity) {
            return h.a(this.quantity - this.filled, 1.0E-8f);
        }
        return this.remaining;
    }

    public void setRemaining(float f2) {
        float f3 = this.remaining;
        this.remaining = f2;
        this.notify("remaining", f3, this.remaining);
    }

    public float getAvgFillPrice() {
        return this.avgFillPrice;
    }

    public void setAvgFillPrice(float f2) {
        float f3 = this.avgFillPrice;
        this.avgFillPrice = f2;
        this.notify("avgFillPrice", f3, this.avgFillPrice);
    }

    public float getLastFillPrice() {
        if (this.lastFillPrice > 0.0f) {
            return this.lastFillPrice;
        }
        if (this.avgFillPrice > 0.0f) {
            return this.avgFillPrice;
        }
        return this.lastFillPrice;
    }

    public void setLastFillPrice(float f2) {
        float f3 = this.lastFillPrice;
        this.lastFillPrice = f2;
        this.notify("lastFillPrice", f3, this.lastFillPrice);
    }

    public long getLastFillTime() {
        return this.lastFillTime;
    }

    public void setLastFillTime(long l2) {
        if (l2 <= 0L) {
            l2 = bs.a();
        }
        long l3 = this.lastFillTime;
        this.lastFillTime = l2;
        this.notify("lastFillTime", l3, this.lastFillTime);
    }

    public String getRejectReason() {
        return this.rejectReason;
    }

    public void setRejectReason(String string) {
        String string2 = this.rejectReason;
        this.rejectReason = string;
        this.notify("rejectReason", string2, this.rejectReason);
    }

    public Object getRejectCode() {
        return this.rejectCode;
    }

    public void setRejectCode(Object object) {
        Object object2 = this.rejectCode;
        this.rejectCode = object;
        this.notify("rejectCode", object2, this.rejectCode);
    }

    public Date getGTD() {
        return this.gTD;
    }

    public long getGTDTime() {
        return this.gTD == null ? 0L : this.gTD.getTime();
    }

    public void setGTD(Date date) {
        Date date2 = this.gTD;
        this.gTD = date;
        this.notify("GTD", date2, this.gTD);
    }

    public Long getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Long l2) {
        Long l3 = this.expiryDate;
        this.expiryDate = l2;
        this.notify("expiryDate", l3, this.expiryDate);
    }

    public String toString2() {
        return super.toString();
    }

    public String toString() {
        Object object = this.ticker == null ? "" : this.ticker.getKey();
        MWInstrument mWInstrument = this.getAcctInstrument();
        if (mWInstrument != null) {
            object = mWInstrument.getKey();
        }
        if (mWInstrument != null && !h.a(object, (Object)mWInstrument.getSymbolDisplay())) {
            object = (String)object + " (" + mWInstrument.getSymbolDisplay() + ")";
        }
        String string = "ID: " + this.orderId + " " + this.getAccountId() + " " + (String)object + " " + String.valueOf((Object)this.status) + " " + String.valueOf((Object)this.action) + " " + String.valueOf((Object)this.orderType);
        if (!h.g(this.ocaId)) {
            string = string + " " + this.ocaId;
        }
        if (!h.g(this.tag)) {
            string = string + " " + this.tag;
        }
        if (this.entryOrder != null) {
            string = this.isEntryOrder() ? string + " ENTRY" : string + " EXIT";
        }
        if (this.getLimitPrice() != 0.0f) {
            string = string + " Limit:" + this.getLimitPrice();
        }
        if (this.getAuxPrice() != 0.0f) {
            string = string + " Aux:" + this.getAuxPrice();
        }
        string = string + " Qty:" + this.quantity + " " + String.valueOf((Object)this.tif);
        if (!h.b((Object)this.adjustedLimitPrice)) {
            string = string + " Adj Limit:" + this.adjustedLimitPrice;
        }
        if (!h.b((Object)this.adjustedAuxPrice)) {
            string = string + " Adj Aux:" + this.adjustedAuxPrice;
        }
        if (!h.b((Object)this.adjustedQuantity)) {
            string = string + " Adj Qty:" + this.adjustedQuantity;
        }
        if (this.getLastFillTime() > 0L) {
            string = string + " Last Fill Time: " + h.d(this.getLastFillTime());
        }
        return string;
    }

    @Override
    public List getNVPs() {
        return h.b(new String[]{this.b("id", this.orderId), this.b("accountId", this.accountId), this.b("parentId", this.parentId), this.a("instr", this.getInstrument()), this.a("entry", this.isEntryOrder()), this.a("action", (Object)this.action), this.a("type", (Object)this.orderType), this.a("quantity", this.quantity), this.a("status", (Object)this.getStatus()), this.a("usePips", this.usePips, false), this.a("limitPrice", this.getLimitPrice(), 0.0f), this.a("auxPrice", this.getAuxPrice(), 0.0f), this.a("outsideRTH", this.outsideRTH), this.a("tif", (Object)this.tif), this.a("expiryDate", (Object)this.expiryDate), this.a("gtd", (Object)this.gTD), this.b("tag", this.tag), this.a("trailFixed", this.trailFixed, false), this.a("trailPoints", this.trailPoints, 0), this.a("trailStopPrice", this.trailStopPrice, 0.0f), this.a("orderDate", (Object)this.getOrderDate())});
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        this.orderId = jSONObject.str("id");
        String string = OrderDirectory.getPermId(this.orderId);
        if (string != null) {
            this.permanentId = string;
        }
        this.accountId = jSONObject.str("accountId");
        this.parentId = jSONObject.str("parentId");
        this.setInstrument(this.a(jSONObject, "instr"));
        this.setEntryOrder(jSONObject.is("entry"));
        try {
            this.orderType = Enums$OrderType.valueOf(jSONObject.str("type"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.action = Enums$OrderAction.valueOf(jSONObject.str("action"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.status = Enums$OrderStatus.valueOf(jSONObject.str("status"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.tif = Enums$TIF.valueOf(jSONObject.str("tif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.quantity = jSONObject.getFloat("quantity");
        this.usePips = jSONObject.is("usePips", false);
        this.limitPrice = jSONObject.getFloat("limitPrice");
        this.trailStopPrice = jSONObject.getFloat("trailStopPrice");
        this.auxPrice = jSONObject.getFloat("auxPrice");
        this.outsideRTH = jSONObject.is("outsideRTH");
        this.trailFixed = jSONObject.is("trailFixed", false);
        this.trailPoints = jSONObject.getInt("trailPoints");
        if (jSONObject.has("expiryDate")) {
            this.expiryDate = jSONObject.getLong("expiryDate");
        }
        if (jSONObject.has("gtd")) {
            this.gTD = new Date(jSONObject.getLong("gtd"));
        }
        if (jSONObject.has("orderDate")) {
            this.orderDate = new Date(jSONObject.getLong("orderDate"));
        }
        this.tag = jSONObject.str("tag");
        this.simulatedOrder = h.a((Object)this.accountId, (Object)"simulated");
    }

    public static MWOrder read(Element element) {
        String string;
        String string2;
        String string3 = element.getAttribute("id");
        String string4 = element.getAttribute("accountId");
        String string5 = element.getAttribute("parentId");
        String string6 = element.getAttribute("symbol");
        MWInstrument mWInstrument = MWInstrument.get(string6, string2 = element.getAttribute("exchange"));
        if (mWInstrument == null) {
            h.a.warning("MWOrder::read() instrument not found: " + string6 + "." + string2);
            return null;
        }
        Enums$OrderAction enums$OrderAction = Enums$OrderAction.valueOf(element.getAttribute("action"));
        Enums$OrderType enums$OrderType = Enums$OrderType.valueOf(element.getAttribute("type"));
        Enums$OrderStatus enums$OrderStatus = Enums$OrderStatus.valueOf(element.getAttribute("status"));
        int n2 = h.b(element.getAttribute("quantity"));
        float f2 = h.b(element.getAttribute("limitPrice"));
        float f3 = h.b(element.getAttribute("auxPrice"));
        long l2 = h.c(element.getAttribute("openTime"));
        MWOrder mWOrder = new MWOrder(string4, string3, LiveTicker.get(mWInstrument), enums$OrderAction, enums$OrderType, enums$OrderStatus);
        mWOrder.setQuantity(n2);
        mWOrder.setOrderDate(new Date(l2));
        mWOrder.setLimitPrice(f2);
        mWOrder.setAuxPrice(f3);
        if (!h.g(string5)) {
            mWOrder.setParentId(string5);
            mWOrder.setTradeId(string5);
        }
        if (!h.g(string = element.getAttribute("outsideRTH"))) {
            mWOrder.outsideRTH = h.c((Object)string);
        }
        if (!h.g(string = element.getAttribute("tif"))) {
            mWOrder.tif = Enums$TIF.valueOf(string);
        }
        if (!h.g(string = element.getAttribute("expiryDate"))) {
            mWOrder.expiryDate = h.c(string);
        }
        if (!h.g(string = element.getAttribute("gtd"))) {
            mWOrder.gTD = new Date(h.c(string));
        }
        if (!h.g(string = element.getAttribute("tag"))) {
            mWOrder.tag = string;
        }
        if (!h.g(string = element.getAttribute("trailFixed"))) {
            mWOrder.trailFixed = h.c((Object)string);
        }
        if (!h.g(string = element.getAttribute("trailPoints"))) {
            mWOrder.trailPoints = h.b(string);
        }
        if (!h.g(string = element.getAttribute("trailStopPrice"))) {
            mWOrder.trailStopPrice = h.b(string);
        }
        if (!h.g(string = element.getAttribute("usePips"))) {
            mWOrder.usePips = h.c((Object)string);
        }
        if (!h.g(string = element.getAttribute("entry"))) {
            mWOrder.entryOrder = h.c((Object)string);
        }
        mWOrder.discardChanges();
        return mWOrder;
    }

    public void addChild(String string) {
        this.childOrders.a((Object)string);
    }

    public void removeAllChildren() {
        this.childOrders.b();
    }

    public void removeChild(String string) {
        this.childOrders.a((Object)string);
    }

    public List getChildren() {
        return this.childOrders.a();
    }

    public List getChildOrders() {
        if (this.childOrders.a()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (String string : this.childOrders.a()) {
            MWOrder mWOrder = OrderDirectory.findOrder(string);
            if (mWOrder == null) {
                mWOrder = OrderDirectory.findByOrigId(string);
            }
            if (mWOrder == null) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public List getLimitOrders() {
        if (this.childOrders.a()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (String string : this.childOrders.a()) {
            MWOrder mWOrder = OrderDirectory.findOrder(string);
            if (mWOrder == null) {
                mWOrder = OrderDirectory.findByOrigId(string);
            }
            if (mWOrder == null || !mWOrder.isLimit()) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public List getStopTrailOrders() {
        if (this.childOrders.a()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (String string : this.childOrders.a()) {
            MWOrder mWOrder = OrderDirectory.findOrder(string);
            if (mWOrder == null) {
                mWOrder = OrderDirectory.findByOrigId(string);
            }
            if (mWOrder == null || !mWOrder.isStopOrTrail()) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public boolean hasChildren() {
        return !this.childOrders.a();
    }

    public boolean hasServerAttachedStopLimit() {
        if (this.isForceClientAttached()) {
            return false;
        }
        this.resolveClosingOrders();
        return this.getStopTrailOrder() != null || this.getLimitOrder() != null;
    }

    public boolean hasParent() {
        return !this.isParentEmpty();
    }

    public boolean isEntryOrder() {
        if (this.entryOrder != null) {
            return this.entryOrder;
        }
        Account account = this.getAccount();
        if (account != null && account.isHedging()) {
            return true;
        }
        float f2 = Positions.getPosition(this.getAcctInstrument(), account);
        if (this.isBuy()) {
            return f2 >= 0.0f;
        }
        return f2 <= 0.0f;
    }

    public void setEntryOrder(boolean bl2) {
        this.entryOrder = bl2;
    }

    public boolean isNetClose() {
        return this.netClose;
    }

    public void setNetClose(boolean bl2) {
        this.netClose = bl2;
    }

    public String getRateId() {
        return this.rateId;
    }

    public void setRateId(String string) {
        this.rateId = string;
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float f2) {
        this.rate = f2;
    }

    public float getMarketRange() {
        return this.marketRange;
    }

    public void setMarketRange(float f2) {
        this.marketRange = f2;
    }

    public boolean isUseMarketRange() {
        return this.useMarketRange;
    }

    public void setUseMarketRange(boolean bl2) {
        this.useMarketRange = bl2;
    }

    public boolean isTrailFixed() {
        return this.trailFixed;
    }

    public void setTrailFixed(boolean bl2) {
        this.trailFixed = bl2;
    }

    public boolean isAdjustedTrailFixed() {
        if (this.adjustedTrailFixed == null) {
            return this.trailFixed;
        }
        return this.adjustedTrailFixed;
    }

    public void setAdjustedTrailFixed(boolean bl2) {
        if (this.isExitStep()) {
            return;
        }
        boolean bl3 = this.isAdjustedTrailFixed();
        if (bl2 == bl3) {
            return;
        }
        this.adjustedTrailFixed = bl2;
        this.updateAdjustedState();
        this.notify("adjustedTrailFixed", bl3, bl2);
    }

    public boolean isAdjustedUsePips() {
        if (this.adjustedUsePips == null) {
            return this.usePips;
        }
        return this.adjustedUsePips;
    }

    public void setAdjustedUsePips(boolean bl2) {
        if (this.isExitStep()) {
            return;
        }
        boolean bl3 = this.isAdjustedUsePips();
        if (bl2 == bl3) {
            return;
        }
        this.adjustedUsePips = bl2;
        this.updateAdjustedState();
        this.notify("adjustedUsePips", bl3, bl2);
    }

    public int getTrailPoints() {
        return this.trailPoints;
    }

    public void setTrailPoints(int n2) {
        this.trailPoints = n2;
    }

    public int getAdjustedTrailPoints() {
        if (this.adjustedTrailPoints == null || this.adjustedTrailPoints == 0) {
            return this.trailPoints;
        }
        return this.adjustedTrailPoints;
    }

    public void setAdjustedTrailPoints(int n2) {
        if (this.isExitStep()) {
            return;
        }
        int n3 = this.getAdjustedTrailPoints();
        if (n3 == n2) {
            return;
        }
        this.adjustedTrailPoints = n2;
        this.updateAdjustedState();
        this.notify("adjustedTrailPoints", n3, n2);
    }

    public boolean isForceClientAttached() {
        return this.forceClientAttached;
    }

    public void setForceClientAttached(boolean bl2) {
        this.forceClientAttached = bl2;
    }

    public void setChildOrder(MWOrder mWOrder) {
        if (mWOrder == null || mWOrder.isExitStep()) {
            return;
        }
        mWOrder.setParentId(this.getOrderId());
        mWOrder.setTradeId(this.getOrderId());
        if (mWOrder.isLimit()) {
            this.setLimitOrder(mWOrder);
        }
        if (mWOrder.isStopOrTrail() || mWOrder.isMIT()) {
            this.setStopTrailOrder(mWOrder);
        }
        if (!this.childOrders.c(mWOrder.getOrderId())) {
            this.addChild(mWOrder.getOrderId());
        }
    }

    public MWOrder getStopTrailOrder() {
        return this.stopTrailOrder;
    }

    public MWOrder getStopOrder() {
        if (this.stopTrailOrder == null || this.stopTrailOrder.isTrail()) {
            return null;
        }
        return this.stopTrailOrder;
    }

    public MWOrder getTrailOrder() {
        if (this.stopTrailOrder == null || !this.stopTrailOrder.isTrail()) {
            return null;
        }
        return this.stopTrailOrder;
    }

    public void setStopTrailOrder(MWOrder mWOrder) {
        MWOrder mWOrder2 = this.stopTrailOrder;
        if (mWOrder != null && (mWOrder.isCancelled() || mWOrder.isFilled())) {
            this.stopTrailOrder = null;
        } else {
            if (mWOrder == this.stopTrailOrder) {
                return;
            }
            this.stopTrailOrder = mWOrder;
        }
        this.notify("stopTrailOrder", mWOrder2, this.stopTrailOrder);
        this.notify("stopTrailOrderPrice", null, Float.valueOf(this.getStopTrailOrderPrice()));
        this.notify("stopOrderPL", null, (Object)this.getStopOrderPL());
    }

    public float getStopTrailOrderPrice() {
        MWOrder mWOrder = this.getStopTrailOrder();
        if (mWOrder == null) {
            return 0.0f;
        }
        return mWOrder.getAdjustedAuxPrice();
    }

    public double getStopOrderPL() {
        if (this.isFilled()) {
            return 0.0;
        }
        MWOrder mWOrder = this.getStopTrailOrder();
        return mWOrder == null ? 0.0 : mWOrder.getOrderPL();
    }

    public void setStopTrailOrderPrice(float f2) {
        if (this.stopTrailOrder != null) {
            this.stopTrailOrder.setAdjustedAuxPrice(f2);
        }
        this.notify("stopOrderPL", null, (Object)this.getStopOrderPL());
    }

    public MWOrder getLimitOrder() {
        return this.limitOrder;
    }

    public void setLimitOrder(MWOrder mWOrder) {
        MWOrder mWOrder2 = this.limitOrder;
        this.limitOrder = mWOrder != null && (mWOrder.isCancelled() || mWOrder.isFilled()) ? null : mWOrder;
        if (mWOrder2 == this.limitOrder) {
            return;
        }
        this.notify("limitOrder", mWOrder2, this.limitOrder);
        this.notify("limitOrderPrice", null, Float.valueOf(this.getLimitOrderPrice()));
        this.notify("limitOrderPL", null, (Object)this.getLimitOrderPL());
    }

    public float getLimitOrderPrice() {
        if (this.limitOrder == null) {
            return 0.0f;
        }
        return this.limitOrder.getAdjustedLimitPrice();
    }

    public double getCommission() {
        return this.commission;
    }

    public void setCommission(double d2) {
        double d3 = this.commission;
        this.commission = d2;
        this.notify("commission", d3, this.commission);
    }

    public double getLimitOrderPL() {
        if (this.isFilled()) {
            return 0.0;
        }
        MWOrder mWOrder = this.getLimitOrder();
        return mWOrder == null ? 0.0 : mWOrder.getOrderPL();
    }

    public void setLimitOrderPrice(float f2) {
        if (this.limitOrder != null) {
            this.limitOrder.setAdjustedLimitPrice(f2);
        }
        this.notify("limitOrderPL", null, (Object)this.getLimitOrderPL());
    }

    public float getOrderPrice() {
        if (this.isMarket()) {
            if (this.isSell()) {
                return this.ticker.getBidPrice();
            }
            return this.ticker.getAskPrice();
        }
        if (this.isLimit()) {
            return this.getAdjustedLimitPrice();
        }
        return this.getAdjustedAuxPrice();
    }

    public float getUnadjustedOrderPrice() {
        if (this.isMarket()) {
            if (this.isSell()) {
                return this.ticker.getBidPrice();
            }
            return this.ticker.getAskPrice();
        }
        if (this.isLimit()) {
            return this.getLimitPrice();
        }
        return this.getAuxPrice();
    }

    public void setOrderPrice(float f2) {
        if (this.isLimit()) {
            this.setAdjustedLimitPrice(f2);
        }
        if (this.isStop() || this.isMIT()) {
            this.setAdjustedAuxPrice(f2);
        }
        if (this.isTrail()) {
            if (bs.r(this.getAccount())) {
                float f3 = f2 - this.getTriggerPrice();
                if (this.isSell()) {
                    f3 = this.getTriggerPrice() - f2;
                }
                this.setAdjustedAuxPrice(this.getAdjustedAuxPrice() + f3);
            } else if (bs.s(this.getAccount())) {
                this.setAdjustedAuxPrice(f2);
            }
        }
        this.notify("orderPL", 0.0, this.getOrderPL());
        Position position = this.getPosition();
        if (position == null || position.isClosed()) {
            return;
        }
        if (this.isStopOrTrail()) {
            position.notify("stopOrderPL", 0.0, this.getOrderPL());
        } else if (this.isLimit()) {
            position.notify("limitOrderPL", 0.0, this.getOrderPL());
        }
    }

    public double getOrderPL() {
        MWInstrument mWInstrument = this.getAcctInstrument();
        if (mWInstrument == null) {
            return 0.0;
        }
        if (this.isCancelled()) {
            return 0.0;
        }
        float f2 = 0.0f;
        MWOrder mWOrder = this.getParentOrder();
        if (mWOrder != null && !mWOrder.isCancelled() && !mWOrder.isFilled()) {
            f2 = mWOrder.getTriggerPrice();
        }
        if (f2 == 0.0f) {
            if (this.isNetClose()) {
                var4_4 = Positions.getSummary(mWInstrument, this.getAccountId());
                if (var4_4 == null) {
                    return 0.0;
                }
                f2 = ((PositionSummary)var4_4).getAvgPrice();
            } else {
                var4_4 = this.position;
                if (var4_4 == null || ((Position)var4_4).isClosed() || ((Position)var4_4).getQuantity() == 0.0f) {
                    return 0.0;
                }
                f2 = ((Position)var4_4).getEntryPrice();
            }
        }
        if (f2 == 0.0f) {
            return 0.0;
        }
        float f3 = this.getTriggerPrice();
        float f4 = Math.abs(this.getAdjustedQuantity());
        if (this.isBuy()) {
            f4 *= -1.0f;
        }
        return mWInstrument.calcPnLAndConvert(f2, f3, f4, ab.a(this.getAccount()));
    }

    public void resolveClosingOrders() {
        List list = OrderDirectory.findChildOrders(this.getOrderId());
        if (h.a((Collection)list) && !h.g(this.getOrigOrderId())) {
            list = OrderDirectory.findChildOrders(this.getOrigOrderId());
        }
        this.resolveClosingOrders(list);
    }

    void resolveClosingOrders(List list) {
        if (h.a((Collection)list)) {
            this.childOrders.b();
            this.setLimitOrder(null);
            this.setStopTrailOrder(null);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        boolean bl3 = false;
        for (MWOrder mWOrder : list) {
            if (!mWOrder.getAcctInstrument().equals(this.getAcctInstrument()) || mWOrder.isExitStep() || mWOrder.isCancelled() || mWOrder.isCancelInProgress()) continue;
            arrayList.add(mWOrder.getOrderId());
            if (mWOrder.isStopOrTrail() || mWOrder.isMIT()) {
                bl3 = true;
                this.setStopTrailOrder(mWOrder);
                continue;
            }
            if (!mWOrder.isLimit()) continue;
            bl2 = true;
            this.setLimitOrder(mWOrder);
        }
        this.childOrders.d(arrayList);
        if (!bl2) {
            this.setLimitOrder(null);
        }
        if (!bl3) {
            this.setStopTrailOrder(null);
        }
    }

    public void updateAdjustedState() {
        boolean bl2 = this.adjusted;
        boolean bl3 = this.adjusted = this.getLimitPrice() != this.getAdjustedLimitPrice() || this.getQuantity() != this.getAdjustedQuantity() || this.getMaxShowQty() != this.getAdjustedMaxShowQty() || this.isMaxShowQtyEnabled() != this.isAdjustedMaxShowQtyEnabled() || this.getAuxPrice() != this.getAdjustedAuxPrice() || this.isOutsideRTH() != this.isAdjustedOutsideRTH() || this.getTrailPoints() != this.getAdjustedTrailPoints() || this.isTrailFixed() != this.isAdjustedTrailFixed() || this.isUsePips() != this.isAdjustedUsePips();
        if (!this.adjusted) {
            this.adjusted |= !h.a((Object)this.getExpiryDate(), (Object)this.getAdjustedExpiryDate());
            this.adjusted |= this.getTif() != this.getAdjustedTif();
            if (!this.adjusted && this.getTif() == Enums$TIF.GTD) {
                this.adjusted |= !h.a((Object)this.getGTD(), (Object)this.getAdjustedGTD());
            }
        }
        if (bl2 != this.adjusted) {
            this.notify("adjusted", bl2, this.adjusted);
        }
    }

    public boolean isCancelInProgress() {
        return this.cancelInProgress;
    }

    public void setCancelInProgress(boolean bl2) {
        this.cancelInProgress = bl2;
    }

    public boolean isReplay() {
        Account account = this.getAccount();
        return account == null ? false : account.isReplay();
    }

    public boolean isExitStep() {
        return this.exitStep != null;
    }

    public ExitStep getExitStep() {
        return this.exitStep;
    }

    public void setExitStep(ExitStep exitStep) {
        this.exitStep = exitStep;
    }

    public void applyExitStrategyUpdates() {
        ExitStep exitStep = this.exitStep;
        if (exitStep == null) {
            return;
        }
        MWOrder mWOrder = this.getParentOrder();
        if (mWOrder == null) {
            h.a.warning("MWOrder::applyExitStrategyUpdates() parent order not found!");
            return;
        }
        float f2 = mWOrder.getTriggerPrice();
        if (f2 == 0.0f) {
            h.a.warning("MWOrder::applyExitStrategyUpdates() trigger price is 0!");
            return;
        }
        MWInstrument mWInstrument = mWOrder.getAcctInstrument();
        if (this.isStopOrTrail()) {
            exitStep.setStopOffset(mWInstrument.priceToInt(Math.abs(this.getAdjustedAuxPrice() - f2)));
        } else if (this.isLimit()) {
            exitStep.setTargetOffset(mWInstrument.priceToInt(Math.abs(this.getAdjustedLimitPrice() - f2)));
        }
        this.commitChanges();
    }

    public void removeExitOrder() {
        ExitStep exitStep = this.exitStep;
        if (exitStep == null) {
            return;
        }
        if (this.isStopOrTrail()) {
            exitStep.setStopEnabled(false);
        } else if (this.isLimit()) {
            exitStep.setTargetEnabled(false);
        }
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean bl2) {
        this.waiting = bl2;
    }

    public String getFailedMsg() {
        return this.failedMsg;
    }

    public void setFailedMsg(String string) {
        this.failedMsg = string;
    }

    public boolean isSimulatedOrder() {
        return this.simulatedOrder;
    }

    public void setSimulatedOrder(boolean bl2) {
        this.simulatedOrder = bl2;
    }

    public boolean isClientMITOrder() {
        return this.getType() == Enums$OrderType.MIT && !this.supportsMITOrders();
    }

    public boolean isClientOrder() {
        MWOrder mWOrder;
        if (this.isSimulatedOrder() || this.isReplay() || this.isClientMITOrder() || this.isExitStep()) {
            return true;
        }
        if (!this.isNew() && !this.isPreSubmitted()) {
            return false;
        }
        if (this.hasParent() && !bs.h(this.getAccount()) && (mWOrder = this.getParentOrder()) != null && mWOrder.isActive()) {
            return true;
        }
        return OrderDirectory.isClientAttachedOrder(this);
    }

    public cd getTradeRoute() {
        return this.tradeRoute;
    }

    public void setTradeRoute(cd cd2) {
        this.tradeRoute = cd2;
    }

    public String getLeverage() {
        return this.leverage;
    }

    public void setLeverage(String string) {
        this.leverage = string;
    }

    public String getSideEffect() {
        return this.sideEffect;
    }

    public void setSideEffect(String string) {
        this.sideEffect = string;
    }

    public int getOffsetTicks() {
        return this.offsetTicks;
    }

    public void setOffsetTicks(int n2) {
        this.offsetTicks = n2;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long l2) {
        if (this.created == l2) {
            return;
        }
        long l3 = this.created;
        this.created = l2;
        if (this.created > this.lastModified) {
            this.lastModified = this.created;
        }
        this.notify("created", l3, l2);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long l2) {
        this.lastModified = l2;
    }

    public void updateLastModified() {
        if (this.isReplay()) {
            this.setLastModified(this.getTicker().getLastTimestamp());
        } else {
            this.setLastModified(bs.a());
        }
    }

    public boolean isCancelReplaceInProgress() {
        return this.cancelReplaceInProgress;
    }

    public void setCancelReplaceInProgress(boolean bl2) {
        this.cancelReplaceInProgress = bl2;
    }

    public com.motivewave.platform.service.srvc.j getPrimaryService() {
        by by2 = bs.a(this.getAccount());
        if (by2 == null) {
            return null;
        }
        return by2.a();
    }

    public Enums$ServiceType getServiceType() {
        by by2 = bs.a(this.getAccount());
        if (by2 == null) {
            return null;
        }
        return by2.a().a();
    }

    public List getTradeRoutes() {
        if (this.isSimulatedOrder() || this.isReplay()) {
            return new ArrayList();
        }
        com.motivewave.platform.service.srvc.j j2 = this.getPrimaryService();
        if (j2 == null) {
            return new ArrayList();
        }
        return j2.a(this.getAcctInstrument().getExchange());
    }

    public com.motivewave.platform.service.srvc.j getRealTimeService() {
        by by2 = bs.a(this.getAccount());
        if (by2 == null) {
            return null;
        }
        return by2.c();
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }

    public void setUpdateInProgress(boolean bl2) {
        this.updateInProgress = bl2;
    }

    public void createHandler() {
        if (this.handler != null || this.ticker == null) {
            return;
        }
        if (!this.isReplay() && !this.isSimulatedOrder()) {
            return;
        }
        this.handler = new bb(this);
        this.ticker.addTickListener(this.handler);
    }

    public void submitClientMIT() {
        if (!this.isClientMITOrder()) {
            return;
        }
        this.commitChanges();
        this.setStatus(Enums$OrderStatus.SUBMITTED);
        OrderDirectory.orderModified(this.getOrderId());
        this.createMITHandler();
    }

    public void createMITHandler() {
        if (this.mitHandler != null) {
            return;
        }
        if (this.isReplay() || this.isSimulatedOrder()) {
            return;
        }
        this.mitHandler = new ba(this);
        this.ticker.addTickListener(this.mitHandler);
    }

    public void fillReplay() {
        if (!this.isReplay() || !this.isMarket()) {
            return;
        }
        this.setFilled(Math.abs(this.getQuantity()));
        float f2 = this.isBuy() ? this.ticker.getBuyPrice() : this.ticker.getSellPrice();
        this.setLastFillPrice(f2);
        this.setAvgFillPrice(f2);
        this.setLastFillTime(this.ticker.getLastTimestamp());
        this.setCommission(this.ticker.getInstrument().calcCommission(this.getFilled()));
        this.setStatus(Enums$OrderStatus.FILLED);
        OrderDirectory.orderFilled(this.getOrderId());
    }

    @Override
    public void orderIdChanged(String string, String string2) {
        for (String string3 : this.childOrders.a()) {
            if (!h.a((Object)string3, (Object)string)) continue;
            this.childOrders.a((Object)string3);
            this.childOrders.a((Object)string2);
        }
    }

    @Override
    public MWOrder clone() {
        try {
            MWOrder mWOrder = (MWOrder)super.clone();
            mWOrder.origOrderId = null;
            mWOrder.exchOrderId = null;
            mWOrder.tag = null;
            mWOrder.parentId = null;
            mWOrder.clientId = null;
            mWOrder.chainId = null;
            mWOrder.ibOrderId = 0;
            mWOrder.permanentId = h.a();
            mWOrder.status = Enums$OrderStatus.NEW;
            mWOrder.groupColor = null;
            mWOrder.tradeId = "";
            mWOrder.ocaId = null;
            mWOrder.orderId = OrderDirectory.getNextOrderId();
            mWOrder.childOrders = new com.motivewave.common.util.g();
            mWOrder.position = null;
            mWOrder.positionSummary = null;
            mWOrder.ignoreChildUpdate = false;
            mWOrder.cancelReplaceInProgress = false;
            mWOrder.cancelInProgress = false;
            mWOrder.updateInProgress = false;
            mWOrder.waiting = false;
            mWOrder.failedMsg = null;
            mWOrder.simulatedOrder = false;
            mWOrder.rejected = false;
            mWOrder.remaining = 0.0f;
            mWOrder.filled = 0.0f;
            mWOrder.trailStopPrice = 0.0f;
            mWOrder.handler = null;
            mWOrder.mitHandler = null;
            OrderDirectory.register(mWOrder);
            if (this.stopTrailOrder != null) {
                mWOrder.stopTrailOrder = this.stopTrailOrder.clone();
                mWOrder.stopTrailOrder.setParentId(mWOrder.getOrderId());
                mWOrder.childOrders.a((Object)mWOrder.stopTrailOrder.getOrderId());
                OrderDirectory.register(mWOrder.stopTrailOrder);
            }
            if (this.limitOrder != null) {
                mWOrder.limitOrder = this.limitOrder.clone();
                mWOrder.limitOrder.setParentId(mWOrder.getOrderId());
                mWOrder.childOrders.a((Object)mWOrder.limitOrder.getOrderId());
                OrderDirectory.register(mWOrder.limitOrder);
            }
            return mWOrder;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isIgnoreChildUpdate() {
        return this.ignoreChildUpdate;
    }

    public void setIgnoreChildUpdate(boolean bl2) {
        this.ignoreChildUpdate = bl2;
    }

    public void onFilled() {
        if (this.onFilledHandlers == null) {
            return;
        }
        for (MWOrder$OnFilled mWOrder$OnFilled : this.onFilledHandlers.a()) {
            mWOrder$OnFilled.onFilled(this);
        }
        this.onFilledHandlers.b();
    }

    public void addOnFilled(MWOrder$OnFilled mWOrder$OnFilled) {
        if (this.onFilledHandlers == null) {
            this.onFilledHandlers = new com.motivewave.common.util.g();
        }
        this.onFilledHandlers.a((Object)mWOrder$OnFilled);
    }

    private void handleMIT(v v2, float f2) {
        float f3 = this.getAuxPrice();
        float f4 = v2.getPrice();
        boolean bl2 = this.isBuy();
        if (f4 == 0.0f) {
            float f5 = f4 = bl2 ? v2.getAskPrice() : v2.getBidPrice();
        }
        if (f4 == 0.0f) {
            return;
        }
        boolean bl3 = false;
        if (f4 == f3) {
            bl3 = true;
        } else if (f2 != 0.0f) {
            if (f4 < f3 && f2 > f3) {
                bl3 = true;
            } else if (f4 > f3 && f2 < f3) {
                bl3 = true;
            }
        }
        if (!bl3) {
            return;
        }
        Ticker ticker = this.ticker;
        Account account = this.getAccount();
        float f6 = this.getQuantity();
        MWOrder mWOrder = this.getStopTrailOrder();
        MWOrder mWOrder2 = this.getLimitOrder();
        MWOrder mWOrder3 = OrderDirectory.createMarketOrder(account, this.ticker, bl2 ? Enums$OrderAction.BUY : Enums$OrderAction.SELL, ticker.getInstrument().getDefaultTIF(), f6);
        OrderDirectory.assignNewOrderId(this, mWOrder3.getOrderId());
        mWOrder3.setOCAId(this.getOCAId());
        this.destroy();
        if (mWOrder != null) {
            ag.a(mWOrder3, mWOrder);
        }
        if (mWOrder2 != null) {
            ag.a(mWOrder3, mWOrder2);
        }
        ag.b(mWOrder3);
    }
}

