/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import ah.f;
import ai.o;
import at.e;
import com.motivewave.common.Enums$DayOfWeek;
import com.motivewave.common.MWException;
import com.motivewave.common.util.ao;
import com.motivewave.common.util.g;
import com.motivewave.common.util.h;
import com.motivewave.common.util.k;
import com.motivewave.common.util.w;
import com.motivewave.platform.common.Enums$BackAdjustMethod;
import com.motivewave.platform.common.Enums$BarSizeMethod;
import com.motivewave.platform.common.Enums$CustomInstrumentType;
import com.motivewave.platform.common.Enums$CustomOperation;
import com.motivewave.platform.common.Enums$InstrumentType;
import com.motivewave.platform.common.Enums$OptionType;
import com.motivewave.platform.common.Enums$OrderExpiry;
import com.motivewave.platform.common.Enums$OrderType;
import com.motivewave.platform.common.Enums$RollMethod;
import com.motivewave.platform.common.Enums$RollWeekOfMonth;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.Enums$TIF;
import com.motivewave.platform.common.a;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.AnalysisSource;
import com.motivewave.platform.databean.BarBuildSettings;
import com.motivewave.platform.databean.Commission;
import com.motivewave.platform.databean.ConnectionID;
import com.motivewave.platform.databean.Currency;
import com.motivewave.platform.databean.Exchange;
import com.motivewave.platform.databean.Flag;
import com.motivewave.platform.databean.IndustryGroup;
import com.motivewave.platform.databean.InstrumentListener;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument$Dependency;
import com.motivewave.platform.databean.MWInstrument$MinTickRule;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.OptionInfo;
import com.motivewave.platform.databean.OrderPreset;
import com.motivewave.platform.databean.PropertyBean;
import com.motivewave.platform.databean.RollSettings;
import com.motivewave.platform.databean.Sector;
import com.motivewave.platform.databean.SymbolInfo;
import com.motivewave.platform.databean.TimeZoneTH;
import com.motivewave.platform.databean.TradingHours;
import com.motivewave.platform.databean.TradingHours$TradingTimes;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.ax;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.SettingsBase;
import com.motivewave.platform.service.SymbolUtil;
import com.motivewave.platform.service.ab;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.by;
import com.motivewave.platform.service.srvc.j;
import com.motivewave.platform.service.srvc.x;
import com.motivewave.platform.service.z;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javafx.beans.InvalidationListener;
import o.d;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MWInstrument
extends ObservableBean
implements com.motivewave.platform.common.w,
Comparable {
    private static Map resolvedMap = Collections.synchronizedMap(new HashMap());
    private int places = -1000;
    private int places2 = -1000;
    private int pointPlaces = -1000;
    private int id = -1;
    private static int idCounter = 1;
    private int uniqueId;
    private String key;
    private String symbol;
    private String underlying;
    private String productCode;
    private String baseSymbol;
    private String commonSymbol;
    private String altCommonSymbol;
    private String exchange;
    private String primaryExchange;
    private String symbolDisplay;
    private String symbolData;
    private String historicalSymbol;
    private String historicalExchange;
    private Enums$InstrumentType type;
    private String title;
    private String sourceDescription;
    private String description;
    private double minTick = 0.01;
    private double minTickTenth = 0.001;
    private float minTickFloat = 0.01f;
    private boolean tickOverride = false;
    private double pointSize = -1.0;
    private String sectorId;
    private String industryGroupId;
    private String serviceId;
    private String symbolDir;
    private Date expiryDate;
    private double priceMagnifier = 1.0;
    private double plDivisor = 1.0;
    private double displayMultiplier = 0.0;
    private String displayMask;
    private DecimalFormat displayFormat;
    private String currency;
    private Double strikePrice;
    private Enums$OptionType optionType;
    private String tradingHoursID;
    private TimeZone timeZone;
    private double contractValue;
    private int contractSize;
    private double pointValue;
    private boolean useDefaultCommission = true;
    private double baseCost = 0.0;
    private double unitCost = 0.0;
    private int unitSize = 1;
    private Boolean showExtendedData;
    private Boolean backFillEnabled;
    private boolean localDataOnly = false;
    private boolean intradayData = true;
    private boolean useContinuousData = true;
    private boolean useContinuousIntraday = true;
    private boolean minuteDailyBars = false;
    private String customDefinition;
    private List dependentInstruments = new ArrayList(1);
    private Enums$CustomInstrumentType customType = Enums$CustomInstrumentType.INDEX;
    private Enums$CustomOperation customOperation = Enums$CustomOperation.SUM;
    private boolean customInverted = false;
    private double customMultiplier = 1.0;
    private Map serviceMap = new LinkedHashMap(1);
    private ConnectionID source;
    private ConnectionID realTimeSource;
    private ConnectionID historicalSource;
    private ConnectionID newsSource;
    private RollSettings rollSettings = null;
    private BarBuildSettings barBuildSettings = null;
    private int contractNumber = 0;
    private MWInstrument activeContract;
    private long activeExp = 0L;
    private String AC_SYNC = com.motivewave.common.h.a();
    private at.f savedPreset;
    private List minTickRules = new ArrayList();
    private long lastTHResolve = 0L;
    private TradingHours lastTH;
    private TradingHours tradingHours;
    private TradingHours defaultHours;
    private Boolean extendedData;
    private boolean resolved = false;
    private Boolean level1PriceSupported = null;
    private Boolean bidAskPriceSupported = null;
    private Boolean historicalBidAskSupported = null;
    private Boolean historicalPriceSupported = null;
    private String flagId;
    private String notes;
    private ao instrListeners = new ao();
    private k analysisDirMap = new k();
    private static Map idMap = new HashMap();
    private static Map keyMap = new HashMap();
    private static Map commonMap = new HashMap();
    private static Map oldKeyMap = new HashMap();
    private static Map symbolFXMap = new HashMap();
    private static Map symbolAlpha2Map = new HashMap();
    private static Map symbol2InstrumentMap = new HashMap();
    private static Map symbolDisplayMap = new HashMap();
    private static Map symbolExchangeMap = new HashMap();
    private static Map symbol2RelatedMap = new HashMap();
    private static g allInstruments = new g();
    private static Map serviceIdMap = new HashMap();
    private static boolean ignoreEvents = false;
    private static boolean unsavedChanges = false;
    private static int pendingUpdates = 0;
    private static g listeners = new g();

    public static MWInstrument resolve(String object) {
        if (com.motivewave.common.h.g((String)object)) {
            return null;
        }
        MWInstrument mWInstrument = MWInstrument.byKey((String)object);
        if (mWInstrument == null && ((String)object).endsWith(".RITHMIC_GATEWAY")) {
            object = ((String)object).substring(0, ((String)object).lastIndexOf(46)) + ".RITHMIC";
            mWInstrument = MWInstrument.byKey((String)object);
        }
        if (mWInstrument != null) {
            return mWInstrument;
        }
        mWInstrument = com.motivewave.platform.common.w.c((String)object);
        if (mWInstrument != null) {
            return mWInstrument;
        }
        if (((String)object).indexOf(124) >= 0 && ((String)object).length() > 20 && (mWInstrument = com.motivewave.platform.common.w.a((String)object, false, true)) != null) {
            return mWInstrument;
        }
        if (resolvedMap.containsKey(object)) {
            return (MWInstrument)resolvedMap.get(object);
        }
        mWInstrument = MWInstrument._resolve((String)object);
        resolvedMap.put(object, mWInstrument);
        return mWInstrument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MWInstrument _resolve(String string) {
        long l2 = System.currentTimeMillis();
        MWInstrument mWInstrument = null;
        try {
            Object object;
            Object object2;
            List list = com.motivewave.common.h.a(string, '.');
            if (com.motivewave.common.h.a((Collection)list)) {
                MWInstrument mWInstrument2 = null;
                return mWInstrument2;
            }
            String string2 = (String)list.get(0);
            Enums$ServiceType enums$ServiceType = null;
            if (list.size() > 1) {
                object2 = com.motivewave.common.h.b(list.get(list.size() - 1)).toUpperCase();
                try {
                    enums$ServiceType = Enums$ServiceType.read((String)object2);
                }
                catch (Exception exception) {
                    com.motivewave.common.h.a.warning("MWJSONUtil::instr() bad service type: " + (String)object2 + " " + string);
                }
            }
            if (com.motivewave.common.h.a((Collection)(object2 = com.motivewave.platform.common.ab.a(string2, enums$ServiceType, null, true))) && !bs.a(new Enums$ServiceType[]{enums$ServiceType})) {
                object2 = com.motivewave.platform.common.ab.a(string2, null, null, true);
            }
            if (com.motivewave.common.h.a((Collection)object2)) {
                MWInstrument mWInstrument3 = null;
                return mWInstrument3;
            }
            mWInstrument = (MWInstrument)object2.get(0);
            if (list.size() > 2 && !com.motivewave.common.h.g((String)list.get(1))) {
                object = (String)list.get(1);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    MWInstrument mWInstrument4 = (MWInstrument)iterator.next();
                    if (!com.motivewave.common.h.b((Object)mWInstrument4.getExchange(), object)) continue;
                    mWInstrument = mWInstrument4;
                    break;
                }
            }
            object = MWInstrument.create(mWInstrument);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            long l3 = System.currentTimeMillis() - l2;
            if (l3 > 1000L) {
                System.err.println("MWInstrument::resolve() " + string + " elapsed: " + l3);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWInstrument() {
        Class<MWInstrument> clazz = MWInstrument.class;
        synchronized (MWInstrument.class) {
            this.uniqueId = idCounter++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public MWInstrument(JSONObject jSONObject) {
        this();
        this.fromJSON(jSONObject);
    }

    public MWInstrument(String string, Enums$InstrumentType enums$InstrumentType, String string2, String string3) {
        this();
        this.underlying = string;
        this.symbol = string;
        this.type = enums$InstrumentType;
        this.exchange = string2;
        this.currency = string3;
    }

    public MWInstrument(String string, Enums$InstrumentType enums$InstrumentType, String string2, String string3, ConnectionID connectionID) {
        this(string, enums$InstrumentType, string2, string3);
        this.source = connectionID;
    }

    public MWInstrument(e e2) {
        this(e2.b(), e2.a(), e2.e(), e2.f());
        this.underlying = e2.a();
        this.title = this.description = e2.d();
        this.setMinTick(e2.a());
        this.pointSize = e2.c();
        this.expiryDate = e2.a();
        this.strikePrice = e2.b();
        this.optionType = e2.a();
        this.contractSize = e2.a();
        this.displayMultiplier = e2.f();
        this.plDivisor = e2.e();
        this.pointValue = e2.g();
        this.priceMagnifier = e2.d();
        if (!com.motivewave.common.h.g(e2.g())) {
            this.primaryExchange = e2.g();
        }
        this.source = e2.a();
        this.serviceId = e2.j();
        this.savedPreset = e2.a();
        if (!com.motivewave.common.h.g(e2.c())) {
            this.setSymbolDisplay(e2.c());
        }
    }

    public MWInstrument(z z2) {
        this(z2.b(), Enums$InstrumentType.FUTURE, z2.c(), z2.e());
        this.underlying = z2.a();
        this.title = z2.d();
        this.setMinTick(z2.a());
        this.pointSize = 1.0;
        this.pointValue = z2.c();
        this.expiryDate = z2.a();
        this.displayMultiplier = z2.b();
    }

    public String getLetter() {
        int n2;
        String string = this.getSymbol();
        if (!Character.isDigit(string.charAt(string.length() - 1))) {
            return "";
        }
        for (n2 = string.length() - 1; n2 >= 0 && Character.isDigit(string.charAt(n2)); --n2) {
        }
        if (n2 < 0) {
            return "";
        }
        return string.substring(n2, n2 + 1);
    }

    public void updateFrom(OptionInfo optionInfo) {
        if (optionInfo == null) {
            return;
        }
        boolean bl2 = false;
        if (optionInfo.putCall != null && this.getOptionType() != optionInfo.putCall) {
            this.setOptionType(optionInfo.putCall);
            bl2 = true;
        }
        if (optionInfo.expires > 0L && this.getExpiryTime() != optionInfo.expires) {
            this.setExpiryDate(new Date(optionInfo.expires));
            bl2 = true;
        }
        if (optionInfo.strikePrice != 0.0 && optionInfo.strikePrice != com.motivewave.common.h.a(this.getStrikePrice())) {
            this.setStrikePrice(optionInfo.strikePrice);
            bl2 = true;
        }
        if (!com.motivewave.common.h.g(optionInfo.underlying) && !com.motivewave.common.h.a((Object)optionInfo.underlying, (Object)this.getUnderlying())) {
            this.setUnderlying(optionInfo.underlying);
            bl2 = true;
        }
        if (optionInfo.exchange != null && !com.motivewave.common.h.a((Object)this.getExchange(), (Object)optionInfo.exchange.getSymbol())) {
            this.setExchange(optionInfo.exchange.getSymbol());
            bl2 = true;
        }
        if (bl2) {
            MWInstrument.update(this);
        }
    }

    public double calcPnL(double d2, float f2, String string) {
        return this.convertTo(this.calcPnL(d2, f2), string);
    }

    public double calcPnL(double d2, float f2) {
        if (f2 == 0.0f) {
            return 0.0;
        }
        d2 = this.round(d2);
        double d3 = d2 * (double)f2;
        if (this.isStock()) {
            return d3;
        }
        if (this.isOption()) {
            int n2 = 100;
            if (this.getContractSize() > 0) {
                n2 = this.getContractSize();
            }
            d3 *= (double)n2;
            if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
                d3 = d2 * this.getPointValue() / this.getPointSize() * (double)f2;
            }
        } else if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
            d3 = d2 * this.getPointValue() / this.getPointSize() * (double)f2;
        } else if (this.getPLDivisor() > 0.0) {
            d3 /= this.getPLDivisor();
        }
        return d3;
    }

    public float roundQty(float f2) {
        if (this.isStock()) {
            if (f2 < 10.0f) {
                f2 *= 1.025f;
            } else if (f2 < 100.0f) {
                f2 *= 1.0025f;
            } else if (f2 < 1000.0f) {
                f2 *= 1.00025f;
            } else if (f2 < 10000.0f) {
                f2 *= 1.000025f;
            } else if (f2 < 100000.0f) {
                f2 *= 1.0000025f;
            } else if (f2 < 1000000.0f) {
                f2 *= 1.0000002f;
            } else if (f2 < 1.0E7f) {
                f2 *= 1.0f;
            }
            return (int)Math.floor(f2);
        }
        OrderPreset orderPreset = this.getOrderPreset();
        float f3 = orderPreset.getQuantityInc();
        if (f3 > 1.0f) {
            int n2 = (int)f3;
            int n3 = (int)Math.floor(f2);
            if (n3 < n2 && (double)n3 / (double)n2 > 0.8) {
                n3 = n2;
            }
            if (n3 % n2 != 0) {
                n3 /= n2;
                n3 *= n2;
            }
            return n3;
        }
        if (f2 < 10.0f) {
            f2 *= 1.025f;
        } else if (f2 < 100.0f) {
            f2 *= 1.0025f;
        } else if (f2 < 1000.0f) {
            f2 *= 1.00025f;
        } else if (f2 < 10000.0f) {
            f2 *= 1.000025f;
        } else if (f2 < 100000.0f) {
            f2 *= 1.0000025f;
        } else if (f2 < 1000000.0f) {
            f2 *= 1.0000002f;
        } else if (f2 < 1.0E7f) {
            f2 *= 1.0f;
        }
        return com.motivewave.common.h.c(f2, f3);
    }

    public float calcQty(double d2, double d3) {
        if (d3 == 0.0) {
            return 0.0f;
        }
        d2 = this.round(d2);
        float f2 = (float)(d3 / d2);
        if (this.isStock()) {
            return this.roundQty(f2);
        }
        if (this.isOption()) {
            int n2 = 100;
            if (this.getContractSize() > 0) {
                n2 = this.getContractSize();
            }
            f2 /= (float)n2;
            if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
                f2 = (float)(d3 / (d2 * this.getPointValue() / this.getPointSize()));
            }
        } else if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
            f2 = (float)(d3 / (d2 * this.getPointValue() / this.getPointSize()));
        } else if (this.getPLDivisor() > 0.0) {
            f2 = (float)((double)f2 * this.getPLDivisor());
        }
        return this.roundQty(f2);
    }

    public double calcRawMove(double d2, float f2) {
        if (f2 == 0.0f) {
            return 0.0;
        }
        double d3 = d2 / (double)f2;
        if (this.isStock()) {
            return d3;
        }
        if (this.isOption()) {
            int n2 = 100;
            if (this.getContractSize() > 0) {
                n2 = this.getContractSize();
            }
            d3 /= (double)n2;
            if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
                d3 = d2 / (double)f2 * this.getPointSize() / this.getPointValue();
            }
        } else if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
            d3 = d2 / (double)f2 * this.getPointSize() / this.getPointValue();
        } else if (this.getPLDivisor() > 0.0) {
            d3 *= this.getPLDivisor();
        }
        return d3;
    }

    public double calcPnL(float f2, float f3, float f4) {
        if (f4 == 0.0f) {
            return 0.0;
        }
        double d2 = this.calcPnL(f3 - f2, f4);
        return d2;
    }

    public double calcPnLAndConvert(float f2, float f3, String string) {
        if (f3 == 0.0f) {
            return 0.0;
        }
        return this.convertTo(this.calcPnL(f2, f3), string);
    }

    public double calcPnLAndConvert(float f2, float f3, float f4, String string) {
        if (f4 == 0.0f) {
            return 0.0;
        }
        return this.convertTo(this.calcPnL(f3 - f2, f4), string);
    }

    public float calcAndConvertPrice(double d2, float f2, float f3) {
        if (f3 == 0.0f) {
            return 0.0f;
        }
        String string = this.getCurrency();
        if (!com.motivewave.common.h.a((Object)string, (Object)bs.b())) {
            d2 = this.convertFrom(d2, bs.b());
        }
        double d3 = d2 / (double)f3;
        if (!this.isStock()) {
            if (this.isOption()) {
                int n2 = 100;
                if (this.getContractSize() > 0) {
                    n2 = this.getContractSize();
                }
                d3 /= (double)n2;
                if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
                    d3 = d2 / (double)f3 * this.getPointSize() / this.getPointValue();
                }
            } else if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
                d3 = d2 / (double)f3 * this.getPointSize() / this.getPointValue();
            } else if (this.getPLDivisor() > 0.0) {
                d3 *= this.getPLDivisor();
            }
        }
        return this.round((float)((double)f2 + d3));
    }

    public double convertTo(double d2, Account account) {
        if (account == null || com.motivewave.common.h.g(account.getBaseCurrency())) {
            return this.convertTo(d2, bs.b());
        }
        return this.convertTo(d2, account.getBaseCurrency());
    }

    public double convertTo(double d2, String string) {
        ax ax2 = LiveTicker.get(this).getConverter(string);
        return ax2.a(d2);
    }

    public double convertFrom(double d2, String string) {
        ax ax2 = LiveTicker.get(this).getConverter(string);
        return ax2.b(d2);
    }

    public Enums$OrderExpiry getDefaultExpiry() {
        OrderPreset orderPreset = this.getOrderPreset();
        if (orderPreset == null || orderPreset.getOrderExpiry() == null) {
            return Enums$OrderExpiry.ONE_DAY;
        }
        return orderPreset.getOrderExpiry();
    }

    public Enums$TIF getDefaultTIF() {
        OrderPreset orderPreset = this.getOrderPreset();
        if (orderPreset == null || orderPreset.getTif() == null) {
            return Enums$TIF.GTC;
        }
        return orderPreset.getTif();
    }

    public float getDefaultQuantity() {
        OrderPreset orderPreset = this.getOrderPreset();
        float f2 = this.getMinStep();
        if (orderPreset == null) {
            return f2;
        }
        float f3 = orderPreset.getQuantity();
        if (f3 < f2) {
            return f2;
        }
        if (f3 < orderPreset.getMinQuantity()) {
            return orderPreset.getMinQuantity();
        }
        return f3;
    }

    public float getMinQuantity() {
        OrderPreset orderPreset = this.getOrderPreset();
        float f2 = this.getMinStep();
        if (orderPreset == null) {
            return f2;
        }
        float f3 = orderPreset.getMinQuantity();
        if (f3 < f2) {
            return f2;
        }
        return f3;
    }

    public List getPresetQuantities() {
        OrderPreset orderPreset = this.getOrderPreset();
        if (orderPreset != null) {
            return new ArrayList(orderPreset.getQuantities());
        }
        ArrayList<Float> arrayList = new ArrayList<Float>();
        float f2 = this.getQuantityInc();
        arrayList.add(Float.valueOf(f2));
        arrayList.add(Float.valueOf(f2 * 2.0f));
        arrayList.add(Float.valueOf(f2 * 3.0f));
        arrayList.add(Float.valueOf(f2 * 5.0f));
        arrayList.add(Float.valueOf(f2 * 10.0f));
        arrayList.add(Float.valueOf(f2 * 15.0f));
        return arrayList;
    }

    public float getQuantityInc() {
        OrderPreset orderPreset = this.getOrderPreset();
        if (orderPreset == null) {
            return this.getMinStep();
        }
        return orderPreset.getQuantityInc();
    }

    public boolean isValueValid(double d2) {
        if (d2 <= this.minTick && d2 >= -this.minTick) {
            return false;
        }
        if (this.isCash() && d2 < 0.0) {
            return false;
        }
        return !Double.isNaN(d2) && !Double.isInfinite(d2);
    }

    public boolean isValueValid(float f2) {
        if (f2 <= this.minTickFloat && f2 >= -this.minTickFloat) {
            return false;
        }
        return !Float.isNaN(f2) && !Float.isInfinite(f2);
    }

    @Override
    public List getNVPs() {
        Object object = com.motivewave.common.h.b(new String[]{this.b("underlying", this.getUnderlying()), this.b("symbol", this.getSymbol()), this.b("symbolDisplay", this.symbolDisplay), this.b("symbolData", this.symbolData), this.b("histSymbol", this.historicalSymbol), this.b("histExchange", this.historicalExchange), this.b("productCode", this.productCode), this.b("title", this.title), this.b("exchange", this.exchange), this.b("currency", this.currency), this.a("type", (Object)this.getType()), this.b("serviceId", this.serviceId), this.a("minTick", this.getMinTick()), this.a("pointSize", this.getPointSize()), this.a("optionType", (Object)this.getOptionType()), this.a("pointValue", this.getPointValue()), this.a("plDivisor", this.getPLDivisor()), this.a("strikePrice", (Object)this.getStrikePrice()), this.a("priceMagnifier", this.getPriceMagnifier()), this.b("displayMask", this.displayMask), this.a("displayMultiplier", this.displayMultiplier), this.b("desc", this.description), this.b("tradingHoursId", this.tradingHoursID), this.a("baseCost", this.baseCost), this.a("unitCost", this.unitCost), this.a("unitSize", this.unitSize), this.a("useDefaultCommission", this.useDefaultCommission), this.a("customDefinition", this.customDefinition), this.a("localDataOnly", this.localDataOnly), this.a("minuteDailyBars", this.minuteDailyBars, false), this.b("sectorId", this.sectorId), this.b("industryGroupId", this.industryGroupId)});
        if (this.expiryDate != null) {
            object.add(this.a("expiryDate", this.expiryDate.getTime()));
        }
        if (this.timeZone != null) {
            object.add(this.b("timeZone", this.timeZone.getID()));
        }
        if (this.showExtendedData != null) {
            object.add(this.a("showExtendedData", (Object)this.showExtendedData));
        }
        if (this.extendedData != null) {
            object.add(this.a("supportsExtendedData", (Object)this.extendedData));
        }
        return object;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        this.underlying = jSONObject.str("underlying");
        this.symbol = jSONObject.str("symbol");
        if (jSONObject.has("exchange")) {
            this.exchange = jSONObject.str("exchange");
        }
        if (jSONObject.has("currency")) {
            this.currency = jSONObject.str("currency");
        }
        this.setSymbolDisplay(jSONObject.str("symbolDisplay"));
        this.setSymbolData(jSONObject.str("symbolData"));
        this.setHistoricalSymbol(jSONObject.str("histSymbol"));
        this.setHistoricalExchange(jSONObject.str("histExchange"));
        this.setProductCode(jSONObject.str("productCode"));
        this.setTitle(jSONObject.str("title"));
        try {
            this.setType(Enums$InstrumentType.valueOf(jSONObject.str("type")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serviceId = jSONObject.str("serviceId");
        try {
            this.setOptionType(Enums$OptionType.valueOf(jSONObject.str("optionType")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setMinTick(jSONObject.getDouble("minTick"));
        this.setPointSize(jSONObject.getDouble("pointSize"));
        this.setPointValue(jSONObject.getDouble("pointValue"));
        this.setPLDivisor(jSONObject.getDouble("plDivisor"));
        this.setStrikePrice(jSONObject.getDouble("strikePrice"));
        this.setPriceMagnifier(jSONObject.getDouble("priceMagnifier"));
        this.setDisplayMask(jSONObject.str("displayMask"));
        this.setDisplayMultiplier(jSONObject.getDouble("displayMultiplier"));
        this.setDescription(jSONObject.str("desc"));
        this.setTradingHoursID(jSONObject.str("tradingHoursID"));
        if (jSONObject.has("expiryDate")) {
            this.setExpiryDate(new Date(jSONObject.getLong("expiryDate")));
        }
        if (jSONObject.has("timeZone")) {
            this.setTimeZone(TimeZone.getTimeZone(jSONObject.str("timeZone")));
        }
        this.setBaseCost(jSONObject.getDouble("baseCost"));
        this.setUnitCost(jSONObject.getDouble("unitCost"));
        this.setUnitSize(jSONObject.getInt("unitSize"));
        this.setUseDefaultCommission(jSONObject.is("useDefaultCommission"));
        if (jSONObject.has("showExtendedData")) {
            this.showExtendedData = jSONObject.is("showExtendedData");
        }
        if (jSONObject.has("supportsExtendedData")) {
            this.extendedData = jSONObject.is("supportsExtendedData");
        }
        this.localDataOnly = jSONObject.is("localDataOnly");
        this.minuteDailyBars = jSONObject.is("minuteDailyBars", false);
        if (jSONObject.has("sectorId")) {
            this.sectorId = jSONObject.str("sectorId");
        }
        if (jSONObject.has("industryGroupId")) {
            this.industryGroupId = jSONObject.str("industryGroupId");
        }
        if (jSONObject.has("customDefinition")) {
            this.setCustomDefinition(jSONObject.str("customDefinition"));
            try {
                this.loadDefinition();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static MWInstrument read(Element element) {
        Object object;
        Object object22;
        String string;
        if (element == null) {
            return null;
        }
        if (!com.motivewave.common.h.g(element.getAttribute("optionType"))) {
            return null;
        }
        String string2 = element.getAttribute("symbol");
        if (com.motivewave.common.h.g(string2)) {
            string2 = element.getAttribute("sym");
        }
        if (com.motivewave.common.h.g(string = element.getAttribute("exchange"))) {
            string = element.getAttribute("exch");
        }
        MWInstrument mWInstrument = null;
        Enums$ServiceType enums$ServiceType = null;
        String string3 = element.getAttribute("service");
        if (!com.motivewave.common.h.g(string3)) {
            try {
                enums$ServiceType = Enums$ServiceType.read(string3);
            }
            catch (Exception exception) {
                com.motivewave.common.h.a.warning("MWInstrument::read() undefined service: " + element.getAttribute("service"));
            }
        }
        boolean bl2 = enums$ServiceType == null || enums$ServiceType == bs.a();
        Date date = null;
        try {
            if (!com.motivewave.common.h.g(element.getAttribute("expiryDate"))) {
                date = com.motivewave.common.h.a(element.getAttribute("expiryDate"), "yyyy-MM-dd");
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        if (date != null && date.before(new Date(System.currentTimeMillis() - 2419200000L)) && !SymbolUtil.a(string2, enums$ServiceType)) {
            return null;
        }
        if (!com.motivewave.common.h.g(element.getAttribute("id"))) {
            mWInstrument = MWInstrument.get(com.motivewave.common.h.b(element.getAttribute("id")));
            if (mWInstrument != null && com.motivewave.common.h.b((Object)mWInstrument.getSymbol(), (Object)string2) && enums$ServiceType != null && enums$ServiceType == mWInstrument.getSourceType()) {
                return mWInstrument;
            }
            mWInstrument = null;
        }
        if (!com.motivewave.common.h.g(element.getAttribute("instrument_id"))) {
            mWInstrument = MWInstrument.get(com.motivewave.common.h.b(element.getAttribute("instrument_id")));
            if (mWInstrument != null && com.motivewave.common.h.b((Object)mWInstrument.getSymbol(), (Object)string2) && enums$ServiceType != null && enums$ServiceType == mWInstrument.getSourceType()) {
                return mWInstrument;
            }
            mWInstrument = null;
        }
        Enums$OptionType enums$OptionType = null;
        String string4 = element.getAttribute("optionType");
        if (!com.motivewave.common.h.g(string4)) {
            try {
                enums$OptionType = Enums$OptionType.valueOf(string4);
            }
            catch (Exception exception) {
                com.motivewave.common.h.a.warning("MWInstrument::read() invalid option type: " + string4);
            }
        }
        if (!com.motivewave.common.h.g(string) && (mWInstrument = MWInstrument.get(string2, string)) != null) {
            return mWInstrument;
        }
        if (!bl2) {
            mWInstrument = MWInstrument.getStrict(string2, enums$ServiceType);
            if (mWInstrument != null) {
                return mWInstrument;
            }
        } else if (enums$OptionType == null) {
            MWInstrument mWInstrument2 = mWInstrument = bl2 ? MWInstrument.bySymbol(string2) : MWInstrument.get(string2, enums$ServiceType);
            if (mWInstrument != null) {
                return mWInstrument;
            }
        }
        Enums$InstrumentType enums$InstrumentType = Enums$InstrumentType.STOCK;
        String string5 = element.getAttribute("type");
        if (!com.motivewave.common.h.g(string5)) {
            try {
                enums$InstrumentType = Enums$InstrumentType.valueOf(string5);
            }
            catch (Exception exception) {
                com.motivewave.common.h.a.warning("MWInstrument::read() invalid instrument type: " + string5);
            }
        }
        if (enums$InstrumentType == Enums$InstrumentType.CUSTOM && !ai.e()) {
            com.motivewave.common.h.a.warning("MWInstrument::read() unsupported instrument type: " + String.valueOf((Object)enums$InstrumentType) + " symbol: " + string2);
            return null;
        }
        if (enums$InstrumentType != Enums$InstrumentType.CUSTOM && !bs.a(enums$InstrumentType)) {
            com.motivewave.common.h.a.warning("MWInstrument::read() unsupported instrument type: " + String.valueOf((Object)enums$InstrumentType) + " symbol: " + string2);
            return null;
        }
        Currency currency = Currency.get(element.getAttribute("currency"));
        String string6 = element.getAttribute("exchange");
        if (com.motivewave.common.h.g(string6)) {
            string6 = element.getAttribute("exch");
        }
        Exchange exchange = Exchange.get(string6);
        String string7 = element.getAttribute("minTick");
        ArrayList<Enums$ServiceType> arrayList = new ArrayList<Enums$ServiceType>();
        for (Object object22 : bs.w()) {
            object = ((by)object22).a().a();
            if (arrayList.contains(object)) continue;
            arrayList.add((Enums$ServiceType)((Object)object));
        }
        if (com.motivewave.common.h.g(string7) && enums$InstrumentType != Enums$InstrumentType.STOCK) {
            com.motivewave.common.h.a.warning("MWInstrument::read() not enough information to recreate instrument: " + string2);
            return null;
        }
        Object object3 = null;
        object22 = bs.w().iterator();
        while (object22.hasNext()) {
            object = (by)object22.next();
            if (((by)object).a().a() != enums$ServiceType) continue;
            object3 = object;
            break;
        }
        if (object3 == null) {
            object22 = bs.w().iterator();
            while (object22.hasNext()) {
                object = (by)object22.next();
                if (!((by)object).a().a(enums$InstrumentType)) continue;
                object3 = object;
                break;
            }
            if (object3 != null && ((by)object3).a() && enums$InstrumentType == Enums$InstrumentType.STOCK) {
                exchange = Exchange.get("SMART");
            }
        }
        mWInstrument = new MWInstrument(string2, enums$InstrumentType, exchange.getSymbol(), currency.getSymbol());
        if (object3 != null) {
            mWInstrument.setSource(((by)object3).a().getConnectionID());
        }
        if ((object22 = h.b("custom", element)) != null) {
            object = h.b("definition", (Node)object22);
            mWInstrument.setCustomDefinition(h.a((Node)object));
        }
        if (com.motivewave.common.h.g(string7)) {
            return mWInstrument;
        }
        mWInstrument.setUnderlying(element.getAttribute("underlying"));
        mWInstrument.setExpiryDate(date);
        mWInstrument.setMinTick(com.motivewave.common.h.a(element.getAttribute("minTick")));
        mWInstrument.setPLDivisor(com.motivewave.common.h.a(element.getAttribute("multiplier")));
        mWInstrument.setStrikePrice(com.motivewave.common.h.a(element.getAttribute("strikePrice")));
        mWInstrument.setPriceMagnifier(com.motivewave.common.h.a(element.getAttribute("priceMagnifier")));
        mWInstrument.setOptionType(enums$OptionType);
        string7 = element.getAttribute("symbolDisplay");
        if (!com.motivewave.common.h.g(string7)) {
            mWInstrument.setSymbolDisplay(string7);
        }
        if (!com.motivewave.common.h.g(string7 = element.getAttribute("symbolData"))) {
            mWInstrument.setSymbolData(string7);
        }
        if (!com.motivewave.common.h.g(string7 = element.getAttribute("histSymbol"))) {
            mWInstrument.setHistoricalSymbol(string7);
        }
        if (!com.motivewave.common.h.g(string7 = element.getAttribute("histExchange"))) {
            mWInstrument.setHistoricalExchange(string7);
        }
        if (!com.motivewave.common.h.g(string7 = element.getAttribute("pointSize"))) {
            mWInstrument.setPointSize(com.motivewave.common.h.a(string7));
        }
        if (!com.motivewave.common.h.g(string7 = element.getAttribute("displayMask"))) {
            mWInstrument.setDisplayMask(string7);
        }
        if (!com.motivewave.common.h.g(string7 = element.getAttribute("displayMultiplier"))) {
            mWInstrument.setDisplayMultiplier(com.motivewave.common.h.a(string7));
        }
        if (!com.motivewave.common.h.g(string7 = element.getAttribute("desc"))) {
            mWInstrument.setDescription(string7);
        } else {
            mWInstrument.setDescription(string2);
        }
        string7 = element.getAttribute("trading_hours_id");
        if (!com.motivewave.common.h.g(string7)) {
            mWInstrument.setTradingHoursID(string7);
        }
        mWInstrument = MWInstrument.createAndRegister(mWInstrument);
        return mWInstrument;
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "type": {
                Enums$InstrumentType enums$InstrumentType = this.getType();
                if (enums$InstrumentType == null) {
                    return "";
                }
                if (enums$InstrumentType != Enums$InstrumentType.CUSTOM) {
                    return enums$InstrumentType.toString();
                }
                Enums$CustomInstrumentType enums$CustomInstrumentType = this.getCustomType();
                if (enums$CustomInstrumentType == null) {
                    return enums$InstrumentType.toString();
                }
                return enums$InstrumentType.toString() + " - " + enums$CustomInstrumentType.toString();
            }
            case "symbolData": {
                return this.getSymbolData();
            }
            case "activeContract": {
                MWInstrument mWInstrument = this.getActiveContract();
                return mWInstrument == null ? "" : mWInstrument.getSymbolDisplay();
            }
            case "baseCost": {
                return com.motivewave.platform.common.ab.a(this.getBaseCost());
            }
            case "contractValue": {
                return com.motivewave.platform.common.ab.a(this.getContractValue());
            }
            case "currency": {
                return com.motivewave.common.h.b((Object)this.getCurrency());
            }
            case "customDescription": {
                return this.getDescription();
            }
            case "customTitle": {
                return this.getTitle();
            }
            case "description": {
                return this.getDescription();
            }
            case "notes": {
                return com.motivewave.common.h.b((Object)this.getNotes());
            }
            case "displayMask": {
                return this.getDisplayMask();
            }
            case "exchange": {
                return com.motivewave.common.h.b((Object)this.getExchange());
            }
            case "primaryExchange": {
                return com.motivewave.common.h.b((Object)this.getPrimaryExchange());
            }
            case "productCode": {
                return this.getProductCode();
            }
            case "sectorId": {
                return this.getSectorId();
            }
            case "sectorName": {
                return this.getSectorName();
            }
            case "industryGroupId": {
                return this.getIndustryGroupId();
            }
            case "industryGroupName": {
                return this.getIndustryGroupName();
            }
            case "symbol": {
                return this.getSymbol();
            }
            case "historicalSymbol": {
                return this.getHistoricalSymbol();
            }
            case "historicalExchange": {
                return this.getHistoricalExchange();
            }
            case "symbolDisplay": {
                return this.getSymbolDisplay();
            }
            case "title": {
                return this.getTitle();
            }
            case "underlying": {
                return this.getUnderlying();
            }
            case "sourceType": {
                return this.getServiceName();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "strikePrice": {
                return this.isOption() && this.strikePrice != null ? this.formatValue(this.strikePrice) : "";
            }
            case "expiryDate": {
                return this.expiryDate == null ? "" : com.motivewave.common.h.a(this.expiryDate, "yyyy-MM-dd");
            }
        }
        Object object = this.getProperty(string);
        return com.motivewave.common.h.b(object);
    }

    @Override
    public Object getProperty(String string) {
        return switch (string) {
            case "symbolData" -> this.getSymbolData();
            case "baseCost" -> this.getBaseCost();
            case "contractValue" -> this.getContractValue();
            case "currency" -> this.getCurrency();
            case "customDescription" -> this.getDescription();
            case "customTitle" -> this.getTitle();
            case "decimalPlaces" -> this.getDecimalPlaces();
            case "defaultQuantity" -> Float.valueOf(this.getDefaultQuantity());
            case "notes" -> this.getNotes();
            case "description" -> this.getDescription();
            case "displayMask" -> this.getDisplayMask();
            case "displayMultiplier" -> this.getDisplayMultiplier();
            case "exchange" -> this.getExchange();
            case "exchangeSymbol" -> this.getExchange();
            case "expiryDate" -> this.getExpiryDate();
            case "expiryTime" -> this.getExpiryTime();
            case "instrumentType" -> this.getType();
            case "type" -> this.getType();
            case "sectorId" -> this.getSectorId();
            case "sectorName" -> this.getSectorName();
            case "industryGroupId" -> this.getIndustryGroupId();
            case "industryGroupName" -> this.getIndustryGroupName();
            case "minStep" -> Float.valueOf(this.getMinStep());
            case "minTick" -> this.getMinTick();
            case "multiplier" -> this.getPLDivisor();
            case "optionType" -> this.getOptionType();
            case "pointSize" -> this.getPointSize();
            case "pointValue" -> this.getPointValue();
            case "priceMagnifier" -> this.getPriceMagnifier();
            case "primaryExchange" -> this.getPrimaryExchange();
            case "productCode" -> this.getProductCode();
            case "strikePrice" -> this.getStrikePrice();
            case "symbol" -> this.getSymbol();
            case "historicalSymbol" -> this.getHistoricalSymbol();
            case "historicalExchange" -> this.getHistoricalExchange();
            case "symbolDisplay" -> this.getSymbolDisplay();
            case "title" -> this.getTitle();
            case "underlying" -> this.getUnderlying();
            case "serviceName" -> this.getServiceName();
            case "connectionName" -> this.getConnectionName();
            case "flagId" -> this.getFlagId();
            case "activeContract" -> this.getActiveContract();
            default -> super.getProperty(string);
        };
    }

    public String getServiceName() {
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        return enums$ServiceType == null ? "" : enums$ServiceType.toString();
    }

    public String getConnectionName() {
        ConnectionID connectionID = this.getSource();
        if (connectionID == null) {
            return "";
        }
        by by2 = connectionID.getConnection();
        if (by2 != null) {
            return by2.a().getName();
        }
        return "";
    }

    public boolean hasOrderPreset() {
        return d.a(this) != null;
    }

    public OrderPreset getOrderPreset() {
        OrderPreset orderPreset = d.a(this);
        if (orderPreset != null) {
            return orderPreset;
        }
        orderPreset = d.a(this.getType(), this.getSourceType());
        if (orderPreset != null) {
            return orderPreset;
        }
        if (this.type == null) {
            com.motivewave.common.h.a.severe("MWInstrument::getOrderPreset() type is null! " + this.toString());
        }
        orderPreset = new OrderPreset(null, this.type);
        orderPreset.setQuantity(this.supportsFractionalVolume() ? 1.0E-4f : 1.0f);
        orderPreset.setQuantityInc(this.supportsFractionalVolume() ? 1.0E-8f : 1.0f);
        orderPreset.setLimitOffset(50);
        orderPreset.setStopOffset(10);
        orderPreset.setTrailOffset(10);
        orderPreset.setTif(Enums$TIF.DAY);
        orderPreset.setOrderType(Enums$OrderType.LMT);
        d.a(orderPreset);
        d.b(orderPreset);
        return orderPreset;
    }

    public int getLimitOffset() {
        return this.getOrderPreset().getLimitOffset();
    }

    public float getLimitOffsetAmount() {
        return this.round((float)((double)this.getLimitOffset() * this.getMinTick()));
    }

    public int getLimitOffsetPips() {
        return (int)((double)this.getLimitOffset() / (this.getPointSize() / this.getMinTick()));
    }

    public int getStopOffset() {
        return this.getOrderPreset().getStopOffset();
    }

    public float getStopOffsetAmount() {
        return this.round((float)((double)this.getStopOffset() * this.getMinTick()));
    }

    public int getStopOffsetPips() {
        return (int)((double)this.getStopOffset() / (this.getPointSize() / this.getMinTick()));
    }

    public int getTrailOffset() {
        return this.getOrderPreset().getTrailOffset();
    }

    public float getTrailOffsetAmount() {
        return this.round((float)((double)this.getTrailOffset() * this.getMinTick()));
    }

    public int getTrailOffsetPips() {
        return (int)((double)this.getTrailOffset() / (this.getPointSize() / this.getMinTick()));
    }

    public boolean isIB() {
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        return enums$ServiceType != null && enums$ServiceType.isIB();
    }

    public boolean isCQG() {
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        return enums$ServiceType != null && enums$ServiceType.isCQG();
    }

    public boolean isRithmic() {
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        return enums$ServiceType != null && enums$ServiceType.isRithmic();
    }

    public boolean supportsSettlement() {
        return this.isFuture() && (this.isCQG() || this.isRithmic());
    }

    public boolean isBarChart() {
        return this.getSourceType() == Enums$ServiceType.BARCHART;
    }

    public boolean isDXFeed() {
        return this.getSourceType() == Enums$ServiceType.DXFEED;
    }

    public boolean isExpired() {
        if (this.expiryDate == null) {
            return false;
        }
        if (!this.isFuture() && !this.isOption()) {
            return false;
        }
        if (SymbolUtil.c(this)) {
            return false;
        }
        long l2 = bs.a();
        return l2 > this.expiryDate.getTime() + 86400000L;
    }

    public boolean isExpiredStrict() {
        if (this.expiryDate == null) {
            return false;
        }
        if (!this.isFuture() && !this.isOption()) {
            return false;
        }
        if (SymbolUtil.c(this)) {
            return false;
        }
        long l2 = bs.a();
        return l2 > this.getEndOfDay(this.expiryDate.getTime(), true);
    }

    public boolean isExpiredWeek() {
        if (this.expiryDate == null) {
            return false;
        }
        if (!this.isFuture() && !this.isOption()) {
            return false;
        }
        if (SymbolUtil.c(this)) {
            return false;
        }
        long l2 = bs.a();
        return l2 > this.expiryDate.getTime() + 604800000L;
    }

    public boolean isLevel1PriceSupported() {
        if (this.level1PriceSupported != null) {
            return this.level1PriceSupported;
        }
        if (bs.a(this) == null) {
            return true;
        }
        this.level1PriceSupported = bs.n(this);
        return this.level1PriceSupported;
    }

    public boolean isBidAskPriceSupported() {
        if (this.bidAskPriceSupported != null) {
            return this.bidAskPriceSupported;
        }
        if (bs.a(this) == null) {
            return true;
        }
        this.bidAskPriceSupported = bs.o(this);
        return this.bidAskPriceSupported;
    }

    public boolean isIndex() {
        return this.type == Enums$InstrumentType.INDEX;
    }

    public boolean isStock() {
        return this.type == Enums$InstrumentType.STOCK;
    }

    public boolean isCrypto() {
        return this.type != null && this.type.isCrypto();
    }

    public boolean isCFD() {
        return this.type == Enums$InstrumentType.CFD;
    }

    public boolean isCash() {
        return this.type == Enums$InstrumentType.CASH;
    }

    public boolean isOption() {
        return this.type != null && this.type.isOption();
    }

    public boolean isStockOption() {
        return this.type != null && this.type == Enums$InstrumentType.OPTION;
    }

    public boolean isFutureOption() {
        return this.type != null && this.type == Enums$InstrumentType.FUTURE_OPTION;
    }

    public boolean isFuture() {
        return this.type != null && this.type.isFuture();
    }

    public boolean hasHistoricalBidAskData() {
        if (this.historicalBidAskSupported != null) {
            return this.historicalBidAskSupported;
        }
        if (this.isLocalDataOnly() || this.isCustom()) {
            return false;
        }
        this.historicalBidAskSupported = bs.r(this);
        return this.historicalBidAskSupported;
    }

    public boolean hasHistoricalPriceData() {
        if (this.historicalPriceSupported != null) {
            return this.historicalPriceSupported;
        }
        if (this.isLocalDataOnly() || this.isCustom()) {
            return true;
        }
        this.historicalPriceSupported = bs.t(this);
        return this.historicalPriceSupported;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public String getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(String string) {
        this.underlying = com.motivewave.common.h.q(string);
    }

    public String getUnderlying(Enums$ServiceType enums$ServiceType) {
        String string;
        Enums$ServiceType enums$ServiceType2 = this.getSourceType();
        if (enums$ServiceType == null || enums$ServiceType == enums$ServiceType2) {
            return this.getUnderlying();
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo != null && !com.motivewave.common.h.g(symbolInfo.getUnderlying())) {
            return symbolInfo.getUnderlying();
        }
        String string2 = string = symbolInfo == null ? this.getSymbol() : symbolInfo.getSymbol();
        if (this.isFuture()) {
            string2 = (string = com.motivewave.common.h.c(string, "@#&!-_+=?><':;!~`%^&*()")).length() == 5 ? string.substring(0, 3) : (string.length() < 3 ? string : string.substring(0, 2));
        }
        return string2;
    }

    public String getBaseSymbol() {
        return this.baseSymbol;
    }

    public void setBaseSymbol(String string) {
        this.baseSymbol = com.motivewave.common.h.q(string);
    }

    public String getCommonBase() {
        String string = this.getBaseSymbol();
        if (com.motivewave.common.h.g(string)) {
            string = this.getUnderlying();
        }
        string = SymbolUtil.a(string);
        string = com.motivewave.common.h.a(string, "+", "");
        string = com.motivewave.common.h.a(string, "@", "");
        string = com.motivewave.common.h.a(string, "#", "");
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        if (enums$ServiceType != null && enums$ServiceType.isCQG()) {
            string = SymbolUtil.k(string);
        }
        return string;
    }

    public String getCommonSymbol() {
        if (this.commonSymbol == null) {
            this.commonSymbol = SymbolUtil.c(this);
            if (this.commonSymbol == null) {
                this.commonSymbol = "";
            }
        }
        return this.commonSymbol == "" ? null : this.commonSymbol;
    }

    public String getAltCommonSymbol() {
        return this.altCommonSymbol;
    }

    public void setAltCommonSymbol(String string) {
        if (com.motivewave.common.h.g(string)) {
            string = null;
        }
        if (com.motivewave.common.h.a((Object)string, (Object)this.altCommonSymbol)) {
            return;
        }
        this.altCommonSymbol = string == null ? null : string.toUpperCase();
        this.analysisDirMap.a();
    }

    private String getAltCommonDir() {
        if (com.motivewave.common.h.g(this.altCommonSymbol)) {
            return null;
        }
        if (this.altCommonSymbol.endsWith(".CMN")) {
            return this.altCommonSymbol;
        }
        for (Enums$ServiceType enums$ServiceType : Enums$ServiceType.values()) {
            if (!this.altCommonSymbol.endsWith("." + enums$ServiceType.getName())) continue;
            return this.altCommonSymbol;
        }
        return this.altCommonSymbol + ".CMN";
    }

    public MWInstrument getUnderlyingInstrument() {
        if (!this.isOption()) {
            return MWInstrument.bySymbol(this.getUnderlying());
        }
        MWInstrument mWInstrument = null;
        if (!com.motivewave.common.h.g(this.getBaseSymbol())) {
            mWInstrument = MWInstrument.bySymbol(this.getBaseSymbol());
        }
        if (mWInstrument != null) {
            return mWInstrument;
        }
        return MWInstrument.bySymbol(this.getUnderlying());
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String string) {
        this.productCode = com.motivewave.common.h.q(string);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String string) {
        if (com.motivewave.common.h.a((Object)string, (Object)this.symbol)) {
            return;
        }
        String string2 = this.symbol;
        this.updateKey(() -> {
            this.symbol = string;
        });
        this.notify("symbol", string2, this.symbol);
    }

    public String getSymbol(Enums$ServiceType enums$ServiceType) {
        Enums$ServiceType enums$ServiceType2 = this.getSourceType();
        if (enums$ServiceType == null || enums$ServiceType == enums$ServiceType2) {
            return this.getSymbol();
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo != null && !com.motivewave.common.h.g(symbolInfo.getSymbol())) {
            return symbolInfo.getSymbol();
        }
        return SymbolUtil.a(this, enums$ServiceType2, enums$ServiceType);
    }

    @Override
    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = this.getKey(this.getExchange());
        return this.key;
    }

    public String getKey(String string) {
        Object object;
        String string2 = SymbolUtil.a(this.getSymbol());
        Object object2 = string2;
        if (!this.isSymbolUnique()) {
            String string3;
            Object object3 = object = string == null ? "" : SymbolUtil.a(string);
            if (!com.motivewave.common.h.g((String)object)) {
                object2 = (String)object2 + "." + (String)object;
            }
            if (this.isIB() && !com.motivewave.common.h.g(string3 = SymbolUtil.a(this.getPrimaryExchange()))) {
                object2 = (String)object2 + "." + string3;
            }
        } else {
            object2 = ((String)object2).toUpperCase();
        }
        object = this.getSourceType();
        if (object != null) {
            object2 = (String)object2 + "." + ((Enums$ServiceType)((Object)object)).getName();
        }
        return object2;
    }

    private String getOldKey() {
        Object object;
        String string = SymbolUtil.a(this.getSymbol());
        string = com.motivewave.common.h.a(string, "$", "");
        string = com.motivewave.common.h.a(string, "_", "");
        Object object2 = string;
        if (!this.isSymbolUnique()) {
            String string2;
            String string3;
            object = this.getExchange();
            String string4 = string3 = object == null ? "" : SymbolUtil.a((String)object);
            if (!com.motivewave.common.h.g(string3)) {
                object2 = (String)object2 + "." + string3;
            }
            if (this.isIB() && !com.motivewave.common.h.g(string2 = SymbolUtil.a(this.getPrimaryExchange()))) {
                object2 = (String)object2 + "." + string2;
            }
        } else {
            object2 = ((String)object2).toUpperCase();
        }
        object = this.getSourceType();
        if (object != null) {
            object2 = (String)object2 + "." + ((Enums$ServiceType)((Object)object)).getName();
        }
        return object2;
    }

    public String getKeyWithExchange() {
        Object object;
        String string = SymbolUtil.a(this.getSymbol());
        String string2 = this.exchange == null ? "" : SymbolUtil.a(this.exchange);
        Object object2 = string;
        if (!com.motivewave.common.h.g(string2)) {
            object2 = (String)object2 + "." + string2;
        }
        if (this.isIB() && !com.motivewave.common.h.g((String)(object = SymbolUtil.a(this.getPrimaryExchange())))) {
            object2 = (String)object2 + "." + (String)object;
        }
        if ((object = this.getSourceType()) != null) {
            object2 = (String)object2 + "." + ((Enums$ServiceType)((Object)object)).getName();
        }
        return object2;
    }

    public File getAnalysisFile(String string) {
        File file = this.getAnalysisDirectory();
        if (file == null) {
            return null;
        }
        return new File(file, string + ".mwml");
    }

    public File getAnalysisFile(AnalysisSource analysisSource, String string) {
        File file = this.getAnalysisDirectory(analysisSource);
        if (file == null) {
            return null;
        }
        return new File(file, string + ".mwml");
    }

    public File getAnalysisDirectory(AnalysisSource analysisSource) {
        return this.getAnalysisDirectory(analysisSource.getDirectory(), analysisSource.isReadOnly() || b.h(), !analysisSource.isReadOnly(), true);
    }

    public File getAnalysisDirectory() {
        return this.getAnalysisDirectory(bs.a().getAnalysisDir());
    }

    public File getAnalysisDirectoryNoCreate() {
        return this.getAnalysisDirectory(bs.a().getAnalysisDir(), b.h(), false, false);
    }

    public File getAnalysisDirectory(File file) {
        return this.getAnalysisDirectory(file, b.h(), true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getAnalysisDirectory(File file, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        File file2;
        File file3;
        File file4;
        File file5 = file;
        if (!com.motivewave.common.h.b((Object)file.getName(), (Object)"analysis")) {
            file5 = new File(file, "analysis");
        }
        if ((file4 = (File)this.analysisDirMap.b(file5)) != null) {
            return file4;
        }
        if (!file5.exists()) {
            file5.mkdirs();
            if (!file5.exists()) {
                return null;
            }
        }
        if (!(file3 = new File(file5, this.getType().name())).exists() && this.getType() == Enums$InstrumentType.CRYPTO_CURRENCY && (file2 = new File(file5, "CRYTO_CURRENCY")).exists()) {
            file3 = file2;
        }
        if (!file3.exists()) {
            file3.mkdirs();
            if (!file3.exists()) {
                return null;
            }
        }
        if (!com.motivewave.common.h.g(this.getSymbolDir()) && new File(file3, this.getSymbolDir()).exists()) {
            file4 = new File(file3, this.getSymbolDir());
            this.analysisDirMap.a(file5, file4);
            return file4;
        }
        file2 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl2) {
            if (!com.motivewave.common.h.g(this.altCommonSymbol) && ((File)(object4 = new File(file3, this.getAltCommonDir()))).exists()) {
                this.analysisDirMap.a(file5, object4);
                return object4;
            }
            object4 = this.getCommonSymbol();
            if (!com.motivewave.common.h.g((String)object4)) {
                object3 = SymbolUtil.c(this);
                if (!com.motivewave.common.h.a(object3, object4)) {
                    com.motivewave.common.h.a.warning("MWInstrument::getAnalysisDirectory() common symbol changed: " + (String)object4 + " -> " + (String)object3);
                    object22 = new File(file3, ((String)object4).toUpperCase() + ".CMN");
                    if (((File)object22).exists()) {
                        arrayList.add(object22);
                    }
                    this.commonSymbol = object4 = object3;
                    object = idMap;
                    synchronized (object) {
                        commonMap.put(object4, this);
                    }
                }
                if (!com.motivewave.common.h.g((String)object4) && (file2 = new File(file3, ((String)object4).toUpperCase() + ".CMN")).exists()) {
                    this.analysisDirMap.a(file5, file2);
                    return file2;
                }
            }
            if (bl4) {
                for (Object object22 : SymbolUtil.a(this)) {
                    object = new File(file3, ((String)object22).toUpperCase() + ".CMN");
                    if (!((File)object).exists()) continue;
                    this.analysisDirMap.a(file5, object);
                    return object;
                }
                object3 = SymbolUtil.d(this);
                if (!com.motivewave.common.h.g((String)object3)) {
                    object22 = new File(file3, ((String)object3).toUpperCase() + ".TDA");
                    if (((File)object22).exists()) {
                        this.analysisDirMap.a(file5, object22);
                        return object22;
                    }
                    object22 = new File(file3, ((String)(object3 = com.motivewave.common.h.a((String)object3, ".", "_"))).toUpperCase() + ".TDA");
                    if (((File)object22).exists()) {
                        this.analysisDirMap.a(file5, object22);
                        return object22;
                    }
                    object22 = new File(file3, ((String)(object3 = com.motivewave.common.h.a((String)object3, "$", ""))).toUpperCase() + ".TDA");
                    if (((File)object22).exists()) {
                        this.analysisDirMap.a(file5, object22);
                        return object22;
                    }
                }
                if (!com.motivewave.common.h.g((String)(object3 = SymbolUtil.e(this))) && ((File)(object22 = new File(file3, ((String)object3).toUpperCase() + ".IQFEED"))).exists()) {
                    this.analysisDirMap.a(file5, object22);
                    return object22;
                }
                object22 = new File(file3, this.getKey());
                if (((File)object22).exists()) {
                    this.analysisDirMap.a(file5, object22);
                    return object22;
                }
            }
        }
        if (file2 == null) {
            file2 = new File(file3, this.getKey());
            if (file2.exists()) {
                this.analysisDirMap.a(file5, file2);
                return file2;
            }
        } else {
            object4 = new File(file3, this.getKey());
            if (((File)object4).exists()) {
                arrayList.add(object4);
            }
        }
        if (!bl3 && !file2.exists()) {
            return null;
        }
        if (!bl2 && !com.motivewave.common.h.g((String)(object4 = this.getCommonSymbol())) && ((File)(object3 = new File(file3, ((String)object4).toUpperCase() + ".CMN"))).exists()) {
            arrayList.add(object3);
        }
        if (((File)(object4 = new File(file3, com.motivewave.platform.common.ab.a(this)))).exists()) {
            arrayList.add(object4);
        }
        if (this.getSourceType() != null && this.getSourceType().isSymbolUnique()) {
            object3 = SymbolUtil.a(this.getSymbol()).toUpperCase();
            object22 = com.motivewave.common.h.a((String)object3, "$", "");
            object22 = com.motivewave.common.h.a((String)object22, "_", "");
            object = "";
            Enums$ServiceType enums$ServiceType = this.getSourceType();
            if (enums$ServiceType != null) {
                object = ("." + enums$ServiceType.getName()).toUpperCase();
            }
            for (File file6 : file3.listFiles()) {
                String string = file6.getName().toUpperCase();
                if (!string.startsWith((String)object3 + ".") && !string.startsWith((String)object22 + ".") || !com.motivewave.common.h.g((String)object) && !string.endsWith((String)object)) continue;
                arrayList.add(file6);
            }
        }
        file2.mkdirs();
        this.migrateFiles(arrayList, file2, bl3);
        this.analysisDirMap.a(file5, file2);
        return file2;
    }

    private void migrateFiles(List list, File file, boolean bl2) {
        if (com.motivewave.common.h.a((Collection)list)) {
            return;
        }
        com.motivewave.common.h.c();
        HashMap<String, File> hashMap = new HashMap<String, File>();
        for (File file2 : list) {
            for (File file3 : file2.listFiles()) {
                String string = file3.getName();
                if (!string.toUpperCase().endsWith(".MWML")) continue;
                File file4 = (File)hashMap.get(string);
                if (file4 == null) {
                    hashMap.put(string, file3);
                    continue;
                }
                if (Math.abs(file3.lastModified() - file4.lastModified()) < 60000L) {
                    if (file3.length() <= file4.length()) continue;
                    hashMap.put(string, file3);
                    continue;
                }
                if (file3.lastModified() <= file4.lastModified()) continue;
                hashMap.put(string, file3);
            }
        }
        com.motivewave.common.h.a.info("MWInstrument::migrateFiles() migrating analysis files: " + this.getKey() + " " + hashMap.size());
        for (File file2 : hashMap.values()) {
            try {
                com.motivewave.common.h.e(file2, new File(file, file2.getName()));
            }
            catch (Exception exception) {
                com.motivewave.common.h.a.warning("MWInstrument::getAnalysisDirectory() error migrating analysis: " + file2.getAbsolutePath() + " error: " + exception.getMessage());
            }
        }
        if (bl2) {
            for (File file2 : list) {
                com.motivewave.common.h.a.info("MWInstrument::migrateFiles() deleting old directory: " + file2.getPath());
                com.motivewave.common.h.a(file2);
            }
        }
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getServiceId(Enums$ServiceType enums$ServiceType) {
        Enums$ServiceType enums$ServiceType2 = this.getSourceType();
        if (enums$ServiceType == null || enums$ServiceType == enums$ServiceType2) {
            return this.serviceId;
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo == null) {
            MWInstrument mWInstrument = MWInstrument.get(this.getSymbol(enums$ServiceType), enums$ServiceType);
            if (mWInstrument != null) {
                return mWInstrument.getServiceId();
            }
            return this.serviceId;
        }
        if (!com.motivewave.common.h.g(symbolInfo.getServiceId())) {
            return symbolInfo.getServiceId();
        }
        MWInstrument mWInstrument = MWInstrument.get(symbolInfo.getSymbol(), symbolInfo.getExchange(), enums$ServiceType);
        if (mWInstrument != null) {
            return mWInstrument.getServiceId();
        }
        mWInstrument = MWInstrument.get(symbolInfo.getSymbol(), enums$ServiceType);
        if (mWInstrument != null) {
            return mWInstrument.getServiceId();
        }
        return this.serviceId;
    }

    public void setServiceId(String string) {
        this.serviceId = com.motivewave.common.h.q(string);
    }

    public String getSymbolDir() {
        return this.symbolDir;
    }

    public void setSymbolDir(String string) {
        this.symbolDir = com.motivewave.common.h.q(string);
    }

    public String getSymbolData() {
        return this.symbolData;
    }

    public void setSymbolData(String string) {
        this.symbolData = string;
    }

    public String getSymbolDisplay() {
        if (!com.motivewave.common.h.g(this.symbolDisplay)) {
            return this.symbolDisplay;
        }
        return this.symbol;
    }

    public void setSymbolDisplay(String string) {
        if (com.motivewave.common.h.g(string) || com.motivewave.common.h.a((Object)string, (Object)this.getSymbol())) {
            this.symbolDisplay = null;
            return;
        }
        this.symbolDisplay = string;
        this.notify("symbolDisplay", null, this.symbolDisplay);
    }

    public boolean isSymbolDisplayEmpty() {
        return com.motivewave.common.h.g(this.symbolDisplay);
    }

    public String getSectorId() {
        return this.sectorId;
    }

    public void setSectorId(String string) {
        if (com.motivewave.common.h.a((Object)this.sectorId, (Object)string)) {
            return;
        }
        this.sectorId = string;
        this.notify("sectorId", null, string);
        this.notify("sectorName", null, this.getIndustryGroupName());
    }

    public void setSector(Sector sector) {
        String string = this.getSectorName();
        this.sectorId = sector == null ? null : sector.getId();
        this.notify("sectorName", string, this.getSectorName());
    }

    public Sector getSector() {
        return com.motivewave.common.h.g(this.sectorId) ? null : Sector.get(this.sectorId);
    }

    public String getSectorName() {
        Sector sector = this.getSector();
        return sector == null ? "" : sector.getName();
    }

    public String getIndustryGroupId() {
        return this.industryGroupId;
    }

    public void setIndustryGroupId(String string) {
        if (com.motivewave.common.h.a((Object)this.industryGroupId, (Object)string)) {
            return;
        }
        this.industryGroupId = string;
        this.notify("industryGroupId", null, string);
        this.notify("industryGroupName", null, this.getIndustryGroupName());
    }

    public void setIndustryGroup(IndustryGroup industryGroup) {
        String string = this.getIndustryGroupName();
        if (industryGroup == null) {
            this.industryGroupId = null;
        } else {
            if (!com.motivewave.common.h.g(industryGroup.getSectorId())) {
                this.setSector(industryGroup.getSector());
            }
            this.industryGroupId = industryGroup.getId();
        }
        this.notify("industryGroupName", string, this.getIndustryGroupName());
    }

    public IndustryGroup getIndustryGroup() {
        return IndustryGroup.get(this.industryGroupId);
    }

    public String getIndustryGroupName() {
        IndustryGroup industryGroup = this.getIndustryGroup();
        return industryGroup == null ? "" : industryGroup.getName();
    }

    public Enums$InstrumentType getType() {
        return this.type == null ? Enums$InstrumentType.STOCK : this.type;
    }

    public void setType(Enums$InstrumentType enums$InstrumentType) {
        Enums$InstrumentType enums$InstrumentType2 = this.type;
        this.type = enums$InstrumentType;
        this.notify("type", (Object)enums$InstrumentType2, (Object)this.type);
    }

    public boolean supportsFractionalVolume() {
        return SymbolUtil.a(this) < 1.0f;
    }

    public boolean hasExpiryDate() {
        return this.expiryDate != null;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public LocalDate getExpiryLocalDate() {
        return com.motivewave.common.h.a(this.expiryDate);
    }

    public void setExpiryDate(Date date) {
        Date date2 = this.expiryDate;
        this.expiryDate = date;
        this.notify("expiryDate", date2, this.expiryDate);
    }

    public long getExpiryTime() {
        return this.expiryDate == null ? 0L : this.expiryDate.getTime();
    }

    public long getExpiryEOD() {
        if (this.expiryDate == null) {
            return 0L;
        }
        return this.getEndOfDay(this.expiryDate.getTime(), true);
    }

    public String getExchange() {
        return this.exchange == null ? "" : this.exchange;
    }

    public String getExchange(Enums$ServiceType enums$ServiceType) {
        Enums$ServiceType enums$ServiceType2 = this.getSourceType();
        if (enums$ServiceType == null || enums$ServiceType == enums$ServiceType2) {
            return this.getExchange();
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo != null) {
            return symbolInfo.getExchange();
        }
        String string = this.getExchange();
        if (enums$ServiceType.isIB()) {
            if (this.isCash() && !com.motivewave.common.h.a(string, new String[]{"IDEAL", "IDEALPRO"})) {
                string = "IDEALPRO";
            } else if (this.isStock()) {
                string = "SMART";
            }
        } else if (enums$ServiceType == Enums$ServiceType.GOOGLE) {
            return f.a(this);
        }
        return string;
    }

    public void setExchange(String string) {
        if (com.motivewave.common.h.a((Object)string, (Object)this.exchange)) {
            return;
        }
        String string2 = this.exchange;
        if (this.isSymbolUnique()) {
            this.exchange = string;
        } else {
            this.updateKey(() -> {
                this.exchange = string;
            });
        }
        this.notify("exchange", string2, this.exchange);
    }

    public String getPrimaryExchange() {
        return com.motivewave.common.h.g(this.primaryExchange) ? "" : this.primaryExchange;
    }

    public String getPrimaryExchange(Enums$ServiceType enums$ServiceType) {
        Enums$ServiceType enums$ServiceType2 = this.getSourceType();
        if (enums$ServiceType == null || enums$ServiceType == enums$ServiceType2) {
            return this.getPrimaryExchange();
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo != null) {
            return symbolInfo.getPrimaryExchange();
        }
        return this.getPrimaryExchange();
    }

    public void setPrimaryExchange(String string) {
        if (com.motivewave.common.h.a((Object)string, (Object)this.primaryExchange)) {
            return;
        }
        String string2 = this.primaryExchange;
        if (this.isIB()) {
            this.updateKey(() -> {
                this.primaryExchange = string;
            });
        } else {
            this.primaryExchange = string;
        }
        this.notify("primaryExchange", string2, this.primaryExchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateKey(Runnable runnable) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2 = MWInstrument.exists(this);
        if (bl2) {
            MWInstrument.unregister(this);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Workspace workspace = bs.a();
        if (workspace != null) {
            object3 = workspace.getAnalysisSources().iterator();
            while (object3.hasNext()) {
                object2 = (AnalysisSource)object3.next();
                if (((AnalysisSource)object2).isReadOnly() || (object = this.getAnalysisDirectory(((AnalysisSource)object2).getDirectory())) == null || !((File)object).exists()) continue;
                hashMap.put(object2, object);
            }
        }
        object2 = object3 = this.getSymbolDir();
        if (com.motivewave.common.h.g((String)object3)) {
            object3 = com.motivewave.platform.common.ab.a(this);
            object2 = this.getKey();
        }
        object = this.getKey();
        runnable.run();
        this.key = null;
        if (!bl2) {
            return;
        }
        MWInstrument.register(this);
        LiveTicker.keyUpdated((String)object, this.getKey());
        try {
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object82;
            if (workspace == null) {
                return;
            }
            for (Object object82 : workspace.getAnalysisSources()) {
                if (((AnalysisSource)object82).isReadOnly() || (object7 = (File)hashMap.get(object82)) == null || com.motivewave.common.h.a(object6 = this.getKey(), (Object)((File)object7).getName())) continue;
                object5 = new File(((File)object7).getParent(), (String)object6);
                ((File)object7).renameTo((File)object5);
                object4 = new File((File)object5, ".sync");
                if (!((File)object4).exists()) continue;
                ((File)object4).delete();
            }
            File file = workspace.isUseDatabase() ? Workspace.getWorkspaceDir() : workspace.getRepoDir();
            object82 = new File(file, "analysis");
            if (!((File)object82).exists()) {
                return;
            }
            object7 = new File((File)object82, this.getType().name());
            if (!((File)object7).exists()) {
                return;
            }
            object6 = new File((File)object7, (String)object3);
            if (!((File)object6).exists()) {
                object6 = new File((File)object7, (String)object2);
            }
            if (!((File)object6).exists() && this.isSymbolUnique()) {
                object2 = this.getKeyWithExchange();
                object6 = new File((File)object7, (String)object2);
            }
            if (!((File)object6).exists()) {
                return;
            }
            object5 = this.getSymbolDir();
            if (com.motivewave.common.h.g(object5)) {
                object5 = this.getKey();
            }
            if (com.motivewave.common.h.a(object2, object5)) {
                return;
            }
            object4 = new File((File)object7, (String)object5);
            ((File)object6).renameTo((File)object4);
            File file2 = new File((File)object4, ".sync");
            if (file2.exists()) {
                file2.delete();
            }
        }
        finally {
            for (InstrumentListener instrumentListener : this.instrListeners.a()) {
                instrumentListener.keyUpdated(this, (String)object, this.getKey());
            }
        }
    }

    public double getPriceMagnifier() {
        return this.priceMagnifier;
    }

    public void setPriceMagnifier(double d2) {
        double d3 = this.priceMagnifier;
        this.priceMagnifier = d2;
        this.notify("priceMagnifier", d3, this.priceMagnifier);
    }

    public double getPLDivisor() {
        return this.plDivisor;
    }

    public void setPLDivisor(double d2) {
        double d3 = this.plDivisor;
        this.plDivisor = d2;
        this.notify("pLDivisor", d3, this.plDivisor);
    }

    public double getDisplayMultiplier() {
        return this.displayMultiplier;
    }

    public void setDisplayMultiplier(double d2) {
        double d3 = this.displayMultiplier;
        this.displayMultiplier = d2;
        this.notify("displayMultiplier", d3, this.displayMultiplier);
    }

    public String getDisplayMask() {
        return this.displayMask;
    }

    public void setDisplayMask(String string) {
        String string2 = this.displayMask;
        if (com.motivewave.common.h.g(string)) {
            this.displayFormat = null;
            this.displayMask = null;
        } else {
            this.displayMask = string;
            try {
                this.displayFormat = new DecimalFormat(string);
            }
            catch (Throwable throwable) {
                com.motivewave.common.h.a.warning("MWInstrument::setDisplayMask() invalid format: " + string);
                this.displayFormat = null;
            }
        }
        this.notify("displayMask", string2, this.displayMask);
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String string) {
        this.currency = string;
    }

    public boolean isCustomContinuous() {
        return this.getType() == Enums$InstrumentType.CUSTOM_CONTINUOUS;
    }

    public boolean isCustom() {
        return this.getType() == Enums$InstrumentType.CUSTOM && !com.motivewave.common.h.g(this.customDefinition);
    }

    public String getCustomDefinition() {
        return this.customDefinition;
    }

    public void setCustomDefinition(String string) {
        this.customDefinition = string;
    }

    public boolean isCustomInverted() {
        return this.customInverted;
    }

    public void setCustomInverted(boolean bl2) {
        this.customInverted = bl2;
    }

    public double getCustomMultiplier() {
        return this.customMultiplier;
    }

    public void setCustomMultiplier(double d2) {
        this.customMultiplier = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWInstrument getActiveContract() {
        if (this.activeContract == null || bs.a() > this.activeExp) {
            MWInstrument mWInstrument = this.activeContract;
            String string = this.AC_SYNC;
            synchronized (string) {
                block9: {
                    if (bs.a() <= this.activeExp && this.activeContract != null) {
                        return this.activeContract;
                    }
                    try {
                        this.activeContract = ab.a(this);
                        this.activeExp = this.getEndOfDay(bs.a(), false);
                        if (this.activeExp < bs.a()) {
                            this.activeExp = this.getEndOfNextDay(bs.a(), false);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!(exception instanceof MWException)) break block9;
                        com.motivewave.common.h.a.warning("MWInstrument::getActiveContract() error getting active contract: " + this.getSymbol() + " error: " + exception.getMessage());
                    }
                }
            }
            if (mWInstrument != this.activeContract) {
                this.notify("activeContract", mWInstrument, this.activeContract);
            }
        }
        return this.activeContract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActiveContract() {
        MWInstrument mWInstrument = this.activeContract;
        String string = this.AC_SYNC;
        synchronized (string) {
            this.activeContract = null;
            this.activeExp = 0L;
        }
        if (mWInstrument != null) {
            this.notify("activeContract", mWInstrument, this.activeContract);
        }
    }

    public List getDependencies() {
        return Collections.unmodifiableList(this.dependentInstruments);
    }

    public int getContractNumber() {
        return this.contractNumber;
    }

    public void setContractNumber(int n2) {
        this.contractNumber = n2;
    }

    public void updateDefinition() {
        if (this.getType() != Enums$InstrumentType.CUSTOM) {
            return;
        }
        Object object = com.motivewave.common.h.b(new String[]{this.a("type", (Object)this.customType), this.a("operation", (Object)this.customOperation), this.a("inverted", this.customInverted, false), this.a("multiplier", this.customMultiplier)});
        Object object2 = com.motivewave.common.h.b(new String[0]);
        for (MWInstrument$Dependency mWInstrument$Dependency : this.dependentInstruments) {
            object2.add(this.a(this.b("symbol", mWInstrument$Dependency.instr.getSymbol()), this.b("exchange", mWInstrument$Dependency.instr.getExchange()), this.a("multiplier", mWInstrument$Dependency.multiplier), this.a("exp", mWInstrument$Dependency.exponent), this.a("inverted", mWInstrument$Dependency.inverted, false)));
        }
        object.add(this.a("instruments", (Collection)object2));
        this.customDefinition = this.a((Collection)object);
    }

    public void loadDefinition() {
        if (com.motivewave.common.h.g(this.customDefinition)) {
            return;
        }
        this.dependentInstruments = new ArrayList();
        if (w.a(this.customDefinition)) {
            try {
                JSONObject jSONObject = new JSONObject(this.customDefinition);
                try {
                    if (jSONObject.has("type")) {
                        this.customType = Enums$CustomInstrumentType.valueOf(jSONObject.str("type"));
                    }
                }
                catch (Exception exception) {
                    com.motivewave.common.h.a.severe("MWInstrument::loadDefinition() invalid custom type: " + jSONObject.str("type"));
                    com.motivewave.common.h.a.severe(this.customDefinition);
                    this.customType = Enums$CustomInstrumentType.INDEX;
                }
                String string = com.motivewave.common.h.q(jSONObject.str("operation"));
                if (com.motivewave.common.h.g(string)) {
                    string = "SUM";
                }
                try {
                    this.customOperation = Enums$CustomOperation.valueOf(string);
                }
                catch (Exception exception) {
                    com.motivewave.common.h.a.severe("MWInstrument::loadDefinition() invalid custom operation: " + string);
                    com.motivewave.common.h.a.severe(this.customDefinition);
                    this.customOperation = Enums$CustomOperation.SUM;
                }
                this.customInverted = jSONObject.is("inverted", false);
                this.customMultiplier = jSONObject.getDouble("multiplier");
                for (JSONObject jSONObject2 : jSONObject.getObjList("instruments")) {
                    MWInstrument mWInstrument = MWInstrument.get(jSONObject2.str("symbol"), jSONObject2.str("exchange"));
                    if (mWInstrument == null && (mWInstrument = MWInstrument.bySymbol(jSONObject2.str("symbol"))) == null) {
                        com.motivewave.common.h.a.severe("MWInstrument:loadDefinition() " + this.getSymbol() + " Unable to resolve dependent instrument: " + jSONObject2.str("symbol") + " " + jSONObject2.str("exchange"));
                        return;
                    }
                    double d2 = jSONObject2.getDouble("multiplier", 1.0);
                    boolean bl2 = jSONObject2.is("inverted", false);
                    double d3 = jSONObject2.getDouble("exp", 1.0);
                    this.dependentInstruments.add(new MWInstrument$Dependency(mWInstrument, d2, d3, bl2));
                }
                this.setType(Enums$InstrumentType.CUSTOM);
            }
            catch (Exception exception) {
                com.motivewave.common.h.a.warning("MWInstrument::loadCustomDefinition() error reading json: " + exception.getMessage());
                com.motivewave.common.h.a.warning(this.customDefinition);
                com.motivewave.common.h.c();
            }
            return;
        }
        Element element = h.a(this.customDefinition).getDocumentElement();
        String string = element.getAttribute("type");
        if (com.motivewave.common.h.g(string)) {
            string = "SPREAD";
        }
        try {
            this.customType = Enums$CustomInstrumentType.valueOf(string);
        }
        catch (Exception exception) {
            com.motivewave.common.h.a.severe("MWInstrument::loadDefinition() invalid custom type: " + string);
            com.motivewave.common.h.a.severe(this.customDefinition);
            this.customType = Enums$CustomInstrumentType.SPREAD;
        }
        String string2 = com.motivewave.common.h.q(element.getAttribute("operation"));
        if (com.motivewave.common.h.g(string2)) {
            string2 = "SUM";
        }
        try {
            this.customOperation = Enums$CustomOperation.valueOf(string2);
        }
        catch (Exception exception) {
            com.motivewave.common.h.a.severe("MWInstrument::loadDefinition() invalid custom operation: " + string2);
            com.motivewave.common.h.a.severe(this.customDefinition);
            this.customOperation = Enums$CustomOperation.SUM;
        }
        this.customInverted = com.motivewave.common.h.c((Object)element.getAttribute("inverted"));
        this.customMultiplier = com.motivewave.common.h.a(element.getAttribute("multiplier"));
        Node node = h.b("instruments", element);
        for (Element element2 : h.c("instrument", node)) {
            int n2 = com.motivewave.common.h.b(element2.getAttribute("id"));
            String string3 = element2.getAttribute("symbol");
            String string4 = element2.getAttribute("exchange");
            MWInstrument mWInstrument = MWInstrument.get(n2);
            if (mWInstrument == null || !com.motivewave.common.h.a((Object)mWInstrument.getSymbol(), (Object)string3)) {
                mWInstrument = MWInstrument.get(string3, string4);
            }
            if (mWInstrument == null && (mWInstrument = MWInstrument.bySymbol(string3)) == null) {
                com.motivewave.common.h.a.severe("MWInstrument:loadDefinitionXML() " + this.getSymbol() + " Unable to resolve dependent instrument: " + string3 + " " + string4);
                return;
            }
            String string5 = element2.getAttribute("multiplier");
            if (com.motivewave.common.h.g(string5)) {
                string5 = element2.getAttribute("weight");
            }
            double d4 = 1.0;
            if (!com.motivewave.common.h.g(string5)) {
                d4 = com.motivewave.common.h.a(com.motivewave.common.h.a(string5), 8);
            }
            boolean bl3 = false;
            if (!com.motivewave.common.h.g(element2.getAttribute("inverted"))) {
                bl3 = com.motivewave.common.h.c((Object)element2.getAttribute("inverted"));
            }
            double d5 = 1.0;
            if (!com.motivewave.common.h.g(element2.getAttribute("exp"))) {
                d5 = com.motivewave.common.h.a(com.motivewave.common.h.a(element2.getAttribute("exp")), 8);
            }
            this.dependentInstruments.add(new MWInstrument$Dependency(mWInstrument, d4, d5, bl3));
        }
        this.setType(Enums$InstrumentType.CUSTOM);
    }

    public void setCustomType(Enums$CustomInstrumentType enums$CustomInstrumentType) {
        this.customType = enums$CustomInstrumentType;
    }

    public Enums$CustomInstrumentType getCustomType() {
        return this.customType;
    }

    public void setCustomOperation(Enums$CustomOperation enums$CustomOperation) {
        this.customOperation = enums$CustomOperation;
    }

    public Enums$CustomOperation getCustomOperation() {
        return this.customOperation;
    }

    public void addDependency(MWInstrument$Dependency mWInstrument$Dependency) {
        this.dependentInstruments.add(mWInstrument$Dependency);
    }

    public void clearDependentInstruments() {
        this.dependentInstruments.clear();
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public void setSourceDescription(String string) {
        this.sourceDescription = string;
    }

    public double getMinTick() {
        return this.minTick;
    }

    public float getMinTickFloat() {
        return this.minTickFloat;
    }

    public void setMinTick(double d2) {
        if (d2 <= 0.0) {
            return;
        }
        if (d2 > 1.0 && !com.motivewave.common.h.a((Object)d2, new Object[]{2.0, 2.5, 5.0, 10.0, 20.0, 25.0, 50.0, 100.0})) {
            com.motivewave.common.h.a.warning("MWInstrument::setMinTick() bad min tick: " + d2);
            d2 = 0.01;
        }
        if (d2 == this.minTick) {
            return;
        }
        double d3 = this.minTick;
        this.minTick = d2;
        this.places = com.motivewave.common.h.a(this.minTick);
        this.minTickFloat = this.round((float)d2);
        this.minTickTenth = this.minTick == 0.0 ? 0.01 : (this.minTick == 5.0 ? 1.0 : (this.minTick == 0.25 ? 0.01 : (this.minTick == 0.5 ? 0.1 : (this.minTick == 0.025 ? 0.001 : (this.minTick == 0.05 ? 0.01 : (this.minTick == 0.0025 ? 1.0E-4 : (this.minTick == 0.005 ? 0.001 : (this.minTick == 0.015625 ? this.minTick : (this.minTick == 0.03125 ? this.minTick : (this.minTick == 0.0078125 ? this.minTick : (this.minTick == 0.125 ? this.minTick : (this.minTick == 0.0078125 ? this.minTick : (this.minTick == 0.00390625 ? this.minTick : this.minTick / 10.0)))))))))))));
        this.places2 = com.motivewave.common.h.a(this.minTickTenth);
        this.notify("minTick", d3, this.minTick);
        if (d2 > this.pointSize) {
            this.setPointSize(d2);
        }
    }

    public void setMinTickRules(List list) {
        this.minTickRules = list;
    }

    public double getMinTick(float f2) {
        if (!this.isOption() || this.minTickRules.isEmpty()) {
            return this.minTick;
        }
        for (MWInstrument$MinTickRule mWInstrument$MinTickRule : this.minTickRules) {
            if (!mWInstrument$MinTickRule.applies(f2)) continue;
            double d2 = mWInstrument$MinTickRule.getMinTick();
            if (d2 != this.minTick) {
                this.setMinTick(d2);
                MWInstrument.update(this);
            }
            return d2;
        }
        return this.minTick;
    }

    public float getMinStep() {
        return SymbolUtil.a(this);
    }

    public boolean isTickOverride() {
        return this.tickOverride;
    }

    public void setTickOverride(boolean bl2) {
        boolean bl3 = this.tickOverride;
        this.tickOverride = bl2;
        this.notify("tickOverride", bl3, this.tickOverride);
    }

    public String getMinTickAsString() {
        return com.motivewave.common.h.c(this.minTick, com.motivewave.common.h.a(this.minTick));
    }

    public double getPointSize() {
        if (this.isFuture() || this.isCustomContinuous()) {
            return 1.0;
        }
        return this.pointSize <= 0.0 ? this.minTick : this.pointSize;
    }

    public void setPointSize(double d2) {
        if (d2 < this.minTick) {
            d2 = this.minTick;
        }
        if (d2 > 1.0 && !com.motivewave.common.h.a((Object)d2, new Object[]{2.0, 2.5, 5.0, 10.0, 20.0, 25.0, 50.0, 100.0})) {
            com.motivewave.common.h.a.warning("MWInstrument::setPointSize() bad point size: " + d2 + " " + this.getKey());
            d2 = this.minTick;
        }
        double d3 = this.pointSize;
        this.pointSize = d2;
        if (this.pointPlaces == -1000) {
            this.pointPlaces = com.motivewave.common.h.a(this.getPointSize());
        }
        this.notify("pointSize", d3, this.pointSize);
    }

    public String getPointSizeAsString() {
        return com.motivewave.common.h.c(this.getPointSize(), com.motivewave.common.h.a(this.minTick));
    }

    public Double getStrikePrice() {
        return this.strikePrice;
    }

    public void setStrikePrice(Double d2) {
        this.strikePrice = d2;
    }

    public Enums$OptionType getOptionType() {
        return this.optionType;
    }

    public void setOptionType(Enums$OptionType enums$OptionType) {
        this.optionType = enums$OptionType;
    }

    public String getTitle() {
        return com.motivewave.common.h.g(this.title) ? this.symbol : this.title;
    }

    public void setTitle(String string) {
        if (com.motivewave.common.h.a((Object)string, (Object)this.getTitle())) {
            return;
        }
        String string2 = this.getTitle();
        this.title = com.motivewave.common.h.q(string);
        this.notify("title", string2, string);
    }

    public Enums$RollMethod getRollMethod() {
        return this.getRollMethod(null);
    }

    public Enums$RollMethod getRollMethod(RollSettings rollSettings) {
        RollSettings rollSettings2 = this.getRollSettings(rollSettings);
        return rollSettings2 == null ? Enums$RollMethod.NONE : rollSettings2.getRollMethod();
    }

    public RollSettings getRollSettings() {
        return this.rollSettings;
    }

    public void setRollSettings(RollSettings rollSettings) {
        RollSettings rollSettings2 = this.rollSettings;
        this.rollSettings = rollSettings;
        this.notify("rollSettings", rollSettings2, rollSettings);
    }

    public RollSettings getRollSettings(RollSettings rollSettings) {
        if (!this.isFuture() && !this.isCustomContinuous()) {
            return null;
        }
        if (rollSettings != null) {
            return rollSettings;
        }
        if (this.rollSettings != null) {
            return this.rollSettings;
        }
        return b.a(this);
    }

    public BarBuildSettings resolveBarBuildSettings() {
        if (this.barBuildSettings != null) {
            return this.barBuildSettings;
        }
        TradingHours tradingHours = this.resolveTradingHours();
        if (tradingHours != null && tradingHours.getBarBuildSettings() != null) {
            return tradingHours.getBarBuildSettings();
        }
        return b.a().getBarBuildSettings();
    }

    public BarBuildSettings getBarBuildSettings() {
        return this.barBuildSettings;
    }

    public void setBarBuildSettings(BarBuildSettings barBuildSettings) {
        BarBuildSettings barBuildSettings2 = this.barBuildSettings;
        this.barBuildSettings = barBuildSettings;
        this.notify("barBuild", barBuildSettings2, barBuildSettings);
    }

    @Override
    public String formatPrice(float f2) {
        return this.formatValue(f2);
    }

    public String formatShort(float f2) {
        return com.motivewave.common.h.p(this.formatPrice(f2));
    }

    public String formatShort(double d2) {
        return com.motivewave.common.h.p(this.formatValue(d2));
    }

    public String formatValue(double d2) {
        int n2 = 0;
        double d3 = this.getMinTick();
        if (this.places == -1000) {
            this.places = com.motivewave.common.h.a(d3);
        }
        n2 = this.places;
        return this.formatPriceWith(d2, d3, n2);
    }

    public String formatTenth(double d2) {
        double d3 = this.getMinTick();
        if (this.places == -1000) {
            this.places = com.motivewave.common.h.a(d3);
        }
        if (this.places2 == -1000) {
            this.places2 = com.motivewave.common.h.a(this.minTickTenth);
        }
        String string = this.formatPriceWith(d2, this.minTickTenth, this.places2);
        if (this.places2 > this.places) {
            if (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public String formatPriceWith(double d2, double d3, int n2) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            return "";
        }
        if (this.displayMultiplier > 1.0E-7) {
            d2 *= this.displayMultiplier;
        }
        if (this.displayFormat != null) {
            return this.displayFormat.format(d2);
        }
        if (this.displayMultiplier > 1.0E-6) {
            if (this.displayMultiplier >= 10000.0) {
                n2 -= 4;
            } else if (this.displayMultiplier >= 1000.0) {
                n2 -= 3;
            } else if (this.displayMultiplier >= 100.0) {
                n2 -= 2;
            } else if (this.displayMultiplier >= 10.0) {
                --n2;
            }
        }
        d2 = (double)Math.round(d2 / d3) * d3;
        if (d3 == 0.015625 || d3 == 0.03125 || d3 == 0.0078125) {
            double d4 = Math.floor(d2);
            int n3 = (int)(320.0 * (d2 - d4));
            if (d2 < 0.0) {
                d4 = Math.ceil(d2);
                n3 = (int)(320.0 * (d4 - d2));
            }
            String string = "";
            if (n3 < 10) {
                string = "00";
            } else if (n3 < 100) {
                string = "0";
            }
            if (d2 < 0.0 && d4 == 0.0) {
                return "-0'" + string + n3;
            }
            return (int)d4 + "'" + string + n3;
        }
        if (d3 == 0.125) {
            double d5 = Math.floor(d2);
            double d6 = d2 - d5;
            if (d2 < 0.0) {
                d5 = Math.ceil(d2);
                d6 = d5 - d2;
            }
            if (d2 < 0.0 && d5 == 0.0) {
                return "-0 " + (int)(d6 * 8.0) + "/8";
            }
            return (int)d5 + " " + (int)(d6 * 8.0) + "/8";
        }
        if (d3 == 0.0078125) {
            double d7 = Math.floor(d2);
            double d8 = d2 - d7;
            if (d2 < 0.0) {
                d7 = Math.ceil(d2);
                d8 = d7 - d2;
            }
            if (d2 < 0.0 && d7 == 0.0) {
                return "-0 " + (int)(d8 * 128.0) + "/128";
            }
            return (int)d7 + " " + (int)(d8 * 128.0) + "/128";
        }
        if (d3 == 0.00390625) {
            double d9 = Math.floor(d2);
            double d10 = d2 - d9;
            if (d2 < 0.0) {
                d9 = Math.ceil(d2);
                d10 = d9 - d2;
            }
            if (d2 < 0.0 && d9 == 0.0) {
                return "-0 " + (int)(d10 * 256.0) + "/256";
            }
            return (int)d9 + " " + (int)(d10 * 256.0) + "/256";
        }
        return com.motivewave.common.h.c(d2, n2);
    }

    public String formatValue(float f2) {
        int n2 = 0;
        double d2 = this.getMinTick();
        if (this.places == -1000) {
            this.places = com.motivewave.common.h.a(d2);
        }
        n2 = this.places;
        return this.formatValue(f2, this.getMinTickFloat(), n2);
    }

    public String formatValueNormalized(float f2) {
        int n2 = 0;
        double d2 = this.getMinTick();
        if (this.places == -1000) {
            this.places = com.motivewave.common.h.a(d2);
        }
        n2 = this.places;
        return this.formatValueNormalized(f2, this.getMinTickFloat(), n2);
    }

    public String formatValue(float f2, float f3) {
        return this.formatValue(f2, f3, 0);
    }

    private String formatValue(float f2, float f3, int n2) {
        if (this.displayMultiplier > 1.0E-7) {
            f2 = (float)((double)f2 * this.displayMultiplier);
        }
        if (this.displayFormat != null) {
            return this.displayFormat.format(f2);
        }
        if (n2 == 0) {
            n2 = com.motivewave.common.h.a(f3);
        }
        if (this.displayMultiplier > 1.0E-6) {
            if (this.displayMultiplier >= 10000.0) {
                n2 -= 4;
            } else if (this.displayMultiplier >= 1000.0) {
                n2 -= 3;
            } else if (this.displayMultiplier >= 100.0) {
                n2 -= 2;
            } else if (this.displayMultiplier >= 10.0) {
                --n2;
            }
        }
        if ((double)f3 == 0.015625 || (double)f3 == 0.03125 || (double)f3 == 0.0078125) {
            double d2 = Math.floor(f2);
            int n3 = (int)(320.0 * ((double)f2 - d2));
            if (f2 < 0.0f) {
                d2 = Math.ceil(f2);
                n3 = (int)(320.0 * (d2 - (double)f2));
            }
            String string = "";
            if (n3 < 10) {
                string = "00";
            } else if (n3 < 100) {
                string = "0";
            }
            if (f2 < 0.0f && d2 == 0.0) {
                return "-0'" + string + n3;
            }
            return (int)d2 + "'" + string + n3;
        }
        if ((double)f3 == 0.125) {
            double d3 = Math.floor(f2);
            double d4 = (double)f2 - d3;
            if (f2 < 0.0f) {
                d3 = Math.ceil(f2);
                d4 = d3 - (double)f2;
            }
            if (f2 < 0.0f && d3 == 0.0) {
                return "-0 " + (int)(d4 * 8.0) + "/8";
            }
            return (int)d3 + " " + (int)(d4 * 8.0) + "/8";
        }
        if ((double)f3 == 0.0078125) {
            double d5 = Math.floor(f2);
            double d6 = (double)f2 - d5;
            if (f2 < 0.0f) {
                d5 = Math.ceil(f2);
                d6 = d5 - (double)f2;
            }
            if (f2 < 0.0f && d5 == 0.0) {
                return "-0 " + (int)(d6 * 128.0) + "/128";
            }
            return (int)d5 + " " + (int)(d6 * 128.0) + "/128";
        }
        if ((double)f3 == 0.00390625) {
            double d7 = Math.floor(f2);
            double d8 = (double)f2 - d7;
            if (f2 < 0.0f) {
                d7 = Math.ceil(f2);
                d8 = d7 - (double)f2;
            }
            if (f2 < 0.0f && d7 == 0.0) {
                return "-0 " + (int)(d8 * 256.0) + "/256";
            }
            return (int)d7 + " " + (int)(d8 * 256.0) + "/256";
        }
        String string = com.motivewave.common.h.b(f2, n2);
        return string;
    }

    private String formatValueNormalized(float f2, float f3, int n2) {
        if (this.displayMultiplier > 1.0E-7) {
            f2 = (float)((double)f2 * this.displayMultiplier);
        }
        if (this.displayFormat != null) {
            return this.displayFormat.format(f2);
        }
        if (n2 == 0) {
            n2 = com.motivewave.common.h.a(f3);
        }
        if (this.displayMultiplier > 1.0E-6) {
            if (this.displayMultiplier >= 10000.0) {
                n2 -= 4;
            } else if (this.displayMultiplier >= 1000.0) {
                n2 -= 3;
            } else if (this.displayMultiplier >= 100.0) {
                n2 -= 2;
            } else if (this.displayMultiplier >= 10.0) {
                --n2;
            }
        }
        String string = com.motivewave.common.h.b(f2, n2);
        return string;
    }

    public double parseDouble(String string) {
        if (string == null) {
            return 0.0;
        }
        if (com.motivewave.common.h.g(string = string.trim())) {
            return 0.0;
        }
        if (this.displayFormat != null) {
            try {
                double d2 = com.motivewave.common.h.a((Object)this.displayFormat.parse(string));
                if (this.displayMultiplier > 1.0E-7) {
                    d2 /= this.displayMultiplier;
                }
                return d2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n2 = 1;
        if (string.startsWith("-")) {
            n2 = -1;
            string = string.substring(1);
        }
        if (string.indexOf("'") >= 0) {
            Object object = string.substring(string.indexOf("'") + 1);
            if (com.motivewave.common.h.g((String)object)) {
                object = "0";
            } else if (((String)object).length() == 1) {
                object = (String)object + "00";
            } else if (((String)object).length() == 2) {
                object = (String)object + "0";
            } else if (((String)object).length() > 3) {
                object = ((String)object).substring(0, 2);
            }
            int n3 = com.motivewave.common.h.b((String)object);
            if (n3 > 320) {
                n3 = 320;
            }
            double d3 = (double)n3 / 320.0;
            return (d3 + (double)com.motivewave.common.h.b(string.substring(0, string.indexOf("'")))) * (double)n2;
        }
        if (string.indexOf("/") > 0) {
            int n4 = com.motivewave.common.h.b(string.substring(string.indexOf("/") + 1));
            int n5 = string.indexOf(" ");
            int n6 = com.motivewave.common.h.b(string.substring(n5 < 0 ? 0 : n5, string.indexOf("/")));
            double d4 = (double)n6 / (double)n4;
            if (n5 > 0) {
                d4 += (double)com.motivewave.common.h.b(string.substring(0, n5));
            }
            return d4 * (double)n2;
        }
        double d5 = com.motivewave.common.h.a(string);
        if (this.displayMultiplier > 1.0E-7) {
            d5 /= this.displayMultiplier;
        }
        return d5 * (double)n2;
    }

    public float round(float f2, boolean bl2) {
        if (bl2) {
            return this.roundToPoint(f2);
        }
        return this.round(f2);
    }

    public int priceToInt(float f2) {
        double d2 = this.round((double)f2);
        return (int)Math.round(d2 / this.getMinTick());
    }

    public int priceToInt(double d2) {
        double d3 = this.round(d2);
        return (int)Math.round(d3 / this.getMinTick());
    }

    public float priceFromInt(int n2) {
        return (float)n2 * this.getMinTickFloat();
    }

    public double priceFromIntD(int n2) {
        return (double)n2 * this.getMinTick();
    }

    public float round(float f2) {
        if (this.minTick == 0.0) {
            return f2;
        }
        return (float)com.motivewave.common.h.a(com.motivewave.common.h.a((double)f2, this.minTick), 9);
    }

    public double round(double d2) {
        if (this.minTick == 0.0) {
            return d2;
        }
        return com.motivewave.common.h.a(com.motivewave.common.h.a(d2, this.minTick), 9);
    }

    public float roundTenth(float f2) {
        if (this.minTick == 0.0) {
            return f2;
        }
        return (float)com.motivewave.common.h.a(com.motivewave.common.h.a((double)f2, this.minTick / 10.0), 9);
    }

    public double roundTenth(double d2) {
        if (this.minTick == 0.0) {
            return d2;
        }
        return com.motivewave.common.h.a(com.motivewave.common.h.a(d2, this.minTick / 10.0), 9);
    }

    public float roundToPoint(float f2) {
        if (!this.isCash()) {
            return this.round(f2);
        }
        if (this.minTick != 0.0 && (double)f2 < this.minTick && (double)f2 > -this.minTick) {
            return 0.0f;
        }
        return (float)com.motivewave.common.h.a(com.motivewave.common.h.a((double)f2, this.getPointSize()), 9);
    }

    public float floorToPoint(float f2) {
        if (!this.isCash()) {
            return this.round(f2);
        }
        if (this.minTick != 0.0 && (double)f2 < this.minTick && (double)f2 > -this.minTick) {
            return 0.0f;
        }
        return com.motivewave.common.h.a(com.motivewave.common.h.c(f2, (float)this.getPointSize()), 6);
    }

    public String getDescription() {
        if (!com.motivewave.common.h.g(this.description)) {
            return this.description;
        }
        if (!com.motivewave.common.h.g(this.sourceDescription)) {
            return this.sourceDescription;
        }
        if (!com.motivewave.common.h.g(this.title)) {
            return this.title;
        }
        if (this.type == Enums$InstrumentType.STOCK) {
            if (com.motivewave.common.h.g(this.exchange)) {
                return this.getTitle();
            }
            String string = this.getTitle() + " (" + this.exchange + ")";
            return string;
        }
        if (com.motivewave.common.h.a((Object)this.type, new Object[]{Enums$InstrumentType.FUTURE, Enums$InstrumentType.CONT_FUTURE})) {
            String string = this.symbol;
            if (this.expiryDate == null) {
                return "Futures " + string;
            }
            return com.motivewave.common.h.a(this.expiryDate, "MMMyy") + " Futures " + string;
        }
        return this.getSymbol();
    }

    public void setDescription(String string) {
        if (com.motivewave.common.h.a((Object)string, (Object)this.getDescription())) {
            return;
        }
        String string2 = this.getDescription();
        this.description = string;
        this.notify("description", string2, string);
    }

    public String getTradingHoursID() {
        return this.tradingHoursID;
    }

    public void setTradingHoursID(String string) {
        if (com.motivewave.common.h.a((Object)string, (Object)this.tradingHoursID) || this.getTradingHours() == TradingHours.get(string)) {
            return;
        }
        this.tradingHoursID = string;
        this.tradingHoursUpdated();
    }

    public TradingHours getTradingHours() {
        if (this.tradingHours != null) {
            return this.tradingHours;
        }
        this.tradingHours = this.resolveTradingHours();
        if (this.tradingHours == null) {
            return TradingHours.get(TradingHours.NONE);
        }
        return this.tradingHours;
    }

    public TradingHours getDefaultHours() {
        if (this.defaultHours != null) {
            return this.defaultHours;
        }
        String string = SymbolUtil.b(this.getUnderlying(), this.getSourceType());
        this.defaultHours = TradingHours.getDefault(string);
        return this.defaultHours == null ? this.getTradingHours() : this.defaultHours;
    }

    public void tradingHoursUpdated() {
        this.tradingHours = null;
        this.timeZone = null;
        this.lastTHResolve = 0L;
        this.resolveTimeZone();
    }

    private TradingHours _resolveTradingHours() {
        TradingHours tradingHours;
        String string;
        Object object;
        Object object2;
        if (this.isCrypto()) {
            return TradingHours.get(TradingHours.CRYPTO_UTC);
        }
        String string2 = this.getExchange();
        if (!com.motivewave.common.h.g(string2)) {
            object2 = TradingHours.byExchange(string2);
            if (object2 != null) {
                this.lastTH = object2;
                this.lastTHResolve = System.currentTimeMillis();
                return object2;
            }
            object = this.primaryExchange;
            if (!com.motivewave.common.h.g((String)object) && (object2 = TradingHours.byExchange((String)object)) != null) {
                this.lastTH = object2;
                this.lastTHResolve = System.currentTimeMillis();
                return object2;
            }
        }
        object2 = null;
        object = bs.a(this);
        if (object == null) {
            if (!com.motivewave.common.h.a((Collection)bs.w())) {
                com.motivewave.common.h.a.warning("MWInstrument::resolveTradingHours() instance not found for: " + this.toString());
            }
            this.lastTH = new TimeZoneTH(this.getTimeZone());
            this.lastTHResolve = System.currentTimeMillis();
            return this.lastTH;
        }
        object2 = ((by)object).a();
        if (((x)object2).aB() && this.isCash()) {
            return TradingHours.get(TradingHours.FXCM);
        }
        if (com.motivewave.common.h.a((Object)this.getType(), new Object[]{Enums$InstrumentType.FUTURE, Enums$InstrumentType.CONT_FUTURE})) {
            String string3 = this.getUnderlying();
            String string4 = SymbolUtil.b(string3, this.getSourceType());
            if (com.motivewave.common.h.g(string4)) {
                this.lastTH = new TimeZoneTH(this.getTimeZone());
                this.lastTHResolve = System.currentTimeMillis();
                return this.lastTH;
            }
            return TradingHours.get(string4);
        }
        if (((x)object2).av()) {
            return TradingHours.get(TradingHours.FXCM);
        }
        if (((x)object2).au() && this.getType() == Enums$InstrumentType.CASH) {
            return TradingHours.get(TradingHours.IB_FOREX);
        }
        if (((x)object2).ax() && this.getType() == Enums$InstrumentType.CASH) {
            return TradingHours.get(TradingHours.TS_FOREX);
        }
        if (((x)object2).aA()) {
            return TradingHours.get(TradingHours.OANDA);
        }
        if (((x)object2).aw()) {
            return TradingHours.get(TradingHours.FOREX);
        }
        if (this.isCash()) {
            TradingHours.get(TradingHours.FXCM);
        }
        if ((com.motivewave.common.h.g(string2) || com.motivewave.common.h.b((Object)string2, (Object)"SMART")) && com.motivewave.common.h.g(string2 = this.primaryExchange)) {
            this.lastTH = new TimeZoneTH(this.getTimeZone());
            this.lastTHResolve = System.currentTimeMillis();
            return this.lastTH;
        }
        switch (string2) {
            case "NYSE": 
            case "AMEX": 
            case "NYSE_AMEX": 
            case "NYSEARCA": {
                return TradingHours.get(TradingHours.NYSE);
            }
            case "NASDAQ": 
            case "INDEXNASDAQ": {
                return TradingHours.get(TradingHours.NASDAQ);
            }
            case "OTC": 
            case "OTCBB": {
                return TradingHours.get(TradingHours.NASDAQ);
            }
            case "TSE": 
            case "TSX": {
                return TradingHours.get(TradingHours.TSX);
            }
            case "ASX": {
                return TradingHours.get(TradingHours.ASX);
            }
            case "XETRA": {
                return TradingHours.get(TradingHours.XETRA);
            }
            case "CURRENCY": {
                return TradingHours.get(TradingHours.FOREX);
            }
        }
        if ((this.isFuture() || this.type == Enums$InstrumentType.CUSTOM_CONTINUOUS) && !com.motivewave.common.h.g(string = SymbolUtil.b(this.getUnderlying(), this.getSourceType())) && (tradingHours = TradingHours.get(string)) != null) {
            return tradingHours;
        }
        if (cj.h.a() && !this.isOption() && !this.isFutureOption()) {
            System.err.println("Trading Hours Not found for: " + string2 + " " + this.getKey() + " " + this.getUnderlying());
        }
        this.lastTH = new TimeZoneTH(this.getTimeZone());
        this.lastTHResolve = System.currentTimeMillis();
        return this.lastTH;
    }

    private TradingHours resolveTradingHours() {
        if (com.motivewave.common.h.g(this.tradingHoursID)) {
            if (System.currentTimeMillis() - this.lastTHResolve < 1000L) {
                return this.lastTH;
            }
            this.lastTH = this._resolveTradingHours();
            this.lastTHResolve = System.currentTimeMillis();
            this.resolveTimeZone();
            return this.lastTH;
        }
        return TradingHours.get(this.tradingHoursID);
    }

    public Calendar getCalendar() {
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours != null) {
            return tradingHours.getCalendar();
        }
        return com.motivewave.common.h.a(this.resolveTimeZone());
    }

    public int getTradingDay(long l2) {
        return this.getTradingHours().getTradingDay(l2);
    }

    public long getStartOfPreviousDay(long l2, boolean bl2) {
        return this.getTradingHours().getStartOfPreviousDay(l2, bl2);
    }

    public long getStartOfDay(long l2, boolean bl2) {
        return this.getTradingHours().getStartOfDay(l2, bl2);
    }

    public long getStartOfDayDefault(long l2, boolean bl2) {
        return this.getDefaultHours().getStartOfDay(l2, bl2);
    }

    public long getEndOfDayDefault(long l2, boolean bl2) {
        return this.getDefaultHours().getEndOfDay(l2, bl2);
    }

    public long getStartOfDay2(long l2, boolean bl2) {
        return this.getTradingHours().getStartOfDay2(l2, bl2);
    }

    public long getStartOfNextDay(long l2, boolean bl2) {
        return this.getTradingHours().getStartOfNextDay(l2, bl2);
    }

    public long getEndOfNextDay(long l2, boolean bl2) {
        return this.getTradingHours().getEndOfNextDay(l2, bl2);
    }

    public long getEndOfPreviousDay(long l2, boolean bl2) {
        return this.getTradingHours().getEndOfPreviousDay(l2, bl2);
    }

    public long getEndOfDay(long l2, boolean bl2) {
        return this.getTradingHours().getEndOfDay(l2, bl2);
    }

    public long getStartOfWeek(long l2, boolean bl2) {
        return this.getTradingHours().getStartOfWeek(l2, bl2);
    }

    public long getEndOfWeek(long l2, boolean bl2) {
        return this.getTradingHours().getEndOfWeek(l2, bl2);
    }

    public long getStartOfMonth(long l2, boolean bl2) {
        return this.getTradingHours().getStartOfMonth(l2, bl2);
    }

    public long getEndOfMonth(long l2, boolean bl2) {
        return this.getTradingHours().getEndOfMonth(l2, bl2);
    }

    public long getStartOfYear(long l2, boolean bl2) {
        return this.getTradingHours().getStartOfYear(l2, bl2);
    }

    public long getEndOfYear(long l2, boolean bl2) {
        return this.getTradingHours().getEndOfYear(l2, bl2);
    }

    public boolean isTradeableDay(long l2, boolean bl2) {
        return this.getTradingHours().isTradeableDay(l2, bl2);
    }

    public boolean isInsideTradingHours(long l2, boolean bl2) {
        return this.getTradingHours().isInsideTradingHours(l2, bl2, true);
    }

    public boolean isInsideTradingHours(long l2, long l3, boolean bl2) {
        return this.getTradingHours().isInsideTradingHours(l2, l3, bl2);
    }

    public boolean isInsideTradingHours(long l2, boolean bl2, boolean bl3) {
        return this.getTradingHours().isInsideTradingHours(l2, bl2, bl3);
    }

    public boolean isInsideTradingDay(long l2, boolean bl2, boolean bl3) {
        return this.getTradingHours().isInsideTradingDay(l2, bl2, bl3);
    }

    public TradingHours$TradingTimes getTradingTimes(long l2, boolean bl2) {
        return this.getTradingHours().getTradingTimes(l2, bl2);
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean bl2) {
        this.resolved = bl2;
    }

    public Boolean supportsExtendedData() {
        return this.extendedData;
    }

    public void setSupportsExtendedData(Boolean bl2) {
        this.extendedData = bl2;
    }

    public boolean isExtendedDataSupported() {
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours != null && !tradingHours.hasExtendedHours()) {
            return false;
        }
        if (this.extendedData != null) {
            return this.extendedData;
        }
        return tradingHours == null || tradingHours.hasExtendedHours();
    }

    public boolean isShowExtendedData() {
        return this.showExtendedData == null ? b.a().x() : this.showExtendedData.booleanValue();
    }

    public void setShowExtendedData(boolean bl2) {
        this.showExtendedData = bl2;
    }

    public boolean isShowExtendedDataSet() {
        return this.showExtendedData != null;
    }

    public boolean isBackFillEnabled() {
        return this.backFillEnabled == null ? b.a().isBackfillEnabled() : this.backFillEnabled.booleanValue();
    }

    public void setBackFillEnabled(boolean bl2) {
        this.backFillEnabled = bl2;
    }

    public boolean isBackFillEnabledSet() {
        return this.backFillEnabled != null;
    }

    public boolean isLocalDataOnly() {
        return this.localDataOnly;
    }

    public void setLocalDataOnly(boolean bl2) {
        this.localDataOnly = bl2;
    }

    public boolean isMinuteDailyBars() {
        return this.minuteDailyBars;
    }

    public void setMinuteDailyBars(boolean bl2) {
        this.minuteDailyBars = bl2;
    }

    public boolean hasIntradayData() {
        return this.intradayData;
    }

    public void setIntradayData(boolean bl2) {
        this.intradayData = bl2;
    }

    public boolean isUseContinuousData() {
        return this.useContinuousData;
    }

    public void setUseContinuousData(boolean bl2) {
        this.useContinuousData = bl2;
    }

    public boolean isUseContinuousIntraday() {
        return this.useContinuousIntraday;
    }

    public void setUseContinuousIntraday(boolean bl2) {
        this.useContinuousIntraday = bl2;
    }

    public TimeZone getTimeZone() {
        return this.timeZone == null ? b.b() : this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone resolveTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours != null && tradingHours.getTimeZone() != null) {
            return tradingHours.getTimeZone();
        }
        this.timeZone = b.b();
        return this.timeZone;
    }

    public double getContractValue() {
        return this.contractValue;
    }

    public void setContractValue(double d2) {
        this.contractValue = d2;
    }

    public int getContractSize() {
        if (this.isOption() && (com.motivewave.common.h.a((Object)this.getCurrency(), (Object)"INR") || com.motivewave.common.h.a((Object)this.getExchange(), (Object)"NSE"))) {
            return 1;
        }
        return this.contractSize;
    }

    public void setContractSize(int n2) {
        this.contractSize = n2;
    }

    public double getPointValue() {
        if ((this.isFuture() || this.isCustomContinuous()) && this.pointValue == 0.0 && !com.motivewave.common.h.g(this.getUnderlying())) {
            return SymbolUtil.e(this.getUnderlying());
        }
        return this.pointValue;
    }

    public double getRawPointValue() {
        return this.pointValue;
    }

    public void setPointValue(double d2) {
        this.pointValue = d2;
    }

    public boolean isUseDefaultCommission() {
        return this.useDefaultCommission;
    }

    public void setUseDefaultCommission(boolean bl2) {
        this.useDefaultCommission = bl2;
    }

    public double getBaseCost() {
        return this.baseCost;
    }

    public void setBaseCost(double d2) {
        this.baseCost = d2;
    }

    public double getUnitCost() {
        return this.unitCost;
    }

    public void setUnitCost(double d2) {
        this.unitCost = d2;
    }

    public int getUnitSize() {
        return this.unitSize;
    }

    public void setUnitSize(int n2) {
        this.unitSize = n2;
    }

    public double calcCommission(float f2) {
        if (f2 == 0.0f || Float.isNaN(f2)) {
            return 0.0;
        }
        if (this.isCustomContinuous() && this.activeContract != null) {
            return this.activeContract.calcCommission(f2);
        }
        f2 = Math.abs(f2);
        if (this.useDefaultCommission) {
            Commission commission = Commission.get(this.getType());
            if (commission == null) {
                return 0.0;
            }
            return commission.getBaseCost() + commission.getUnitCost() * (f2 / (float)commission.getUnitSize());
        }
        return this.baseCost + this.unitCost * (double)(f2 / (float)this.unitSize);
    }

    public Flag getFlag() {
        if (com.motivewave.common.h.g(this.flagId)) {
            return null;
        }
        Flag flag = Flag.get(this.flagId);
        if (flag == null) {
            this.setFlagId(null);
        }
        return flag;
    }

    public String getFlagId() {
        return this.flagId;
    }

    public void setFlagId(String string) {
        String string2 = this.flagId;
        this.flagId = string;
        this.notify("flagId", string2, string);
        if (!com.motivewave.common.h.a((Object)string2, (Object)string)) {
            MWInstrument.update(this);
        }
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        String string2 = this.notes;
        this.notes = string;
        this.notify("notes", string2, string);
        if (!com.motivewave.common.h.a((Object)string2, (Object)string)) {
            MWInstrument.update(this);
        }
    }

    public void addListener(InstrumentListener instrumentListener) {
        this.instrListeners.a(instrumentListener);
    }

    public void removeListener(InstrumentListener instrumentListener) {
        this.instrListeners.b(instrumentListener);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            MWInstrument mWInstrument = (MWInstrument)object;
            return com.motivewave.common.h.a((Object)mWInstrument.getKey(), (Object)this.getKey());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return this.getKey();
    }

    public int getDecimalPlaces() {
        return this.places;
    }

    public MWInstrument getHistoricalInstrument() {
        if (com.motivewave.common.h.g(this.historicalSymbol)) {
            return null;
        }
        if (com.motivewave.common.h.a((Object)this.historicalSymbol, (Object)this.getSymbol()) && com.motivewave.common.h.a((Object)this.historicalExchange, (Object)this.getExchange())) {
            return null;
        }
        MWInstrument mWInstrument = MWInstrument.get(this.historicalSymbol, this.historicalExchange);
        if (mWInstrument == this) {
            return null;
        }
        return mWInstrument;
    }

    public void setHistoricalInstrument(MWInstrument mWInstrument) {
        if (mWInstrument == null || mWInstrument == this) {
            this.historicalExchange = null;
            this.historicalSymbol = null;
            return;
        }
        this.historicalSymbol = mWInstrument.getSymbol();
        this.historicalExchange = mWInstrument.getExchange();
    }

    public int compareTo(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return 1;
        }
        if (mWInstrument == this) {
            return 0;
        }
        return this.getKey().compareTo(mWInstrument.getKey());
    }

    public void setHistoricalSymbol(String string) {
        this.historicalSymbol = string;
    }

    public String getHistoricalExchange() {
        return this.historicalExchange;
    }

    public void setHistoricalExchange(String string) {
        this.historicalExchange = string;
    }

    public MWInstrument getInstrument(Enums$ServiceType enums$ServiceType, boolean bl2) {
        if (enums$ServiceType == this.getSourceType() || enums$ServiceType == null) {
            return this;
        }
        MWInstrument mWInstrument = MWInstrument.get(this.getSymbol(enums$ServiceType), enums$ServiceType);
        if (mWInstrument != null) {
            return mWInstrument;
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo != null && !com.motivewave.common.h.g(symbolInfo.getSymbol())) {
            mWInstrument = new MWInstrument(symbolInfo.getSymbol(), this.getType(), symbolInfo.getExchange(), symbolInfo.getCurrency());
            mWInstrument.setPrimaryExchange(symbolInfo.getPrimaryExchange());
            mWInstrument.setServiceId(symbolInfo.getServiceId());
            if (bl2) {
                MWInstrument.register(mWInstrument);
            }
            return mWInstrument;
        }
        String string = this.getSymbol(enums$ServiceType);
        if (!com.motivewave.common.h.g(string) && this.isFuture() && (mWInstrument = SymbolUtil.a(string, enums$ServiceType, bl2)) != null) {
            return mWInstrument;
        }
        return this;
    }

    public MWInstrument getAcctInstrument(Account account) {
        MWInstrument mWInstrument;
        if (account != null && account.isReplay()) {
            return this;
        }
        MWInstrument mWInstrument2 = mWInstrument = this.isCustomContinuous() ? this.getActiveContract() : this;
        if (mWInstrument == null) {
            mWInstrument = this;
        }
        if (account == null) {
            return mWInstrument;
        }
        return (mWInstrument = mWInstrument.getInstrument(account.getLeadAccount().getServiceType(), true)) == null ? this : mWInstrument;
    }

    public String getHistoricalSymbol() {
        if (!com.motivewave.common.h.g(this.historicalSymbol)) {
            return this.historicalSymbol;
        }
        if (this.historicalSource == null || this.historicalSource.equals(this.source)) {
            return this.getSymbol();
        }
        String string = this.getSymbolData();
        if (!com.motivewave.common.h.g(string)) {
            return string;
        }
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        if (this.historicalSource.getConnection() != null) {
            enums$ServiceType = this.historicalSource.getConnection().a().a();
        }
        return this.getSymbol(enums$ServiceType);
    }

    public String getHistoricalSymbol(Enums$ServiceType enums$ServiceType) {
        if (!com.motivewave.common.h.g(this.historicalSymbol)) {
            return this.historicalSymbol;
        }
        if (this.historicalSource == null || this.historicalSource.equals(this.source)) {
            return this.getSymbol(enums$ServiceType);
        }
        String string = this.getSymbolData();
        if (!com.motivewave.common.h.g(string) && this.getSourceType() == enums$ServiceType) {
            return string;
        }
        return this.getSymbol(enums$ServiceType);
    }

    public String getNewsSymbol() {
        if (this.newsSource == null || this.newsSource.equals(this.source)) {
            return this.getSymbol();
        }
        String string = this.getSymbolData();
        if (!com.motivewave.common.h.g(string)) {
            return string;
        }
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        if (this.newsSource.getConnection() != null) {
            enums$ServiceType = this.newsSource.getConnection().a().a();
        }
        return this.getSymbol(enums$ServiceType);
    }

    public Map getServiceMap() {
        return this.serviceMap;
    }

    public SymbolInfo findMapping(Enums$ServiceType enums$ServiceType) {
        SymbolInfo symbolInfo = (SymbolInfo)this.serviceMap.get((Object)enums$ServiceType);
        if (symbolInfo != null) {
            return symbolInfo;
        }
        if (enums$ServiceType.isIB()) {
            for (Enums$ServiceType enums$ServiceType2 : Enums$ServiceType.values()) {
                if (!enums$ServiceType2.isIB() || (symbolInfo = (SymbolInfo)this.serviceMap.get((Object)enums$ServiceType2)) == null) continue;
                return symbolInfo;
            }
            return null;
        }
        if (enums$ServiceType.isFXCM()) {
            for (Enums$ServiceType enums$ServiceType3 : Enums$ServiceType.values()) {
                if (!enums$ServiceType3.isFXCM() || (symbolInfo = (SymbolInfo)this.serviceMap.get((Object)enums$ServiceType3)) == null) continue;
                return symbolInfo;
            }
            return null;
        }
        if (enums$ServiceType.isRithmic()) {
            for (Enums$ServiceType enums$ServiceType4 : Enums$ServiceType.values()) {
                if (!enums$ServiceType4.isRithmic() || (symbolInfo = (SymbolInfo)this.serviceMap.get((Object)enums$ServiceType4)) == null) continue;
                return symbolInfo;
            }
            return null;
        }
        if (enums$ServiceType.isCQG()) {
            for (Enums$ServiceType enums$ServiceType5 : Enums$ServiceType.values()) {
                if (!enums$ServiceType5.isCQG() || (symbolInfo = (SymbolInfo)this.serviceMap.get((Object)enums$ServiceType5)) == null) continue;
                return symbolInfo;
            }
            return null;
        }
        return null;
    }

    public boolean isSourceEmpty() {
        return this.source == null;
    }

    public ConnectionID getSource() {
        if (this.source == null) {
            by by2 = bs.a();
            if (by2 == null || by2.a() == null) {
                return null;
            }
            return by2.a().getConnectionID();
        }
        return this.source;
    }

    public void setSource(ConnectionID connectionID) {
        if (this.compare(connectionID, this.source)) {
            return;
        }
        if (this.source == null) {
            this.source = connectionID;
            this.key = null;
            return;
        }
        if (connectionID != null && connectionID.getService() != this.getSourceType()) {
            this.updateKey(() -> {
                this.source = connectionID;
            });
        } else {
            this.source = connectionID;
        }
    }

    public Enums$ServiceType getSourceType() {
        if (this.source == null) {
            by by2 = bs.a(this);
            if (by2 == null) {
                return null;
            }
            return by2.a().a();
        }
        return this.source.getService();
    }

    public boolean isSymbolUnique() {
        if (this.isLocalDataOnly()) {
            return false;
        }
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        if (enums$ServiceType == null) {
            return false;
        }
        return enums$ServiceType.isSymbolUnique();
    }

    public j getRealTimeService() {
        if (this.realTimeSource != null) {
            by by2 = this.realTimeSource.getConnection();
            if (by2 == null) {
                return null;
            }
            return by2.c();
        }
        ConnectionID connectionID = this.getSource();
        if (connectionID == null) {
            return null;
        }
        by by3 = connectionID.getConnection();
        if (by3 == null) {
            return null;
        }
        return by3.c();
    }

    public ConnectionID getRealTimeSource() {
        return this.realTimeSource;
    }

    public void setRealTimeSource(ConnectionID connectionID) {
        if (this.compare(connectionID, this.getSource())) {
            connectionID = null;
        }
        this.realTimeSource = connectionID;
    }

    private boolean compare(ConnectionID connectionID, ConnectionID connectionID2) {
        if (connectionID == connectionID2) {
            return true;
        }
        if (connectionID == null || connectionID2 == null) {
            return false;
        }
        return connectionID.getPersistString().equals(connectionID2.getPersistString());
    }

    public ConnectionID getHistoricalSource() {
        return this.historicalSource;
    }

    public void setHistoricalSource(ConnectionID connectionID) {
        if (this.compare(connectionID, this.getSource())) {
            connectionID = null;
        }
        this.historicalSource = connectionID;
    }

    public j getHistoricalService() {
        if (this.historicalSource != null) {
            by by2 = this.historicalSource.getConnection();
            if (by2 == null) {
                return null;
            }
            return by2.b();
        }
        ConnectionID connectionID = this.getSource();
        if (connectionID == null) {
            return null;
        }
        by by3 = connectionID.getConnection();
        if (by3 == null) {
            return null;
        }
        return by3.b();
    }

    public ConnectionID getNewsSource() {
        return this.newsSource;
    }

    public void setNewsSource(ConnectionID connectionID) {
        if (this.compare(connectionID, this.getSource())) {
            connectionID = null;
        }
        this.newsSource = connectionID;
    }

    public String getServiceMapConfig() {
        return this.b(this.serviceMap.values());
    }

    public void setServiceMapConfig(String string) {
        if (com.motivewave.common.h.g(string)) {
            return;
        }
        if (w.a(string)) {
            try {
                JSONArray jSONArray = new JSONArray(string);
                this.serviceMap.clear();
                for (JSONObject jSONObject : jSONArray.asObjList()) {
                    SymbolInfo symbolInfo = new SymbolInfo(jSONObject);
                    this.serviceMap.put(symbolInfo.getServiceType(), symbolInfo);
                }
            }
            catch (Exception exception) {
                com.motivewave.common.h.a.warning("MWInstrument::setServiceMapConfig() " + string);
                exception.printStackTrace();
            }
            return;
        }
        try {
            Element element = h.a(string).getDocumentElement();
            if (element == null) {
                return;
            }
            for (Element element2 : h.c("map", element)) {
                try {
                    SymbolInfo symbolInfo = new SymbolInfo(Enums$ServiceType.read(element2.getAttribute("service")), null, element2.getAttribute("underlying"), element2.getAttribute("symbol"), element2.getAttribute("exchange"), element2.getAttribute("primaryExchange"), element2.getAttribute("currency"));
                    this.serviceMap.put(symbolInfo.getServiceType(), symbolInfo);
                }
                catch (Exception exception) {
                    com.motivewave.common.h.a.warning("MWInstrument::setServiceMapConfig() " + string);
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            com.motivewave.common.h.a.warning("MWInstrument::setServiceMapConfig() error reading xml: " + exception.getMessage() + " xml: " + string);
        }
    }

    public void clearAnalysisDirMap() {
        this.analysisDirMap.a();
    }

    public static void save() {
        Workspace workspace = bs.a();
        File file = new File(workspace.getConfigDir(), "instruments.csv");
        if (!unsavedChanges && file.exists()) {
            return;
        }
        unsavedChanges = false;
        MWInstrument.save(workspace, MWInstrument.getAll());
    }

    public static void save(Workspace workspace, List list) {
        try {
            PrintWriter printWriter = new PrintWriter(new File(workspace.getConfigDir(), "instruments.csv"));
            Map map = MWInstrument.createMap(list);
            a.a(printWriter, map);
            for (MWInstrument mWInstrument : list) {
                MWInstrument.toCSV(mWInstrument, map, printWriter);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        Map map = idMap;
        synchronized (map) {
            idMap.clear();
            allInstruments.b();
            symbol2InstrumentMap.clear();
            symbolDisplayMap.clear();
            symbolExchangeMap.clear();
            symbol2RelatedMap.clear();
            keyMap.clear();
            List list = MWInstrument.load(bs.a());
            MWInstrument.register(list);
            for (MWInstrument mWInstrument : list) {
                try {
                    mWInstrument.loadDefinition();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            MWInstrument.migrateExchanges(list);
            File file = new File(bs.a().getConfigDir(), "instruments.csv");
            if (!file.exists() || unsavedChanges) {
                MWInstrument.save();
            }
            unsavedChanges = false;
        }
    }

    public static void migrateExchange(MWInstrument mWInstrument) {
        Enums$ServiceType enums$ServiceType = mWInstrument.getSourceType();
        if (enums$ServiceType == null || !mWInstrument.isFuture()) {
            return;
        }
        if (!enums$ServiceType.isIB() && !enums$ServiceType.isRithmic()) {
            return;
        }
        String string = com.motivewave.common.h.b((Object)mWInstrument.getExchange()).toUpperCase();
        String string2 = com.motivewave.common.h.b((Object)mWInstrument.getBaseSymbol()).toUpperCase();
        if (com.motivewave.common.h.g(string2)) {
            string2 = com.motivewave.common.h.b((Object)mWInstrument.getUnderlying()).toUpperCase();
        }
        if (enums$ServiceType.isRithmic()) {
            if (com.motivewave.common.h.a((Object)string2, (Object)"MYM") && com.motivewave.common.h.a((Object)string, (Object)"CME")) {
                com.motivewave.common.h.a.info("MWInstrument::load() updating exchange for: " + mWInstrument.getSymbol() + " " + mWInstrument.getExchange() + " -> CBOT");
                mWInstrument.setExchange("CBOT");
                unsavedChanges = true;
            }
        } else if (enums$ServiceType.isIB()) {
            String string3;
            String string4;
            String string5 = o.a(string2, string);
            if (!com.motivewave.common.h.a((Object)string5, (Object)string)) {
                com.motivewave.common.h.a.info("MWInstrument::load() updating exchange for: " + mWInstrument.getSymbol() + " " + mWInstrument.getExchange() + " -> " + string5);
                mWInstrument.setExchange(string5);
                unsavedChanges = true;
            }
            if (!com.motivewave.common.h.g(string4 = mWInstrument.getCurrency()) && !com.motivewave.common.h.a((Object)(string3 = o.b(string2, string4 = string4.toUpperCase())), (Object)string4)) {
                com.motivewave.common.h.a.info("MWInstrument::load() updating currency for: " + mWInstrument.getSymbol() + " " + string4 + " -> " + string3);
                mWInstrument.setCurrency(string3);
                unsavedChanges = true;
            }
        }
    }

    public static void migrateExchanges(List list) {
        if (!bs.c() && !bs.n()) {
            return;
        }
        for (MWInstrument mWInstrument : list) {
            MWInstrument.migrateExchange(mWInstrument);
        }
    }

    public static List load(File file) {
        long l2 = System.currentTimeMillis();
        ArrayList<MWInstrument> arrayList = new ArrayList<MWInstrument>();
        if (!file.exists()) {
            return arrayList;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            if (string != null) {
                Map map = a.a(string);
                if (map != null) {
                    string = bufferedReader.readLine();
                }
                while (string != null) {
                    MWInstrument mWInstrument = MWInstrument.fromCSV(string, map);
                    if (mWInstrument != null) {
                        arrayList.add(mWInstrument);
                    }
                    string = bufferedReader.readLine();
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        com.motivewave.common.h.a.info("MWInstrument::load() load instruments: " + arrayList.size() + " elapsed: " + (System.currentTimeMillis() - l2));
        return arrayList;
    }

    public static List load(Workspace workspace) {
        File file = new File(workspace.getConfigDir(), "instruments.csv");
        List list = new ArrayList();
        list = MWInstrument.load(file);
        List list2 = workspace.getServiceTypes();
        if (!com.motivewave.common.h.a((Collection)list2)) {
            for (MWInstrument mWInstrument : new ArrayList(list)) {
                Enums$ServiceType enums$ServiceType = mWInstrument.getSourceType();
                if (mWInstrument.isLocalDataOnly() || enums$ServiceType == null || list2.contains((Object)enums$ServiceType)) continue;
                com.motivewave.common.h.a.warning("MWInstrument::load() removing instrument: " + mWInstrument.getKey());
                list.remove(mWInstrument);
                unsavedChanges = true;
            }
        }
        return list;
    }

    private static String clean(String string, boolean bl2) {
        if (!bl2 || com.motivewave.common.h.g(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u0100') continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static MWInstrument fromCSV(String string, Map map) {
        Date date;
        SettingsBase settingsBase;
        String string2;
        List list = a.a(string);
        if (com.motivewave.common.h.a((Collection)list)) {
            return null;
        }
        MWInstrument mWInstrument = new MWInstrument();
        mWInstrument.source = ConnectionID.get(a.a((String)list.get(43), map));
        boolean bl2 = false;
        mWInstrument.id = a.a((String)list.get(0));
        mWInstrument.underlying = MWInstrument.clean((String)list.get(1), bl2);
        mWInstrument.baseSymbol = MWInstrument.clean((String)list.get(2), bl2);
        mWInstrument.productCode = (String)list.get(3);
        mWInstrument.type = Enums$InstrumentType.fromShortCode((String)list.get(4));
        mWInstrument.symbol = MWInstrument.clean((String)list.get(5), bl2);
        mWInstrument.exchange = MWInstrument.clean(a.a((String)list.get(6), map), bl2);
        mWInstrument.primaryExchange = a.a((String)list.get(7), map);
        mWInstrument.currency = a.a((String)list.get(8), map);
        mWInstrument.symbolDisplay = MWInstrument.clean((String)list.get(9), bl2);
        mWInstrument.symbolData = MWInstrument.clean((String)list.get(10), bl2);
        mWInstrument.symbolDir = MWInstrument.clean((String)list.get(11), bl2);
        mWInstrument.historicalSymbol = MWInstrument.clean((String)list.get(12), bl2);
        mWInstrument.historicalExchange = (String)list.get(13);
        mWInstrument.serviceId = (String)list.get(14);
        mWInstrument.expiryDate = a.a((String)list.get(15));
        mWInstrument.title = MWInstrument.clean((String)list.get(16), bl2);
        mWInstrument.description = MWInstrument.clean((String)list.get(17), bl2);
        mWInstrument.sourceDescription = (String)list.get(18);
        mWInstrument.sectorId = (String)list.get(19);
        mWInstrument.industryGroupId = (String)list.get(20);
        mWInstrument.setTimeZone(a.a((String)list.get(22)));
        mWInstrument.setTradingHoursID((String)list.get(21));
        mWInstrument.setMinTick(a.a(a.a((String)list.get(23), map)));
        mWInstrument.tickOverride = a.a((String)list.get(24));
        mWInstrument.setPointSize(a.a(a.a((String)list.get(25), map)));
        mWInstrument.priceMagnifier = a.a((String)list.get(26));
        mWInstrument.plDivisor = a.a((String)list.get(27));
        mWInstrument.contractSize = a.a((String)list.get(28));
        mWInstrument.contractValue = a.a((String)list.get(29));
        mWInstrument.pointValue = a.a((String)list.get(30));
        mWInstrument.displayMultiplier = a.a((String)list.get(31));
        mWInstrument.setDisplayMask((String)list.get(32));
        mWInstrument.strikePrice = a.a((String)list.get(33));
        String string3 = (String)list.get(34);
        if (com.motivewave.common.h.a((Object)string3, (Object)"C")) {
            mWInstrument.optionType = Enums$OptionType.CALL;
        } else if (com.motivewave.common.h.a((Object)string3, (Object)"P")) {
            mWInstrument.optionType = Enums$OptionType.PUT;
        }
        mWInstrument.extendedData = a.a((String)list.get(35));
        mWInstrument.showExtendedData = a.a((String)list.get(36));
        mWInstrument.localDataOnly = a.a((String)list.get(37));
        mWInstrument.intradayData = a.a((String)list.get(38));
        mWInstrument.useDefaultCommission = a.a((String)list.get(39));
        mWInstrument.baseCost = a.a((String)list.get(40));
        mWInstrument.unitCost = a.a((String)list.get(41));
        mWInstrument.unitSize = a.a((String)list.get(42));
        mWInstrument.realTimeSource = ConnectionID.get(a.a((String)list.get(44), map));
        mWInstrument.historicalSource = ConnectionID.get(a.a((String)list.get(45), map));
        mWInstrument.newsSource = ConnectionID.get(a.a((String)list.get(46), map));
        if (!com.motivewave.common.h.g((String)list.get(47))) {
            mWInstrument.setServiceMapConfig((String)list.get(47));
        }
        if (!com.motivewave.common.h.g((String)list.get(48))) {
            mWInstrument.customDefinition = (String)list.get(48);
        }
        if (list.size() > 49) {
            mWInstrument.useContinuousData = a.a((String)list.get(49));
        }
        if (list.size() > 50) {
            mWInstrument.flagId = a.a((String)list.get(50), map);
        }
        if (list.size() > 51 && !com.motivewave.common.h.g(string2 = a.a((String)list.get(51), map))) {
            settingsBase = new RollSettings();
            mWInstrument.rollSettings = settingsBase;
            try {
                settingsBase.setRollMethod(Enums$RollMethod.valueOf(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list.size() > 52 && !com.motivewave.common.h.g(string2 = a.a((String)list.get(52), map))) {
                try {
                    settingsBase.setAdjustMethod(Enums$BackAdjustMethod.valueOf(string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (list.size() > 58) {
                settingsBase.setDays(a.a((String)list.get(58)));
            }
            if (list.size() > 60) {
                settingsBase.setBusinessDays(a.a((String)list.get(60)));
            }
            if (list.size() > 61) {
                settingsBase.setDOM(a.a((String)list.get(61)));
            }
            if (list.size() > 62 && !com.motivewave.common.h.g(string2 = a.a((String)list.get(62), map))) {
                try {
                    settingsBase.setDOW(Enums$DayOfWeek.valueOf(string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (list.size() > 63 && !com.motivewave.common.h.g(string2 = a.a((String)list.get(63), map))) {
                try {
                    settingsBase.setWOM(Enums$RollWeekOfMonth.valueOf(string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (list.size() > 53) {
            mWInstrument.backFillEnabled = a.a((String)list.get(53));
        }
        if (list.size() > 54) {
            mWInstrument.resolved = a.a((String)list.get(54));
        }
        if (list.size() > 55) {
            mWInstrument.commonSymbol = (String)list.get(55);
            if (com.motivewave.common.h.g(mWInstrument.commonSymbol)) {
                mWInstrument.commonSymbol = null;
            }
        }
        if (list.size() > 56) {
            mWInstrument.altCommonSymbol = (String)list.get(56);
            if (com.motivewave.common.h.g(mWInstrument.altCommonSymbol)) {
                mWInstrument.altCommonSymbol = null;
            }
        }
        if (list.size() > 57) {
            mWInstrument.useContinuousIntraday = a.a((String)list.get(57));
        }
        if (list.size() > 59) {
            mWInstrument.contractNumber = a.a((String)list.get(59));
        }
        if (list.size() > 64) {
            boolean bl3 = false;
            settingsBase = new BarBuildSettings();
            String string4 = (String)list.get(64);
            if (!com.motivewave.common.h.g(string4)) {
                bl3 = true;
                settingsBase.set("tz", (Object)TimeZone.getTimeZone(string4));
            }
            if (list.size() > 65 && !com.motivewave.common.h.g(string4 = (String)list.get(65))) {
                bl3 = true;
                settingsBase.set("method", (Object)Enums$BarSizeMethod.valueOf(string4));
            }
            if (list.size() > 66 && (!com.motivewave.common.h.g(string4 = (String)list.get(66)) || bl3)) {
                bl3 = true;
                settingsBase.set("startTime", (Object)a.a(string4));
            }
            if (com.motivewave.common.h.a((Object)settingsBase, (Object)b.a().getBarBuildSettings())) {
                settingsBase = null;
            }
            Object object = mWInstrument.barBuildSettings = bl3 ? settingsBase : null;
            if (settingsBase != null) {
                settingsBase.onUpdated();
            }
        }
        if (list.size() > 67) {
            mWInstrument.notes = (String)list.get(67);
        }
        if (list.size() > 68) {
            mWInstrument.minuteDailyBars = a.a((String)list.get(68));
        }
        if (mWInstrument.isFuture() && mWInstrument.expiryDate != null && System.currentTimeMillis() - mWInstrument.expiryDate.getTime() > 252460800000L && SymbolUtil.c(mWInstrument.symbol) && (date = SymbolUtil.a(mWInstrument.underlying, mWInstrument.symbol, mWInstrument.getSourceType())) != null) {
            com.motivewave.common.h.a.warning("MWInstrument::fromCSV() migrating expired symbol: " + mWInstrument.symbol + " " + com.motivewave.common.h.a(mWInstrument.expiryDate) + " -> " + com.motivewave.common.h.a(date));
            mWInstrument.expiryDate = date;
        }
        return mWInstrument;
    }

    public static void toCSV(MWInstrument mWInstrument, Map map, PrintWriter printWriter) {
        String string = null;
        if (mWInstrument.optionType == Enums$OptionType.CALL) {
            string = "C";
        } else if (mWInstrument.optionType == Enums$OptionType.PUT) {
            string = "P";
        }
        String string2 = mWInstrument.title;
        String string3 = mWInstrument.description;
        String string4 = mWInstrument.sourceDescription;
        if (com.motivewave.common.h.a((Object)string4, (Object)string2) || !com.motivewave.common.h.g(string3)) {
            string4 = null;
        }
        if (com.motivewave.common.h.a((Object)string3, (Object)mWInstrument.title)) {
            string3 = null;
        } else if (com.motivewave.common.h.a((Object)string3, (Object)string4)) {
            string3 = null;
        }
        String string5 = mWInstrument.underlying;
        if (mWInstrument.isStock() || mWInstrument.isCash()) {
            string5 = null;
        }
        RollSettings rollSettings = mWInstrument.rollSettings;
        BarBuildSettings barBuildSettings = mWInstrument.barBuildSettings;
        a.a(printWriter, new Object[]{mWInstrument.id > 0 ? Integer.valueOf(mWInstrument.id) : null, string5, mWInstrument.baseSymbol, mWInstrument.productCode, mWInstrument.type == null ? "" : mWInstrument.type.getShortCode(), mWInstrument.symbol, a.a(mWInstrument.exchange, map), a.a(mWInstrument.primaryExchange, map), a.a(mWInstrument.currency, map), mWInstrument.symbolDisplay, mWInstrument.symbolData, mWInstrument.symbolDir, mWInstrument.historicalSymbol, mWInstrument.historicalExchange, mWInstrument.serviceId, mWInstrument.expiryDate, string2, string3, string4, mWInstrument.sectorId, mWInstrument.industryGroupId, mWInstrument.tradingHoursID, mWInstrument.timeZone, a.a(a.a(mWInstrument.minTick), map), mWInstrument.tickOverride, a.a(a.a(mWInstrument.pointSize), map), mWInstrument.priceMagnifier, mWInstrument.plDivisor, mWInstrument.contractSize, mWInstrument.contractValue, mWInstrument.pointValue, mWInstrument.displayMultiplier, mWInstrument.displayMask, mWInstrument.strikePrice, string, mWInstrument.extendedData, mWInstrument.showExtendedData, mWInstrument.localDataOnly, mWInstrument.intradayData, mWInstrument.useDefaultCommission, mWInstrument.baseCost, mWInstrument.unitCost, mWInstrument.unitSize, a.a(mWInstrument.source == null ? "" : mWInstrument.source.getPersistString(), map), a.a(mWInstrument.realTimeSource == null ? "" : mWInstrument.realTimeSource.getPersistString(), map), a.a(mWInstrument.historicalSource == null ? "" : mWInstrument.historicalSource.getPersistString(), map), a.a(mWInstrument.newsSource == null ? "" : mWInstrument.newsSource.getPersistString(), map), mWInstrument.getServiceMap() == null ? "" : mWInstrument.getServiceMapConfig(), mWInstrument.isCustom() ? mWInstrument.getCustomDefinition() : "", mWInstrument.useContinuousData, mWInstrument.flagId, rollSettings == null ? null : rollSettings.getRollMethod(), rollSettings == null ? null : rollSettings.getAdjustMethod(), mWInstrument.backFillEnabled, mWInstrument.resolved, cj.h.a() ? mWInstrument.commonSymbol : "", cj.h.a() ? mWInstrument.altCommonSymbol : "", mWInstrument.useContinuousIntraday, rollSettings == null ? null : Integer.valueOf(rollSettings.getDays()), mWInstrument.contractNumber, rollSettings == null ? null : Boolean.valueOf(rollSettings.isBusinessDays()), rollSettings == null ? null : Integer.valueOf(rollSettings.getDOM()), rollSettings == null ? null : rollSettings.getDOW(), rollSettings == null ? null : rollSettings.getWOM(), barBuildSettings == null ? null : barBuildSettings.getTz(), barBuildSettings == null ? null : barBuildSettings.getMethod(), barBuildSettings == null ? null : Integer.valueOf(barBuildSettings.getStartTime()), mWInstrument.notes, mWInstrument.minuteDailyBars});
    }

    private static Map createMap(List list) {
        HashMap hashMap = new HashMap();
        int n2 = 1;
        for (MWInstrument mWInstrument : list) {
            n2 = a.a(mWInstrument.exchange, hashMap, n2);
            n2 = a.a(mWInstrument.primaryExchange, hashMap, n2);
            n2 = a.a(mWInstrument.currency, hashMap, n2);
            n2 = a.a(mWInstrument.source == null ? "" : mWInstrument.source.getPersistString(), hashMap, n2);
            n2 = a.a(mWInstrument.realTimeSource == null ? "" : mWInstrument.realTimeSource.getPersistString(), hashMap, n2);
            n2 = a.a(mWInstrument.historicalSource == null ? "" : mWInstrument.historicalSource.getPersistString(), hashMap, n2);
            n2 = a.a(mWInstrument.newsSource == null ? "" : mWInstrument.newsSource.getPersistString(), hashMap, n2);
            n2 = a.a(a.a(mWInstrument.minTick), hashMap, n2);
            n2 = a.a(a.a(mWInstrument.pointSize), hashMap, n2);
            n2 = a.a(mWInstrument.flagId, hashMap, n2);
        }
        return hashMap;
    }

    public static String convertKey(String string) {
        if (string.indexOf(46) < 0) {
            return string;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        Enums$ServiceType enums$ServiceType = null;
        try {
            enums$ServiceType = Enums$ServiceType.valueOf(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (enums$ServiceType == null) {
            return string;
        }
        if (!enums$ServiceType.isSymbolUnique()) {
            return string;
        }
        String string3 = string.substring(0, string.indexOf(46));
        return string3 + "." + enums$ServiceType.getName();
    }

    public static MWInstrument get(Instrument instrument) {
        if (instrument == null) {
            return null;
        }
        try {
            return ((LiveTicker)instrument).getInstrument();
        }
        catch (Exception exception) {
            return MWInstrument.get(instrument.getSymbol(), instrument.getExchangeSymbol());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(int n2) {
        Map map = idMap;
        synchronized (map) {
            return (MWInstrument)idMap.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearServiceMap() {
        Map map = idMap;
        synchronized (map) {
            symbol2RelatedMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(String string, Enums$ServiceType enums$ServiceType) {
        MWInstrument mWInstrument2;
        Iterator iterator;
        Object object;
        Object object2;
        if (enums$ServiceType == null) {
            return MWInstrument.bySymbol(string);
        }
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        if (enums$ServiceType == bs.a() && (object2 = MWInstrument.bySymbol(string)) != null && ((MWInstrument)object2).getSourceType() == enums$ServiceType) {
            return object2;
        }
        string = string.trim().toUpperCase();
        object2 = null;
        ArrayList arrayList = null;
        Object object3 = idMap;
        synchronized (object3) {
            object2 = (List)symbol2InstrumentMap.get(string);
            object = MWInstrument.findMatch((List)object2, enums$ServiceType);
            if (object != null) {
                return object;
            }
            arrayList = (ArrayList)symbolDisplayMap.get(string);
            if (arrayList != null) {
                arrayList = new ArrayList(arrayList);
            }
        }
        object3 = MWInstrument.findMatch(arrayList, enums$ServiceType);
        if (object3 != null) {
            return object3;
        }
        object = MWInstrument.getRelated(string);
        object3 = MWInstrument.findMatch((List)object, enums$ServiceType);
        if (object3 != null) {
            return object3;
        }
        if (!com.motivewave.common.h.a((Collection)object2)) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                mWInstrument2 = (MWInstrument)iterator.next();
                if (mWInstrument2 == null || mWInstrument2.getSourceType() != enums$ServiceType) continue;
                return mWInstrument2;
            }
        }
        if (!com.motivewave.common.h.a(arrayList)) {
            for (MWInstrument mWInstrument2 : arrayList) {
                if (mWInstrument2 == null || mWInstrument2.getSourceType() != enums$ServiceType) continue;
                return mWInstrument2;
            }
        }
        if (!com.motivewave.common.h.a((Collection)object)) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                mWInstrument2 = (MWInstrument)iterator.next();
                if (mWInstrument2 == null || mWInstrument2.getSourceType() != enums$ServiceType) continue;
                return mWInstrument2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument getStrict(String string, Enums$ServiceType enums$ServiceType) {
        if (enums$ServiceType == null) {
            return MWInstrument.bySymbol(string);
        }
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        string = string.trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            MWInstrument mWInstrument = MWInstrument.findMatch((List)symbol2InstrumentMap.get(string), enums$ServiceType);
            if (mWInstrument != null) {
                return mWInstrument;
            }
            mWInstrument = MWInstrument.findMatch((List)symbolDisplayMap.get(string), enums$ServiceType);
            if (mWInstrument != null) {
                return mWInstrument;
            }
        }
        return MWInstrument.findMatch(MWInstrument.getRelated(string), enums$ServiceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRelated(String string) {
        if (com.motivewave.common.h.g(string)) {
            return new ArrayList();
        }
        String string2 = string.trim().toUpperCase();
        ArrayList<Object> arrayList = null;
        Map map = idMap;
        synchronized (map) {
            arrayList = (ArrayList<Object>)symbol2RelatedMap.get(string2);
            if (arrayList != null) {
                return arrayList;
            }
            arrayList = new ArrayList<Object>();
            MWInstrument mWInstrument = MWInstrument.bySymbol(string);
            if (mWInstrument != null) {
                arrayList.add(mWInstrument);
                for (PropertyBean propertyBean : mWInstrument.getServiceMap().values()) {
                    MWInstrument mWInstrument2 = MWInstrument.bySymbol(((SymbolInfo)propertyBean).getSymbol());
                    if (mWInstrument2 == null || arrayList.contains(mWInstrument2)) continue;
                    arrayList.add(mWInstrument2);
                }
            }
            for (PropertyBean propertyBean : MWInstrument.getAll()) {
                if (arrayList.contains(propertyBean)) continue;
                for (SymbolInfo symbolInfo : ((MWInstrument)propertyBean).getServiceMap().values()) {
                    if (!com.motivewave.common.h.b((Object)symbolInfo.getSymbol(), (Object)string)) continue;
                    arrayList.add(propertyBean);
                }
            }
            symbol2RelatedMap.put(string, arrayList);
        }
        return arrayList;
    }

    public static boolean isRelated(MWInstrument mWInstrument, MWInstrument mWInstrument2) {
        if (mWInstrument == mWInstrument2) {
            return true;
        }
        if (mWInstrument2 == null || mWInstrument == null) {
            return false;
        }
        String string = mWInstrument2.getKey();
        if (com.motivewave.common.h.a((Object)string, (Object)mWInstrument.getKey())) {
            return true;
        }
        for (MWInstrument mWInstrument3 : MWInstrument.getRelated(mWInstrument.getSymbol())) {
            if (!com.motivewave.common.h.a((Object)mWInstrument3.getKey(), (Object)string)) continue;
            return true;
        }
        if (mWInstrument2.getSourceType() != mWInstrument.getSourceType()) {
            Object object = SymbolUtil.a(mWInstrument2, mWInstrument2.getSourceType(), mWInstrument.getSourceType());
            if (com.motivewave.common.h.a(object, (Object)mWInstrument.getSymbol())) {
                return true;
            }
            object = SymbolUtil.a(mWInstrument, mWInstrument.getSourceType(), mWInstrument2.getSourceType());
            if (com.motivewave.common.h.a(object, (Object)mWInstrument2.getSymbol())) {
                return true;
            }
        }
        if (mWInstrument.isCustomContinuous() || mWInstrument2.isCustomContinuous()) {
            mWInstrument = mWInstrument.isCustomContinuous() ? mWInstrument.getActiveContract() : mWInstrument;
            mWInstrument2 = mWInstrument2.isCustomContinuous() ? mWInstrument2.getActiveContract() : mWInstrument2;
            return MWInstrument.isRelated(mWInstrument, mWInstrument2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument bySymbol(String string) {
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        string = string.trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            List list = (ArrayList)symbol2InstrumentMap.get(string);
            if (!com.motivewave.common.h.a((Collection)list)) {
                return (MWInstrument)list.get(0);
            }
            list = (List)symbolDisplayMap.get(string);
            if (com.motivewave.common.h.a((Collection)list)) {
                return null;
            }
            list = new ArrayList(list);
            return (MWInstrument)list.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument byKey(String string) {
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        Map map = idMap;
        synchronized (map) {
            MWInstrument mWInstrument = (MWInstrument)keyMap.get(string);
            if (mWInstrument != null) {
                return mWInstrument;
            }
            return (MWInstrument)keyMap.get(MWInstrument.convertKey(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument byCommonSymbol(String string) {
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        Map map = idMap;
        synchronized (map) {
            return (MWInstrument)commonMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MWInstrument byOldKey(String string) {
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        Map map = idMap;
        synchronized (map) {
            MWInstrument mWInstrument = (MWInstrument)oldKeyMap.get(string);
            if (mWInstrument != null) {
                return mWInstrument;
            }
            return (MWInstrument)oldKeyMap.get(MWInstrument.convertKey(string));
        }
    }

    public static MWInstrument resolveFromKey(String object) {
        MWInstrument mWInstrument = MWInstrument.byKey((String)object);
        if (mWInstrument == null && ((String)object).endsWith(".RITHMIC_GATEWAY")) {
            object = ((String)object).substring(0, ((String)object).lastIndexOf(46)) + ".RITHMIC";
            mWInstrument = MWInstrument.byKey((String)object);
        }
        if (mWInstrument != null) {
            return mWInstrument;
        }
        mWInstrument = MWInstrument.byOldKey((String)object);
        if (mWInstrument != null) {
            return mWInstrument;
        }
        if (((String)object).endsWith(".CMN")) {
            return MWInstrument.byCommonSymbol(((String)object).substring(0, ((String)object).lastIndexOf(46)));
        }
        List list = com.motivewave.common.h.a((String)object, '.');
        if (com.motivewave.common.h.a((Collection)list)) {
            return null;
        }
        if (list.size() == 1) {
            return MWInstrument.bySymbol(MWInstrument.fixSymbol((String)list.get(0)));
        }
        Enums$ServiceType enums$ServiceType = null;
        try {
            enums$ServiceType = Enums$ServiceType.valueOf((String)list.get(list.size() - 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (list.size() >= 3) {
            mWInstrument = MWInstrument.get(MWInstrument.fixSymbol((String)list.get(0)), (String)list.get(1), enums$ServiceType);
        }
        if (mWInstrument != null) {
            return mWInstrument;
        }
        mWInstrument = MWInstrument.get(MWInstrument.fixSymbol((String)list.get(0)), enums$ServiceType);
        if (mWInstrument != null) {
            return mWInstrument;
        }
        return MWInstrument.bySymbol(MWInstrument.fixSymbol((String)list.get(0)));
    }

    private static String fixSymbol(String string) {
        return com.motivewave.common.h.a(string, "_", ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MWInstrument _getByKey(String string) {
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        Map map = idMap;
        synchronized (map) {
            return (MWInstrument)keyMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAll(String string) {
        if (com.motivewave.common.h.g(string)) {
            return Collections.EMPTY_LIST;
        }
        string = string.trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            List list = (ArrayList)symbol2InstrumentMap.get(string);
            if (!com.motivewave.common.h.a((Collection)list)) {
                return list;
            }
            list = (List)symbolDisplayMap.get(string);
            if (com.motivewave.common.h.a((Collection)list)) {
                return Collections.EMPTY_LIST;
            }
            list = new ArrayList(list);
            return list;
        }
    }

    public static MWInstrument get(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        return MWInstrument.get(jSONObject.str("symbol"), jSONObject.str("exchange"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(String string, String string2) {
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        if (com.motivewave.common.h.g(string2)) {
            return MWInstrument.bySymbol(string);
        }
        string = string.trim().toUpperCase();
        string2 = string2.trim().toUpperCase();
        String string3 = string + ":" + string2;
        Map map = idMap;
        synchronized (map) {
            List list = (List)symbolExchangeMap.get(string3);
            if (com.motivewave.common.h.a((Collection)list)) {
                List list2 = MWInstrument.getAll(string);
                if (com.motivewave.common.h.a((Collection)list2)) {
                    return null;
                }
                for (MWInstrument mWInstrument : list2) {
                    if (!com.motivewave.common.h.b((Object)mWInstrument.getExchange(), (Object)string2)) continue;
                    return mWInstrument;
                }
                for (MWInstrument mWInstrument : list2) {
                    if (!com.motivewave.common.h.b((Object)mWInstrument.getPrimaryExchange(), (Object)string2)) continue;
                    return mWInstrument;
                }
                return (MWInstrument)list2.get(0);
            }
            return (MWInstrument)list.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(String string, String string2, String string3) {
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        if (com.motivewave.common.h.g(string2)) {
            return MWInstrument.bySymbol(string);
        }
        if (com.motivewave.common.h.g(string3)) {
            return MWInstrument.get(string, string2);
        }
        string = string.trim().toUpperCase();
        string2 = string2.trim().toUpperCase();
        string3 = string3.trim().toUpperCase();
        String string4 = string + ":" + string2;
        Map map = idMap;
        synchronized (map) {
            List list = (List)symbolExchangeMap.get(string4);
            if (list == null) {
                return null;
            }
            for (MWInstrument mWInstrument : list) {
                if (!com.motivewave.common.h.b((Object)mWInstrument.getCurrency(), (Object)string3)) continue;
                return mWInstrument;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(Enums$ServiceType enums$ServiceType, String string) {
        Map map = idMap;
        synchronized (map) {
            return (MWInstrument)serviceIdMap.get(String.valueOf((Object)enums$ServiceType) + ":" + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(String string, String string2, Enums$ServiceType enums$ServiceType) {
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        if (com.motivewave.common.h.g(string2) || enums$ServiceType != null && enums$ServiceType.isSymbolUnique()) {
            return MWInstrument.get(string, enums$ServiceType);
        }
        string = string.trim().toUpperCase();
        string2 = string2.trim().toUpperCase();
        String string3 = string + ":" + string2;
        Map map = idMap;
        synchronized (map) {
            return MWInstrument.findMatch((List)symbolExchangeMap.get(string3), enums$ServiceType);
        }
    }

    private static MWInstrument findMatch(List list, Enums$ServiceType enums$ServiceType) {
        if (com.motivewave.common.h.a((Collection)list)) {
            return null;
        }
        if (enums$ServiceType == null) {
            return (MWInstrument)list.get(0);
        }
        for (MWInstrument mWInstrument : list) {
            if (enums$ServiceType != mWInstrument.getSourceType()) continue;
            return mWInstrument;
        }
        for (MWInstrument mWInstrument : list) {
            if (!enums$ServiceType.isCompatible(mWInstrument.getSourceType())) continue;
            return mWInstrument;
        }
        for (MWInstrument mWInstrument : list) {
            if (mWInstrument.getSourceType() != null) continue;
            return mWInstrument;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMultiple(String string) {
        if (com.motivewave.common.h.g(string)) {
            return false;
        }
        string = string.trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            List list = (List)symbol2InstrumentMap.get(string);
            if (com.motivewave.common.h.a((Collection)list)) {
                list = (List)symbolDisplayMap.get(string);
            }
            if (list == null) {
                return false;
            }
            return list.size() != 1;
            {
            }
        }
    }

    public static String getSymbolFromDir(String string) {
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        if (string.indexOf(46) < 0) {
            return MWInstrument.fixSymbol(string);
        }
        return MWInstrument.fixSymbol(string.substring(0, string.indexOf(46)));
    }

    public static String getExchangeFromDir(String string) {
        if (com.motivewave.common.h.g(string) || string.indexOf(46) < 0) {
            return null;
        }
        String string2 = string.substring(string.indexOf(46) + 1);
        if (string2.indexOf(46) >= 0) {
            string2 = string2.substring(0, string2.indexOf(46));
        }
        for (Enums$ServiceType enums$ServiceType : Enums$ServiceType.values()) {
            if (!com.motivewave.common.h.b((Object)enums$ServiceType.getName(), (Object)string2)) continue;
            return null;
        }
        return string2;
    }

    public static Enums$ServiceType getServiceFromDir(String string) {
        if (com.motivewave.common.h.g(string) || string.indexOf(46) < 0) {
            return null;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        for (Enums$ServiceType enums$ServiceType : Enums$ServiceType.values()) {
            if (!com.motivewave.common.h.b((Object)enums$ServiceType.getName(), (Object)string2)) continue;
            return enums$ServiceType;
        }
        return null;
    }

    public static MWInstrument resolveFromDirName(String string) {
        Object object;
        MWInstrument mWInstrument = MWInstrument.byKey(string);
        if (mWInstrument != null) {
            return mWInstrument;
        }
        mWInstrument = MWInstrument.bySymbol(string);
        if (mWInstrument != null) {
            return mWInstrument;
        }
        mWInstrument = MWInstrument.byOldKey(string);
        if (mWInstrument != null) {
            return mWInstrument;
        }
        Enums$ServiceType enums$ServiceType = null;
        if (string.indexOf(46) > 0) {
            object = string;
            String string2 = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
            for (Object object2 : Enums$ServiceType.values()) {
                if (!com.motivewave.common.h.b((Object)object2.getName(), (Object)string2)) continue;
                enums$ServiceType = object2;
                break;
            }
            if (enums$ServiceType != null) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf(46));
            }
            if (((String)object).indexOf(46) > 0) {
                String string3 = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
                String string4 = MWInstrument.fixSymbol(((String)object).substring(0, ((String)object).indexOf(46)));
                mWInstrument = MWInstrument.get(string4, string3, enums$ServiceType);
                if (mWInstrument != null) {
                    return mWInstrument;
                }
                String string5 = ((String)object).substring(((String)object).indexOf(46) + 1);
                string4 = MWInstrument.fixSymbol(((String)object).substring(0, ((String)object).indexOf(46)));
                mWInstrument = MWInstrument.get(string4, string5, enums$ServiceType);
                if (mWInstrument != null && mWInstrument.getSourceType() == enums$ServiceType) {
                    return mWInstrument;
                }
                List list = (List)symbolAlpha2Map.get(com.motivewave.common.h.o(string4));
                if (list != null) {
                    for (MWInstrument mWInstrument2 : list) {
                        if (!com.motivewave.common.h.b((Object)com.motivewave.common.h.o(mWInstrument2.getExchange()), (Object)string5)) continue;
                        return mWInstrument2;
                    }
                }
                if (enums$ServiceType != null) {
                    mWInstrument = MWInstrument.byOldKey(string4 + "." + string5 + "." + enums$ServiceType.getName());
                    if (mWInstrument == null) {
                        mWInstrument = MWInstrument.byOldKey(string4 + "." + enums$ServiceType.getName());
                    }
                    if (mWInstrument != null) {
                        return mWInstrument;
                    }
                }
            } else {
                String string6 = MWInstrument.fixSymbol((String)object);
                mWInstrument = MWInstrument.get(string6, enums$ServiceType);
                if (mWInstrument != null) {
                    return mWInstrument;
                }
                if (enums$ServiceType != null && (mWInstrument = MWInstrument.byOldKey(string6 + "." + enums$ServiceType.getName())) != null) {
                    return mWInstrument;
                }
            }
        }
        if ((object = (List)symbolAlpha2Map.get(com.motivewave.common.h.o(string))) != null) {
            return (MWInstrument)object.get(0);
        }
        return (MWInstrument)symbolFXMap.get(SymbolUtil.b(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument resolveExpiredContract(MWInstrument mWInstrument) {
        long l2 = System.currentTimeMillis();
        try {
            if (mWInstrument == null || !mWInstrument.isFuture() || !mWInstrument.isExpiredStrict()) {
                MWInstrument mWInstrument2 = mWInstrument;
                return mWInstrument2;
            }
            MWInstrument mWInstrument3 = MWInstrument.findNearestContract(mWInstrument.getUnderlying());
            if (mWInstrument3 != null) {
                MWInstrument mWInstrument4 = mWInstrument3;
                return mWInstrument4;
            }
            MWInstrument mWInstrument5 = mWInstrument;
            return mWInstrument5;
        }
        finally {
            long l3 = System.currentTimeMillis() - l2;
            if (l3 > 1000L) {
                System.err.println("MWInstrument::resolveExpiredContract() " + String.valueOf(mWInstrument) + " elapsed: " + l3);
            }
        }
    }

    public static MWInstrument findNearestContract(String string) {
        if (com.motivewave.common.h.g(string)) {
            return null;
        }
        string = string.trim().toUpperCase();
        MWInstrument mWInstrument = null;
        for (MWInstrument mWInstrument2 : MWInstrument.getAll()) {
            if (!mWInstrument2.isFuture() || !com.motivewave.common.h.b((Object)string, (Object)mWInstrument2.getUnderlying()) || mWInstrument2.getExpiryDate() == null || mWInstrument2.getExpiryDate().getTime() < System.currentTimeMillis()) continue;
            if (mWInstrument == null) {
                mWInstrument = mWInstrument2;
                continue;
            }
            if (mWInstrument2.getExpiryDate().getTime() >= mWInstrument.getExpiryDate().getTime()) continue;
            mWInstrument = mWInstrument2;
        }
        return mWInstrument;
    }

    public static MWInstrument create(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return null;
        }
        MWInstrument mWInstrument2 = MWInstrument._getByKey(mWInstrument.getKey());
        at.f f2 = mWInstrument.savedPreset;
        mWInstrument.savedPreset = null;
        if (f2 != null) {
            Object object;
            if (mWInstrument2 != null) {
                mWInstrument = mWInstrument2;
            }
            if ((object = d.a(mWInstrument)) == null || ((OrderPreset)object).getInstrument() == null) {
                object = new OrderPreset(mWInstrument);
                ((OrderPreset)object).setQuantity(f2.a());
                ((OrderPreset)object).setMinQuantity(f2.b());
                ((OrderPreset)object).setQuantityInc(f2.c());
                d.a((OrderPreset)object);
            }
        }
        if (mWInstrument2 != null) {
            return mWInstrument2;
        }
        MWInstrument.register(mWInstrument);
        for (InstrumentListener instrumentListener : mWInstrument.instrListeners.a()) {
            instrumentListener.created(mWInstrument);
        }
        unsavedChanges = true;
        return mWInstrument;
    }

    /*
     * WARNING - void declaration
     */
    public static List createOrReplace(List list) {
        ArrayList<void> arrayList = new ArrayList<void>();
        ArrayList<MWInstrument> arrayList2 = new ArrayList<MWInstrument>();
        for (MWInstrument mWInstrument : list) {
            void object;
            MWInstrument mWInstrument2 = MWInstrument._getByKey(mWInstrument.getKey());
            if (mWInstrument2 != null) {
                mWInstrument2.setBaseSymbol(mWInstrument.getBaseSymbol());
                mWInstrument2.setProductCode(mWInstrument.getProductCode());
                mWInstrument2.setType(mWInstrument.getType());
                mWInstrument2.setCurrency(mWInstrument.getCurrency());
                mWInstrument2.setSymbolDisplay(mWInstrument.getSymbolDisplay());
                mWInstrument2.setSymbolData(mWInstrument.getSymbolData());
                mWInstrument2.setSymbolDir(mWInstrument.getSymbolDir());
                mWInstrument2.setHistoricalSymbol(mWInstrument.getHistoricalSymbol());
                mWInstrument2.setHistoricalExchange(mWInstrument.getHistoricalExchange());
                mWInstrument2.setServiceId(mWInstrument.getServiceId());
                mWInstrument2.setExpiryDate(mWInstrument.getExpiryDate());
                mWInstrument2.setTitle(mWInstrument.getTitle());
                mWInstrument2.setDescription(mWInstrument.getDescription());
                mWInstrument2.setSourceDescription(mWInstrument.getSourceDescription());
                mWInstrument2.setSectorId(mWInstrument.getSectorId());
                mWInstrument2.setIndustryGroupId(mWInstrument.getIndustryGroupId());
                mWInstrument2.setTradingHoursID(mWInstrument.getTradingHoursID());
                mWInstrument2.setTimeZone(mWInstrument.getTimeZone());
                mWInstrument2.setMinTick(mWInstrument.getMinTick());
                mWInstrument2.setTickOverride(mWInstrument.isTickOverride());
                mWInstrument2.setPointSize(mWInstrument.getPointSize());
                mWInstrument2.setPriceMagnifier(mWInstrument.getPriceMagnifier());
                mWInstrument2.setPLDivisor(mWInstrument.getPLDivisor());
                mWInstrument2.setContractSize(mWInstrument.getContractSize());
                mWInstrument2.setContractValue(mWInstrument.getContractValue());
                mWInstrument2.setPointValue(mWInstrument.getPointValue());
                mWInstrument2.setDisplayMultiplier(mWInstrument.getDisplayMultiplier());
                mWInstrument2.setDisplayMask(mWInstrument.getDisplayMask());
                mWInstrument2.setStrikePrice(mWInstrument.getStrikePrice());
                mWInstrument2.setOptionType(mWInstrument.getOptionType());
                mWInstrument2.showExtendedData = mWInstrument.showExtendedData;
                mWInstrument2.backFillEnabled = mWInstrument.backFillEnabled;
                mWInstrument2.setSupportsExtendedData(mWInstrument.supportsExtendedData());
                mWInstrument2.setLocalDataOnly(mWInstrument.isLocalDataOnly());
                mWInstrument2.setUseDefaultCommission(mWInstrument.isUseDefaultCommission());
                mWInstrument2.setBaseCost(mWInstrument.getBaseCost());
                mWInstrument2.setUnitCost(mWInstrument.getUnitCost());
                mWInstrument2.setUnitSize(mWInstrument.getUnitSize());
                mWInstrument2.minuteDailyBars = mWInstrument.minuteDailyBars;
                mWInstrument2.source = mWInstrument.source;
                mWInstrument2.realTimeSource = mWInstrument.realTimeSource;
                mWInstrument2.historicalSource = mWInstrument.historicalSource;
                mWInstrument2.newsSource = mWInstrument.newsSource;
                mWInstrument2.serviceMap = mWInstrument.serviceMap;
                mWInstrument2.customDefinition = mWInstrument.customDefinition;
                mWInstrument2.rollSettings = mWInstrument.rollSettings;
                mWInstrument2.barBuildSettings = mWInstrument.barBuildSettings;
                mWInstrument2.setFlagId(mWInstrument.getFlagId());
                mWInstrument2.setNotes(mWInstrument.getNotes());
                MWInstrument mWInstrument3 = mWInstrument2;
            } else {
                arrayList2.add(mWInstrument);
            }
            arrayList.add(object);
        }
        MWInstrument.register(arrayList2);
        for (MWInstrument mWInstrument : arrayList2) {
            for (InstrumentListener instrumentListener : mWInstrument.instrListeners.a()) {
                instrumentListener.created(mWInstrument);
            }
        }
        unsavedChanges = true;
        return arrayList;
    }

    public static MWInstrument createAndRegister(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return null;
        }
        MWInstrument mWInstrument2 = MWInstrument._getByKey(mWInstrument.getKey());
        if (mWInstrument2 != null) {
            return mWInstrument2;
        }
        MWInstrument.register(mWInstrument);
        unsavedChanges = true;
        return mWInstrument;
    }

    public static void update(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return;
        }
        if (!MWInstrument.exists(mWInstrument)) {
            MWInstrument.register(mWInstrument);
        }
        for (InstrumentListener instrumentListener : mWInstrument.instrListeners.a()) {
            instrumentListener.updated(mWInstrument);
        }
        unsavedChanges = true;
    }

    public static List getAll() {
        return allInstruments.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return;
        }
        String string = mWInstrument.getSymbol().trim().toUpperCase();
        String string2 = mWInstrument.getSymbolDisplay().trim().toUpperCase();
        String string3 = com.motivewave.common.h.b((Object)mWInstrument.getExchange()).trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            Object object;
            if (mWInstrument.id >= 0) {
                idMap.remove(mWInstrument.id);
            }
            keyMap.remove(mWInstrument.getKey());
            allInstruments.b((Object)mWInstrument);
            symbol2InstrumentMap.remove(string);
            symbolDisplayMap.remove(mWInstrument.getSymbolDisplay().trim().toUpperCase());
            symbolExchangeMap.remove(string + ":" + string3);
            symbolExchangeMap.remove(string2 + ":" + string3);
            if (!com.motivewave.common.h.g(mWInstrument.getServiceId())) {
                serviceIdMap.remove(String.valueOf((Object)mWInstrument.getSourceType()) + ":" + mWInstrument.getServiceId(), mWInstrument);
            }
            if ((object = (List)symbol2RelatedMap.get(string)) != null) {
                object.remove(mWInstrument);
            }
        }
        for (Object object : mWInstrument.instrListeners.a()) {
            object.deleted(mWInstrument);
        }
        unsavedChanges = true;
    }

    public static void populate(List list) {
        for (e e2 : list) {
            ConnectionID connectionID = e2.a();
            MWInstrument mWInstrument = new MWInstrument(e2.b(), e2.a(), e2.e(), e2.f(), connectionID);
            mWInstrument.setUnderlying(e2.a());
            mWInstrument.setDescription(e2.d());
            mWInstrument.setMinTick(e2.a());
            mWInstrument.setPointSize(e2.c());
            mWInstrument.setPriceMagnifier(e2.d());
            mWInstrument.setPLDivisor(e2.e());
            mWInstrument.setDisplayMultiplier(e2.f());
            mWInstrument.setPointValue(e2.g());
            mWInstrument.setExpiryDate(e2.a());
            if (mWInstrument.isFuture() && connectionID != null) {
                mWInstrument.setTradingHoursID(SymbolUtil.b(e2.a(), connectionID.getService()));
            }
            MWInstrument.register(mWInstrument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exists(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return false;
        }
        Map map = idMap;
        synchronized (map) {
            return keyMap.containsKey(mWInstrument.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean register(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return false;
        }
        if (MWInstrument.exists(mWInstrument)) {
            MWInstrument mWInstrument2;
            com.motivewave.common.h.a.warning("MWInstrument::register() instrument already exists! " + String.valueOf(mWInstrument));
            if (mWInstrument.getId() > 0 && (mWInstrument2 = MWInstrument._getByKey(mWInstrument.getKey())) != null) {
                Map map = idMap;
                synchronized (map) {
                    idMap.put(mWInstrument.id, mWInstrument2);
                }
            }
            return false;
        }
        String string = mWInstrument.getSymbol().trim().toUpperCase();
        String string2 = com.motivewave.common.h.o(string);
        String string3 = mWInstrument.getSymbolDisplay().trim().toUpperCase();
        String string4 = com.motivewave.common.h.b((Object)mWInstrument.getExchange()).trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            List<MWInstrument> list;
            idMap.put(mWInstrument.id, mWInstrument);
            keyMap.put(mWInstrument.getKey(), mWInstrument);
            keyMap.put(mWInstrument.getKey().toUpperCase(), mWInstrument);
            oldKeyMap.put(mWInstrument.getOldKey(), mWInstrument);
            allInstruments.a((Object)mWInstrument);
            String string5 = mWInstrument.getCommonSymbol();
            if (!com.motivewave.common.h.g(string5)) {
                commonMap.put(string5, mWInstrument);
            }
            if ((list = (ArrayList<MWInstrument>)symbol2InstrumentMap.get(string)) == null) {
                list = new ArrayList<MWInstrument>();
            }
            if (!list.contains(mWInstrument)) {
                list.add(mWInstrument);
            }
            symbol2InstrumentMap.put(string, list);
            list = (List)symbolAlpha2Map.get(string2);
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(mWInstrument)) {
                list.add(mWInstrument);
            }
            symbolAlpha2Map.put(string2, list);
            if (mWInstrument.isCash()) {
                symbolFXMap.put(SymbolUtil.b(string), mWInstrument);
            }
            if ((list = (List)symbolDisplayMap.get(string3)) == null) {
                list = new ArrayList();
            }
            if (!list.contains(mWInstrument)) {
                list.add(mWInstrument);
            }
            symbolDisplayMap.put(string3, list);
            MWInstrument.registerSymbol2Exchange(string + ":" + string4, mWInstrument);
            MWInstrument.registerSymbol2Exchange(string3 + ":" + string4, mWInstrument);
            if (!com.motivewave.common.h.g(mWInstrument.primaryExchange)) {
                string4 = mWInstrument.primaryExchange.toUpperCase();
                MWInstrument.registerSymbol2Exchange(string + ":" + string4, mWInstrument);
                MWInstrument.registerSymbol2Exchange(string3 + ":" + string4, mWInstrument);
            }
            if (!com.motivewave.common.h.g(mWInstrument.getServiceId())) {
                serviceIdMap.put(String.valueOf((Object)mWInstrument.getSourceType()) + ":" + mWInstrument.getServiceId(), mWInstrument);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregister(MWInstrument mWInstrument) {
        String string = mWInstrument.getSymbol().trim().toUpperCase();
        String string2 = mWInstrument.getSymbolDisplay().trim().toUpperCase();
        String string3 = com.motivewave.common.h.b((Object)mWInstrument.getExchange()).trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            idMap.remove(mWInstrument.id);
            keyMap.remove(mWInstrument.getKey());
            allInstruments.a((Object)mWInstrument);
            List list = (List)symbol2InstrumentMap.get(string);
            if (list != null) {
                list.remove(mWInstrument);
            }
            if ((list = (List)symbolDisplayMap.get(string2)) != null) {
                list.remove(mWInstrument);
            }
            if ((list = (List)symbolExchangeMap.get(string + ":" + string3)) != null) {
                list.remove(mWInstrument);
            }
            if ((list = (List)symbolExchangeMap.get(string2 + ":" + string3)) != null) {
                list.remove(mWInstrument);
            }
            if (!com.motivewave.common.h.g(mWInstrument.primaryExchange)) {
                string3 = mWInstrument.primaryExchange.toUpperCase();
                list = (List)symbolExchangeMap.get(string + ":" + string3);
                if (list != null) {
                    list.remove(mWInstrument);
                }
                if ((list = (List)symbolExchangeMap.get(string2 + ":" + string3)) != null) {
                    list.remove(mWInstrument);
                }
            }
            if (!com.motivewave.common.h.g(mWInstrument.getServiceId())) {
                serviceIdMap.remove(String.valueOf((Object)mWInstrument.getSourceType()) + ":" + mWInstrument.getServiceId(), mWInstrument);
            }
        }
    }

    public static void addListener(InvalidationListener invalidationListener) {
        listeners.a((Object)invalidationListener);
    }

    public static void removeListener(InvalidationListener invalidationListener) {
        listeners.a((Object)invalidationListener);
    }

    public static synchronized void beginUpdate() {
        if (pendingUpdates < 0) {
            pendingUpdates = 0;
        }
        ++pendingUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endUpdate() {
        Class<MWInstrument> clazz = MWInstrument.class;
        synchronized (MWInstrument.class) {
            if (--pendingUpdates > 0) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            pendingUpdates = 0;
            if (ignoreEvents) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            for (InvalidationListener invalidationListener : listeners.a()) {
                invalidationListener.invalidated(null);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerSymbol2Exchange(String string, MWInstrument mWInstrument) {
        Map map = idMap;
        synchronized (map) {
            ArrayList<MWInstrument> arrayList = (ArrayList<MWInstrument>)symbolExchangeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<MWInstrument>();
            }
            if (!arrayList.contains(mWInstrument)) {
                arrayList.add(mWInstrument);
            }
            symbolExchangeMap.put(string, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(List list) {
        String string;
        Object object;
        Cloneable cloneable3;
        Object object2;
        if (com.motivewave.common.h.a((Collection)list)) {
            return;
        }
        Map map = idMap;
        synchronized (map) {
            for (Cloneable cloneable2 : new ArrayList(list)) {
                List<Cloneable> list2;
                if (keyMap.containsKey(((MWInstrument)cloneable2).getKey())) {
                    list.remove(cloneable2);
                    com.motivewave.common.h.a.warning("MWInstrument::register() instrument already exists! " + String.valueOf(cloneable2));
                    if (((MWInstrument)cloneable2).getId() <= 0 || (object2 = MWInstrument._getByKey(((MWInstrument)cloneable2).getKey())) == null) continue;
                    cloneable3 = idMap;
                    synchronized (cloneable3) {
                        idMap.put(((MWInstrument)cloneable2).id, object2);
                        continue;
                    }
                }
                object2 = ((MWInstrument)cloneable2).getSymbol().trim().toUpperCase();
                cloneable3 = com.motivewave.common.h.o((String)object2);
                object = ((MWInstrument)cloneable2).getSymbolDisplay().trim().toUpperCase();
                Object object3 = com.motivewave.common.h.b((Object)((MWInstrument)cloneable2).getExchange()).trim().toUpperCase();
                if (((MWInstrument)cloneable2).id > 0) {
                    idMap.put(((MWInstrument)cloneable2).id, cloneable2);
                }
                keyMap.put(((MWInstrument)cloneable2).getKey(), cloneable2);
                oldKeyMap.put(((MWInstrument)cloneable2).getOldKey(), cloneable2);
                string = ((MWInstrument)cloneable2).getCommonSymbol();
                if (!com.motivewave.common.h.g(string)) {
                    commonMap.put(string, cloneable2);
                }
                if ((list2 = (ArrayList<Cloneable>)symbol2InstrumentMap.get(object2)) == null) {
                    list2 = new ArrayList<Cloneable>();
                }
                if (!list2.contains(cloneable2)) {
                    list2.add(cloneable2);
                }
                symbol2InstrumentMap.put(object2, list2);
                list2 = (List)symbolAlpha2Map.get(cloneable3);
                if (list2 == null) {
                    list2 = new ArrayList();
                }
                if (!list2.contains(cloneable2)) {
                    list2.add(cloneable2);
                }
                symbolAlpha2Map.put(cloneable3, list2);
                if (((MWInstrument)cloneable2).isCash()) {
                    symbolFXMap.put(SymbolUtil.b((String)object2), cloneable2);
                }
                if ((list2 = (List)symbolDisplayMap.get(object)) == null) {
                    list2 = new ArrayList();
                }
                if (!list2.contains(cloneable2)) {
                    list2.add(cloneable2);
                }
                symbolDisplayMap.put(object, list2);
                MWInstrument.registerSymbol2Exchange((String)object2 + ":" + (String)object3, (MWInstrument)cloneable2);
                MWInstrument.registerSymbol2Exchange((String)object + ":" + (String)object3, (MWInstrument)cloneable2);
                if (!com.motivewave.common.h.g(((MWInstrument)cloneable2).primaryExchange)) {
                    object3 = ((MWInstrument)cloneable2).primaryExchange.toUpperCase();
                    MWInstrument.registerSymbol2Exchange((String)object2 + ":" + (String)object3, (MWInstrument)cloneable2);
                    MWInstrument.registerSymbol2Exchange((String)object + ":" + (String)object3, (MWInstrument)cloneable2);
                }
                if (com.motivewave.common.h.g(((MWInstrument)cloneable2).getServiceId())) continue;
                serviceIdMap.put(String.valueOf((Object)((MWInstrument)cloneable2).getSourceType()) + ":" + ((MWInstrument)cloneable2).getServiceId(), cloneable2);
            }
            allInstruments.b(list);
        }
        Collections.sort(list, (mWInstrument, mWInstrument2) -> mWInstrument.getSymbol().compareToIgnoreCase(mWInstrument2.getSymbol()));
        map = idMap;
        synchronized (map) {
            Cloneable cloneable2;
            Object object4 = null;
            cloneable2 = new ArrayList();
            for (Cloneable cloneable3 : list) {
                if (com.motivewave.common.h.g(((MWInstrument)cloneable3).getSymbol())) continue;
                if (((MWInstrument)cloneable3).isCash()) {
                    symbolFXMap.put(SymbolUtil.b(((MWInstrument)cloneable3).getSymbol()), cloneable3);
                }
                object = ((MWInstrument)cloneable3).getSymbol().trim().toUpperCase();
                if (object4 == null) {
                    object4 = object;
                } else if (!com.motivewave.common.h.a(object, object4)) {
                    if (!com.motivewave.common.h.a((Collection)((Object)cloneable2))) {
                        symbol2InstrumentMap.put(object4, cloneable2);
                        symbolAlpha2Map.put(com.motivewave.common.h.o((String)object4), cloneable2);
                    }
                    cloneable2 = new ArrayList();
                    object4 = object;
                }
                cloneable2.add(cloneable3);
            }
            if (!com.motivewave.common.h.a((Collection)((Object)cloneable2)) && object4 != null) {
                symbol2InstrumentMap.put(object4, cloneable2);
                symbolAlpha2Map.put(com.motivewave.common.h.o(object4), cloneable2);
            }
            Collections.sort(list, (mWInstrument, mWInstrument2) -> {
                if (com.motivewave.common.h.g(mWInstrument.getSymbolDisplay())) {
                    return -1;
                }
                if (com.motivewave.common.h.g(mWInstrument2.getSymbolDisplay())) {
                    return 1;
                }
                return mWInstrument.getSymbolDisplay().compareToIgnoreCase(mWInstrument2.getSymbolDisplay());
            });
            object2 = null;
            cloneable3 = new ArrayList<Object>();
            for (Object object3 : list) {
                if (com.motivewave.common.h.g(((MWInstrument)object3).getSymbolDisplay())) continue;
                string = ((MWInstrument)object3).getSymbolDisplay().trim().toUpperCase();
                if (object2 == null) {
                    object2 = string;
                } else if (!com.motivewave.common.h.a((Object)string, object2)) {
                    if (!com.motivewave.common.h.a(cloneable3)) {
                        symbolDisplayMap.put(object2, cloneable3);
                    }
                    cloneable3 = new ArrayList();
                    object2 = string;
                }
                cloneable3.add(object3);
            }
            if (!com.motivewave.common.h.a(cloneable3) && object2 != null) {
                symbolDisplayMap.put(object2, cloneable3);
            }
        }
    }
}

