/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$JournalAction;
import com.motivewave.platform.common.Enums$JournalType;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$OrderStatus;
import com.motivewave.platform.common.Enums$OrderType;
import com.motivewave.platform.common.Enums$TIF;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.ConnectionID;
import com.motivewave.platform.databean.InstrumentListener;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.by;
import java.util.List;

public class JournalEntry
extends ObservableBean
implements InstrumentListener,
Comparable {
    private long time;
    private Enums$JournalType type;
    private Enums$JournalAction action;
    private ConnectionID connection;
    private String message;
    private String orderId;
    private String parentId;
    private String acctId;
    private String ocaId;
    private String permId;
    private long orderTime;
    private long lastFillTime;
    private float quantity;
    private float filled;
    private float remaining;
    private float price;
    private float lastFillPrice;
    private Enums$OrderType orderType;
    private Enums$OrderStatus orderStatus;
    private Enums$TIF tif;
    private Enums$OrderAction orderAction;
    private MWInstrument instrument;
    private String instrKey;

    public static JournalEntry fromCSV(String string) {
        List list = h.a(string, false);
        if (list.size() < 10) {
            return null;
        }
        JournalEntry journalEntry = new JournalEntry();
        journalEntry.time = h.c((String)list.get(0));
        try {
            journalEntry.type = Enums$JournalType.valueOf((String)list.get(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            journalEntry.action = Enums$JournalAction.valueOf((String)list.get(2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        journalEntry.connection = ConnectionID.get((String)list.get(3));
        if (list.size() == 10) {
            String string2;
            String string3 = h.g((String)list.get(4)) ? null : h.q((String)list.get(4));
            String string4 = string2 = h.g((String)list.get(5)) ? null : h.q((String)list.get(5));
            if (!h.g(string3)) {
                journalEntry.instrument = MWInstrument.get(string3, string2, journalEntry.connection == null ? null : journalEntry.connection.getService());
                if (journalEntry.instrument != null) {
                    journalEntry.instrKey = journalEntry.instrument.getKey();
                }
            }
            journalEntry.orderId = h.g((String)list.get(6)) ? null : h.q((String)list.get(6));
            journalEntry.orderTime = h.g((String)list.get(7)) ? 0L : h.c(h.q((String)list.get(7)));
            String string5 = (String)list.get(8);
            if (!h.g(string5)) {
                try {
                    journalEntry.orderStatus = Enums$OrderStatus.valueOf(string5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            journalEntry.message = (String)list.get(9);
        } else {
            int n2 = 4;
            journalEntry.message = (String)list.get(n2++);
            journalEntry.instrKey = (String)list.get(n2++);
            journalEntry.acctId = (String)list.get(n2++);
            journalEntry.orderId = (String)list.get(n2++);
            journalEntry.parentId = (String)list.get(n2++);
            journalEntry.ocaId = (String)list.get(n2++);
            journalEntry.orderTime = h.c((String)list.get(n2++));
            try {
                journalEntry.orderType = Enums$OrderType.valueOf((String)list.get(n2++));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                journalEntry.orderAction = Enums$OrderAction.valueOf((String)list.get(n2++));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                journalEntry.orderStatus = Enums$OrderStatus.valueOf((String)list.get(n2++));
            }
            catch (Exception exception) {
                // empty catch block
            }
            journalEntry.price = h.b((String)list.get(n2++));
            journalEntry.quantity = h.b((String)list.get(n2++));
            try {
                journalEntry.tif = Enums$TIF.valueOf((String)list.get(n2++));
            }
            catch (Exception exception) {
                // empty catch block
            }
            journalEntry.filled = h.b((String)list.get(n2++));
            journalEntry.remaining = h.b((String)list.get(n2++));
            journalEntry.lastFillPrice = h.b((String)list.get(n2++));
            journalEntry.lastFillTime = h.c((String)list.get(n2++));
            if (n2 < list.size()) {
                journalEntry.permId = (String)list.get(n2++);
            }
            journalEntry.resolveInstrument();
        }
        return journalEntry;
    }

    public static String toCSV(JournalEntry journalEntry) {
        ConnectionID connectionID = journalEntry.getConnectionID();
        return h.a(new Object[]{journalEntry.time, journalEntry.type, journalEntry.action, connectionID == null ? "" : connectionID.getPersistString(), journalEntry.message, journalEntry.instrKey, journalEntry.acctId, journalEntry.orderId, journalEntry.parentId, journalEntry.ocaId, journalEntry.orderTime, journalEntry.orderType, journalEntry.orderAction, journalEntry.orderStatus, Float.valueOf(journalEntry.price), Float.valueOf(journalEntry.quantity), journalEntry.tif, Float.valueOf(journalEntry.filled), Float.valueOf(journalEntry.remaining), Float.valueOf(journalEntry.lastFillPrice), journalEntry.lastFillTime, journalEntry.permId});
    }

    private JournalEntry() {
    }

    public JournalEntry(Enums$JournalAction enums$JournalAction, ConnectionID connectionID, String string) {
        this.time = bs.a();
        this.type = Enums$JournalType.CONNECTION;
        this.connection = connectionID;
        this.action = enums$JournalAction;
        this.message = string;
    }

    public JournalEntry(Enums$JournalAction enums$JournalAction, MWOrder mWOrder, String string) {
        this.time = bs.a();
        this.type = Enums$JournalType.ORDER;
        this.action = enums$JournalAction;
        this.message = string;
        by by2 = bs.a(mWOrder.getAccount());
        if (by2 != null) {
            this.connection = by2.a().a();
        }
        this.instrument = mWOrder.getAcctInstrument();
        if (this.instrument != null) {
            this.instrKey = this.instrument.getKey();
            this.instrument.addListener(this);
        }
        this.acctId = mWOrder.getAccountId();
        this.orderId = mWOrder.getOrderId();
        this.permId = mWOrder.getPermanentId();
        this.parentId = mWOrder.getParentId();
        this.ocaId = mWOrder.getOCAId();
        this.orderTime = mWOrder.getLastModified();
        this.orderType = mWOrder.getType();
        this.orderAction = mWOrder.getAction();
        this.orderStatus = mWOrder.getStatus();
        this.price = mWOrder.getTriggerPrice();
        this.quantity = mWOrder.getQuantity();
        this.tif = mWOrder.getTif();
        this.filled = mWOrder.getFilled();
        this.remaining = mWOrder.getRemaining();
        this.lastFillPrice = mWOrder.getLastFillPrice();
        this.lastFillTime = mWOrder.getLastFillTime();
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "time": {
                return this.time;
            }
            case "type": {
                return this.type;
            }
            case "action": {
                return this.action;
            }
            case "connection": {
                return this.connection;
            }
            case "message": {
                return this.message;
            }
            case "orderTime": {
                return this.orderTime;
            }
            case "orderId": {
                return this.orderId;
            }
            case "orderStatus": {
                return this.orderStatus;
            }
            case "symbol": {
                this.resolveInstrument();
                return this.instrument == null ? "" : this.instrument.getSymbol();
            }
            case "exchange": {
                this.resolveInstrument();
                return this.instrument == null ? "" : this.instrument.getExchange();
            }
            case "symbolExchange": {
                this.resolveInstrument();
                return this.instrument == null ? "" : this.instrument.getSymbol() + ":" + this.instrument.getExchange();
            }
            case "instrument": {
                return this.getInstrument();
            }
        }
        return null;
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "time": {
                return ab.i(this.time, b.b());
            }
            case "type": {
                return this.type == null ? "" : this.type.toString();
            }
            case "action": {
                return this.action == null ? "" : this.action.toString();
            }
            case "connection": {
                return h.b((Object)this.connection);
            }
            case "message": {
                return this.message;
            }
            case "orderTime": {
                return ab.i(this.orderTime, b.b());
            }
            case "orderId": {
                return this.orderId;
            }
            case "orderStatus": {
                return this.orderStatus == null ? "" : this.orderStatus.toString();
            }
            case "symbol": {
                this.resolveInstrument();
                return this.instrument == null ? "" : this.instrument.getSymbol();
            }
            case "exchange": {
                this.resolveInstrument();
                return this.instrument == null ? "" : this.instrument.getExchange();
            }
            case "symbolExchange": {
                this.resolveInstrument();
                return this.instrument == null ? "" : this.instrument.getSymbol() + ":" + this.instrument.getExchange();
            }
        }
        return "";
    }

    public long getTime() {
        return this.time;
    }

    public Enums$JournalType getType() {
        return this.type;
    }

    public Enums$JournalAction getAction() {
        return this.action;
    }

    public ConnectionID getConnectionID() {
        return this.connection;
    }

    public String getMessage() {
        return this.message;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getPermId() {
        return this.permId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getAccountId() {
        return this.acctId;
    }

    public String getOCAId() {
        return this.ocaId;
    }

    public long getOrderTime() {
        return this.orderTime;
    }

    public long getLastFillTime() {
        return this.lastFillTime;
    }

    public float getPrice() {
        return this.price;
    }

    public float getLastFillPrice() {
        return this.lastFillPrice;
    }

    public float getQuantity() {
        return this.quantity;
    }

    public float getFilled() {
        return this.filled;
    }

    public float getRemaining() {
        return this.remaining;
    }

    public Enums$OrderType getOrderType() {
        return this.orderType;
    }

    public Enums$TIF getTif() {
        return this.tif;
    }

    public Enums$OrderAction getOrderAction() {
        return this.orderAction;
    }

    public Enums$OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public MWInstrument getInstrument() {
        this.resolveInstrument();
        return this.instrument;
    }

    public int compareTo(JournalEntry journalEntry) {
        if (journalEntry == null) {
            return -1;
        }
        if (journalEntry == this) {
            return 0;
        }
        return Long.compare(this.time, journalEntry.time);
    }

    private void resolveInstrument() {
        if (this.instrument != null || h.g(this.instrKey)) {
            return;
        }
        this.instrument = MWInstrument.byKey(this.instrKey);
        if (this.instrument != null) {
            this.instrument.addListener(this);
        }
    }

    @Override
    public void keyUpdated(MWInstrument mWInstrument, String string, String string2) {
        if (mWInstrument != this.instrument) {
            return;
        }
        this.instrKey = string2;
    }
}

