/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.common.p;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.themes.ChartTheme;
import com.motivewave.platform.databean.as;
import com.motivewave.platform.sdk.common.IndicatorInfo;
import java.awt.Color;
import java.util.Collection;
import org.json.JSONObject;
import org.w3c.dom.Element;

public class IndicatorHome {
    public static final String ASK = "ask";
    public static final String MIDPOINT = "midpoint";
    public static final String BID = "bid";
    public static final String LAST = "last";
    public static final String HIGH = "high";
    public static final String LOW = "low";
    public static final String OPEN = "open";
    public static final String CLOSE = "close";
    public static final String PREV_HIGH = "prevHigh";
    public static final String PREV_LOW = "prevLow";
    public static final String AVG_ENTRY_LONG = "avgEntryLong";
    public static final String AVG_ENTRY_SHORT = "avgEntryShort";
    public static final String SETTLEMENT = "settle";

    public static String convertOldName(String string) {
        if (string == null) {
            return null;
        }
        return switch (string) {
            case "BID_INDICATOR" -> BID;
            case "ASK_INDICATOR" -> ASK;
            case "MIDPOINT_INDICATOR" -> MIDPOINT;
            case "LAST_INDICATOR" -> LAST;
            case "HIGH_INDICATOR" -> HIGH;
            case "LOW_INDICATOR" -> LOW;
            case "OPEN_INDICATOR" -> OPEN;
            case "CLOSE_INDICATOR" -> CLOSE;
            case "PREV_HIGH_INDICATOR" -> PREV_HIGH;
            case "PREV_LOW_INDICATOR" -> PREV_LOW;
            default -> string;
        };
    }

    public static String property2Name(String string) {
        if (h.g(string)) {
            return string;
        }
        return switch (string) {
            case "askPrice" -> ASK;
            case "bidPrice" -> BID;
            case MIDPOINT -> MIDPOINT;
            case "lastPrice" -> LAST;
            case HIGH -> HIGH;
            case LOW -> LOW;
            case OPEN -> OPEN;
            case CLOSE -> CLOSE;
            case "highPrevDay" -> PREV_HIGH;
            case "lowPrevDay" -> PREV_LOW;
            case SETTLEMENT -> SETTLEMENT;
            default -> string;
        };
    }

    public static boolean isBuildIn(String string) {
        if (h.g(string)) {
            return false;
        }
        return h.a(string, ASK, MIDPOINT, BID, LAST, HIGH, LOW, OPEN, CLOSE, PREV_HIGH, PREV_LOW, AVG_ENTRY_LONG, AVG_ENTRY_SHORT, SETTLEMENT);
    }

    public static String getFormLabel(String string) {
        if (h.g(string)) {
            return "";
        }
        return switch (string) {
            case ASK -> ab.a("ASK_INDICATOR", new Object[0]);
            case BID -> ab.a("BID_INDICATOR", new Object[0]);
            case MIDPOINT -> ab.a("MIDPOINT_INDICATOR", new Object[0]);
            case LAST -> ab.a("LAST_INDICATOR", new Object[0]);
            case HIGH -> ab.a("HIGH_INDICATOR", new Object[0]);
            case LOW -> ab.a("LOW_INDICATOR", new Object[0]);
            case OPEN -> ab.a("OPEN_INDICATOR", new Object[0]);
            case CLOSE -> ab.a("CLOSE_INDICATOR", new Object[0]);
            case PREV_HIGH -> ab.a("PREV_HIGH_INDICATOR", new Object[0]);
            case PREV_LOW -> ab.a("PREV_LOW_INDICATOR", new Object[0]);
            case AVG_ENTRY_LONG -> ab.a("AVG_ENTRY_LONG_INDICATOR", new Object[0]);
            case AVG_ENTRY_SHORT -> ab.a("AVG_ENTRY_SHORT_INDICATOR", new Object[0]);
            case SETTLEMENT -> ab.a("SETTLEMENT_INDICATOR", new Object[0]);
            default -> "";
        };
    }

    public static String toJSON(IndicatorInfo indicatorInfo) {
        as as2 = new as();
        return as2.a((Collection)h.b(new String[]{as2.b("name", indicatorInfo.getId()), as2.a("enabled", indicatorInfo.isEnabled()), as2.a("showLine", indicatorInfo.isShowLine(), false), as2.a("showLabel", indicatorInfo.isShowLabel()), as2.a("width", indicatorInfo.getLineWidth(), 1.0f), as2.a("dash", indicatorInfo.getLineDash()), as2.a("lineColor", indicatorInfo.getLineColor()), as2.a("outlineColor", indicatorInfo.getOutlineColor()), as2.a("labelColor", indicatorInfo.getLabelColor()), as2.a("textColor", indicatorInfo.getTextColor()), as2.a("font", indicatorInfo.isUseDefaultFont() ? null : indicatorInfo.getFont()), as2.b("top", indicatorInfo.isTop()), as2.a("tagTextColor", indicatorInfo.getTagTextColor()), as2.a("tagBgColor", indicatorInfo.getTagBgColor()), as2.a("showTag", indicatorInfo.isShowTag(), false), as2.a("tag", indicatorInfo.getTag())}));
    }

    public static IndicatorInfo fromJSON(String string, JSONObject jSONObject) {
        if (jSONObject.has("name")) {
            string = jSONObject.str("name");
        }
        boolean bl2 = false;
        if (jSONObject.has("top")) {
            bl2 = jSONObject.is("top", false);
        } else if (!h.g(string)) {
            switch (string) {
                case "ask": 
                case "bid": 
                case "last": {
                    bl2 = true;
                    break;
                }
            }
        }
        string = IndicatorHome.convertOldName(string);
        Object object = jSONObject.getColor("tagBgColor");
        if (jSONObject.has("showTagOutline") && !jSONObject.is("showTagOutline", false)) {
            object = null;
        }
        return new IndicatorInfo(string, jSONObject.getColor(jSONObject.has("bg") ? "bg" : "labelColor"), jSONObject.getColor(jSONObject.has("text") ? "text" : "textColor"), jSONObject.getColor(jSONObject.has("outline") ? "outline" : "outlineColor"), jSONObject.is("outlineEnabled"), jSONObject.getFont("font"), bl2, jSONObject.is("showLabel"), jSONObject.getColor(jSONObject.has("line") ? "line" : "lineColor"), jSONObject.getFloat("width", 1.0f), jSONObject.getDash("dash"), jSONObject.is("showLine", false), jSONObject.is("showTag", false), jSONObject.str("tag"), jSONObject.getColor("tagTextColor"), (Color)object, jSONObject.is("enabled", true));
    }

    public static IndicatorInfo readXML(Element element) {
        if (element == null) {
            return null;
        }
        String string = element.getAttribute("name");
        string = IndicatorHome.convertOldName(string);
        float f2 = h.b(element.getAttribute("width"));
        if (f2 <= 0.0f) {
            f2 = 1.0f;
        }
        float[] fArray = h.a(element.getAttribute("dash"));
        return new IndicatorInfo(string, h.a((Element)com.motivewave.common.util.h.b("labelColor", element)), h.a((Element)com.motivewave.common.util.h.b("textColor", element)), h.a((Element)com.motivewave.common.util.h.b("outlineColor", element)), true, UIUtil.a((Element)com.motivewave.common.util.h.b("font", element)), false, true, h.a((Element)com.motivewave.common.util.h.b("lineColor", element)), f2, fArray, h.a((Object)element.getAttribute("showLine"), (Boolean)false).booleanValue(), false, null, null, null, h.a((Object)element.getAttribute("enabled"), (Boolean)true).booleanValue());
    }

    public static Color getLineColor(IndicatorInfo indicatorInfo) {
        if (indicatorInfo != null && indicatorInfo.getLineColor() != null) {
            return indicatorInfo.getLineColor();
        }
        return IndicatorHome.getLineColor(indicatorInfo == null ? null : indicatorInfo.getId());
    }

    public static Color getLineColor(String string) {
        ChartTheme chartTheme = ChartTheme.getTheme();
        if (string == null) {
            string = "";
        }
        return switch (string) {
            case ASK -> chartTheme.ASK_LINE;
            case BID -> chartTheme.BID_LINE;
            case LAST, MIDPOINT -> chartTheme.PRICE_LINE;
            case HIGH -> chartTheme.HIGH_LINE;
            case LOW -> chartTheme.LOW_LINE;
            case OPEN -> chartTheme.OPEN_LINE;
            case CLOSE -> chartTheme.CLOSE_LINE;
            case AVG_ENTRY_LONG -> chartTheme.BLUE;
            case AVG_ENTRY_SHORT -> chartTheme.RED;
            case SETTLEMENT -> p.GREEN;
            default -> chartTheme.isDark() ? p.WHITE : p.BLACK;
        };
    }

    public static Color getTextColor(IndicatorInfo indicatorInfo) {
        if (indicatorInfo != null && indicatorInfo.getTextColor() != null) {
            return indicatorInfo.getTextColor();
        }
        return IndicatorHome.getTextColor(indicatorInfo == null ? null : indicatorInfo.getId());
    }

    public static Color getTextColor(String string) {
        if (h.a(string, HIGH, LOW, AVG_ENTRY_LONG, AVG_ENTRY_SHORT)) {
            return p.WHITE;
        }
        return p.BLACK;
    }

    public static Color getOutlineColor(IndicatorInfo indicatorInfo) {
        if (indicatorInfo != null && indicatorInfo.getOutlineColor() != null) {
            return indicatorInfo.getOutlineColor();
        }
        return ChartTheme.getTheme().IND_OUTLINE;
    }

    public static Color getLabelColor(IndicatorInfo indicatorInfo, ChartTheme chartTheme) {
        if (indicatorInfo == null) {
            return p.WHITE;
        }
        return indicatorInfo.getLabelColor() == null ? IndicatorHome.getLabelColor(indicatorInfo.getId(), chartTheme) : indicatorInfo.getLabelColor();
    }

    public static Color getLabelColor(String string, ChartTheme chartTheme) {
        if (h.g(string)) {
            return p.WHITE;
        }
        if (chartTheme == null) {
            chartTheme = ChartTheme.getTheme();
        }
        return switch (string) {
            case ASK -> chartTheme.IND_ASK_PRICE_BG;
            case BID -> chartTheme.IND_BID_PRICE_BG;
            case MIDPOINT -> chartTheme.IND_LAST_VALUE_BG;
            case LAST -> chartTheme.IND_LAST_VALUE_BG;
            case HIGH -> chartTheme.IND_HIGH_PRICE_BG;
            case LOW -> chartTheme.IND_LOW_PRICE_BG;
            case OPEN -> chartTheme.IND_OPEN_PRICE_BG;
            case CLOSE -> chartTheme.IND_CLOSE_PRICE_BG;
            case AVG_ENTRY_LONG -> chartTheme.BLUE;
            case AVG_ENTRY_SHORT -> chartTheme.RED;
            case SETTLEMENT -> p.GREEN;
            default -> p.WHITE;
        };
    }

    public static IndicatorInfo of(String string, boolean bl2) {
        return IndicatorHome.of(string, bl2, false);
    }

    public static IndicatorInfo of(String string, boolean bl2, boolean bl3) {
        return new IndicatorInfo(string, null, null, null, true, null, bl3, true, null, 1.0f, new float[]{3.0f, 3.0f}, false, false, null, null, null, bl2);
    }

    public static IndicatorInfo setEnabled(IndicatorInfo indicatorInfo, boolean bl2) {
        return new IndicatorInfo(indicatorInfo.getId(), indicatorInfo.getLabelColor(), indicatorInfo.getTextColor(), indicatorInfo.getOutlineColor(), indicatorInfo.isOutlineEnabled(), indicatorInfo.getFont(), indicatorInfo.isTop(), indicatorInfo.isShowLabel(), indicatorInfo.getLineColor(), indicatorInfo.getLineWidth(), indicatorInfo.getLineDash(), indicatorInfo.isShowLine(), indicatorInfo.isShowTag(), indicatorInfo.getTag(), indicatorInfo.getTagTextColor(), indicatorInfo.getTagBgColor(), bl2);
    }

    public static IndicatorInfo setLabel(IndicatorInfo indicatorInfo, Color color, Color color2, Color color3) {
        return new IndicatorInfo(indicatorInfo.getId(), color, color2, color3, color3 != null, indicatorInfo.getFont(), indicatorInfo.isTop(), indicatorInfo.isShowLabel(), indicatorInfo.getLineColor(), indicatorInfo.getLineWidth(), indicatorInfo.getLineDash(), indicatorInfo.isShowLine(), indicatorInfo.isShowTag(), indicatorInfo.getTag(), indicatorInfo.getTagTextColor(), indicatorInfo.getTagBgColor(), indicatorInfo.isEnabled());
    }

    public static IndicatorInfo setShowLine(IndicatorInfo indicatorInfo, boolean bl2) {
        return new IndicatorInfo(indicatorInfo.getId(), indicatorInfo.getLabelColor(), indicatorInfo.getTextColor(), indicatorInfo.getOutlineColor(), indicatorInfo.isOutlineEnabled(), indicatorInfo.getFont(), indicatorInfo.isTop(), indicatorInfo.isShowLabel(), indicatorInfo.getLineColor(), indicatorInfo.getLineWidth(), indicatorInfo.getLineDash(), bl2, indicatorInfo.isShowTag(), indicatorInfo.getTag(), indicatorInfo.getTagTextColor(), indicatorInfo.getTagBgColor(), indicatorInfo.isEnabled());
    }
}

