/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.platform.common.af;
import com.motivewave.platform.common.f;
import com.motivewave.platform.databean.MWInstrument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;

public class ImportFormat {
    private boolean multiSymbol = false;
    private String symbol;
    private String name;
    private String exchange;
    private MWInstrument instrument;
    private File file;
    private int symbolIndex = -1;
    private int openIndex = -1;
    private int closeIndex = -1;
    private int highIndex = -1;
    private int lowIndex = -1;
    private int openBidIndex = -1;
    private int openAskIndex = -1;
    private int closeBidIndex = -1;
    private int closeAskIndex = -1;
    private int highBidIndex = -1;
    private int highAskIndex = -1;
    private int lowBidIndex = -1;
    private int lowAskIndex = -1;
    private int volumeIndex = -1;
    private int openInterestIndex = -1;
    private int dateIndex = -1;
    private int timeIndex = -1;
    private int nameIndex = -1;
    private int upVolIndex = -1;
    private int downVolIndex = -1;
    private double minTick = 0.01;
    private SimpleDateFormat dateTimeFormat;
    private boolean secSince70 = false;
    private boolean dateLetters = false;
    private TimeZone timeZone;
    private int barSize = 0;
    private Boolean rth = null;
    private boolean validNameFormat = false;
    private char separator = (char)44;
    private boolean ignoreEmpty = false;

    public ImportFormat(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void detectFormat(File file) {
        this.file = file;
        try {
            this.detectFormat(new BufferedReader(new FileReader(file)), file.getName());
        }
        catch (MWException mWException) {
            throw mWException;
        }
        catch (Exception exception) {
            throw new MWException(f.E_IMPORT_DETECT_FORMAT, exception.getMessage());
        }
    }

    public void detectFormat(BufferedReader bufferedReader, String string) {
        try {
            boolean bl2;
            int n2;
            List list;
            Object object;
            String string2;
            String string3;
            this.secSince70 = false;
            this.dateTimeFormat = null;
            this.symbol = null;
            this.instrument = null;
            this.barSize = 0;
            this.validNameFormat = false;
            this.downVolIndex = -1;
            this.upVolIndex = -1;
            this.openInterestIndex = -1;
            this.timeIndex = -1;
            this.dateIndex = -1;
            this.volumeIndex = -1;
            this.closeIndex = -1;
            this.lowIndex = -1;
            this.highIndex = -1;
            this.openIndex = -1;
            this.nameIndex = -1;
            this.symbolIndex = -1;
            this.closeBidIndex = -1;
            this.lowBidIndex = -1;
            this.highBidIndex = -1;
            this.openBidIndex = -1;
            this.closeAskIndex = -1;
            this.lowAskIndex = -1;
            this.highAskIndex = -1;
            this.openAskIndex = -1;
            this.minTick = 0.01;
            String string4 = string.toUpperCase();
            this.separator = (char)44;
            this.ignoreEmpty = false;
            String string5 = string3 = this.nextLine(bufferedReader);
            if (string3 != null && string3.indexOf(44) < 0) {
                string3 = this.nextLine(bufferedReader);
            }
            if (string3 == null) {
                return;
            }
            if ((string4.endsWith(".CSV") || string4.endsWith(".TXT")) && string3.indexOf(44) < 0) {
                bufferedReader.close();
                throw new MWException(af.a("E_CSV_NOT_CSV_FILE", new Object[0]));
            }
            if (string4.endsWith(".PRN") && string3.indexOf(44) < 0) {
                this.separator = (char)32;
                this.ignoreEmpty = true;
            }
            if ((string2 = string4).indexOf(46) > 0) {
                string2 = string2.substring(0, string2.lastIndexOf(46));
            }
            this.validNameFormat = true;
            String string6 = "";
            if (string2.length() >= 11) {
                string6 = string4.substring(0, 11);
            }
            if (string6.matches("\\d\\d\\d\\d-\\d\\d-\\d\\d-") && string4.length() > 11) {
                object = string2.substring(11);
                list = h.a((String)object, '-');
                this.exchange = (String)list.get(0);
                this.multiSymbol = true;
                this.barSize = 1440;
            } else if (!h.g(string2)) {
                object = h.a(string2, ' ');
                this.symbol = (String)object.get(0);
                if (object.size() > 2) {
                    int n3 = 1;
                    String string7 = (String)object.get(n3);
                    if (h.a((Object)string7, (Object)"-") || h.a((Object)string7, (Object)"")) {
                        string7 = (String)object.get(++n3);
                    }
                    if (h.b(string7) && object.size() > ++n3) {
                        n2 = h.b(string7);
                        if (h.a(object.get(n3), (Object)"MIN")) {
                            this.barSize = n2;
                        } else if (h.a(object.get(n3), (Object)"HOUR")) {
                            this.barSize = n2 * 60;
                        } else if (h.a(object.get(n3), (Object)"DAY")) {
                            this.barSize = n2 * 1440;
                        } else if (h.a(object.get(n3), (Object)"DAYS")) {
                            this.barSize = n2 * 1440;
                        } else if (h.a(object.get(n3), (Object)"WEEK")) {
                            this.barSize = n2 * 7 * 1440;
                        } else if (h.a(object.get(n3), (Object)"MONTH")) {
                            this.barSize = n2 * 30 * 1440;
                        }
                    }
                    if (object.size() > n3 + 1) {
                        if ((h.a((Object)(string7 = (String)object.get(++n3)), (Object)"-") || h.a((Object)string7, (Object)"")) && object.size() > n3) {
                            string7 = (String)object.get(++n3);
                        }
                        if (h.b((Object)string7, (Object)"RTH")) {
                            this.rth = true;
                        } else if (h.b((Object)string7, (Object)"ETH")) {
                            this.rth = false;
                        }
                    }
                }
            }
            object = string3.toUpperCase();
            list = this.tokenize(string3);
            if (((String)object).indexOf("DTYYYYMMDD") >= 0 || ((String)object).indexOf("DATE") >= 0 || ((String)object).indexOf("TIME") >= 0) {
                if (list.size() <= 3) {
                    for (var10_14 = 0; var10_14 < list.size(); ++var10_14) {
                        String string8 = (String)list.get(var10_14);
                        string8 = string8.toUpperCase();
                        if ((string8 = string8.trim()).indexOf("DTYYYYMMDD") >= 0) {
                            this.dateTimeFormat = new SimpleDateFormat("yyyyMMdd");
                            this.dateIndex = var10_14;
                            continue;
                        }
                        if (string8.indexOf("DATE") >= 0) {
                            this.dateIndex = var10_14;
                            continue;
                        }
                        if (string8.indexOf("<TIME>") >= 0 || string8.indexOf("\"TIME\"") >= 0 || string8.startsWith("TIME")) {
                            this.timeIndex = var10_14;
                            continue;
                        }
                        if (this.closeIndex < 0 && (string8.indexOf("CLOSE") >= 0 || string8.indexOf("VALUE") >= 0 || string8.indexOf("SETTLE") >= 0 || string8.indexOf("RATE") >= 0)) {
                            this.closeIndex = var10_14;
                            continue;
                        }
                        if (this.volumeIndex < 0 && string8.indexOf("VOLUME") >= 0) {
                            this.volumeIndex = var10_14;
                            continue;
                        }
                        if (this.volumeIndex >= 0 || string8.indexOf("VOL") < 0) continue;
                        this.volumeIndex = var10_14;
                    }
                    if (this.closeIndex < 0 || this.dateIndex < 0) {
                        h.a.warning("ImportFormat::detectFormat() unrecognized header: " + string3);
                        bufferedReader.close();
                        throw new MWException(f.E_IMPORT_UNRECOGNIZED_FORMAT);
                    }
                    this.lowIndex = this.highIndex = this.closeIndex;
                    this.openIndex = this.highIndex;
                } else {
                    var10_14 = 0;
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        String string9 = (String)list.get(n2);
                        string9 = string9.toUpperCase();
                        if ((string9 = string9.trim()).indexOf("TICKER") >= 0 || string9.indexOf("SYMBOL") >= 0) {
                            this.symbolIndex = n2;
                            this.multiSymbol = true;
                            continue;
                        }
                        if (string9.indexOf("NAME") >= 0) {
                            this.nameIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("OPENINT") >= 0 || string9.indexOf("OPEN INT") >= 0 || string9.indexOf("INTEREST") >= 0) {
                            this.openInterestIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("O/I") >= 0 || h.a((Object)string9, (Object)"OI")) {
                            this.openInterestIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("DTYYYYMMDD") >= 0) {
                            this.dateTimeFormat = new SimpleDateFormat("yyyyMMdd");
                            this.dateIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("DATE") >= 0) {
                            this.dateIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("<TIME>") >= 0 || string9.indexOf("\"TIME\"") >= 0 || h.a((Object)string9, (Object)"TIME")) {
                            this.timeIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("OPENBID") >= 0 || string9.indexOf("OPEN BID") >= 0) {
                            this.openBidIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("OPENASK") >= 0 || string9.indexOf("OPEN ASK") >= 0) {
                            this.openAskIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("HIGHBID") >= 0 || string9.indexOf("HIGH BID") >= 0) {
                            this.highBidIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("HIGHASK") >= 0 || string9.indexOf("HIGH ASK") >= 0) {
                            this.highAskIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("LOWBID") >= 0 || string9.indexOf("LOW BID") >= 0) {
                            this.lowBidIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("LOWASK") >= 0 || string9.indexOf("LOW ASK") >= 0) {
                            this.lowAskIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("CLOSEBID") >= 0 || string9.indexOf("CLOSE BID") >= 0) {
                            this.closeBidIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("CLOSEASK") >= 0 || string9.indexOf("CLOSE ASK") >= 0) {
                            this.closeAskIndex = n2;
                            continue;
                        }
                        if (var10_14 == 0 && string9.indexOf("CLOSE") >= 0) {
                            this.closeIndex = n2;
                            var10_14 = 1;
                            continue;
                        }
                        if (string9.indexOf("OPEN") >= 0) {
                            this.openIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("SETTLE") >= 0 && var10_14 == 0) {
                            this.closeIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("RATE") >= 0 && var10_14 == 0) {
                            this.closeIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("HIGH") >= 0) {
                            this.highIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("LOW") >= 0) {
                            this.lowIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("TOTAL TICKS") >= 0 && this.volumeIndex < 0) {
                            this.volumeIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("VOLUME") >= 0) {
                            this.volumeIndex = n2;
                            continue;
                        }
                        if (string9.indexOf("VOL") >= 0) {
                            this.volumeIndex = n2;
                            continue;
                        }
                        if (h.a((Object)string9, (Object)"UP")) {
                            this.upVolIndex = n2;
                            continue;
                        }
                        if (!h.a((Object)string9, (Object)"DOWN")) continue;
                        this.downVolIndex = n2;
                    }
                    if (this.closeIndex < 0 && this.closeBidIndex < 0) {
                        h.a.warning("ImportFormat::detectFormat() unrecognized header: " + string3);
                        bufferedReader.close();
                        throw new MWException(f.E_IMPORT_UNRECOGNIZED_FORMAT);
                    }
                }
            } else {
                int n4;
                string3 = this.nextLine(bufferedReader);
                list = this.tokenize(string3);
                this.dateIndex = -1;
                for (n4 = 0; n4 < list.size(); ++n4) {
                    if (h.a((String)list.get(n4)) == null) continue;
                    this.dateIndex = n4;
                    break;
                }
                this.timeIndex = -1;
                for (n4 = 0; n4 < list.size(); ++n4) {
                    String string10;
                    if (n4 == this.dateIndex || (string10 = (String)list.get(n4)).length() < 4 || string10.length() > 8 || string10.indexOf(58) <= 0) continue;
                    this.timeIndex = n4;
                    break;
                }
                if (this.dateIndex == -1 && this.timeIndex == -1) {
                    List list2 = this.tokenize(string5);
                    for (n2 = 0; n2 < list2.size(); ++n2) {
                        if (!h.b(list2.get(n2), (Object)"TIME")) continue;
                        this.dateIndex = n2;
                        break;
                    }
                }
                if (list.size() == 2) {
                    for (var10_14 = 0; var10_14 < list.size(); ++var10_14) {
                        if (var10_14 == this.dateIndex || var10_14 == this.timeIndex || !h.e((String)list.get(var10_14))) continue;
                        this.lowIndex = this.closeIndex = var10_14;
                        this.highIndex = this.closeIndex;
                        this.openIndex = this.closeIndex;
                        break;
                    }
                } else {
                    int n5;
                    int n6;
                    int n7;
                    this.symbolIndex = -1;
                    for (var10_14 = 0; var10_14 < list.size(); ++var10_14) {
                        String string11;
                        if (var10_14 == this.dateIndex || var10_14 == this.timeIndex || (string11 = (String)list.get(var10_14)).length() <= 2 || !h.d(string11)) continue;
                        this.symbolIndex = var10_14;
                        break;
                    }
                    this.volumeIndex = -1;
                    var10_14 = 0;
                    for (n7 = 0; n7 < list.size(); ++n7) {
                        if (n7 == this.dateIndex || n7 == this.symbolIndex || n7 == this.timeIndex || !h.b((String)list.get(n7)) || (n6 = h.b((String)list.get(n7))) < var10_14) continue;
                        var10_14 = n6;
                        this.volumeIndex = n7;
                    }
                    this.openInterestIndex = -1;
                    if (list.size() > 6) {
                        n7 = Integer.MAX_VALUE;
                        for (n6 = 0; n6 < list.size(); ++n6) {
                            int n8;
                            if (n6 == this.dateIndex || n6 == this.symbolIndex || n6 == this.volumeIndex || n6 == this.timeIndex || !h.b((String)list.get(n6)) || (n8 = h.b((String)list.get(n6))) >= n7) continue;
                            n7 = n8;
                            this.openInterestIndex = n6;
                        }
                    }
                    this.closeIndex = -1;
                    this.lowIndex = -1;
                    this.highIndex = -1;
                    this.openIndex = -1;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    for (n5 = 0; n5 < list.size(); ++n5) {
                        if (n5 == this.dateIndex || n5 == this.symbolIndex || n5 == this.volumeIndex || n5 == this.openInterestIndex || n5 == this.timeIndex) continue;
                        String string12 = (String)list.get(n5);
                        if (list.size() > 7 && string12.indexOf(46) < 0 || !h.e(string12)) continue;
                        double d6 = h.a(string12);
                        if (d2 == 0.0 && list.size() > 4) {
                            d2 = d6;
                            this.openIndex = n5;
                            continue;
                        }
                        if (d4 == 0.0) {
                            d4 = d6;
                            this.highIndex = n5;
                            continue;
                        }
                        if (d5 == 0.0) {
                            d5 = d6;
                            this.lowIndex = n5;
                            continue;
                        }
                        if (d3 != 0.0) continue;
                        d3 = d6;
                        this.closeIndex = n5;
                    }
                    if (d5 > d2 && this.openIndex >= 0) {
                        n5 = this.lowIndex;
                        double d7 = d5;
                        this.lowIndex = this.openIndex;
                        d5 = d2;
                        this.openIndex = n5;
                        d2 = d7;
                    }
                    if (d5 > d3) {
                        n5 = this.lowIndex;
                        double d8 = d5;
                        this.lowIndex = this.closeIndex;
                        d5 = d3;
                        this.closeIndex = n5;
                        d3 = d8;
                    }
                    if (d5 > d4) {
                        n5 = this.lowIndex;
                        double d9 = d5;
                        this.lowIndex = this.highIndex;
                        d5 = d4;
                        this.highIndex = n5;
                        d4 = d9;
                    }
                    if (d4 < d2 && this.openIndex >= 0) {
                        n5 = this.highIndex;
                        double d10 = d4;
                        this.highIndex = this.openIndex;
                        d4 = d2;
                        this.openIndex = n5;
                        d2 = d10;
                    }
                    if (d4 < d3) {
                        n5 = this.highIndex;
                        double d11 = d4;
                        this.highIndex = this.closeIndex;
                        d4 = d3;
                        this.closeIndex = n5;
                        d3 = d11;
                    }
                }
                if (this.dateIndex < 0 || this.highIndex < 0 || this.lowIndex < 0 && this.closeIndex < 0) {
                    bufferedReader.close();
                    throw new MWException(f.E_IMPORT_UNRECOGNIZED_FORMAT);
                }
            }
            string3 = this.nextLine(bufferedReader);
            if (string3 == null) {
                h.a.warning("ImportFormat::detectFormat() no data");
                bufferedReader.close();
                throw new MWException(f.E_IMPORT_UNRECOGNIZED_FORMAT);
            }
            list = this.tokenize(string3);
            if (this.symbolIndex >= 0) {
                this.symbol = this.getSymbol(list);
            }
            if (this.nameIndex >= 0) {
                this.name = this.getSymbol(list);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (this.dateIndex >= 0) {
                arrayList.add((String)list.get(this.dateIndex));
            }
            if (this.timeIndex >= 0) {
                arrayList2.add((String)list.get(this.timeIndex));
            }
            int n9 = (bl2 = this.isPriceData()) ? (this.openIndex >= 0 ? h.a(this.getOpen(list)) : h.a(this.getClose(list))) : (this.openBidIndex >= 0 ? h.a(this.getOpenBid(list)) : h.a(this.getCloseBid(list)));
            int n10 = h.a(bl2 ? this.getClose(list) : this.getCloseBid(list));
            if (n10 > n9) {
                n9 = n10;
            }
            if ((n10 = h.a(bl2 ? this.getHigh(list) : this.getHighBid(list))) > n9) {
                n9 = n10;
            }
            if ((n10 = h.a(bl2 ? this.getLow(list) : this.getLowBid(list))) > n9) {
                n9 = n10;
            }
            String string13 = "";
            boolean bl3 = false;
            int n11 = 0;
            this.dateLetters = true;
            while (n11 < 30 && (string3 = this.nextLine(bufferedReader)) != null) {
                float f2;
                list = this.tokenize(string3);
                if (this.dateIndex >= 0) {
                    String string14 = this.getTimeStr(list);
                    if (arrayList.contains(string14)) continue;
                    arrayList.add(string14);
                }
                if (this.timeIndex >= 0) {
                    arrayList2.add((String)list.get(this.timeIndex));
                }
                float f3 = bl2 ? this.getClose(list) : this.getCloseBid(list);
                float f4 = bl2 ? this.getHigh(list) : this.getHighBid(list);
                float f5 = f2 = bl2 ? this.getLow(list) : this.getLowBid(list);
                if (f3 == 0.0f && f4 == 0.0f && f2 == 0.0f) continue;
                ++n11;
                n10 = h.a(f3);
                if (n10 > n9) {
                    n9 = n10;
                }
                if ((n10 = h.a(f4)) > n9) {
                    n9 = n10;
                }
                if ((n10 = h.a(f2)) > n9) {
                    n9 = n10;
                }
                if (this.symbolIndex < 0) continue;
                String string15 = this.getSymbol(list);
                if (!(h.g(string15) || h.g(string13) || h.b((Object)string13, (Object)string15))) {
                    bl3 = true;
                }
                string13 = string15;
            }
            bufferedReader.close();
            if (!this.multiSymbol) {
                this.multiSymbol = bl3;
            }
            this.minTick = n9 <= 0 ? 1.0 : Math.pow(10.0, -n9);
            this.secSince70 = this.isSecSince70(arrayList.isEmpty() ? arrayList2 : arrayList);
            if (!this.secSince70) {
                this.dateTimeFormat = h.a(arrayList);
                if (this.dateTimeFormat == null) {
                    h.a.warning("ImportFormat::detectFormat() Invalid date format: " + (String)list.get(this.dateIndex));
                    throw new MWException(f.E_IMPORT_UNRECOGNIZED_DATE_FORMAT, list.get(this.dateIndex));
                }
                this.dateLetters = this.dateTimeFormat.toPattern().indexOf("MMM") >= 0;
                if (this.timeZone != null) {
                    this.dateTimeFormat.setTimeZone(this.timeZone);
                }
            }
            if (this.barSize <= 0) {
                long l2 = 31557600000L;
                if (!h.a(arrayList2)) {
                    long l3 = 0L;
                    for (String string16 : arrayList2) {
                        long l4 = this.readTime(string16);
                        if (l3 == 0L) {
                            l3 = l4;
                            continue;
                        }
                        long l5 = Math.abs(l4 - l3);
                        if (l5 < l2 && l5 > 0L) {
                            l2 = l5;
                        }
                        l3 = l4;
                    }
                } else {
                    long l6 = 0L;
                    for (String string17 : arrayList) {
                        long l7 = 0L;
                        try {
                            l7 = this.parseTime(string17);
                        }
                        catch (Exception exception) {
                            h.a.warning("ImportFormat::detectFormat() invalid date: " + string17);
                            continue;
                        }
                        if (l6 == 0L) {
                            l6 = l7;
                            continue;
                        }
                        long l8 = l7 - l6;
                        if (l8 < 0L) {
                            l8 = -l8;
                        }
                        if (l8 < l2 && l8 > 0L) {
                            l2 = l8;
                        }
                        l6 = l7;
                    }
                }
                if (l2 <= 0L) {
                    l2 = -l2;
                }
                this.barSize = (int)(l2 / 60000L);
                if (this.barSize >= 1000) {
                    this.barSize = 1440;
                } else if (this.barSize >= 30) {
                    this.barSize = 30;
                } else if (this.barSize >= 5) {
                    this.barSize = 5;
                } else if (this.barSize >= 1) {
                    this.barSize = 1;
                }
                if (this.barSize == 0) {
                    h.a.warning("ImportFormat::detectFormat() unable to detect bar size, assuming daily bars: " + string);
                    this.barSize = 1440;
                }
            }
            if (this.barSize > 0 && !h.a((Object)this.barSize, new Object[]{1, 5, 30, 1440})) {
                throw new MWException(f.E_IMPORT_INVALID_BAR_SIZE);
            }
            if (!h.g(this.symbol)) {
                this.instrument = MWInstrument.bySymbol(this.symbol);
            }
        }
        catch (MWException mWException) {
            throw mWException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MWException(f.E_IMPORT_DETECT_FORMAT, exception.getMessage());
        }
    }

    private boolean isSecSince70(List list) {
        if (h.a((Collection)list)) {
            return false;
        }
        for (String string : list) {
            if (string.length() == 10 && h.b(string)) continue;
            return false;
        }
        return true;
    }

    public boolean isPriceData() {
        return this.closeIndex >= 0;
    }

    public boolean isBidAskData() {
        return this.closeBidIndex >= 0 && this.closeAskIndex >= 0;
    }

    public float getOpen(List list) {
        return this.getFloat(list, this.openIndex);
    }

    public void setOpenIndex(int n2) {
        this.openIndex = n2;
    }

    public float getOpenBid(List list) {
        return this.getFloat(list, this.openBidIndex);
    }

    public void setOpenBidIndex(int n2) {
        this.openBidIndex = n2;
    }

    public float getOpenAsk(List list) {
        return this.getFloat(list, this.openAskIndex);
    }

    public void setOpenAskIndex(int n2) {
        this.openAskIndex = n2;
    }

    public float getHigh(List list) {
        return this.getFloat(list, this.highIndex);
    }

    public void setHighIndex(int n2) {
        this.highIndex = n2;
    }

    public float getHighBid(List list) {
        return this.getFloat(list, this.highBidIndex);
    }

    public void setHighBidIndex(int n2) {
        this.highBidIndex = n2;
    }

    public float getHighAsk(List list) {
        return this.getFloat(list, this.highAskIndex);
    }

    public void setHighAskIndex(int n2) {
        this.highAskIndex = n2;
    }

    public float getLow(List list) {
        return this.getFloat(list, this.lowIndex);
    }

    public void setLowIndex(int n2) {
        this.lowIndex = n2;
    }

    public float getLowBid(List list) {
        return this.getFloat(list, this.lowBidIndex);
    }

    public void setLowBidIndex(int n2) {
        this.lowBidIndex = n2;
    }

    public float getLowAsk(List list) {
        return this.getFloat(list, this.lowAskIndex);
    }

    public void setLowAskIndex(int n2) {
        this.lowAskIndex = n2;
    }

    public float getClose(List list) {
        return this.getFloat(list, this.closeIndex);
    }

    public void setCloseIndex(int n2) {
        this.closeIndex = n2;
    }

    public float getCloseBid(List list) {
        return this.getFloat(list, this.closeBidIndex);
    }

    public void setCloseBidIndex(int n2) {
        this.closeBidIndex = n2;
    }

    public float getCloseAsk(List list) {
        return this.getFloat(list, this.closeAskIndex);
    }

    public void setCloseAskIndex(int n2) {
        this.closeAskIndex = n2;
    }

    private float getFloat(List list, int n2) {
        if (n2 < 0 || n2 >= list.size()) {
            return 0.0f;
        }
        return this.toFloat(ImportFormat.fixString((String)list.get(n2)));
    }

    private float toFloat(String string) {
        if (string.length() > 9) {
            return (float)h.a(string);
        }
        return h.b(string);
    }

    public float getVolume(List list) {
        if (this.volumeIndex < 0 || this.volumeIndex >= list.size()) {
            if (this.upVolIndex >= 0 && this.downVolIndex >= 0) {
                float f2 = this.upVolIndex < list.size() ? this.toFloat(ImportFormat.fixString((String)list.get(this.upVolIndex))) : 0.0f;
                float f3 = this.downVolIndex < list.size() ? this.toFloat(ImportFormat.fixString((String)list.get(this.downVolIndex))) : 0.0f;
                return f2 + f3;
            }
            return 0.0f;
        }
        return this.toFloat(ImportFormat.fixString((String)list.get(this.volumeIndex)));
    }

    public void setVolumeIndex(int n2) {
        this.volumeIndex = n2;
    }

    public long getOpenInterest(List list) {
        if (this.openInterestIndex < 0 || this.openInterestIndex >= list.size()) {
            return 0L;
        }
        return h.c(ImportFormat.fixString((String)list.get(this.openInterestIndex)));
    }

    public void setOpenInterestIndex(int n2) {
        this.openInterestIndex = n2;
    }

    public String getSymbol(List list) {
        if (this.symbolIndex < 0 || this.symbolIndex >= list.size()) {
            return null;
        }
        return (String)list.get(this.symbolIndex);
    }

    public String getName(List list) {
        if (this.nameIndex < 0 || this.nameIndex >= list.size()) {
            return null;
        }
        return (String)list.get(this.nameIndex);
    }

    public double getMinTick() {
        return this.minTick;
    }

    public List tokenize(String string) {
        if (this.separator == ',') {
            return h.a(string, false);
        }
        return h.a(string, this.separator, this.ignoreEmpty);
    }

    private long parseTime(String string) {
        if (h.g(string)) {
            return -1L;
        }
        if (this.secSince70) {
            long l2 = h.c(string);
            return l2 * 1000L;
        }
        return this.dateTimeFormat.parse(h.n(string)).getTime();
    }

    public long getTime(List list) {
        if (h.a((Collection)list)) {
            return -1L;
        }
        if (this.secSince70) {
            long l2 = h.c(this.getTimeStr(list));
            return l2 * 1000L;
        }
        long l3 = -1L;
        String string = h.n(this.getTimeStr(list));
        try {
            l3 = this.dateTimeFormat.parse(string).getTime();
            if (this.timeIndex >= 0) {
                l3 += this.readTime((String)list.get(this.timeIndex));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            h.a.warning("ImportFormat:getTime() invalid time: " + string);
            return -1L;
        }
        return l3;
    }

    private long readTime(String string) {
        if (h.g(string = h.q(string))) {
            return 0L;
        }
        if (this.secSince70 && h.b(string)) {
            long l2 = h.c(string);
            if (l2 * 1000L > System.currentTimeMillis()) {
                return l2;
            }
            return l2 * 1000L;
        }
        if (string.indexOf(58) >= 0) {
            string = h.a(string, ":", "");
        }
        if (string.indexOf(46) >= 0) {
            string = h.a(string, ".", "");
        }
        string = string.toUpperCase();
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.endsWith("M")) {
            bl2 = string.endsWith("AM");
            bl3 = string.endsWith("PM");
            string = string.substring(0, string.length() - 2).trim();
        }
        int n2 = 0;
        int n3 = 0;
        if (string.length() == 6) {
            n2 = h.b(string.substring(0, 2));
            n3 = h.b(string.substring(2, 4));
        } else if (string.length() == 5) {
            n2 = h.b(string.substring(0, 1));
            n3 = h.b(string.substring(1, 3));
        } else if (string.length() == 4) {
            n2 = h.b(string.substring(0, 2));
            n3 = h.b(string.substring(2, 4));
        }
        if (bl2 && n2 == 12) {
            n2 = 0;
        }
        if (bl3 && n2 < 12) {
            n2 += 12;
        }
        return (long)n2 * 3600000L + (long)n3 * 60000L;
    }

    public String getTimeStr(List list) {
        if (h.a((Collection)list)) {
            return "";
        }
        String string = (String)list.get(this.dateIndex < 0 ? this.timeIndex : this.dateIndex);
        if (!this.dateLetters) {
            string = h.a(string, "l", "1");
            string = h.a(string, "O", "0");
        }
        return string;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String string) {
        this.symbol = string;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String string) {
        this.exchange = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public MWInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(MWInstrument mWInstrument) {
        this.instrument = mWInstrument;
    }

    public int getBarSize() {
        return this.barSize;
    }

    public void setBarSize(int n2) {
        this.barSize = n2;
    }

    public Boolean isRTH() {
        return this.rth;
    }

    public void setRTH(boolean bl2) {
        this.rth = bl2;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isValidNameFormat() {
        return this.validNameFormat;
    }

    public boolean isMultiSymbol() {
        return this.multiSymbol;
    }

    public char getSeparator() {
        return this.separator;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    private static String fixString(String string) {
        string = h.a(string, "\"", "");
        string = h.a(string, "'", "");
        return string;
    }

    private String nextLine(BufferedReader bufferedReader) {
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        while (h.g(string)) {
            string = bufferedReader.readLine();
            if (string != null) continue;
            return null;
        }
        return string;
    }
}

