/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$BackAdjustMethod;
import com.motivewave.platform.common.Enums$BarSizeMethod;
import com.motivewave.platform.common.Enums$RollMethod;
import com.motivewave.platform.databean.BarBuildSettings;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.RollSettings;
import com.motivewave.platform.databean.Settings;
import com.motivewave.platform.databean.Settings$Definition;
import com.motivewave.platform.databean.ap;
import com.motivewave.platform.service.bs;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONObject;

public class HistDataSettings
extends Settings {
    private boolean rangeAllowGaps = true;
    private boolean saveLiveTS = true;
    private boolean restartDaily = true;
    private boolean intervalPoints = false;
    private boolean showPFColors = true;
    private boolean barChartContinuous = true;
    private boolean contractDefaults = true;
    private boolean backFillEnabled = true;
    private static Settings$Definition def = new ap();

    public void setDataExportDir(MWInstrument mWInstrument, File file) {
        Map map = (Map)this.get("dataExportMap");
        map.put(mWInstrument, file);
    }

    public File getDataExportDir(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return (File)this.get("dataExportDir");
        }
        Map map = (Map)this.get("dataExportMap");
        File file = (File)map.get(mWInstrument);
        if (file != null) {
            return file;
        }
        return (File)this.get("dataExportDir");
    }

    public void remove(MWInstrument mWInstrument) {
        Map map = (Map)this.get("dataExportMap");
        map.remove(mWInstrument);
    }

    public File getDataImportDirNotNull() {
        File file = (File)this.get("dataImportDir");
        return file == null || !file.exists() ? h.a() : file;
    }

    public boolean isSaveLiveTS() {
        return this.saveLiveTS;
    }

    public boolean isUseHistorical() {
        return this.has("useHistorical") ? this.is("useHistorical") : !bs.y(null);
    }

    public boolean isRangeAllowGaps() {
        return this.rangeAllowGaps;
    }

    public boolean isRestartDaily() {
        return this.restartDaily;
    }

    public boolean isIntervalPoints() {
        return this.intervalPoints;
    }

    public boolean isShowPFColors() {
        return this.showPFColors;
    }

    public List getExportGroups() {
        return (List)this.get("exportGroups");
    }

    public void setExportGroups(List list) {
        this.set("exportGroups", list);
    }

    public boolean isBarChartContinuous() {
        return this.barChartContinuous;
    }

    public BarBuildSettings getBarBuildSettings() {
        return (BarBuildSettings)this.get("barBuildSettings");
    }

    public RollSettings getRollSettings() {
        return (RollSettings)this.get("rollSettings");
    }

    public boolean isContractDefaults() {
        return this.contractDefaults;
    }

    public boolean isBackfillEnabled() {
        return this.backFillEnabled;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        super.fromJSON(jSONObject);
        if (jSONObject.has("rollMethod")) {
            this.getRollSettings().setRollMethod(Enums$RollMethod.valueOf(jSONObject.str("rollMethod")));
        }
        if (jSONObject.has("adjustMethod")) {
            this.getRollSettings().setAdjustMethod(Enums$BackAdjustMethod.valueOf(jSONObject.str("adjustMethod")));
        }
        if (jSONObject.has("daysBeforeExpiry")) {
            this.getRollSettings().setDays(jSONObject.getInt("daysBeforeExpiry"));
        }
        this.set("rollMethod", null);
        this.set("adjustMethod", null);
        this.set("daysBeforeExpiry", null);
        if (jSONObject.has("bsTZ")) {
            this.getBarBuildSettings().set("tz", TimeZone.getTimeZone(jSONObject.str("bsTZ")));
        }
        if (jSONObject.has("bsMethod")) {
            this.getBarBuildSettings().set("method", (Object)Enums$BarSizeMethod.valueOf(jSONObject.str("bsMethod")));
        }
        if (jSONObject.has("bsStartTime")) {
            this.getBarBuildSettings().set("startTime", jSONObject.getInt("bsStartTime"));
        }
        this.set("bsTZ", null);
        this.set("bsMethod", null);
        this.set("bsStartTime", null);
        this.getBarBuildSettings().onUpdated();
        this.getRollSettings().onUpdated();
    }

    @Override
    protected void onChange(String string, Object object, Object object2) {
        super.onChange(string, object, object2);
        switch (string) {
            case "saveLiveTS": {
                this.saveLiveTS = this.is(string);
                break;
            }
            case "rangeAllowGaps": {
                this.rangeAllowGaps = this.is(string);
                break;
            }
            case "restartDaily": {
                this.restartDaily = this.is(string);
                break;
            }
            case "intervalPoints": {
                this.intervalPoints = this.is(string);
                break;
            }
            case "showPFColors": {
                this.showPFColors = this.is(string);
                break;
            }
            case "barChartContinuous": {
                this.barChartContinuous = this.is(string);
                break;
            }
            case "contractDefaults": {
                this.contractDefaults = this.is(string);
                break;
            }
            case "backFillEnabled": {
                this.backFillEnabled = this.is(string);
                break;
            }
        }
    }

    @Override
    protected Settings$Definition getDefinition() {
        return def;
    }
}

