/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.common.Enums$Flag;
import com.motivewave.platform.common.an;
import com.motivewave.platform.databean.cell.FlagRenderer;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.paint.Color;

public class Flag {
    private String id;
    private Color color;
    private Enums$Flag type = Enums$Flag.CIRCLE;
    private static Path2D triangle = new Path2D.Double();
    private static Path2D octogon;
    private static Path2D star;
    private static Path2D flag;
    private static Map idMap;

    private Flag(String string, Enums$Flag enums$Flag, Color color) {
        this.id = string;
        this.type = enums$Flag;
        this.color = color;
    }

    public String getId() {
        return this.id;
    }

    public Color getColor() {
        return this.color;
    }

    public Enums$Flag getType() {
        return this.type;
    }

    public Node getGraphic() {
        FlagRenderer flagRenderer = new FlagRenderer();
        flagRenderer.setFlag(this.id);
        flagRenderer.setMinSize(16.0, 16.0);
        flagRenderer.setPrefSize(16.0, 16.0);
        flagRenderer.setMaxSize(16.0, 16.0);
        return flagRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawTo(Graphics2D graphics2D, double d2, double d3) {
        double d4 = d2 / 2.0;
        double d5 = d3 / 2.0;
        graphics2D.setColor(UIUtil.a(this.color));
        graphics2D.translate(d4, d5);
        try {
            switch (this.getType()) {
                case CIRCLE: {
                    graphics2D.fillOval(-6, -6, 12, 12);
                    return;
                }
                case SQUARE: {
                    graphics2D.fillRect(-6, -6, 12, 12);
                    return;
                }
                case TRIANGLE: {
                    graphics2D.fill(triangle);
                    return;
                }
                case OCTOGON: {
                    graphics2D.fill(octogon);
                    return;
                }
                case FLAG: {
                    graphics2D.fill(flag);
                    return;
                }
                case STAR: {
                    graphics2D.fill(star);
                    return;
                }
                case CHECK: {
                    graphics2D.setStroke(an.SOLID_LINE_3PT);
                    graphics2D.drawLine(-5, 0, -1, 5);
                    graphics2D.drawLine(-1, 5, 6, -5);
                    return;
                }
            }
            return;
        }
        finally {
            graphics2D.translate(-d4, -d5);
        }
    }

    public Flag clone() {
        try {
            return (Flag)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Flag get(String string) {
        if (h.g(string)) {
            return null;
        }
        Map map = idMap;
        synchronized (map) {
            Flag flag = (Flag)idMap.get(string);
            if (flag != null) {
                return flag;
            }
            List list = h.a(string, ':');
            if (list.size() != 2) {
                return null;
            }
            try {
                Enums$Flag enums$Flag = Enums$Flag.values()[h.b((String)list.get(0))];
                Color color = UIUtil.a(new java.awt.Color(Integer.valueOf((String)list.get(1), 32), true));
                return Flag.get(enums$Flag, color);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Flag get(Enums$Flag enums$Flag, Color color) {
        Map map = idMap;
        synchronized (map) {
            String string = (enums$Flag.ordinal() + ":" + Integer.toString(UIUtil.a(color).getRGB(), 32)).intern();
            Flag flag = (Flag)idMap.get(string);
            if (flag != null) {
                return flag;
            }
            flag = new Flag(string, enums$Flag, color);
            idMap.put(string, flag);
            return flag;
        }
    }

    static {
        triangle.moveTo(0.0, -6.0);
        triangle.lineTo(-8.0, 6.0);
        triangle.lineTo(8.0, 6.0);
        triangle.closePath();
        octogon = new Path2D.Double();
        octogon.moveTo(-2.5, -6.0);
        octogon.lineTo(2.5, -6.0);
        octogon.lineTo(6.0, -2.5);
        octogon.lineTo(6.0, 2.5);
        octogon.lineTo(2.5, 6.0);
        octogon.lineTo(-2.5, 6.0);
        octogon.lineTo(-6.0, 2.5);
        octogon.lineTo(-6.0, -2.5);
        octogon.closePath();
        flag = new Path2D.Double();
        flag.moveTo(-7.0, -6.0);
        flag.lineTo(7.0, -6.0);
        flag.lineTo(2.0, 0.0);
        flag.lineTo(7.0, 6.0);
        flag.lineTo(-7.0, 6.0);
        flag.closePath();
        star = new Path2D.Double();
        star.moveTo(0.0, -7.0);
        star.lineTo(2.0, -1.5);
        star.lineTo(7.0, -1.5);
        star.lineTo(3.0, 2.0);
        star.lineTo(5.0, 7.0);
        star.lineTo(0.0, 4.0);
        star.lineTo(-5.0, 7.0);
        star.lineTo(-3.0, 2.0);
        star.lineTo(-7.0, -1.5);
        star.lineTo(-2.0, -1.5);
        star.closePath();
        idMap = Collections.synchronizedMap(new HashMap());
    }
}

