/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$DataFormat;
import com.motivewave.platform.common.a;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.f;
import com.motivewave.platform.databean.ExportFile;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Settings;
import com.motivewave.platform.databean.Settings$Definition;
import com.motivewave.platform.databean.ak;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.l;
import com.motivewave.platform.service.s;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONObject;

public class ExportGroup
extends Settings {
    private static Settings$Definition def = new ak();

    public ExportGroup() {
    }

    public ExportGroup(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public String getName() {
        return (String)this.get("name");
    }

    public File getDirectory() {
        return (File)this.get("directory");
    }

    public TimeZone getTimeZone() {
        return (TimeZone)this.get("timeZone");
    }

    public boolean isRTH() {
        return this.is("rth");
    }

    public Enums$DataFormat getFormat() {
        return (Enums$DataFormat)((Object)this.get("format"));
    }

    public boolean isAutoExport() {
        return this.is("autoExport");
    }

    public int getExportInterval() {
        return (Integer)this.get("exportInterval");
    }

    public List getFiles() {
        return (List)this.get("files");
    }

    public void exportData(com.motivewave.platform.ui.component.s s2) {
        File file = this.getDirectory();
        if (file == null) {
            throw new MWException(f.E_EXPORT_NO_DIRECTORY, this.getName());
        }
        if (!file.exists()) {
            file.mkdirs();
            if (!file.exists()) {
                throw new MWException(f.E_EXPORT_CREATE_DIRECTORY, this.getName(), file.getAbsolutePath());
            }
        }
        if (!file.isDirectory()) {
            throw new MWException(f.E_EXPORT_NOT_A_DIRECTORY, this.getName(), file.getAbsolutePath());
        }
        List list = this.getFiles();
        if (h.a((Collection)list)) {
            return;
        }
        for (ExportFile exportFile : list) {
            if (s2 != null) {
                s2.a(ab.a("MSG_EXPORTING_DATA_GROUP", exportFile.getInstrument().getSymbolDisplay(), exportFile.getBarSize()), 0.0);
            }
            this.exportFile(exportFile);
            if (s2 == null) continue;
            s2.c(1.0);
        }
    }

    public void exportFile(ExportFile exportFile) {
        k.b b2;
        Object object;
        Object object2;
        long l2;
        Enums$DataFormat enums$DataFormat = this.getFormat();
        MWInstrument mWInstrument = exportFile.getInstrument();
        BarSize barSize = exportFile.getBarSize();
        SimpleDateFormat simpleDateFormat = ExportGroup.getDF(enums$DataFormat, exportFile.getBarSize());
        TimeZone timeZone = this.getTimeZone();
        if (timeZone == null) {
            timeZone = b.b();
        }
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        File file = new File(this.getDirectory(), exportFile.getFilename());
        long l3 = l2 = exportFile.isAll() ? 0L : exportFile.getSince();
        if (exportFile.isDeleteFile() && file.exists()) {
            file.delete();
            exportFile.setDeleteFile(false);
        }
        boolean bl2 = false;
        if (file.exists() && !h.g((String)(object2 = h.a(file)))) {
            object = a.a((String)object2);
            try {
                l2 = simpleDateFormat.parse((String)object.get(0)).getTime();
                bl2 = true;
            }
            catch (Exception exception) {
                h.a.warning("ExportGroup::exportFile() " + mWInstrument.getKey() + " " + String.valueOf(barSize) + " unable to read last time stamp exporting all: " + (String)object2);
            }
        }
        object2 = new s(null, mWInstrument, barSize, this.isRTH());
        object = l.a((s)object2, l2, bs.a());
        ((com.motivewave.platform.service.srvc.b)object).a();
        List list = ((com.motivewave.platform.service.srvc.a)object).a();
        if (h.a((Collection)list)) {
            h.a.warning("ExportGroup::exportFile() no data available for: " + mWInstrument.getKey() + " " + String.valueOf(barSize));
            return;
        }
        if (bl2) {
            while (!list.isEmpty() && ((k.b)list.get(0)).getStartTime() <= l2) {
                list.remove(0);
            }
            if (h.a((Collection)list)) {
                return;
            }
        }
        if (!(b2 = (k.b)list.get(list.size() - 1)).isComplete()) {
            list.remove(list.size() - 1);
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file, bl2));
            switch (enums$DataFormat) {
                case CSV2: 
                case CSV1: {
                    for (k.b b3 : list) {
                        printWriter.println(simpleDateFormat.format(b3.getStartTime()) + "," + mWInstrument.round(b3.getOpen()) + "," + mWInstrument.round(b3.getHigh()) + "," + mWInstrument.round(b3.getLow()) + "," + mWInstrument.round(b3.getClose()) + "," + b3.getVolume());
                    }
                    break;
                }
                case NINJA_TRADER_END: {
                    for (k.b b4 : list) {
                        printWriter.println(simpleDateFormat.format(b4.getEndTime()) + ";" + mWInstrument.round(b4.getOpen()) + ";" + mWInstrument.round(b4.getHigh()) + ";" + mWInstrument.round(b4.getLow()) + ";" + mWInstrument.round(b4.getClose()) + ";" + b4.getVolume());
                    }
                    break;
                }
                case NINJA_TRADER_START: {
                    for (k.b b5 : list) {
                        printWriter.println(simpleDateFormat.format(b5.getStartTime()) + ";" + mWInstrument.round(b5.getOpen()) + ";" + mWInstrument.round(b5.getHigh()) + ";" + mWInstrument.round(b5.getLow()) + ";" + mWInstrument.round(b5.getClose()) + ";" + b5.getVolume());
                    }
                    break;
                }
            }
            printWriter.flush();
            printWriter.close();
            h.a.info("ExportGroup::exportFile() exported: " + list.size() + " records to: " + exportFile.getFilename());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MWException(f.E_EXPORT_WRITE_DATA, file.getAbsolutePath(), exception.getMessage());
        }
    }

    private static SimpleDateFormat getDF(Enums$DataFormat enums$DataFormat, BarSize barSize) {
        switch (enums$DataFormat) {
            case CSV2: {
                return barSize.isIntraday() ? new SimpleDateFormat("dd/MM/yyyy HH:mm:ss") : new SimpleDateFormat("dd/MM/yyyy");
            }
        }
        return barSize.isIntraday() ? new SimpleDateFormat("yyyyMMdd HHmmss") : new SimpleDateFormat("yyyyMMdd");
    }

    @Override
    protected Settings$Definition getDefinition() {
        return def;
    }
}

