/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Settings;
import com.motivewave.platform.databean.Settings$Definition;
import com.motivewave.platform.databean.aj;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.Enums;
import org.json.JSONObject;

public class ExportFile
extends Settings {
    private static Settings$Definition def = new aj();

    public ExportFile() {
    }

    public ExportFile(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public MWInstrument getInstrument() {
        return (MWInstrument)this.get("instrument");
    }

    public void setInstrument(MWInstrument mWInstrument) {
        this.set("instrument", mWInstrument);
        this.firePropertyChange("filename", null, this.getFilename());
    }

    public BarSize getBarSize() {
        return (BarSize)this.get("barSize");
    }

    public void setBarSize(BarSize barSize) {
        this.set("barSize", barSize);
        this.firePropertyChange("filename", null, this.getFilename());
    }

    public String getFilename() {
        return this.isUseDefaultFn() ? this.getDefaultFilename() : (String)this.get("filename");
    }

    public void setFilename(String string) {
        this.set("filename", string);
    }

    public boolean isUseDefaultFn() {
        return this.is("useDefaultFn");
    }

    public void setUseDefaultFn(boolean bl2) {
        this.set("useDefaultFn", bl2);
        this.firePropertyChange("filename", null, this.getFilename());
    }

    public Enums.BarData getBarData() {
        return (Enums.BarData)this.get("barData");
    }

    public void setBarData(Enums.BarData barData) {
        this.set("barData", barData);
    }

    public boolean isAll() {
        return this.is("all");
    }

    public long getSince() {
        return (Long)this.get("since");
    }

    public boolean isDeleteFile() {
        return this.is("df");
    }

    public void setDeleteFile(boolean bl2) {
        this.set("df", bl2);
    }

    private String getDefaultFilename() {
        MWInstrument mWInstrument = this.getInstrument();
        BarSize barSize = this.getBarSize();
        if (mWInstrument == null || barSize == null) {
            return "";
        }
        return mWInstrument.getKey() + "_" + barSize.getIntervalMinutes() + ".csv";
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "instrument": {
                return this.getInstrument() == null ? "" : this.getInstrument().getSymbolDisplay();
            }
            case "barSize": {
                return this.getBarSize().toString();
            }
            case "filename": {
                return h.b((Object)this.getFilename());
            }
            case "barData": {
                return this.getBarData() == null ? "" : this.getBarData().toString();
            }
        }
        return super.format(string);
    }

    @Override
    public Object getDefault(String string) {
        if (h.a((Object)string, (Object)"filename")) {
            return this.getDefaultFilename();
        }
        if (h.a((Object)string, (Object)"since")) {
            if (this.getBarSize().isIntraday()) {
                return System.currentTimeMillis() - 16070400000L;
            }
            return System.currentTimeMillis() - 63115200000L;
        }
        return super.getDefault(string);
    }

    @Override
    protected Settings$Definition getDefinition() {
        return def;
    }
}

